/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.auto.JDFAutoAssembly;
import org.cip4.jdflib.auto.JDFAutoBinderySignature;
import org.cip4.jdflib.auto.JDFAutoIdentificationField;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.auto.JDFAutoPreview;
import org.cip4.jdflib.auto.JDFAutoPreviewGenerationParams;
import org.cip4.jdflib.auto.JDFAutoStrippingParams;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.intent.JDFColorIntent;
import org.cip4.jdflib.resource.process.JDFAssembly;
import org.cip4.jdflib.resource.process.JDFBarcodeProductionParams;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFContentObject;
import org.cip4.jdflib.resource.process.JDFIdentificationField;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFLayoutElementProductionParams;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFPreview;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.resource.process.prepress.JDFPreviewGenerationParams;
import org.cip4.jdflib.util.StringUtil;

public class MISPreGoldenTicket
extends MISGoldenTicket {
    public static final String MISPRE_CONTENTCREATION = "MISPRE.ContentCreation";
    public static final String MISPRE_IMPOSITIONPREPARATION = "MISPRE.ImpositionPreparation";
    public static final String MISPRE_PREPRESSPREPARATION = "MISPRE.PrePressPreparation";
    public static final String MISPRE_IMPOSITIONRIPING = "MISPRE.ImpositionRIPing";
    public static final String MISPRE_PLATEMAKING = "MISPRE.PlateMaking";
    public static final String MISPRE_PLATESETTING = "MISPRE.PlateSetting";
    public boolean bStripping = false;
    public boolean bSingleSided = false;

    public MISPreGoldenTicket(MISPreGoldenTicket previous, VJDFAttributeMap _vparts) {
        super(previous.misICSLevel, previous.theVersion, previous.jmfICSLevel);
        this.partIDKeys = new VString(previous.partIDKeys);
        this.vParts = _vparts == null ? new VJDFAttributeMap(previous.vParts) : _vparts;
        this.icsLevel = previous.icsLevel;
        this.nCols = previous.nCols;
        this.workStyle = previous.workStyle;
        this.thePreviousNode = previous.theNode;
        this.theParentNode = previous.theParentNode;
    }

    public MISPreGoldenTicket(MISPreGoldenTicket parent) {
        super(parent);
    }

    @Override
    protected void fillCatMaps() {
        super.fillCatMaps();
        this.catMap.put(MISPRE_CONTENTCREATION, new VString(JDFNode.EnumType.LayoutElementProduction.getName(), null));
        this.catMap.put(MISPRE_IMPOSITIONPREPARATION, new VString("ImpositionPreparation", null));
        if (!this.bStripping) {
            this.catMap.put(MISPRE_PREPRESSPREPARATION, new VString("PrePressPreparation", null));
        } else {
            this.catMap.put(MISPRE_PREPRESSPREPARATION, new VString("Stripping", null));
        }
        this.catMap.put(MISPRE_IMPOSITIONRIPING, new VString("Imposition RIPing PreviewGeneration", null));
        this.catMap.put(MISPRE_PLATEMAKING, new VString("Imposition RIPing PreviewGeneration ImageSetting", null));
        this.catMap.put(MISPRE_PLATESETTING, new VString("ImageSetting", null));
    }

    public MISPreGoldenTicket(int _icsLevel, JDFElement.EnumVersion jdfVersion, int _jmfLevel, int _misLevel, VJDFAttributeMap vPartMap) {
        super(_misLevel, jdfVersion, _jmfLevel);
        this.partIDKeys = new VString("SignatureName,SheetName,Side,Separation", ",");
        this.vParts = vPartMap;
        this.icsLevel = _icsLevel;
    }

    @Override
    public void init() {
        String cat;
        this.theNode.setType(JDFNode.EnumType.ProcessGroup);
        this.initColsFromParent();
        this.theNode.linkOutputs(this.thePreviousNode);
        int ncols = this.getNCols();
        while (this.cols.size() > ncols && ncols > 0) {
            this.cols.remove(ncols);
        }
        if (this.icsLevel < 0) {
            return;
        }
        String icsTag = "MISPre_L" + this.icsLevel + "-" + this.theVersion.getName();
        this.theNode.appendAttribute("ICSVersions", icsTag, null, " ", true);
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("MISPre Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        if (MISPRE_CONTENTCREATION.equals(cat = this.getCategory())) {
            this.initGBContentCreation();
        } else if (MISPRE_PREPRESSPREPARATION.equals(cat)) {
            this.initGBPrePressPreparation();
        } else if (MISPRE_IMPOSITIONPREPARATION.equals(cat)) {
            this.initGBImpositionPreparation();
        } else if (MISPRE_IMPOSITIONRIPING.equals(cat)) {
            this.initGBImpositionRIPing();
        } else if (MISPRE_PLATESETTING.equals(cat)) {
            this.initGBPlateSetting();
        } else if (MISPRE_PLATEMAKING.equals(cat)) {
            this.initGBPlateMaking();
        }
        super.init();
        this.setActivePart(this.vParts, true);
    }

    private void initGBImpositionRIPing() {
        this.linkPrepressPrepRunLists();
        this.initColorantControl();
        this.initDevice(null);
        this.initPreviewSep();
        this.initPreviewComp();
        this.initConduitRunListOut();
    }

    private void linkPrepressPrepRunLists() {
        VElement vprepreviousNode = this.theNode.getJDFRoot().getvJDFNode(null, null, false);
        if (vprepreviousNode != null && vprepreviousNode.size() > 0) {
            for (int i = 0; i < vprepreviousNode.size(); ++i) {
                JDFNode node = (JDFNode)vprepreviousNode.get(i);
                VString types = node.getTypes();
                if (types == null || !types.contains("PrePressPreparation")) continue;
                this.theNode.linkOutputs(node);
            }
        }
    }

    private void initGBPlateMaking() {
        this.linkPrepressPrepRunLists();
        this.initColorantControl();
        this.initDevice(null);
        this.initPreviewSep();
        this.initPreviewComp();
        this.initPreviewGenerationParams();
        this.initPlateXM(JDFResourceLink.EnumUsage.Output);
    }

    private void initPreviewGenerationParams() {
    }

    private void initGBPlateSetting() {
        this.initColorantControl();
        this.initDevice(null);
        this.initPlateXM(JDFResourceLink.EnumUsage.Output);
    }

    private void initGBPrePressPreparation() {
        if (this.thePreviousNode != null) {
            this.theNode.linkOutputs(this.thePreviousNode);
        } else {
            this.initDocumentRunList();
        }
        JDFRunList rl = this.initConduitRunListOut();
        this.theNode.getLink((JDFResource)rl, JDFResourceLink.EnumUsage.Output).setProcessUsage(JDFNode.EnumProcessUsage.Document);
    }

    private JDFBinderySignature initBinderySignature(String catalog) {
        JDFBinderySignature bs = (JDFBinderySignature)this.theNode.addResource("BinderySignature", JDFResourceLink.EnumUsage.Input);
        bs.setBinderySignatureType(JDFAutoBinderySignature.EnumBinderySignatureType.Fold);
        bs.setFoldCatalog(catalog);
        int f = StringUtil.parseInt(StringUtil.token(catalog, 0, "-").substring(1), 0) / 2;
        if (f > 0) {
            int fx = f;
            int fy = 1;
            if (f >= 8) {
                fx /= 2;
                fy *= 2;
            }
            bs.setNumberUp(new JDFXYPair((double)fx, (double)fy));
        }
        return bs;
    }

    private void initStrippingParams() {
        JDFStrippingParams sp = (JDFStrippingParams)this.theNode.getCreateResource("StrippingParams", JDFResourceLink.EnumUsage.Input, 0);
        sp.setDescriptiveName("Impositioning for job " + this.theNode.getJobID(true));
        sp.setWorkStyle(JDFAutoStrippingParams.EnumWorkStyle.getEnum(this.workStyle.getValue()));
        this.getReducedMap(new VString("Separation PartVersion", null));
        JDFBinderySignature bs0 = (JDFBinderySignature)this.theNode.getResource("BinderySignature", JDFResourceLink.EnumUsage.Input, 0);
        JDFBinderySignature bs1 = (JDFBinderySignature)this.theNode.getResource("BinderySignature", JDFResourceLink.EnumUsage.Input, 1);
        if (bs1 == null) {
            bs1 = bs0;
        }
        if (this.vParts != null) {
            VJDFAttributeMap reducedMap = this.getReducedMap(new VString("Side Separation PartVersion", " "));
            if (reducedMap != null) {
                int size = reducedMap.size();
                for (int i = 0; i < size; ++i) {
                    JDFAttributeMap part = reducedMap.elementAt(i);
                    JDFResource partSP = sp.getCreatePartition(part, this.partIDKeys);
                    JDFBinderySignature bs = partSP.getSheetName().toLowerCase().contains("cover") ? bs0 : bs1;
                    partSP.refElement(bs);
                    JDFResourceLink rl = this.theNode.getLink((JDFResource)bs, null);
                    if (rl == null) continue;
                    rl.deleteNode();
                }
            }
        } else {
            sp.refElement(bs0);
        }
        sp.appendDevice().setDeviceID("Press_ID");
        sp.appendPosition().setRelativeBox(new JDFRectangle(0.0, 0.0, 0.5, 1.0));
        sp.appendPosition().setRelativeBox(new JDFRectangle(0.5, 1.0, 1.0, 1.0));
        sp.appendStripCellParams().setTrimSize(new JDFXYPair(612.0, 792.0));
        sp.refElement(this.initPaperMedia());
    }

    private void initGBImpositionPreparation() {
        this.theNode.setTypes(new VString(this.bStripping ? "Stripping" : "ImpositionPreparation", null));
        if (this.bStripping) {
            this.initBinderySignature("F4-1");
            this.initBinderySignature("F16-2");
            this.initStrippingParams();
            this.initAssembly();
        }
        this.initOutputLayout();
        JDFRunList rlMarks = this.initConduitRunListOut();
        this.theNode.getLink((JDFResource)rlMarks, JDFResourceLink.EnumUsage.Output).setProcessUsage(JDFNode.EnumProcessUsage.Marks);
    }

    private void initAssembly() {
        JDFAssembly assem = (JDFAssembly)this.theNode.getCreateResource("Assembly", JDFResourceLink.EnumUsage.Input, 0);
        assem.setOrder(JDFAutoAssembly.EnumOrder.Collecting);
    }

    private void initOutputLayout() {
        JDFLayout lo = (JDFLayout)this.theNode.getCreateResource("Layout", JDFResourceLink.EnumUsage.Output, 0);
        lo.setDescriptiveName("Conduit Layout");
        lo.setResStatus(JDFResource.EnumResStatus.Unavailable, false);
        VString vSigSheetSide = new VString("SignatureName SheetName Side", null);
        lo.setPartIDKeys(vSigSheetSide);
        for (int i = 0; i < this.vParts.size(); ++i) {
            lo.getCreatePartition(this.vParts.elementAt(i), vSigSheetSide);
        }
    }

    private void initGBContentCreation() {
        this.theNode.setTypes(new VString(JDFNode.EnumType.LayoutElementProduction.getName(), null));
        JDFRunList ruli = this.initDocumentRunList();
        JDFResourceLink rl = this.theNode.getLink((JDFResource)ruli, JDFResourceLink.EnumUsage.Input);
        rl.setProcessUsage((JDFNode.EnumProcessUsage)null);
        this.initLayoutElementProductionParams();
        this.initConduitRunListOut();
    }

    private JDFRunList initConduitRunListOut() {
        JDFRunList rl = (JDFRunList)this.theNode.getCreateResource("RunList", JDFResourceLink.EnumUsage.Output, 0);
        rl.setResStatus(JDFResource.EnumResStatus.Unavailable, false);
        rl.setDescriptiveName("Marks RunList");
        return rl;
    }

    private void initLayoutElementProductionParams() {
        JDFLayoutElementProductionParams lep = (JDFLayoutElementProductionParams)this.theNode.getCreateResource("LayoutElementProductionParams", JDFResourceLink.EnumUsage.Input, 0);
        JDFBarcodeProductionParams bp = lep.getCreateLayoutElementPart(0).appendBarcodeProductionParams();
        JDFIdentificationField idf = bp.appendIdentificationField();
        idf.setEncoding(JDFAutoIdentificationField.EnumEncoding.Barcode);
        idf.setEncodingDetails("EAN");
        idf.setValue("123456");
    }

    private void initColsFromParent() {
        if (this.theParentNode == null) {
            return;
        }
        JDFColorIntent ci = (JDFColorIntent)this.theParentNode.getResource("ColorIntent", JDFResourceLink.EnumUsage.Input, 0);
        if (ci == null) {
            return;
        }
        int c = ci.getNumColors();
        if (c > 0) {
            this.nCols[0] = this.nCols[1] = c;
        }
    }

    @Override
    public void execute(VJDFAttributeMap parts, boolean outputAvailable, boolean bFirst) {
        VJDFAttributeMap partsLocal = parts;
        partsLocal = null;
        this.setActivePart(partsLocal, bFirst);
        super.execute(partsLocal, outputAvailable, bFirst);
        if (MISPRE_IMPOSITIONPREPARATION.equals(this.getCategory())) {
            this.executeGBImpositionPreparation();
        }
    }

    private void executeGBImpositionPreparation() {
        this.executeLayout();
        this.executeRunList(JDFResourceLink.EnumUsage.Input);
        this.executeMarksRunList(JDFResourceLink.EnumUsage.Output);
    }

    private void executeMarksRunList(JDFResourceLink.EnumUsage usage) {
        JDFRunList rl = (JDFRunList)this.theExpandedNode.getResource("RunList", usage, 0);
        if (!"Marks".equals(this.theExpandedNode.getLink((JDFResource)rl, usage).getProcessUsage())) {
            rl = (JDFRunList)this.theExpandedNode.getResource("RunList", usage, 1);
        }
        if (!"Marks".equals(this.theExpandedNode.getLink((JDFResource)rl, usage).getProcessUsage())) {
            rl = null;
        }
        if (rl != null && !rl.hasChildElement("LayoutElement", null)) {
            rl.addPDF("./folder/TheMarks.pdf", 0, -1);
        }
    }

    private void executeRunList(JDFResourceLink.EnumUsage usage) {
        JDFRunList rl = (JDFRunList)this.theExpandedNode.getResource("RunList", usage, 0);
        if (rl == null) {
            return;
        }
        if (!rl.hasChildElement("LayoutElement", null)) {
            rl.addPDF("./folder/Thedoc.pdf", 0, -1);
        }
        if (JDFResourceLink.EnumUsage.Output.equals((Object)usage)) {
            rl.setResStatus(JDFResource.EnumResStatus.Available, true);
        }
    }

    private void executeLayout() {
        JDFLayout lo = (JDFLayout)this.theExpandedNode.getResource("Layout", JDFResourceLink.EnumUsage.Output, 0);
        if (lo != null && this.vParts != null) {
            VJDFAttributeMap reducedMap = this.getReducedMap(new VString("Separation PartVersion", " "));
            lo.setResStatus(JDFResource.EnumResStatus.Available, true);
            if (reducedMap != null) {
                int size = reducedMap.size();
                for (int i = 0; i < size; ++i) {
                    JDFAttributeMap part = reducedMap.elementAt(i);
                    if (this.bSingleSided && "Back".equals(part.get("Side"))) continue;
                    JDFLayout partLO = (JDFLayout)lo.getCreatePartition(part, this.partIDKeys);
                    for (int j = 0; j < 4; ++j) {
                        JDFContentObject co = partLO.appendContentObject();
                        co.setCTM(new JDFMatrix(1 + 10 * j, 2 + 20 * j, 3 + 30 * j, 4 + 40 * j, 5 + 50 * j, 6 + 0 * j));
                        co.setOrd(j + i * 4);
                    }
                }
            }
        }
    }

    protected void initPreviewSep() {
        if (this.theParentNode != null) {
            this.theNode.ensureLink(this.theParentNode.getResource("Preview", JDFResourceLink.EnumUsage.Output, 0), JDFResourceLink.EnumUsage.Output, null);
        }
        JDFPreview pv = (JDFPreview)this.theNode.getCreateResource("Preview", JDFResourceLink.EnumUsage.Output, 0);
        pv.setResStatus(JDFResource.EnumResStatus.Incomplete, false);
        pv.setPreviewUsage(JDFAutoPreview.EnumPreviewUsage.Separation);
        pv.setPartUsage(JDFResource.EnumPartUsage.Explicit);
        pv.setPreviewFileType(JDFPreview.EnumPreviewFileType.PNG);
        if (this.vParts != null) {
            for (int i = 0; i < this.vParts.size(); ++i) {
                JDFAttributeMap part = this.vParts.elementAt(i);
                JDFPreview pvp = (JDFPreview)pv.getCreatePartition(part, this.partIDKeys);
                int ncols = "Front".equals(part.get("Side")) ? this.nCols[0] : this.nCols[1];
                for (int j = 0; j < ncols; ++j) {
                    JDFPreview pvsep = (JDFPreview)pvp.getCreatePartition(JDFResource.EnumPartIDKey.Separation, this.cols.get(j), this.partIDKeys);
                    pvsep.setURL("http://foo.preview." + i + "." + this.cols.get(j) + ".pdf");
                    pvsep.setResStatus(JDFResource.EnumResStatus.Incomplete, false);
                }
            }
        }
    }

    protected void initPreviewComp() {
        if (this.theParentNode != null) {
            this.theNode.ensureLink(this.theParentNode.getResource("Preview", JDFResourceLink.EnumUsage.Output, 0), JDFResourceLink.EnumUsage.Output, null);
        }
        JDFPreview pv = (JDFPreview)this.theNode.getCreateResource("Preview", JDFResourceLink.EnumUsage.Output, 0);
        pv.setResStatus(JDFResource.EnumResStatus.Incomplete, false);
        pv.setPreviewUsage(JDFAutoPreview.EnumPreviewUsage.Viewable);
        pv.setPartUsage(JDFResource.EnumPartUsage.Explicit);
        pv.setPreviewFileType(JDFPreview.EnumPreviewFileType.PNG);
        if (this.vParts != null) {
            VJDFAttributeMap vRedParts = this.getReducedMap(new VString("Separation", null));
            for (int i = 0; i < vRedParts.size(); ++i) {
                JDFAttributeMap part = this.vParts.elementAt(i);
                JDFPreview pvp = (JDFPreview)pv.getCreatePartition(part, this.partIDKeys);
                pvp.setResStatus(JDFResource.EnumResStatus.Incomplete, false);
            }
        }
    }

    @Override
    public void makeReady() {
        super.makeReady();
        this.makeReadyPreviewGeneration();
    }

    private void makeReadyPreviewGeneration() {
        VString v = this.theExpandedNode.getAllTypes();
        if (v != null && v.contains(JDFNode.EnumType.PreviewGeneration.getName())) {
            JDFPreviewGenerationParams pgp = (JDFPreviewGenerationParams)this.theExpandedNode.getCreateResource("PreviewGenerationParams", JDFResourceLink.EnumUsage.Input, 0);
            pgp.setPreviewUsage(JDFAutoPreviewGenerationParams.EnumPreviewUsage.Separation);
        }
    }

    public JDFMedia getPlateMedia() {
        if (this.theNode == null) {
            return null;
        }
        for (int i = 0; i < 10; ++i) {
            JDFMedia plate = (JDFMedia)this.theNode.getResource("Media", JDFResourceLink.EnumUsage.Input, i);
            if (plate == null) {
                return null;
            }
            if (!JDFAutoMedia.EnumMediaType.Plate.equals((Object)plate.getMediaType())) continue;
            return plate;
        }
        return null;
    }
}

