/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.pool;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoNotification;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueueEntry;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.JDFSpawned;
import org.cip4.jdflib.pool.JDFPool;
import org.cip4.jdflib.resource.JDFCreated;
import org.cip4.jdflib.resource.JDFDeleted;
import org.cip4.jdflib.resource.JDFMerged;
import org.cip4.jdflib.resource.JDFModified;
import org.cip4.jdflib.resource.JDFNotification;
import org.cip4.jdflib.resource.JDFPhaseTime;
import org.cip4.jdflib.resource.JDFProcessRun;
import org.cip4.jdflib.resource.JDFResourceAudit;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFAuditPool
extends JDFPool {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[9];

    public JDFAuditPool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAuditPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAuditPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    @Override
    public String toString() {
        return "JDFAuditPool[ -->" + super.toString() + "]";
    }

    public void ensureCreated() {
        JDFAudit created = this.getAudit(0, JDFAudit.EnumAuditType.Created, null, null);
        if (created == null) {
            JDFAudit a = this.getAudit(0, null, null, null);
            JDFCreated c = this.addCreated(null, null);
            if (a != null) {
                c.setTimeStamp(a.getTimeStamp());
                this.moveElement(c, a);
            }
        }
    }

    @Deprecated
    public JDFProcessRun addProcessRun(JDFElement.EnumNodeStatus s, String by) {
        return this.addProcessRun(s, by, null);
    }

    public JDFProcessRun addProcessRun(JDFElement.EnumNodeStatus s, String by, VJDFAttributeMap vmParts) {
        JDFProcessRun pr = (JDFProcessRun)this.addAudit(JDFAudit.EnumAuditType.ProcessRun, by);
        pr.setStart(null);
        pr.setEnd(null);
        pr.setEndStatus(s);
        pr.setPartMapVector(vmParts);
        return pr;
    }

    public JDFAudit addAudit(JDFAudit.EnumAuditType typ, String by) {
        JDFNode r;
        JDFAudit l = (JDFAudit)this.appendElement(typ.getName(), null);
        if (by != null) {
            JDFElement.EnumVersion version = this.getVersion(true);
            if (version != null && (EnumUtil.aLessThanB(version, JDFElement.EnumVersion.Version_1_4) || EnumUtil.aLessEqualsThanB(JDFElement.EnumVersion.Version_2_0, version))) {
                l.setAuthor(by);
            } else {
                l.appendEmployee().setDescriptiveName(by);
            }
        }
        if ((r = this.getJDFRoot()) != null && r.hasAttribute("SpawnID")) {
            l.setSpawnID(r.getSpawnID(false));
        }
        return l;
    }

    public JDFCreated addCreated(String by, KElement createdElem) {
        JDFCreated created = (JDFCreated)this.addAudit(JDFAudit.EnumAuditType.Created, by);
        if (createdElem != null) {
            String xpath = createdElem.buildRelativeXPath(this.getParentJDF(), 1);
            created.setXPath(xpath);
        }
        return created;
    }

    public JDFModified addModified(String by, KElement modifiedElem) {
        JDFModified modified = (JDFModified)this.addAudit(JDFAudit.EnumAuditType.Modified, by);
        if (modifiedElem != null) {
            String xpath = modifiedElem.buildRelativeXPath(this.getParentJDF(), 1);
            modified.setXPath(xpath);
        }
        return modified;
    }

    public JDFDeleted addDeleted(String by, KElement deletedElem) {
        JDFDeleted deleted = (JDFDeleted)this.addAudit(JDFAudit.EnumAuditType.Deleted, by);
        if (deletedElem != null) {
            String xpath = deletedElem.buildRelativeXPath(this.getParentJDF(), 1);
            deleted.setXPath(xpath);
        }
        return deleted;
    }

    public JDFResourceAudit addResourceAudit(String by) {
        return (JDFResourceAudit)this.addAudit(JDFAudit.EnumAuditType.ResourceAudit, by);
    }

    public JDFAudit addEvent(String by, JDFAudit.EnumSeverity s) {
        JDFNotification l = (JDFNotification)this.addAudit(JDFAudit.EnumAuditType.Notification, by);
        l.setSeverity(s);
        return l;
    }

    public JDFPhaseTime addPhaseTime(JDFElement.EnumNodeStatus phase, String by, VJDFAttributeMap vmParts) {
        JDFPhaseTime myAudit = (JDFPhaseTime)this.addAudit(JDFAudit.EnumAuditType.PhaseTime, by);
        myAudit.setStatus(phase);
        myAudit.setStart(new JDFDate());
        myAudit.setPartMapVector(vmParts);
        JDFNode parentJDF = this.getParentJDF();
        if (parentJDF != null) {
            myAudit.setSpawnID(StringUtil.getNonEmpty(parentJDF.getSpawnID(true)));
        }
        return myAudit;
    }

    public JDFSpawned addSpawned(JDFNode spawned, VString rRefsRO, VString rRefsRW, String by, VJDFAttributeMap vmParts) {
        JDFSpawned a = (JDFSpawned)this.addAudit(JDFAudit.EnumAuditType.Spawned, by);
        a.setAttribute("jRef", spawned.getID(), null);
        String ms = null;
        if (rRefsRO != null && !rRefsRO.isEmpty()) {
            ms = StringUtil.setvString(rRefsRO);
            a.setAttribute("rRefsROCopied", ms, null);
        }
        if (rRefsRW != null && !rRefsRW.isEmpty()) {
            ms = StringUtil.setvString(rRefsRW);
            a.setAttribute("rRefsRWCopied", ms, null);
        }
        a.setPartMapVector(vmParts);
        return a;
    }

    public JDFMerged addMerged(JDFNode merged, VString rRefsOverwritten, String by, VJDFAttributeMap vmParts) {
        VString rRefsOverwrittenLocal = rRefsOverwritten;
        JDFMerged mergedAudit = (JDFMerged)this.addAudit(JDFAudit.EnumAuditType.Merged, by);
        mergedAudit.setjRef(merged.getID());
        if (rRefsOverwrittenLocal != null && rRefsOverwrittenLocal.isEmpty()) {
            rRefsOverwrittenLocal = null;
        }
        mergedAudit.setrRefsOverwritten(rRefsOverwrittenLocal);
        mergedAudit.setPartMapVector(vmParts);
        return mergedAudit;
    }

    public JDFNotification addNotification(JDFAutoNotification.EnumClass severity, String by, VJDFAttributeMap vmParts) {
        JDFNotification l = (JDFNotification)this.addAudit(JDFAudit.EnumAuditType.Notification, by);
        if (l != null) {
            if (severity != null) {
                l.setClass(severity);
            }
            l.setPartMapVector(vmParts);
        }
        return l;
    }

    @Deprecated
    public JDFPhaseTime getLastPhase() {
        return this.getLastPhase(null, null);
    }

    @Deprecated
    public JDFPhaseTime getLastPhase(VJDFAttributeMap vPartMap) {
        return this.getLastPhase(vPartMap, null);
    }

    public VElement getResourceAudits(String id, VJDFAttributeMap vPartMap) {
        VElement audits = this.getAudits(JDFAudit.EnumAuditType.ResourceAudit, null, vPartMap);
        if (audits == null || id == null) {
            return null;
        }
        for (int i = audits.size() - 1; i >= 0; --i) {
            JDFResourceAudit ra = (JDFResourceAudit)audits.get(i);
            JDFResourceLink rl = ra.getNewLink();
            if (rl != null && id.equals(rl.getrRef())) continue;
            audits.remove(i);
        }
        return audits.size() == 0 ? null : audits;
    }

    public JDFPhaseTime getLastPhase(VJDFAttributeMap vPartMap, String moduleID) {
        if (KElement.isWildCard(moduleID)) {
            return (JDFPhaseTime)this.getAudit(-1, JDFAudit.EnumAuditType.PhaseTime, null, vPartMap);
        }
        VElement e = this.getAudits(JDFAudit.EnumAuditType.PhaseTime, null, vPartMap);
        if (e != null) {
            int size;
            for (int i = size = e.size() - 1; i >= 0; --i) {
                JDFPhaseTime pt = (JDFPhaseTime)e.elementAt(i);
                if (pt.getChildWithAttribute("ModulePhase", "ModuleID", null, moduleID, 0, true) == null) continue;
                return pt;
            }
        }
        return null;
    }

    @Deprecated
    public VElement getAudits(JDFAudit.EnumAuditType typ, JDFAttributeMap mAttributes) {
        return this.getAudits(typ, mAttributes, null);
    }

    public VElement getAudits(JDFAudit.EnumAuditType typ, JDFAttributeMap mAttributes, VJDFAttributeMap vParts) {
        String strAuditType = null;
        if (typ != null) {
            strAuditType = typ.getName();
        }
        VElement vElem = this.getPoolChildrenGeneric(strAuditType, mAttributes, null);
        if (vParts != null && vParts.size() == 0) {
            vParts = null;
        }
        for (int i = vElem.size() - 1; i >= 0; --i) {
            if (!(vElem.elementAt(i) instanceof JDFAudit)) {
                vElem.removeElementAt(i);
                continue;
            }
            JDFAudit audit = (JDFAudit)vElem.elementAt(i);
            if (vParts == null || vParts.overlapsMap(audit.getPartMapVector())) continue;
            vElem.removeElementAt(i);
        }
        return vElem;
    }

    @Deprecated
    public JDFAudit getAudit(int index, JDFAudit.EnumAuditType typ, JDFAttributeMap mAttributes) {
        return this.getAudit(index, typ, mAttributes, null);
    }

    public JDFAudit getAudit(int index, JDFAudit.EnumAuditType typ, JDFAttributeMap mAttributes, VJDFAttributeMap vParts) {
        VElement v = this.getAudits(typ, mAttributes, vParts);
        if (index < 0) {
            index = v.size() + index;
        }
        if (index >= v.size() || index < 0) {
            return null;
        }
        return (JDFAudit)v.elementAt(index);
    }

    public VElement setPhase(JDFJMF jmf) {
        VElement vMessages = jmf.getMessageVector(null, JDFMessage.EnumType.Status);
        if (vMessages == null) {
            return null;
        }
        VElement vRet = new VElement();
        for (int i = 0; i < vMessages.size(); ++i) {
            JDFMessage status = (JDFMessage)vMessages.elementAt(i);
            VElement devInfos = status.getChildElementVector("DeviceInfo", null, null, true, 0, true);
            for (int j = 0; j < devInfos.size(); ++j) {
                JDFDeviceInfo devInfo = (JDFDeviceInfo)devInfos.elementAt(j);
                VElement phases = devInfo.getChildElementVector("JobPhase", null, null, true, 0, true);
                for (int k = 0; k < phases.size(); ++k) {
                    String jobPartID;
                    JDFJobPhase phase = (JDFJobPhase)phases.elementAt(k);
                    String jobID = phase.getJobID();
                    if (!jobID.equals(this.getParentJDF().getJobID(true)) || !(jobPartID = phase.getJobPartID()).equals(this.getParentJDF().getJobPartID(true))) continue;
                    JDFPhaseTime pt = this.setPhase(phase.getStatus(), phase.getStatusDetails(), phase.getPartMapVector(), devInfo.getChildElementVector("Employee", null));
                    if (pt.getMISDetails() == null) {
                        pt.copyElement(phase.getMISDetails(), null);
                    }
                    pt.setEnd(jmf.getTimeStamp());
                    pt.setStart(phase.getPhaseStartTime());
                    vRet.add(pt);
                }
            }
        }
        vRet.unify();
        return vRet.size() == 0 ? null : vRet;
    }

    @Deprecated
    public JDFPhaseTime setPhase(JDFElement.EnumNodeStatus status, String statusDetails, VJDFAttributeMap vmParts) {
        return this.setPhase(status, statusDetails, vmParts, null);
    }

    public JDFPhaseTime setPhase(JDFElement.EnumNodeStatus status, String statusDetails, VJDFAttributeMap vmParts, VElement employees) {
        VElement ptEmployees;
        JDFPhaseTime lastPhaseTime = this.getLastPhase(vmParts, null);
        statusDetails = StringUtil.getNonEmpty(statusDetails);
        if (status == null && lastPhaseTime != null) {
            status = lastPhaseTime.getStatus();
        }
        if (statusDetails == null && lastPhaseTime != null) {
            statusDetails = StringUtil.getNonEmpty(lastPhaseTime.getStatusDetails());
        }
        boolean bChanged = false;
        VElement vElement = ptEmployees = lastPhaseTime == null ? new VElement() : lastPhaseTime.getChildElementVector("Employee", null);
        if (lastPhaseTime == null) {
            bChanged = true;
        } else if (!(ContainerUtil.equals((Object)lastPhaseTime.getStatus(), (Object)status) && ContainerUtil.equals(statusDetails, lastPhaseTime.getAttribute("StatusDetails", null, null)) && ptEmployees.isEqual(employees))) {
            lastPhaseTime.setEnd(new JDFDate());
            bChanged = true;
        }
        if (bChanged) {
            JDFPhaseTime thisPhaseTime = this.addPhaseTime(status, null, vmParts);
            thisPhaseTime.setStatusDetails(statusDetails);
            thisPhaseTime.copyElements(employees, null);
            return thisPhaseTime;
        }
        return lastPhaseTime;
    }

    public VElement getLinkedResources(JDFAttributeMap mResAtt, boolean bFollowRefs) {
        VString refs = this.getHRefs(null, false, true);
        refs.unify();
        VElement v = new VElement();
        for (int i = 0; i < refs.size(); ++i) {
            KElement e = this.getTarget(refs.elementAt(i), "ID");
            if (e == null || !e.includesAttributes(mResAtt, true)) continue;
            v.addElement(e);
            if (!bFollowRefs || !(e instanceof JDFElement)) continue;
            v.appendUnique(((JDFElement)e).getvHRefRes(bFollowRefs, true));
        }
        return v;
    }

    @Deprecated
    public VElement getLinks(JDFAttributeMap mLinkAtt) {
        return this.getPoolChildrenGeneric("", mLinkAtt, "");
    }

    public void appendUnique(JDFAudit p) {
        this.appendUniqueGeneric(p);
    }

    public void appendUnique(JDFAuditPool p) {
        this.appendUniqueGeneric(p);
    }

    public VElement getPoolChildren(String strName, JDFAttributeMap mAttrib) {
        return this.getPoolChildrenGeneric(strName, mAttrib, "");
    }

    @Deprecated
    public void cleanUpMerge(JDFNode.EnumCleanUpMerge cleanPolicy, String spawnID) throws NoSuchMethodException {
        throw new NoSuchMethodException("use JDFMerge.cleanUpMergeAudits");
    }

    public JDFProcessRun createSubmitProcessRun(JDFQueueEntry qe) {
        JDFProcessRun pr = (JDFProcessRun)this.addAudit(JDFAudit.EnumAuditType.ProcessRun, null);
        pr.setSubmissionTime(new JDFDate());
        if (qe != null) {
            pr.setPartMapVector(qe.getPartMapVector());
            pr.copyAttribute("QueueEntryID", qe, null, null, null);
            if (qe.hasAttribute("SubmissionTime")) {
                pr.copyAttribute("SubmissionTime", qe, null, null, null);
            }
        }
        if (!pr.hasAttribute("SubmissionTime")) {
            pr.setSubmissionTime(new JDFDate());
        }
        if (!pr.hasAttribute("QueueEntryID")) {
            pr.setAttribute("QueueEntryID", "qe_" + KElement.uniqueID(0));
        }
        return pr;
    }

    static {
        JDFAuditPool.elemInfoTable[0] = new ElemInfoTable("Created", 0x33333333L);
        JDFAuditPool.elemInfoTable[1] = new ElemInfoTable("Deleted", 0x33333333L);
        JDFAuditPool.elemInfoTable[2] = new ElemInfoTable("Modified", 0x33333333L);
        JDFAuditPool.elemInfoTable[3] = new ElemInfoTable("Notification", 0x33333333L);
        JDFAuditPool.elemInfoTable[4] = new ElemInfoTable("ResourceAudit", 0x33333333L);
        JDFAuditPool.elemInfoTable[5] = new ElemInfoTable("Spawned", 0x33333333L);
        JDFAuditPool.elemInfoTable[6] = new ElemInfoTable("Merged", 0x33333333L);
        JDFAuditPool.elemInfoTable[7] = new ElemInfoTable("PhaseTime", 0x33333333L);
        JDFAuditPool.elemInfoTable[8] = new ElemInfoTable("ProcessRun", 0x33333333L);
    }
}

