/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDevCaps;
import org.cip4.jdflib.auto.JDFAutoDeviceCap;
import org.cip4.jdflib.auto.JDFAutoMessageService;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.ifaces.IDeviceCapable;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFMessageService;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFAction;
import org.cip4.jdflib.resource.devicecapability.JDFActionPool;
import org.cip4.jdflib.resource.devicecapability.JDFBooleanState;
import org.cip4.jdflib.resource.devicecapability.JDFDevCaps;
import org.cip4.jdflib.resource.devicecapability.JDFEnumerationState;
import org.cip4.jdflib.resource.devicecapability.JDFIntegerState;
import org.cip4.jdflib.resource.devicecapability.JDFLoc;
import org.cip4.jdflib.resource.devicecapability.JDFModuleCap;
import org.cip4.jdflib.resource.devicecapability.JDFNameState;
import org.cip4.jdflib.resource.devicecapability.JDFNumberState;
import org.cip4.jdflib.resource.devicecapability.JDFStringState;
import org.cip4.jdflib.resource.devicecapability.JDFTest;
import org.cip4.jdflib.resource.devicecapability.JDFTestPool;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.VectorMap;

public class JDFDeviceCap
extends JDFAutoDeviceCap
implements IDeviceCapable {
    public static final String FITS_TYPE = "FitsType";
    private static final long serialVersionUID = 1L;
    private boolean ignoreExtensions = false;
    private boolean ignoreDefaults = false;
    private VectorMap setResMap = null;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[13];

    public JDFDeviceCap(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDeviceCap(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDeviceCap(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    @Override
    public String toString() {
        return "JDFDeviceCap[  --> " + super.toString() + " ]";
    }

    @Override
    public String getTypeExpression() {
        if (this.hasAttribute("TypeExpression")) {
            return super.getTypeExpression();
        }
        return this.getAttribute("Types");
    }

    public Vector getCombinedMethod() {
        Vector<Object> v = this.getEnumerationsAttribute("CombinedMethod", null, JDFAutoDeviceCap.EnumCombinedMethod.None, false);
        if (v == null) {
            v = new Vector();
            v.add((ValuedEnum)JDFAutoDeviceCap.EnumCombinedMethod.None);
        }
        return v;
    }

    @Override
    public final VString getNamePathVector() {
        VString vResult = new VString();
        vResult.add("JDF");
        return vResult;
    }

    public final VElement getExecutableJDF(JDFNode jdfRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level) {
        VElement execNodes = new VElement();
        JDFAutoDeviceCap.EnumExecutionPolicy execPolicy = this.getExecutionPolicy();
        VElement vNodes = null;
        if (execPolicy.equals((Object)JDFAutoDeviceCap.EnumExecutionPolicy.RootNode)) {
            vNodes = new VElement();
            vNodes.add(jdfRoot);
        } else {
            vNodes = jdfRoot.getvJDFNode(null, null, false);
        }
        XMLDoc d = new XMLDoc("dummy", null);
        for (int i = 0; i < vNodes.size(); ++i) {
            JDFNode n = (JDFNode)vNodes.elementAt(i);
            KElement root = d.getRoot();
            try {
                KElement nOutput = this.report(n, testlists, level, root);
                if (nOutput != null) continue;
                execNodes.addElement(n);
                continue;
            }
            catch (JDFException jdfe) {
                // empty catch block
            }
        }
        return execNodes.isEmpty() ? null : execNodes;
    }

    public final XMLDoc getBadJDFInfo(JDFNode jdfRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level) {
        XMLDoc bugReport = new XMLDoc("BugReport", null);
        KElement outputRoot = bugReport.getRoot();
        VElement vNodes = jdfRoot.getvJDFNode(null, null, false);
        int size = vNodes.size();
        for (int i = 0; i < size; ++i) {
            JDFNode n = (JDFNode)vNodes.elementAt(i);
            KElement report = null;
            try {
                report = this.report(n, testlists, level, outputRoot);
                continue;
            }
            catch (JDFException jdfe) {
                report = outputRoot.appendElement("RejectedNode");
                report.setAttribute("CaughtException", jdfe.getMessage());
                report.setAttribute("ID", n.getID());
                report.setAttribute("XPath", n.buildXPath(null, 1));
            }
        }
        if (!outputRoot.hasChildNodes()) {
            bugReport = null;
        }
        return bugReport;
    }

    public static XMLDoc getJMFInfo(JDFJMF jmfRoot, JDFResponse knownMessagesResp, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, boolean ignoreExtensions) {
        XMLDoc bugReport = new XMLDoc("JMFReport", null);
        KElement parentRoot = bugReport.getRoot();
        int nBad = 0;
        if (!jmfRoot.isValid(level)) {
            parentRoot.setAttribute("IsValid", false, null);
        }
        VElement messages = jmfRoot.getMessageVector(null, null);
        for (int i = 0; i < messages.size(); ++i) {
            KElement messageReport = parentRoot.appendElement("InvalidMessage");
            JDFMessage m = (JDFMessage)messages.elementAt(i);
            String typeJMF = m.getType();
            messageReport.setAttribute("MessageType", typeJMF);
            messageReport.setAttribute("XPath", m.buildXPath(null, 1));
            messageReport.setAttribute("ID", m.getID());
            JDFMessageService ms = JDFDeviceCap.getMessageServiceForJMFType(m, knownMessagesResp);
            if (ms != null) {
                messageReport.setAttribute(FITS_TYPE, true, null);
                JDFDeviceCap.invalidDevCaps(ms, m, testlists, level, messageReport, ignoreExtensions);
                JDFDeviceCap.actionPoolReport(ms, m, messageReport);
            } else {
                messageReport.setAttribute(FITS_TYPE, false, null);
                messageReport.setAttribute("Message", "JMF  Type: " + typeJMF + " does not match capabilities type: ");
            }
            if (!messageReport.hasChildElements() && messageReport.getBoolAttribute(FITS_TYPE, null, true)) {
                messageReport.renameElement("ValidMessage", null);
                continue;
            }
            ++nBad;
        }
        parentRoot.setAttribute("IsValid", nBad == 0, null);
        return bugReport;
    }

    public static JDFMessageService getMessageServiceForJMFType(JDFMessage m, JDFResponse knownMessagesResp) {
        if (knownMessagesResp == null || !knownMessagesResp.getType().equals("KnownMessages") || m == null || m.getType().equals("")) {
            return null;
        }
        JDFAttributeMap map = new JDFAttributeMap("Type", m.getType());
        JDFMessage.EnumFamily fam = m.getFamily();
        if (fam != null) {
            if (JDFMessage.EnumFamily.Response.equals((Object)fam)) {
                map.put("JMFRole", (ValuedEnum)JDFAutoMessageService.EnumJMFRole.Sender);
            } else {
                map.put(fam.getName(), "true");
            }
        }
        return (JDFMessageService)knownMessagesResp.getChildByTagName("MessageService", null, 0, map, true, true);
    }

    private final KElement report(JDFNode jdfRoot, JDFBaseDataTypes.EnumFitsValue fitsValue, JDFElement.EnumValidationLevel level, KElement parentRoot) {
        KElement root = parentRoot.appendElement("RejectedNode");
        root.setAttribute("XPath", jdfRoot.buildXPath(null, 1));
        root.setAttribute("ID", jdfRoot.getID());
        String typeExp = this.getTypeExpression();
        if (!jdfRoot.isValid(level)) {
            root.setAttribute("IsValid", false, null);
        }
        String badState = this.misMatchingStates(jdfRoot);
        if (!this.matchesType(jdfRoot, true) || badState != null) {
            String typeNode = jdfRoot.getType();
            this.reportTypeMatch(root, false, typeNode, typeExp);
            if (badState != null) {
                root.setAttribute("BadStateName", badState);
                root.setAttribute("BadStateValue", jdfRoot.getAttribute(badState, null, null));
                root.copyElement(this.getState(badState), null);
            }
            return root;
        }
        if (!(root = this.groupReport(jdfRoot, fitsValue, level, root)).hasChildElements() && root.getBoolAttribute(FITS_TYPE, null, true)) {
            root.deleteNode();
            root = null;
        }
        return root;
    }

    private String misMatchingStates(JDFNode jdfRoot) {
        VElement vStates = this.getStates();
        if (vStates == null) {
            return null;
        }
        for (int i = 0; i < vStates.size(); ++i) {
            String attName;
            JDFAbstractState state = (JDFAbstractState)vStates.get(i);
            if (state.fitsValue(jdfRoot.getAttribute(attName = state.getName(), null, null), JDFBaseDataTypes.EnumFitsValue.Present)) continue;
            return attName;
        }
        return null;
    }

    public boolean matchesType(JDFNode testRoot, boolean bLocal) {
        VElement v = this.getMatchingTypeNodeVector(testRoot);
        if (v == null) {
            return false;
        }
        if (bLocal) {
            return v.contains(testRoot);
        }
        return true;
    }

    public VElement getMatchingTypeNodeVector(JDFNode testRoot) {
        if (testRoot == null || !testRoot.hasAttribute("Type")) {
            return null;
        }
        VElement v = new VElement();
        String typeNode = testRoot.getType();
        Vector vCombMethod = this.getCombinedMethod();
        String typeExp = this.getTypeExpression();
        for (int j = 0; j < vCombMethod.size(); ++j) {
            JDFAutoDeviceCap.EnumCombinedMethod combMethod = (JDFAutoDeviceCap.EnumCombinedMethod)((Object)vCombMethod.elementAt(j));
            if (combMethod.equals((Object)JDFAutoDeviceCap.EnumCombinedMethod.None)) {
                if (!StringUtil.matches(typeNode, typeExp)) continue;
                v.add(testRoot);
                continue;
            }
            if (combMethod.equals((Object)JDFAutoDeviceCap.EnumCombinedMethod.Combined) || combMethod.equals((Object)JDFAutoDeviceCap.EnumCombinedMethod.CombinedProcessGroup) && typeNode.equals("Combined")) {
                if (!this.fitsTypes(testRoot.getAllTypes(), false)) continue;
                v.add(testRoot);
                continue;
            }
            if (combMethod.equals((Object)JDFAutoDeviceCap.EnumCombinedMethod.GrayBox) || combMethod.equals((Object)JDFAutoDeviceCap.EnumCombinedMethod.CombinedProcessGroup) && typeNode.equals("ProcessGroup") && !testRoot.isGroupNode()) {
                if (!this.fitsTypes(testRoot.getAllTypes(), true)) continue;
                v.add(testRoot);
                continue;
            }
            if (combMethod.equals((Object)JDFAutoDeviceCap.EnumCombinedMethod.ProcessGroup) || combMethod.equals((Object)JDFAutoDeviceCap.EnumCombinedMethod.CombinedProcessGroup) && typeNode.equals("ProcessGroup")) {
                VElement vNodes = testRoot.getvJDFNode(null, null, false);
                int size = vNodes.size();
                for (int i = 0; i < size - 1; ++i) {
                    JDFNode node = (JDFNode)vNodes.elementAt(i);
                    if (node.isGroupNode()) {
                        VElement matchingTypeNodeVector = this.getMatchingTypeNodeVector(node);
                        if (matchingTypeNodeVector == null) continue;
                        v.addAll(matchingTypeNodeVector);
                        continue;
                    }
                    if (!this.fitsTypes(node.getAllTypes(), true)) continue;
                    v.add(node);
                }
                continue;
            }
            throw new JDFException("JDFDeviceCap.report: Invalid DeviceCap: illegal value of CombinedMethod attribute");
        }
        v.unify();
        return v.size() == 0 ? null : v;
    }

    private void reportTypeMatch(KElement report, boolean matches, String typeNode, String typeExp) {
        report.setAttribute(FITS_TYPE, matches, null);
        report.setAttribute("NodeType", typeNode);
        report.setAttribute("CapsType", typeExp);
        report.copyAttribute("DescriptiveName", this, null, null, null);
        report.setAttribute("CapXPath", this.buildXPath(null, 2));
        if (!matches) {
            report.setAttribute("Message", "Node Type: " + typeNode + " does not match capabilities type: " + typeExp);
        }
    }

    private final boolean fitsTypes(VString typesNode, boolean bSubset) {
        if (typesNode == null || typesNode.isEmpty()) {
            return false;
        }
        if (!bSubset) {
            if (this.hasAttribute("TypeExpression")) {
                String typeExp = this.getTypeExpression();
                String typesNodeStr = StringUtil.setvString(typesNode, " ", null, null);
                return StringUtil.matches(typesNodeStr, typeExp);
            }
            return typesNode.equals(this.getTypes());
        }
        VString dcTypes = this.getTypes();
        for (int i = 0; i < typesNode.size(); ++i) {
            String type = typesNode.get(i);
            if (dcTypes.contains(type)) continue;
            return false;
        }
        return true;
    }

    private final KElement groupReport(JDFNode jdfRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, KElement parentRoot) {
        parentRoot.setAttribute("XPath", jdfRoot.buildXPath(null, 1));
        parentRoot.setAttribute("ID", jdfRoot.getID());
        VElement vNodes = this.getMatchingTypeNodeVector(jdfRoot);
        if (vNodes == null) {
            parentRoot.setAttribute(FITS_TYPE, false, null);
        } else {
            parentRoot.setAttribute(FITS_TYPE, true, null);
            for (int i = 0; i < vNodes.size() - 1; ++i) {
                JDFNode n = (JDFNode)vNodes.elementAt(i);
                KElement childRoot = this.devCapsReport(n, testlists, level, parentRoot);
                if (childRoot == null) continue;
                childRoot.setAttribute("XPath", n.buildXPath(null, 1));
                childRoot.setAttribute("ID", n.getID());
            }
            this.devCapsReport(jdfRoot, testlists, level, parentRoot);
        }
        return parentRoot;
    }

    private final KElement devCapsReport(JDFNode jdfRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, KElement parentRoot) {
        KElement root = parentRoot.appendElement("RejectedChildNode");
        if (!this.ignoreExtensions) {
            this.noFoundDevCaps(jdfRoot, root);
        }
        JDFDeviceCap.invalidDevCaps(this, jdfRoot, testlists, level, root, this.ignoreExtensions);
        JDFDeviceCap.actionPoolReport(this, jdfRoot, root);
        if (!root.hasChildElements()) {
            root.deleteNode();
            root = null;
        }
        return root;
    }

    private static boolean invalidDevCaps(KElement parent, KElement jdfRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, KElement parentReport, boolean ignoreExtensions) {
        boolean bRet;
        KElement mrp = parentReport.appendElement(jdfRoot instanceof JDFNode ? "MissingResources" : "MissingElements");
        KElement irp = parentReport.appendElement(jdfRoot instanceof JDFNode ? "InvalidResources" : "InvalidElements");
        VElement vDevCaps = parent.getChildElementVector("DevCaps", null, null, true, 0, false);
        int size = vDevCaps.size();
        HashSet goodElems = new HashSet();
        HashMap badElems = new HashMap();
        for (int i = 0; i < size; ++i) {
            JDFDevCaps devCaps = (JDFDevCaps)vDevCaps.elementAt(i);
            devCaps.analyzeDevCaps(jdfRoot, testlists, level, mrp, irp, goodElems, badElems, ignoreExtensions);
        }
        boolean bl = bRet = mrp.hasChildElements() || irp.hasChildElements();
        if (!mrp.hasChildElements()) {
            mrp.deleteNode();
        }
        if (!irp.hasChildElements()) {
            irp.deleteNode();
        }
        return bRet;
    }

    private final KElement noFoundDevCaps(JDFNode jdfRoot, KElement parentReport) {
        KElement root = parentReport.appendElement("UnknownResources");
        VElement vLinks = jdfRoot.getResourceLinks(null);
        if (vLinks != null) {
            int linkSize = vLinks.size();
            for (int j = 0; j < linkSize; ++j) {
                JDFResourceLink link = (JDFResourceLink)vLinks.elementAt(j);
                String resName = link.getLinkedResourceName();
                String processUsage = link.getProcessUsage();
                JDFAttributeMap map = new JDFAttributeMap("Name", resName);
                VElement vDevCaps = this.getChildElementVector("DevCaps", null, map, true, 0, false);
                boolean bFound = false;
                int size = vDevCaps.size();
                for (int k = 0; k < size && !bFound; ++k) {
                    JDFDevCaps dc = (JDFDevCaps)vDevCaps.elementAt(k);
                    if (dc.hasAttribute("LinkUsage") && !dc.getLinkUsage().getName().equals(link.getUsage().getName()) || !dc.getProcessUsage().equals(processUsage)) continue;
                    bFound = true;
                }
                if (bFound) continue;
                KElement r = root.appendElement("UnknownResource");
                r.setAttribute("XPath", link.buildXPath(null, 1));
                r.setAttribute("Name", resName);
                if (link.hasAttribute("Usage", null, false) && !link.getUsage().getName().equals("Unknown")) {
                    r.setAttribute("Usage", link.getUsage().getName());
                }
                r.setAttribute("Message", "Found no DevCaps description for this resource");
            }
        }
        this.checkNodeInfoCustomerInfo(jdfRoot, root, "NodeInfo");
        this.checkNodeInfoCustomerInfo(jdfRoot, root, "CustomerInfo");
        this.checkNodeInfoCustomerInfo(jdfRoot, root, "StatusPool");
        if (!root.hasChildElements()) {
            root.deleteNode();
            root = null;
        }
        return root;
    }

    private final void checkNodeInfoCustomerInfo(JDFNode jdfRoot, KElement root, String elementName) {
        JDFAttributeMap map = new JDFAttributeMap();
        map.put("Context", JDFAutoDevCaps.EnumContext.Element.getName());
        map.put("Name", elementName);
        KElement devCaps = this.getChildByTagName("DevCaps", null, 0, map, true, true);
        if (jdfRoot.getElement(elementName, null, 0) != null && devCaps == null) {
            KElement ue = root.appendElement("UnknownElement");
            ue.setAttribute("XPath", jdfRoot.getElement(elementName, null, 0).buildXPath(null, 1));
            ue.setAttribute("Name", elementName);
            ue.setAttribute("Message", "Found no DevCaps description with Context=\"Element\" for: " + elementName);
        }
    }

    public static KElement actionPoolReport(IDeviceCapable devCapable, JDFElement jdfRootorMess, KElement parentReport) {
        KElement root = parentReport.appendElement("ActionPoolReport");
        JDFActionPool actionPool = devCapable.getActionPool();
        if (actionPool != null) {
            JDFJMF jmf;
            JDFTestPool testPool = devCapable.getTestPool();
            if (testPool == null) {
                throw new JDFException("JDFDeviceCap.actionPoolReport: TestPool is required but was not found. Attempt to operate on a null element");
            }
            VElement vActions = actionPool.getChildElementVector("Action", null, null, true, 0, false);
            VElement allElms = jdfRootorMess.getChildrenByTagName(null, null, null, false, true, 0);
            allElms.add(jdfRootorMess);
            if (jdfRootorMess instanceof JDFMessage && (jmf = jdfRootorMess.getJMFRoot()) != null) {
                allElms.add(jmf);
            }
            int elmSize = allElms.size();
            int actionSize = vActions.size();
            for (int i = 0; i < elmSize; ++i) {
                KElement e = allElms.item(i);
                for (int j = 0; j < actionSize; ++j) {
                    JDFAction action = (JDFAction)vActions.elementAt(j);
                    JDFTest test = action.getTest();
                    if (test == null || !test.fitsContext(e)) continue;
                    KElement ar = root.appendElement("ActionReport");
                    if (test.fitsJDF(e, ar)) {
                        KElement arl = root.getChildWithAttribute("ActionReportList", "ID", null, action.getID(), 0, true);
                        if (arl == null) {
                            arl = root.appendElement("ActionReportList");
                            arl.setAttribute("ID", action.getID());
                            arl.setAttribute("Severity", action.getSeverity().getName());
                        }
                        arl.moveElement(ar, null);
                        ar.setAttribute("XPath", e.buildXPath(null, 1));
                        JDFLoc loc = action.getLoc(0);
                        if (loc == null) continue;
                        ar.setAttribute("Message", loc.getValue());
                        String helpText = loc.getHelpText();
                        if (helpText.length() == 0) continue;
                        ar.setAttribute("Help", helpText);
                        continue;
                    }
                    ar.deleteNode();
                }
            }
        }
        root = JDFDeviceCap.cleanActionPoolReport(root);
        return root;
    }

    private static KElement cleanActionPoolReport(KElement actionPoolReport) {
        KElement actionPoolReportLocal = actionPoolReport;
        if (actionPoolReportLocal != null) {
            VElement vARL = actionPoolReportLocal.getChildElementVector("ActionReportList", null, null, true, 0, false);
            for (int i = 0; i < vARL.size(); ++i) {
                VElement actionReportList = vARL.item(i).getChildElementVector("ActionReport", null, null, true, 0, false);
                block1: for (int j = 1; j < actionReportList.size(); ++j) {
                    KElement e1 = actionReportList.item(j);
                    for (int k = 0; k < j; ++k) {
                        KElement e2 = actionReportList.item(k);
                        if (e2 == null) continue;
                        if (e2.getAttribute("XPath").startsWith(e1.getAttribute("XPath"))) {
                            e1.deleteNode();
                            actionReportList.setElementAt(null, j);
                            continue block1;
                        }
                        if (!e1.getAttribute("XPath").startsWith(e2.getAttribute("XPath"))) continue;
                        e2.deleteNode();
                        actionReportList.setElementAt(null, k);
                    }
                }
            }
            if (!actionPoolReportLocal.hasChildElements()) {
                actionPoolReportLocal.deleteNode();
                actionPoolReportLocal = null;
            }
        }
        return actionPoolReportLocal;
    }

    public void createModuleCaps(String includeNameExpression) {
        VElement devcaps = this.getChildElementVector("DevCaps", null, null, true, 0, true);
        if (devcaps != null) {
            int siz = devcaps.size();
            for (int i = 0; i < siz; ++i) {
                JDFDevCaps dcs = (JDFDevCaps)devcaps.elementAt(i);
                String _name = dcs.getName();
                if (!StringUtil.matches(_name, includeNameExpression)) continue;
                JDFModuleCap mc = dcs.appendModuleRef("Module_" + _name);
                mc.setAvailability(EnumAvailability.Installed);
                mc.setDescriptiveName("Module that implements the resource: " + _name);
            }
        }
    }

    public boolean setDefaultsFromCaps(JDFNode node, boolean bLocal, boolean bAll) {
        int i;
        boolean success = false;
        boolean bTestTypes = node.hasAttribute("Type");
        if (!bLocal) {
            VElement vNode = node.getvJDFNode(null, null, false);
            for (int i2 = 0; i2 < vNode.size(); ++i2) {
                JDFNode nod = (JDFNode)vNode.elementAt(i2);
                success = this.setDefaultsFromCaps(nod, true, bAll) || success;
            }
            return success;
        }
        if (bTestTypes && !this.matchesType(node, true)) {
            return false;
        }
        if (this.hasAttribute("Types")) {
            node.setType(JDFNode.EnumType.ProcessGroup);
            Vector cm = this.getCombinedMethod();
            if (cm != null && cm.contains((Object)JDFAutoDeviceCap.EnumCombinedMethod.Combined)) {
                node.setType(JDFNode.EnumType.Combined);
            }
            node.setTypes(this.getTypes());
        }
        this.addResourcesFromDevCaps(node, bAll);
        VElement vDevCaps = this.getChildElementVector("DevCaps", null, null, true, 99999, false);
        int size = vDevCaps.size();
        for (i = 0; i < size; ++i) {
            JDFDevCaps dcs = (JDFDevCaps)vDevCaps.elementAt(i);
            success = dcs.setDefaultsFromCaps(node, bAll) || success;
        }
        VElement vStates = this.getStates();
        for (i = 0; i < vStates.size(); ++i) {
            JDFAbstractState state = (JDFAbstractState)vStates.elementAt(i);
            success = state.setDefaultsFromCaps(node, bAll) || success;
        }
        return success;
    }

    public VElement getStates() {
        VElement vStates = this.getChildrenByTagName(null, null, null, true, true, 0);
        for (int ii = vStates.size() - 1; ii >= 0; --ii) {
            if (vStates.elementAt(ii) instanceof JDFAbstractState) continue;
            vStates.remove(ii);
        }
        return vStates;
    }

    private void addResourcesFromDevCaps(JDFNode node, boolean bAll) {
        JDFDevCaps dcs;
        int i;
        VElement vDevCaps = this.getChildElementVector("DevCaps", null, null, true, 99999, false);
        this.setResMap = new VectorMap();
        int size = vDevCaps.size();
        for (i = 0; i < size; ++i) {
            dcs = (JDFDevCaps)vDevCaps.elementAt(i);
            dcs.appendMatchingElementsToNode(node, bAll, this.setResMap, false);
        }
        for (i = 0; i < size; ++i) {
            dcs = (JDFDevCaps)vDevCaps.elementAt(i);
            dcs.appendMatchingElementsToNode(node, bAll, this.setResMap, true);
        }
    }

    public JDFDevCaps getDevCapsByName(String devCapsName, JDFAutoDevCaps.EnumContext context, JDFResourceLink.EnumUsage linkUsage, JDFNode.EnumProcessUsage processUsage, int iSkip) {
        JDFAttributeMap map = new JDFAttributeMap("Name", devCapsName);
        if (context != null) {
            map.put("Context", context.getName());
        }
        if (linkUsage != null) {
            map.put("LinkUsage", linkUsage.getName());
        }
        if (processUsage != null) {
            map.put("ProcessUsage", processUsage.getName());
        }
        return (JDFDevCaps)this.getChildByTagName("DevCaps", null, iSkip, map, true, true);
    }

    public void setCombinedMethod(JDFAutoDeviceCap.EnumCombinedMethod method) {
        this.setAttribute("CombinedMethod", method.getName(), null);
    }

    public void setCombinedMethod(Vector vMethod) {
        this.setEnumerationsAttribute("CombinedMethod", vMethod, null);
    }

    public boolean isIgnoreExtensions() {
        return this.ignoreExtensions;
    }

    public void setIgnoreExtensions(boolean _ignoreExtensions) {
        this.ignoreExtensions = _ignoreExtensions;
    }

    public boolean isIgnoreDefaults() {
        return this.ignoreDefaults;
    }

    public void setIgnoreDefaults(boolean _ignoreDefaults) {
        this.ignoreDefaults = _ignoreDefaults;
    }

    @Override
    public ICapabilityElement getTargetCap(String id) {
        KElement e = this.getTarget(id, null);
        if (e instanceof ICapabilityElement) {
            return (ICapabilityElement)((Object)e);
        }
        return null;
    }

    public JDFBooleanState appendBooleanState(String nam) {
        JDFBooleanState s = (JDFBooleanState)this.appendElement("BooleanState", null);
        s.setName(nam);
        return s;
    }

    public JDFEnumerationState appendEnumerationState(String nam) {
        JDFEnumerationState s = (JDFEnumerationState)this.appendElement("EnumerationState", null);
        s.setName(nam);
        return s;
    }

    public JDFIntegerState appendIntegerState(String nam) {
        JDFIntegerState s = (JDFIntegerState)this.appendElement("IntegerState", null);
        s.setName(nam);
        return s;
    }

    public JDFNameState appendNameState(String nam) {
        JDFNameState s = (JDFNameState)this.appendElement("NameState", null);
        s.setName(nam);
        return s;
    }

    public JDFStringState appendStringState(String nam) {
        JDFStringState s = (JDFStringState)this.appendElement("StringState", null);
        s.setName(nam);
        return s;
    }

    public JDFBooleanState getBooleanState(String nam) {
        return (JDFBooleanState)this.getChildWithAttribute("BooleanState", "Name", null, nam, 0, true);
    }

    public JDFBooleanState getCreateBooleanState(String nam) {
        JDFBooleanState s = this.getBooleanState(nam);
        if (s == null) {
            s = this.appendBooleanState(nam);
        }
        return s;
    }

    public JDFEnumerationState getCreateEnumerationState(String nam) {
        JDFEnumerationState s = this.getEnumerationState(nam);
        if (s == null) {
            s = this.appendEnumerationState(nam);
        }
        return s;
    }

    public JDFIntegerState getCreateIntegerState(String nam) {
        JDFIntegerState s = this.getIntegerState(nam);
        if (s == null) {
            s = this.appendIntegerState(nam);
        }
        return s;
    }

    public JDFNameState getCreateNameState(String nam) {
        JDFNameState s = this.getNameState(nam);
        if (s == null) {
            s = this.appendNameState(nam);
        }
        return s;
    }

    public JDFStringState getCreateStringState(String nam) {
        JDFStringState s = this.getStringState(nam);
        if (s == null) {
            s = this.appendStringState(nam);
        }
        return s;
    }

    public JDFEnumerationState getEnumerationState(String nam) {
        return (JDFEnumerationState)this.getChildWithAttribute("EnumerationState", "Name", null, nam, 0, true);
    }

    public JDFIntegerState getIntegerState(String nam) {
        return (JDFIntegerState)this.getChildWithAttribute("IntegerState", "Name", null, nam, 0, true);
    }

    public JDFNameState getNameState(String nam) {
        return (JDFNameState)this.getChildWithAttribute("NameState", "Name", null, nam, 0, true);
    }

    public JDFNumberState getNumberState(String nam) {
        return (JDFNumberState)this.getChildWithAttribute("NumberState", "Name", null, nam, 0, true);
    }

    public JDFAbstractState getState(String nam) {
        KElement e;
        int i = 0;
        while ((e = this.getChildWithAttribute(null, "Name", null, nam, i, true)) != null) {
            if (e instanceof JDFAbstractState) {
                return (JDFAbstractState)e;
            }
            ++i;
        }
        return null;
    }

    public JDFStringState getStringState(String nam) {
        return (JDFStringState)this.getChildWithAttribute("StringState", "Name", null, nam, 0, true);
    }

    static {
        JDFDeviceCap.elemInfoTable[0] = new ElemInfoTable("BooleanState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[1] = new ElemInfoTable("DateTimeState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[2] = new ElemInfoTable("DurationState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[3] = new ElemInfoTable("EnumerationState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[4] = new ElemInfoTable("IntegerState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[5] = new ElemInfoTable("MatrixState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[6] = new ElemInfoTable("NameState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[7] = new ElemInfoTable("NumberState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[8] = new ElemInfoTable("PDFPathState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[9] = new ElemInfoTable("RectangleState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[10] = new ElemInfoTable("ShapeState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[11] = new ElemInfoTable("StringState", 0x33333111L);
        JDFDeviceCap.elemInfoTable[12] = new ElemInfoTable("XYPairState", 0x33333111L);
    }

    public static class EnumAvailability
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumAvailability NotInstalled = new EnumAvailability("NotInstalled");
        public static final EnumAvailability NotLicensed = new EnumAvailability("NotLicensed");
        public static final EnumAvailability Disabled = new EnumAvailability("Disabled");
        public static final EnumAvailability Installed = new EnumAvailability("Installed");
        public static final EnumAvailability Module = new EnumAvailability("Module");

        private EnumAvailability(String name) {
            super(name, m_startValue++);
        }

        public static EnumAvailability getEnum(String enumName) {
            return (EnumAvailability)EnumAvailability.getEnum(EnumAvailability.class, (String)enumName);
        }

        public static EnumAvailability getEnum(int enumValue) {
            return (EnumAvailability)EnumAvailability.getEnum(EnumAvailability.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumAvailability.getEnumMap(EnumAvailability.class);
        }

        public static List getEnumList() {
            return EnumAvailability.getEnumList(EnumAvailability.class);
        }

        public static Iterator iterator() {
            return EnumAvailability.iterator(EnumAvailability.class);
        }
    }
}

