/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.logging;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.cip4.jdflib.util.UrlUtil;

public class LogConfigurator {
    public static void configureLog(String logDir, String logName) {
        BasicConfigurator.resetConfiguration();
        Log log = LogFactory.getLog(LogConfigurator.class);
        try {
            PatternLayout layout = new PatternLayout("%d %r [%t] %p %c %x - %m%n");
            ConsoleAppender appender1 = new ConsoleAppender((Layout)layout);
            appender1.setThreshold((Priority)Level.INFO);
            BasicConfigurator.configure((Appender)appender1);
            if (logDir != null) {
                new File(logDir).mkdirs();
                String logFileName = logDir + "/" + logName;
                if (UrlUtil.extension(logFileName) == null) {
                    logFileName = logFileName + ".log";
                }
                RollingFileAppender appender = new RollingFileAppender((Layout)layout, logFileName, true);
                appender.setMaximumFileSize(1000000L);
                appender.setMaxBackupIndex(4);
                appender.setThreshold((Priority)Level.INFO);
                BasicConfigurator.configure((Appender)appender);
                log.info((Object)("log file=" + new File(logFileName).getAbsolutePath()));
            }
            log = LogFactory.getLog(LogConfigurator.class);
        }
        catch (IOException e) {
            log.error((Object)"Snafu while configuring logging ", (Throwable)e);
        }
    }
}

