/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.zip.DataFormatException;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFNumberRange;
import org.cip4.jdflib.datatypes.JDFNumberRangeList;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.JDFXYPairRange;
import org.cip4.jdflib.datatypes.JDFXYPairRangeList;
import org.cip4.jdflib.util.StringUtil;

public class AtrInfo {
    private final long atrValidityStatus;
    private final AttributeInfo.EnumAttributeType atrType;
    private ValuedEnum enumEnum = null;
    private String atrDefault = null;

    public AtrInfo(long s, AttributeInfo.EnumAttributeType t, ValuedEnum e, String _atrDefault) {
        this.atrValidityStatus = s;
        this.atrType = t;
        this.enumEnum = e;
        this.atrDefault = _atrDefault;
    }

    public AtrInfo(long s, AttributeInfo.EnumAttributeType t, ValuedEnum e) {
        this.atrValidityStatus = s;
        this.atrType = t;
        this.enumEnum = e;
        this.atrDefault = null;
    }

    public static boolean matchesAttribute(String smallAtt, String bigAtt, AttributeInfo.EnumAttributeType dataType) {
        JDFBaseDataTypes r;
        JDFXYPair xypair2;
        JDFBaseDataTypes rSmal;
        JDFBaseDataTypes rBig2;
        JDFBaseDataTypes r22;
        if (dataType == null || dataType.equals((Object)AttributeInfo.EnumAttributeType.Any)) {
            return bigAtt.equals(smallAtt);
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.NMTOKENS) || dataType.equals((Object)AttributeInfo.EnumAttributeType.enumerations) || dataType.equals((Object)AttributeInfo.EnumAttributeType.IDREFS)) {
            if (smallAtt.indexOf(" ") > 0) {
                VString vSmall = StringUtil.tokenize(smallAtt, " ", false);
                for (int i = 0; i < vSmall.size(); ++i) {
                    if (StringUtil.hasToken(bigAtt, vSmall.get(i), " ", 0)) continue;
                    return false;
                }
            } else if (!StringUtil.hasToken(bigAtt, smallAtt, " ", 0)) {
                return false;
            }
            return true;
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.NumberRange)) {
            try {
                r22 = new JDFNumberRange(bigAtt);
                if (((JDFNumberRange)r22).inRange(Double.parseDouble(smallAtt))) {
                    return true;
                }
            }
            catch (DataFormatException r22) {
            }
            catch (JDFException r22) {
            }
            catch (IllegalArgumentException r22) {
                // empty catch block
            }
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.NumberRangeList)) {
            try {
                r22 = new JDFNumberRangeList(bigAtt);
                if (((JDFNumberRangeList)r22).inRange(Double.parseDouble(smallAtt))) {
                    return true;
                }
            }
            catch (DataFormatException r3) {
            }
            catch (JDFException r3) {
            }
            catch (IllegalArgumentException r3) {
                // empty catch block
            }
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.IntegerList)) {
            try {
                if (StringUtil.isInteger(smallAtt) && ((JDFIntegerList)(rBig2 = new JDFIntegerList(bigAtt))).contains(StringUtil.parseInt(smallAtt, 0))) {
                    return true;
                }
            }
            catch (DataFormatException rBig2) {
            }
            catch (JDFException rBig2) {
            }
            catch (IllegalArgumentException rBig2) {
                // empty catch block
            }
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.IntegerRange)) {
            try {
                rBig2 = new JDFIntegerRange(bigAtt, Integer.MAX_VALUE);
                rSmal = new JDFIntegerRange(smallAtt, Integer.MAX_VALUE);
                if (((JDFIntegerRange)rBig2).isPartOfRange((JDFRange)rSmal)) {
                    return true;
                }
            }
            catch (DataFormatException rBig3) {
            }
            catch (JDFException rBig3) {
            }
            catch (IllegalArgumentException rBig3) {
                // empty catch block
            }
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.IntegerRangeList)) {
            try {
                rBig2 = new JDFIntegerRangeList(bigAtt, Integer.MAX_VALUE);
                rSmal = new JDFIntegerRangeList(smallAtt, Integer.MAX_VALUE);
                if (((JDFRangeList)rBig2).isPartOfRange((JDFRangeList)rSmal)) {
                    return true;
                }
            }
            catch (DataFormatException rBig4) {
            }
            catch (JDFException rBig4) {
            }
            catch (IllegalArgumentException rBig4) {
                // empty catch block
            }
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.XYPairRange)) {
            try {
                xypair2 = new JDFXYPair(smallAtt);
                r = new JDFXYPairRange(bigAtt);
                if (((JDFXYPairRange)r).inRange(xypair2)) {
                    return true;
                }
            }
            catch (DataFormatException xypair2) {
            }
            catch (IllegalArgumentException xypair2) {
                // empty catch block
            }
        }
        if (dataType.equals((Object)AttributeInfo.EnumAttributeType.XYPairRangeList)) {
            try {
                xypair2 = new JDFXYPair(smallAtt);
                r = new JDFXYPairRangeList(bigAtt);
                if (((JDFXYPairRangeList)r).inRange(xypair2)) {
                    return true;
                }
            }
            catch (DataFormatException dataFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public AttributeInfo.EnumAttributeType getAtrType() {
        return this.atrType;
    }

    public long getAtrValidityStatus() {
        return this.atrValidityStatus;
    }

    public ValuedEnum getEnumEnum() {
        return this.enumEnum;
    }

    public String getAtrDefault() {
        return this.atrDefault;
    }

    public String toString() {
        String s = "Type: " + this.atrType.toString();
        s = s + "; Validity: " + Long.toHexString(this.atrValidityStatus);
        if (this.enumEnum != null) {
            s = s + "; Enum: " + this.enumEnum.toString();
        }
        if (this.atrDefault != null) {
            s = s + "; default: " + this.atrDefault;
        }
        return s;
    }

    public JDFElement.EnumVersion getFirstVersion() {
        for (int i = 0; i < 8; ++i) {
            long masked = this.atrValidityStatus & 15L << 4 * i;
            if ((masked >>= 4 * i) != 2L && masked != 3L) continue;
            return JDFElement.EnumVersion.getEnum(i + 1);
        }
        return null;
    }

    public JDFElement.EnumVersion getLastVersion() {
        for (int i = 7; i >= 0; --i) {
            long masked = this.atrValidityStatus & 15L << 4 * i;
            if ((masked >>= 4 * i) != 2L && masked != 3L) continue;
            if (i == 7) {
                i += 3;
            }
            return JDFElement.EnumVersion.getEnum(i + 1);
        }
        return null;
    }
}

