/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.StringCache;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.util.StringUtil;

public class JDFAttributeMap
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;

    public JDFAttributeMap() {
    }

    public JDFAttributeMap(String key, String value) {
        this.put(key, value);
    }

    public JDFAttributeMap(String key, ValuedEnum value) {
        this.put(key, value.getName());
    }

    public JDFAttributeMap(Map<String, String> inputMap) {
        if (inputMap != null && inputMap.size() > 0) {
            this.putAll(inputMap);
        }
    }

    public JDFAttributeMap(ValuedEnum partIDKey, String value) {
        this(partIDKey.getName(), value);
    }

    public String showKeys(String sep) {
        if (sep == null) {
            sep = "";
        }
        StringBuffer sb = new StringBuffer();
        VString vsKeys = this.getKeys();
        vsKeys.sort();
        int size = vsKeys.size();
        for (int k = 0; k < size; ++k) {
            String strKey = vsKeys.get(k);
            String strValue = this.get(strKey);
            sb.append(k == 0 ? "" : sep).append("(").append(strKey).append(" = ").append(strValue).append(")");
        }
        return sb.toString();
    }

    @Deprecated
    public Enumeration<String> keys() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.putAll(this);
        return ht.keys();
    }

    @Override
    public String toString() {
        return "JDFAttributeMap: {" + this.showKeys(" ") + " }";
    }

    @Override
    public String put(String key, String value) {
        if (key == null || key.equals("")) {
            return null;
        }
        return super.put(StringCache.getCreateString(key), StringCache.getString(value));
    }

    public String putNotNull(Object key, Object value) {
        String k1 = null;
        if (key instanceof ValuedEnum) {
            k1 = ((ValuedEnum)key).getName();
        } else if (key instanceof String) {
            k1 = (String)key;
        }
        String v1 = null;
        if (value instanceof ValuedEnum) {
            v1 = ((ValuedEnum)value).getName();
        } else if (value instanceof String) {
            v1 = (String)value;
        }
        return StringUtil.getNonEmpty(v1) == null ? null : this.put(k1, v1);
    }

    public boolean subMap(JDFAttributeMap subMap) {
        Set subMapSet;
        if (subMap == null || subMap.size() == 0) {
            return true;
        }
        if (subMap.size() > this.size()) {
            return false;
        }
        Set mapSet = this.keySet();
        if (!mapSet.containsAll(subMapSet = subMap.keySet())) {
            return false;
        }
        for (String key : subMapSet) {
            String val;
            String subVal = subMap.get(key);
            if (KElement.isWildCard(subVal) || KElement.isWildCard(val = this.get(key)) || val.equals(subVal)) continue;
            return false;
        }
        return true;
    }

    public boolean subMap(VJDFAttributeMap vMap) {
        if (vMap == null || vMap.size() == 0) {
            return true;
        }
        for (JDFAttributeMap map : vMap) {
            if (!this.subMap(map)) continue;
            return true;
        }
        return false;
    }

    public boolean overlapMap(VJDFAttributeMap vMap) {
        if (vMap == null || vMap.isEmpty()) {
            return true;
        }
        int size = vMap.size();
        for (int i = 0; i < size; ++i) {
            if (!this.overlapMap(vMap.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String key, String regExp, boolean ignoreCase) {
        String myVal = this.get(key);
        return ignoreCase ? StringUtil.matchesIgnoreCase(myVal, regExp) : StringUtil.matchesSimple(myVal, regExp);
    }

    public boolean overlapMap(JDFAttributeMap subMap) {
        if (subMap == null || subMap.size() == 0) {
            return true;
        }
        for (String subMapKey : subMap.keySet()) {
            String val;
            String subMapVal = subMap.get(subMapKey);
            if (KElement.isWildCard(subMapVal) || (val = this.get(subMapKey)) == null || subMapVal.equals(val)) continue;
            return false;
        }
        return true;
    }

    public JDFAttributeMap orMap(JDFAttributeMap subMap) {
        if (subMap == null) {
            return this;
        }
        for (String subMapKey : subMap.keySet()) {
            String subMapVal = subMap.get(subMapKey);
            String hashTableVal = this.get(subMapKey);
            if (hashTableVal != null) {
                if (hashTableVal.equals(subMapVal)) continue;
                this.clear();
                break;
            }
            this.put(subMapKey, subMapVal);
        }
        return this;
    }

    public void andMap(JDFAttributeMap subMap) {
        for (String key : this.getKeys()) {
            String thisVal;
            String subMapVal = subMap.get(key);
            String string = thisVal = subMapVal == null ? null : this.get(key);
            if (subMapVal != null && !subMapVal.equals(thisVal)) {
                subMapVal = null;
            }
            if (subMapVal != null) continue;
            this.remove(key);
        }
    }

    public JDFAttributeMap getOrMap(JDFAttributeMap subMap) {
        if (subMap == null || subMap.size() == 0) {
            return new JDFAttributeMap(this);
        }
        JDFAttributeMap newMap = new JDFAttributeMap(subMap);
        for (String key : this.keySet()) {
            String val = this.get(key);
            String subVal = subMap.get(key);
            if (subVal == null || val.equals(subVal)) {
                newMap.put(key, val);
                continue;
            }
            return null;
        }
        return newMap.size() == 0 ? null : newMap;
    }

    public JDFAttributeMap getAndMap(JDFAttributeMap subMap) {
        if (subMap == null || subMap.size() == 0) {
            return null;
        }
        JDFAttributeMap newMap = new JDFAttributeMap();
        for (String key : this.keySet()) {
            String subVal;
            String val = this.get(key);
            if (val.equals(subVal = subMap.get(key))) {
                newMap.put(key, val);
                continue;
            }
            if (subVal == null) continue;
            return null;
        }
        return newMap.size() == 0 ? null : newMap;
    }

    public JDFAttributeMap reduceMap(Collection<String> keySet) {
        if (keySet == null) {
            this.clear();
            return this;
        }
        for (String key : this.getKeys()) {
            if (keySet.contains(key)) continue;
            this.remove(key);
        }
        return this;
    }

    @Override
    public String remove(Object key) {
        if (key instanceof ValuedEnum) {
            key = ((ValuedEnum)key).getName();
        }
        return (String)super.remove(key);
    }

    public String renameKey(String oldKey, String newKey) {
        String val = this.remove(oldKey);
        String ret = null;
        if (!StringUtil.isEmpty(val)) {
            ret = this.put(newKey, val);
        }
        return ret;
    }

    @Override
    public String get(Object key) {
        if (key instanceof ValuedEnum) {
            key = ((ValuedEnum)key).getName();
        }
        return (String)super.get(key);
    }

    public String getNonEmpty(Object key) {
        return StringUtil.getNonEmpty(this.get(key));
    }

    public int getInt(Object key, int def) {
        return StringUtil.parseInt(this.get(key), def);
    }

    public boolean getBool(Object key, boolean def) {
        return StringUtil.parseBoolean(this.get(key), def);
    }

    public double getDouble(Object key, double def) {
        return StringUtil.parseDouble(this.get(key), def);
    }

    @Override
    public String put(ValuedEnum key, String value) {
        return this.put(key == null ? null : key.getName(), value);
    }

    @Override
    public String put(String key, int value) {
        return this.put(key, StringUtil.formatInteger(value));
    }

    @Override
    public String put(ValuedEnum key, int value) {
        return this.put(key == null ? null : key.getName(), StringUtil.formatInteger(value));
    }

    @Override
    public String put(String key, double value) {
        return this.put(key, StringUtil.formatDouble(value));
    }

    @Override
    public String put(ValuedEnum key, double value) {
        return this.put(key == null ? null : key.getName(), StringUtil.formatDouble(value));
    }

    @Override
    public String put(String key, boolean value) {
        return this.put(key, value ? "true" : "false");
    }

    @Override
    public String put(ValuedEnum key, boolean value) {
        return this.put(key == null ? null : key.getName(), value);
    }

    @Override
    public String put(String key, ValuedEnum value) {
        return this.put(key, value == null ? null : value.getName());
    }

    @Override
    public String put(ValuedEnum key, ValuedEnum value) {
        return this.put(key == null ? null : key.getName(), value);
    }

    public Iterator<String> getKeyIterator() {
        return this.keySet().iterator();
    }

    public VString getKeys() {
        VString thisKeys = new VString();
        thisKeys.addAll(this.keySet());
        return thisKeys;
    }

    public JDFAttributeMap removeKeys(Collection<String> toRemove) {
        if (toRemove != null) {
            for (String key : toRemove) {
                this.remove(key);
            }
        }
        return this;
    }

    @Override
    public JDFAttributeMap clone() {
        return new JDFAttributeMap(this);
    }
}

