/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cip4.jdflib.core.VString;

public class JDFPath {
    private String m_strPath;
    private final GeneralPath m_GPI = new GeneralPath();

    public String toString() {
        String path = "";
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        PathIterator pi = this.getIterator(at);
        int segNum = 0;
        while (!pi.isDone()) {
            float[] seg = new float[6];
            int type = pi.currentSegment(seg);
            path = path + "\nseg[" + segNum + "]= [";
            for (int j = 0; j < 5; ++j) {
                path = path + " " + seg[j] + ",";
            }
            path = path + " type=[" + type + "] ]\n";
            pi.next();
            ++segNum;
        }
        return "Path= [\n\tbox=     " + this.m_GPI.getBounds() + "\n\twinding= " + this.m_GPI.getWindingRule() + "\n\tcurrent= " + this.m_GPI.getCurrentPoint() + "\nsegments:\n" + path + "]";
    }

    private void setPath(String path) {
        this.m_strPath = path;
    }

    public String getPath() {
        return this.m_strPath;
    }

    public JDFPath(String pdfPath) {
        this.setPath(pdfPath);
        StringTokenizer st = new StringTokenizer(pdfPath);
        Vector<String> s = new Vector<String>(4);
        double d = 0.0;
        String nt = "";
        while (st.hasMoreTokens()) {
            while (!Double.valueOf(d).equals(-1.0)) {
                if (st.hasMoreTokens()) {
                    nt = st.nextToken();
                }
                if (nt.startsWith("[")) {
                    nt = nt.substring(1);
                }
                if (nt.endsWith("]")) {
                    nt = nt.substring(0, nt.length() - 1);
                }
                if (nt.equals("")) {
                    s.add("");
                    continue;
                }
                try {
                    d = Double.parseDouble(nt);
                    s.add(nt);
                }
                catch (NumberFormatException e) {
                    d = -1.0;
                }
            }
            if (d != -1.0) continue;
            if ("m".equals(nt)) {
                this.addValues(nt, 2, s);
            } else if ("l".equals(nt)) {
                this.addValues(nt, 2, s);
            } else if ("c".equals(nt)) {
                this.addValues(nt, 6, s);
            } else if ("v".equals(nt)) {
                this.addValues(nt, 4, s);
            } else if ("y".equals(nt)) {
                this.addValues(nt, 4, s);
            } else if ("re".equals(nt)) {
                this.addValues(nt, 4, s);
            } else if ("h".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("n".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("S".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("s".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("f".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("F".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("f*".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("B".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("b".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("B*".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("b*".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("sh".equals(nt)) {
                this.addValues(nt, 1, s);
            } else if ("W".equals(nt)) {
                this.addValues(nt, 0, s);
            } else if ("W*".equals(nt)) {
                this.addValues(nt, 0, s);
            }
            d = 0.0;
            s.clear();
        }
    }

    private boolean addValues(String type, int paramNum, Vector s) {
        block17: {
            float[] a;
            float[] x;
            block16: {
                if (s.size() != paramNum) {
                    return false;
                }
                x = new float[paramNum];
                try {
                    for (int i = 0; i < paramNum; ++i) {
                        x[i] = Float.parseFloat(s.elementAt(i).toString());
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                a = new float[]{0.0f, 0.0f};
                try {
                    Point2D currentPoint = this.m_GPI.getCurrentPoint();
                    if (currentPoint != null) {
                        a[0] = Float.parseFloat("" + currentPoint.getX());
                        a[1] = Float.parseFloat("" + currentPoint.getY());
                    }
                }
                catch (NumberFormatException e) {
                    if ("m".equals(type)) break block16;
                    a[0] = 0.0f;
                    a[1] = 0.0f;
                }
            }
            try {
                if ("m".equals(type)) {
                    this.m_GPI.moveTo(x[0], x[1]);
                    break block17;
                }
                if ("l".equals(type)) {
                    this.m_GPI.lineTo(x[0], x[1]);
                    break block17;
                }
                if ("c".equals(type)) {
                    this.m_GPI.curveTo(x[0], x[1], x[2], x[3], x[4], x[5]);
                    break block17;
                }
                if ("v".equals(type)) {
                    this.m_GPI.curveTo(a[0], a[1], x[0], x[1], x[2], x[3]);
                    break block17;
                }
                if ("y".equals(type)) {
                    this.m_GPI.curveTo(x[0], x[1], x[2], x[3], x[2], x[3]);
                    break block17;
                }
                if ("re".equals(type)) {
                    this.rectangle(x[0], x[1], x[2], x[3]);
                    break block17;
                }
                if ("h".equals(type)) {
                    this.m_GPI.closePath();
                    break block17;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void rectangle(float x, float y, float w, float h) {
        VString v = new VString();
        v.add("" + x);
        v.add("" + y);
        this.addValues("m", 2, v);
        v.clear();
        v.add("" + (x + w));
        v.add("" + y);
        this.addValues("l", 2, v);
        v.clear();
        v.add("" + (x + w));
        v.add("" + (y + h));
        this.addValues("l", 2, v);
        v.clear();
        v.add("" + x);
        v.add("" + (y + h));
        this.addValues("l", 2, v);
        this.addValues("h", 0, v);
    }

    public Shape getShape() {
        return this.m_GPI;
    }

    public PathIterator getIterator(AffineTransform at) {
        return this.m_GPI.getPathIterator(at);
    }

    public void transform(AffineTransform at) {
        this.m_GPI.transform(at);
        this.setPath(this.calcPath(this.m_GPI));
    }

    private String calcPath(Shape shape) {
        StringBuffer buffer = new StringBuffer();
        if (null != shape) {
            NumberFormat formatter = this.getFormatter();
            PathIterator pi = shape.getPathIterator(new AffineTransform());
            double[] seg = new double[6];
            int segNum = 0;
            while (!pi.isDone()) {
                int type = pi.currentSegment(seg);
                switch (type) {
                    case 1: {
                        this.appendSegment(buffer, formatter, seg, 2, "l");
                        break;
                    }
                    case 0: {
                        this.appendSegment(buffer, formatter, seg, 2, "m");
                        break;
                    }
                    case 3: {
                        this.appendSegment(buffer, formatter, seg, 6, "c");
                        break;
                    }
                    case 2: {
                        this.appendSegment(buffer, formatter, seg, 4, "re");
                        break;
                    }
                    case 4: {
                        buffer.append("h");
                        break;
                    }
                }
                pi.next();
                ++segNum;
            }
        }
        return buffer.toString();
    }

    private void appendSegment(StringBuffer buffer, NumberFormat formatter, double[] seg, int nLength, String strOrder) {
        for (int i = 0; i < nLength; ++i) {
            buffer.append(formatter.format(seg[i]));
            buffer.append(" ");
        }
        buffer.append(strOrder);
        buffer.append(" ");
    }

    private NumberFormat getFormatter() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        String pattern = "###.######";
        DecimalFormat formatter = new DecimalFormat("###.######", symbols);
        return formatter;
    }
}

