/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.JDFShapeRange;
import org.cip4.jdflib.util.StringUtil;

public class JDFShapeRangeList
extends JDFRangeList {
    public static JDFShapeRangeList createShapeRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFShapeRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFShapeRangeList() {
    }

    public JDFShapeRangeList(JDFShapeRangeList rl) {
        this.rangeList = new Vector(rl.rangeList);
    }

    public JDFShapeRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public boolean inRange(JDFShape x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            if (!((JDFShapeRange)this.rangeList.elementAt(i)).inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFShapeRangeList.setString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString vs = new VString(zappedWS, " ");
        this.rangeList.clear();
        int size = vs.size();
        for (int i = 0; i < size; ++i) {
            if (size - i < 3) {
                throw new DataFormatException("JDFShapeRangeList.setString: Illegal string " + s);
            }
            StringBuffer str = new StringBuffer(100);
            str.append(vs.elementAt(i)).append(" ").append(vs.elementAt(++i)).append(" ");
            String tildeToken = vs.elementAt(++i);
            str.append(tildeToken);
            if (tildeToken.indexOf("~") != -1) {
                if (size - i < 3) {
                    throw new DataFormatException("JDFShapeRangeList.setString: Illegal string " + s);
                }
                str.append(" ").append(vs.elementAt(++i)).append(" ").append(vs.elementAt(++i));
            }
            try {
                JDFShapeRange r = new JDFShapeRange(str.toString());
                this.rangeList.addElement(r);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFShapeRangeList.setString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFShapeRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFShapeRange x) {
        this.rangeList.addElement(x);
    }

    public void append(JDFShape x) {
        this.append(new JDFShapeRange(x));
    }

    public void append(JDFShape xMin, JDFShape xMax) {
        this.append(new JDFShapeRange(xMin, xMax));
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFShape> v = new Vector<JDFShape>();
        for (int i = 0; i < siz; ++i) {
            JDFShapeRange r = (JDFShapeRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFShape first = (JDFShape)v.elementAt(0);
        JDFShape last = (JDFShape)v.elementAt(n);
        for (int j = 0; j < n; ++j) {
            JDFShape value = (JDFShape)v.elementAt(j);
            JDFShape nextvalue = (JDFShape)v.elementAt(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isLess(last) && value.isLessOrEqual(nextvalue) || first.isGreater(last) && value.isGreaterOrEqual(nextvalue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFShape last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFShape> v = new Vector<JDFShape>();
        for (int i = 0; i < siz; ++i) {
            JDFShapeRange r = (JDFShapeRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFShape first = (JDFShape)v.elementAt(0);
        if (first.equals(last = (JDFShape)v.elementAt(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFShape value = (JDFShape)v.elementAt(j);
            JDFShape nextvalue = (JDFShape)v.elementAt(j + 1);
            if (first.isLess(last) && value.isLess(nextvalue) || first.isGreater(last) && value.isGreater(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

