/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.XJDFCleanupComparator;
import org.cip4.jdflib.util.ContainerUtil;

public abstract class BaseXJDFHelper {
    protected final Log log = LogFactory.getLog(BaseXJDFHelper.class);
    protected KElement theElement;

    protected BaseXJDFHelper() {
        this(null);
    }

    protected BaseXJDFHelper(KElement theElement) {
        this.theElement = theElement;
    }

    public String getXPathValue(String xpath) {
        return this.theElement == null ? null : this.theElement.getXPathAttribute(xpath, null);
    }

    public KElement getXPathElement(String xpath) {
        return this.theElement == null ? null : this.theElement.getXPathElement(xpath);
    }

    public String getAttribute(String attName) {
        return this.theElement == null ? null : this.theElement.getNonEmpty(attName);
    }

    public void removeAttribute(String attrib, String nameSpaceURI) {
        if (this.theElement != null) {
            this.theElement.removeAttribute(attrib, nameSpaceURI);
        }
    }

    public void setAttribute(String attName, String value) {
        if (this.theElement != null) {
            this.theElement.setNonEmpty(attName, value);
        }
    }

    public void reorder() {
    }

    public void setXPathValue(String xpath, String value) {
        if (this.theElement != null) {
            this.theElement.setXPathValue(xpath, value);
        }
    }

    public void cleanUp() {
        XJDFCleanupComparator comparator = new XJDFCleanupComparator();
        this.theElement.sortChildren(comparator, true);
    }

    public KElement getRoot() {
        return this.theElement;
    }

    public KElement deleteNode() {
        KElement ret = this.theElement;
        if (this.theElement != null) {
            this.theElement.deleteNode();
            this.theElement = null;
        }
        return ret;
    }

    public boolean isEqual(BaseXJDFHelper other) {
        if (this.theElement == null) {
            return other == null || other.theElement == null;
        }
        return this.theElement.isEqual(other.theElement);
    }

    public String getID() {
        return this.getAttribute("ID");
    }

    public String ensureID() {
        return this.theElement.appendAnchor(null);
    }

    public void setID(String newID) {
        this.setAttribute("ID", KElement.xmlnsLocalName(newID));
    }

    public int hashCode() {
        int prime = 31;
        int result = 42;
        result = 31 * result + (this.theElement == null ? 0 : this.theElement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseXJDFHelper other = (BaseXJDFHelper)obj;
        return ContainerUtil.equals(this.theElement, other.theElement);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.theElement;
    }

    public KElement appendElement(String elementName) {
        return this.theElement == null ? null : this.theElement.appendElement(elementName);
    }

    public KElement copyHelper(BaseXJDFHelper src) {
        return this.theElement == null || src == null ? null : this.theElement.copyElement(src.getRoot(), null);
    }

    public KElement getCreateElement(String nodeName) {
        return this.theElement == null ? null : this.theElement.getCreateElement(nodeName);
    }

    public void setGeneralID(String idUsage, String idValue) {
        if (this.theElement instanceof JDFElement) {
            ((JDFElement)this.theElement).setGeneralID(idUsage, idValue);
        }
    }

    public String getGeneralID(String idUsage) {
        if (this.theElement instanceof JDFElement) {
            return ((JDFElement)this.theElement).getGeneralID(idUsage, 0);
        }
        return null;
    }
}

