/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.HashSet;
import java.util.Set;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.ResourceHelper;

class XJDFCleanupComparator
extends KElement.SimpleElementNameComparator {
    private static Set<String> retain = null;

    @Override
    public int compare(KElement o1, KElement o2) {
        if (o1 != null && o2 != null) {
            String name1 = o1.getLocalName();
            String name2 = o2.getLocalName();
            if ("Header".equals(name1)) {
                return "Header".equals(name2) ? 0 : -1;
            }
            if ("Header".equals(name2)) {
                return 1;
            }
            KElement parent = o1.getParentNode_KElement();
            if (this.mustRetain(parent)) {
                return 0;
            }
            for (String elemName : new String[]{"Subscription", "Notification"}) {
                if (elemName.equals(name1)) {
                    return elemName.equals(name2) ? 0 : -1;
                }
                if (!elemName.equals(name2)) continue;
                return 1;
            }
            if (JDFElement.isInXJDFNameSpaceStatic(o2.getNamespaceURI()) && !JDFElement.isInXJDFNameSpaceStatic(o1.getNamespaceURI())) {
                return JDFElement.isInXJDFNameSpaceStatic(o2.getNamespaceURI()) ? 1 : -1;
            }
            if (ResourceHelper.isResourceElement(o1)) {
                return 1;
            }
            if (ResourceHelper.isResourceElement(o2)) {
                return -1;
            }
        }
        return super.compare(o1, o2);
    }

    private boolean mustRetain(KElement parent) {
        if (retain == null) {
            retain = new HashSet<String>();
            retain.add("AuditPool");
            retain.add("MediaLayers");
            retain.add("XJMF");
        }
        return parent == null ? false : retain.contains(parent.getLocalName());
    }
}

