/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.AuditPoolHelper;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDRemover;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class XJDFHelper
extends BaseXJDFHelper
implements Cloneable {
    public static final String RESOURCE = "Resource";
    public static final String XJDF = "XJDF";
    public static final String XJMF = "XJMF";
    @Deprecated
    public static final String PARAMETER = "Parameter";

    public static XJDFHelper getHelper(XMLDoc doc) {
        if (doc == null) {
            return null;
        }
        KElement root = doc.getRoot();
        return XJDFHelper.getHelper(root);
    }

    public static XJDFHelper getHelper(KElement root) {
        if (root == null) {
            return null;
        }
        if (!root.getLocalName().equals(XJDF)) {
            root = root.getDeepParent(XJDF, 0);
        }
        return root != null ? new XJDFHelper(root) : null;
    }

    public XJDFHelper(KElement xjdf) {
        if (xjdf == null) {
            this.newXJDF();
        } else {
            this.theElement = xjdf;
        }
        if (this.theElement instanceof JDFElement) {
            ((JDFElement)this.theElement).getOwnerDocument_JDFElement().setInitOnCreate(false);
        }
    }

    public XJDFHelper(String jobID, String jobPartID, VJDFAttributeMap parts) {
        this.newXJDF();
        if (jobID == null) {
            jobID = "Job_" + new JDFDate().getFormattedDateTime("MMdd_hhmmss");
        }
        this.theElement.setAttribute("JobID", jobID);
        this.theElement.setAttribute("JobPartID", jobPartID);
        this.setParts(parts);
        this.cleanUp();
    }

    private void setParts(VJDFAttributeMap parts) {
        SetHelper niHelper = this.getCreateSet(RESOURCE, "NodeInfo", JDFResourceLink.EnumUsage.Input);
        niHelper.getCreatePartitions(parts, true);
    }

    void newXJDF() {
        JDFDoc doc = new JDFDoc(XJDF, JDFElement.EnumVersion.Version_2_0);
        doc.setInitOnCreate(false);
        this.theElement = doc.getRoot();
        AuditPoolHelper aph = this.getCreateAuditPool();
        aph.appendMessage("AuditCreated");
    }

    public Vector<SetHelper> getSets() {
        return this.getSets(null, null);
    }

    public Vector<SetHelper> getSets(String setName, JDFResourceLink.EnumUsage usage) {
        Vector<SetHelper> v = new Vector<SetHelper>();
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e)) continue;
            SetHelper set = new SetHelper(e);
            if (setName != null && !setName.equals(set.getName()) || usage != null && !usage.equals((Object)set.getUsage())) continue;
            v.add(set);
        }
        return v.size() == 0 ? null : v;
    }

    public AuditPoolHelper getAuditPool() {
        KElement auditPool = this.theElement.getElement("AuditPool");
        return auditPool == null ? null : new AuditPoolHelper(auditPool);
    }

    public AuditPoolHelper getCreateAuditPool() {
        KElement auditPool = this.theElement.getCreateElement("AuditPool");
        return new AuditPoolHelper(auditPool);
    }

    public SetHelper getSet(String id) {
        if (StringUtil.isEmpty(id)) {
            return null;
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!id.equals(e.getID()) || !SetHelper.isSet(e)) continue;
            return new SetHelper(e);
        }
        return null;
    }

    public SetHelper getSetForPartition(String id) {
        ResourceHelper ph = this.getPartition(id);
        if (ph != null) {
            return ph.getSet();
        }
        return this.getSet(id);
    }

    public ResourceHelper getPartition(String id) {
        if (id == null) {
            return null;
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            ResourceHelper ph;
            if (!SetHelper.isSet(e) || (ph = new SetHelper(e).getPartition(id)) == null) continue;
            return ph;
        }
        return null;
    }

    @Deprecated
    public boolean isSet(KElement e) {
        return SetHelper.isSet(e);
    }

    public String getJobID() {
        return this.getXPathValue("@JobID");
    }

    public VString getDependentJobParts(JDFResourceLink.EnumUsage usage) {
        Vector<SetHelper> vsh = this.getSets(null, usage);
        VString ret = new VString();
        if (vsh != null) {
            for (SetHelper sh : vsh) {
                ret.appendUnique(sh.getDependentJobParts());
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    public ProductHelper getProduct(String id) {
        KElement productList = this.theElement == null ? null : this.theElement.getElement("ProductList");
        KElement productElement = productList == null ? null : productList.getChildWithAttribute("Product", "ID", null, id, 0, true);
        return productElement == null ? null : new ProductHelper(productElement);
    }

    public ProductHelper getCreateProduct(String id) {
        ProductHelper ph = this.getProduct(id);
        if (ph == null) {
            ph = this.appendProduct();
            ph.setID(id);
        }
        return ph;
    }

    public ProductHelper getRootProduct(int iProduct) {
        Vector<ProductHelper> rootProductHelpers = this.getRootProductHelpers();
        if (rootProductHelpers == null) {
            return null;
        }
        if (iProduct < 0) {
            iProduct = rootProductHelpers.size() + iProduct;
        }
        if (iProduct >= rootProductHelpers.size() || iProduct < 0) {
            return null;
        }
        ProductHelper productHelper = rootProductHelpers.get(iProduct);
        return productHelper;
    }

    public ProductHelper getCreateRootProduct(int iProduct) {
        ProductHelper productHelper = this.getRootProduct(iProduct);
        if (productHelper == null) {
            productHelper = this.appendProduct();
            productHelper.setRoot();
        }
        return productHelper;
    }

    public int numProductHelpers(boolean rootOnly) {
        Vector<ProductHelper> v = rootOnly ? this.getRootProductHelpers() : this.getProductHelpers();
        return v == null ? 0 : v.size();
    }

    public Vector<ProductHelper> getRootProductHelpers() {
        Vector<ProductHelper> vp = this.getProductHelpers();
        if (vp == null) {
            return null;
        }
        Vector<ProductHelper> vp2 = new Vector<ProductHelper>();
        for (ProductHelper ph : vp) {
            if (!ph.isRootProduct()) continue;
            vp2.add(ph);
        }
        return vp2.size() == 0 ? null : vp2;
    }

    public Vector<ProductHelper> getProductHelpers() {
        VElement products;
        KElement productList = this.theElement == null ? null : this.theElement.getElement("ProductList");
        VElement vElement = products = productList == null ? null : productList.getChildElementVector("Product", null);
        if (products == null || products.size() == 0) {
            return null;
        }
        Vector<ProductHelper> vph = new Vector<ProductHelper>();
        for (KElement e : products) {
            vph.add(new ProductHelper(e));
        }
        return vph;
    }

    public ResourceHelper getPartition(String name, int iSet, int iPart) {
        SetHelper sh = this.getSet(name, iSet);
        return sh == null ? null : sh.getPartition(iPart);
    }

    public KElement getResource(String name, int iSet, int iPart) {
        ResourceHelper ph = this.getPartition(name, iSet, iPart);
        return ph == null ? null : ph.getResource();
    }

    public SetHelper getSet(String name, int iSkip) {
        int n = 0;
        KElement e2 = null;
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getAttribute("Name", null, null)) || n++ != iSkip) continue;
            e2 = e;
            break;
        }
        return e2 == null ? null : new SetHelper(e2);
    }

    public SetHelper getSet(String name, JDFResourceLink.EnumUsage usage, String processUsage) {
        String usageString;
        String string = usageString = usage == null ? null : usage.getName();
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getNonEmpty("Name")) || !StringUtil.equals(usageString, e.getNonEmpty("Usage")) || !StringUtil.equals(processUsage, e.getNonEmpty("ProcessUsage"))) continue;
            return new SetHelper(e);
        }
        return null;
    }

    public SetHelper getSet(String name, JDFResourceLink.EnumUsage usage) {
        KElement e;
        String usageString;
        String string = usageString = usage == null ? null : usage.getName();
        for (e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getNonEmpty("Name")) || !StringUtil.equals(usageString, e.getNonEmpty("Usage"))) continue;
            return new SetHelper(e);
        }
        if (usage == null) {
            for (e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
                if (!SetHelper.isSet(e) || name != null && !name.equals(e.getNonEmpty("Name"))) continue;
                return new SetHelper(e);
            }
        }
        return null;
    }

    public SetHelper appendSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        if (family == null) {
            family = RESOURCE;
        }
        KElement newSet = this.theElement.appendElement(family + "Set");
        newSet.setAttribute("Name", name);
        if (name == null) {
            name = "Set";
        }
        SetHelper h = new SetHelper(newSet);
        h.setID(name + KElement.uniqueID(0));
        if (usage != null) {
            h.setUsage(usage);
        }
        return h;
    }

    public SetHelper getCreateSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        SetHelper newSet = this.getSet(name, usage, null);
        if (newSet == null) {
            newSet = this.appendSet(family, name, usage);
        }
        return newSet;
    }

    @Deprecated
    public SetHelper getCreateResourceSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(RESOURCE, name, usage);
    }

    public SetHelper getCreateSet(String name, JDFResourceLink.EnumUsage usage) {
        SetHelper set = this.getSet(name, usage);
        if (set == null) {
            set = this.appendResourceSet(name, usage);
        }
        return set;
    }

    public SetHelper getCreateSet(String name, JDFResourceLink.EnumUsage usage, String processUsage) {
        SetHelper set = this.getSet(name, usage, processUsage);
        if (set == null) {
            set = this.appendSet(RESOURCE, name, usage);
            set.setProcessUsage(processUsage);
        }
        return set;
    }

    @Deprecated
    public SetHelper getCreateParameterSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(RESOURCE, name, usage);
    }

    public void removeSet(String name) {
        SetHelper newSet = this.getSet(name, 0);
        if (newSet != null) {
            newSet.getSet().deleteNode();
        }
    }

    @Deprecated
    public SetHelper appendParameter(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendResourceSet(name, usage);
    }

    public ProductHelper appendProduct() {
        KElement product = this.theElement.getCreateElement("ProductList").appendElement("Product");
        this.reorder();
        ProductHelper productHelper = new ProductHelper(product);
        productHelper.setRoot(productHelper.isRootProduct());
        return productHelper;
    }

    @Deprecated
    public SetHelper appendResource(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendResourceSet(name, usage);
    }

    public SetHelper appendResourceSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendSet(RESOURCE, name, usage);
    }

    @Override
    public String toString() {
        return "XJDFHelper: " + this.theElement;
    }

    public boolean writeToFile(String file) {
        this.cleanUp();
        boolean b = this.getRoot().getOwnerDocument_KElement().write2File(file, 2, false);
        return b;
    }

    public File writeToDir(String dir) {
        String file;
        String newURL;
        boolean ok;
        String jobPartID;
        String jobID = this.getJobID();
        if (StringUtil.getNonEmpty(jobID) == null) {
            jobID = "xjdf";
        }
        if (StringUtil.getNonEmpty(jobPartID = this.getJobPartID()) == null) {
            String types = this.getXPathValue("@Types");
            if (StringUtil.getNonEmpty(types) == null) {
                types = "unknown";
            }
            jobPartID = types;
        }
        return (ok = this.writeToFile(newURL = UrlUtil.getURLWithDirectory(dir, file = jobID + "." + jobPartID + ".xjdf"))) ? new File(newURL) : null;
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.cleanUp();
        this.getRoot().getOwnerDocument_KElement().write2Stream(os, 2, false);
    }

    public void setTypes(String types) {
        VString vtypes = VString.getVString(types, null);
        this.setTypes(vtypes);
    }

    public void setTypes(VString vtypes) {
        this.setXPathValue("@Types", StringUtil.setvString(vtypes));
    }

    public VString getTypes() {
        return VString.getVString(this.getAttribute("Types"), null);
    }

    public String getCategory() {
        return this.getAttribute("Category");
    }

    public VJDFAttributeMap getPartMapVector() {
        SetHelper sh = this.getSet("NodeInfo", JDFResourceLink.EnumUsage.Input, null);
        return sh == null ? null : sh.getPartMapVector();
    }

    public JDFNode.EnumType getType() {
        VString types = VString.getVString(this.getXPathValue("@Types"), null);
        JDFNode.EnumType typ = null;
        if (types != null && types.size() == 1) {
            typ = JDFNode.EnumType.getEnum(types.get(0));
        }
        return typ == null ? JDFNode.EnumType.ProcessGroup : typ;
    }

    @Override
    public void cleanUp() {
        AuditPoolHelper auditPool;
        this.theElement.sortChildren(new KElement.SimpleElementNameComparator(), false);
        Vector<SetHelper> v = this.getSets();
        if (v != null) {
            for (SetHelper sh : v) {
                sh.cleanUp();
                this.theElement.moveElement(sh.getSet(), null);
            }
        }
        if ((auditPool = this.getAuditPool()) != null) {
            auditPool.cleanUp();
        }
        new IDRemover().removeIDs(this.theElement);
    }

    public XJDFHelper clone() {
        KElement k = this.theElement == null ? null : this.theElement.cloneNewDoc();
        return new XJDFHelper(k);
    }

    public String getJobPartID() {
        return this.getXPathValue("@JobPartID");
    }

    public void setJobPartID(String jobPartID) {
        this.setXPathValue("@JobPartID", jobPartID);
    }

    public void setJobID(String jobID) {
        this.setXPathValue("@JobID", jobID);
    }

    @Override
    public void reorder() {
        KElement f;
        KElement pl = this.theElement.getElement("ProductList");
        KElement ap = this.theElement.getElement("AuditPool");
        if (pl != null) {
            f = this.theElement.getFirstChildElement();
            if (f == ap) {
                f = f.getNextSiblingElement();
            }
            this.theElement.moveElement(pl, f);
        }
        if (ap != null) {
            f = this.theElement.getFirstChildElement();
            this.theElement.moveElement(ap, f);
        }
    }

    public void removeType(String typ, int iSkip) {
        VString types = this.getTypes();
        if (types != null && types.indexOf(typ, iSkip) >= 0) {
            int pos = types.indexOf(typ, iSkip);
            types.remove(pos);
            this.setTypes(types);
            Vector<SetHelper> sets = this.getSets();
            if (sets != null) {
                for (SetHelper set : sets) {
                    set.removeTypeFromCPI(pos);
                }
            }
        }
    }

    public XJDFHelper addType(String typ) {
        this.addType(typ, -1);
        return this;
    }

    public XJDFHelper addType(JDFNode.EnumType typ) {
        return this.addType(typ.getName());
    }

    public void addType(String typ, int iSkip) {
        VString types = this.getTypes();
        if (types == null) {
            types = new VString();
        }
        int lastPos = types.size();
        if (iSkip < 0) {
            iSkip = lastPos;
        }
        if (iSkip <= lastPos) {
            types.insertElementAt(typ, iSkip);
            this.setTypes(types);
            Vector<SetHelper> sets = this.getSets();
            if (sets != null) {
                for (SetHelper set : sets) {
                    set.addTypeToCPI(iSkip);
                }
            }
        }
    }

    public int indexOfType(String typ, int iSkip) {
        VString types = this.getTypes();
        if (types == null) {
            return -1;
        }
        int n = -1;
        while (iSkip-- >= 0) {
            int i = types.indexOf(typ, n + 1);
            if (i >= 0) {
                n = i;
                continue;
            }
            n = -1;
            break;
        }
        return n;
    }
}

