/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.IOException;
import java.io.OutputStream;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.extensions.MessageHelper;
import org.cip4.jdflib.extensions.MessagePoolHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDRemover;
import org.cip4.jdflib.jmf.JDFMessage;

public class XJMFHelper
extends MessagePoolHelper {
    public XJMFHelper(KElement pool) {
        super(pool);
    }

    public XJMFHelper() {
        super(null);
        this.newXJMF();
    }

    void newXJMF() {
        JDFDoc doc = new JDFDoc("XJMF", JDFElement.EnumVersion.Version_2_0);
        doc.setInitOnCreate(false);
        this.theElement = doc.getRoot();
        this.cleanUp();
    }

    public MessageHelper appendMessage(JDFMessage.EnumFamily family, JDFMessage.EnumType typ) {
        if (family == null || typ == null) {
            return null;
        }
        return this.appendMessage(this.getMessageName(family, typ.getName()));
    }

    public MessageHelper appendMessage(JDFMessage.EnumFamily family, String typ) {
        if (family == null || typ == null) {
            return null;
        }
        return this.appendMessage(this.getMessageName(family, typ));
    }

    private String getMessageName(JDFMessage.EnumFamily family, String typ) {
        return family.getName() + typ;
    }

    public boolean writeToFile(String file) {
        this.cleanUp();
        boolean b = this.getRoot().getOwnerDocument_KElement().write2File(file, 2, false);
        return b;
    }

    public KElement getHeader() {
        return MessageHelper.ensureHeader(this.theElement);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        MessageHelper.ensureHeader(this.theElement);
        new IDRemover().removeIDs(this.theElement);
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.cleanUp();
        this.getRoot().getOwnerDocument_KElement().write2Stream(os, 2, false);
    }

    public static XJMFHelper getHelper(KElement root) {
        if (root == null) {
            return null;
        }
        if (!root.getLocalName().equals("XJMF")) {
            root = root.getDeepParent("XJMF", 0);
        }
        return root != null ? new XJMFHelper(root) : null;
    }

    public static XJMFHelper getHelper(XMLDoc doc) {
        if (doc == null) {
            return null;
        }
        KElement root = doc.getRoot();
        return XJMFHelper.getHelper(root);
    }
}

