/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.HashMap;
import java.util.Map;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDPart;
import org.cip4.jdflib.util.StringUtil;

public class IDFinder
extends BaseElementWalker {
    final Map<String, IDPart> theMap = new HashMap<String, IDPart>();
    final Map<String, String> indexMap = new HashMap<String, String>();
    boolean needSplitPart = false;

    public IDFinder() {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
    }

    public Map<String, IDPart> getMap(KElement n) {
        this.theMap.clear();
        this.walkTree(n, null);
        return this.theMap;
    }

    public class WalkSet
    extends BaseWalker {
        public WalkSet() {
            super(IDFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            int n;
            String id = e.getAttribute("ID", null, null);
            if (id == null) {
                id = "IDF" + KElement.uniqueID(0);
                e.setID(id);
            }
            if ((n = e.numChildElements("Resource", null)) > 1) {
                SetHelper sh = new SetHelper(e);
                VJDFAttributeMap parts = sh.getPartMapVector();
                parts.removeKey("ProductPart");
                IDFinder.this.needSplitPart = parts.size() < n;
            } else {
                IDFinder.this.needSplitPart = false;
            }
            IDFinder.this.theMap.put(id, new IDPart(id, null));
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b = super.matches(toCheck);
            if (!b) {
                return false;
            }
            return SetHelper.isSet(toCheck);
        }
    }

    public class WalkResource
    extends BaseWalker {
        public WalkResource() {
            super(IDFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String id = e.getAttribute("ID", null, null);
            if (id == null) {
                id = e.generateDotID("ID", null);
                e.setID(id);
            }
            VElement vPart = e.getChildElementVector("Part", null, null, true, 0, false);
            String idParent = this.getParentID(e, vPart);
            IDFinder.this.theMap.put(id, new IDPart(idParent, vPart));
            return e;
        }

        private String getParentID(KElement e, VElement parts) {
            String productID;
            KElement part;
            String idParent = e.getParentNode_KElement().getAttribute("ID", null, null);
            KElement kElement = part = parts == null ? null : parts.get(0);
            if (part != null && IDFinder.this.needSplitPart && (productID = StringUtil.getNonEmpty(part.getAttribute("ProductPart"))) != null) {
                idParent = idParent + "." + productID;
            }
            return idParent;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b = super.matches(toCheck);
            if (!b) {
                return false;
            }
            String localName = toCheck.getLocalName();
            return localName.equals("Resource") || localName.equals("Parameter");
        }
    }
}

