/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.io.File;
import java.util.Vector;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.XJDFZipWriter;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;

class MultiJDFToXJDF {
    private final JDFToXJDF jdfToXJDF;

    void saveZip(String fileName, JDFNode rootNode, boolean replace) {
        File file = new File(fileName);
        if (file.canRead()) {
            if (replace) {
                file.delete();
            } else {
                throw new JDFException("output file exists: " + file.getPath());
            }
        }
        FileUtil.writeFile(this.getZipWriter(rootNode), new File(fileName));
    }

    XJDFZipWriter getZipWriter(JDFNode rootNode) {
        this.jdfToXJDF.setSingleNode(true);
        Vector<XJDFHelper> vXJDFs = this.getXJDFs(rootNode);
        XJDFZipWriter w = new XJDFZipWriter();
        for (XJDFHelper h : vXJDFs) {
            w.addXJDF(h);
        }
        return w;
    }

    MultiJDFToXJDF(JDFToXJDF jdfToXJDF) {
        this.jdfToXJDF = jdfToXJDF;
    }

    Vector<XJDFHelper> getXJDFs(JDFNode root) {
        if (root == null) {
            return null;
        }
        this.jdfToXJDF.setSingleNode(true);
        Vector<XJDFHelper> vRet = new Vector<XJDFHelper>();
        VElement v = this.getProcessNodes(root);
        boolean keepProduct = this.jdfToXJDF.wantProduct;
        this.jdfToXJDF.wantProduct = true;
        if ("Product".equals(root.getType())) {
            XJDFHelper xjdfHelper = this.convertSingle(root);
            vRet.add(xjdfHelper);
        }
        this.jdfToXJDF.wantProduct = false;
        for (KElement n : v) {
            XJDFHelper xjdfHelper = this.convertSingle(n);
            vRet.add(xjdfHelper);
        }
        this.jdfToXJDF.wantProduct = keepProduct;
        return vRet;
    }

    private XJDFHelper convertSingle(KElement n) {
        KElement xjdf = this.jdfToXJDF.makeNewJDF((JDFNode)n, null);
        XJDFHelper xjdfHelper = new XJDFHelper(xjdf);
        if (this.jdfToXJDF.isCleanup()) {
            xjdfHelper.cleanUp();
        }
        return xjdfHelper;
    }

    VElement getProcessNodes(JDFNode rootNode) {
        VElement v = rootNode.getvJDFNode(null, null, false);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFNode n = (JDFNode)v.elementAt(i);
            if (!n.isProcessNode()) {
                v.remove(i);
                continue;
            }
            this.ensureJobPartID(i, n);
        }
        return v;
    }

    private void ensureJobPartID(int i, JDFNode n) {
        String nam = n.getJobPartID(false);
        if (StringUtil.getNonEmpty(nam) == null) {
            nam = "Part_" + i;
            n.setJobPartID(nam);
        }
    }

    public String toString() {
        return "MultiJDFToXJDF [" + (this.jdfToXJDF != null ? "jdfToXJDF=" + this.jdfToXJDF : "") + "]";
    }
}

