/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFSubElement;
import org.cip4.jdflib.resource.process.JDFEmployee;

public class WalkAudit
extends WalkJDFSubElement {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFAudit;
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFAudit a = (JDFAudit)jdf;
        this.employeeToAuthor(a);
        KElement e = super.walk(jdf, xjdf);
        return e;
    }

    private void employeeToAuthor(JDFAudit a) {
        JDFEmployee emp = a.getEmployee(0);
        if (emp != null) {
            a.setAuthor(emp.getDescriptiveName());
            a.removeChildren("Employee", null, null);
        }
    }

    void moveToParentAudit(KElement jdf, KElement auditParent) {
        auditParent.moveAttribute("AgentName", jdf);
        auditParent.moveAttribute("AgentVersion", jdf);
        auditParent.moveAttribute("ID", jdf);
        auditParent.moveAttribute("Time", jdf, "TimeStamp", null, null);
        JDFEmployee emp = (JDFEmployee)jdf.getElement("Employee");
        if (emp != null) {
            auditParent.setAttribute("Author", emp.getDescriptiveName());
            auditParent.setAttribute("PersonalID", emp.getPersonalID());
        } else {
            auditParent.moveAttribute("Author", jdf);
            auditParent.moveAttribute("PersonalID", jdf);
        }
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("AgentName");
        map.remove("AgentVersion");
        map.renameKey("TimeStamp", "Time");
        super.updateAttributes(map);
    }
}

