/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.util.StringUtil;

public class WalkMessage
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFMessage m2;
        JDFMessage m = (JDFMessage)jdf;
        if (this.jdfToXJDF.isTypeSafeMessage() && (m2 = this.makeTypesafe(m)) == null) {
            return null;
        }
        return super.walk(jdf, xjdf);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        super.updateAttributes(map);
        if (this.jdfToXJDF.isTypeSafeMessage()) {
            map.renameKey("SenderID", "DeviceID");
            map.remove("Type");
            map.remove("Acknowledged");
            map.remove("AcknowledgeType");
            map.remove("AcknowledgeURL");
            map.remove("Format");
            map.remove("LastRepeat");
            map.remove("Template");
        }
    }

    JDFMessage makeTypesafe(JDFMessage m) {
        String type;
        JDFMessage.EnumFamily family = this.getNewFamily(m);
        String string = type = family == null ? null : this.getMessageType(m);
        if (type == null) {
            return null;
        }
        m.renameElement(this.getFamilyName(family) + type, null);
        return m;
    }

    String getFamilyName(JDFMessage.EnumFamily family) {
        return family.getName();
    }

    String getMessageType(JDFMessage m) {
        JDFMessage.EnumType type = m.getEnumType();
        boolean zappType = this.isZappType(type);
        if (zappType) {
            this.log.warn((Object)("Removing unsupported message Type: " + m.getType()));
        }
        return zappType ? null : type.getName();
    }

    boolean isZappType(JDFMessage.EnumType type) {
        return JDFMessage.EnumType.CloseQueue.equals((Object)type) || JDFMessage.EnumType.Events.equals((Object)type) || JDFMessage.EnumType.FlushResources.equals((Object)type) || JDFMessage.EnumType.HoldQueue.equals((Object)type) || JDFMessage.EnumType.KnownControllers.equals((Object)type) || JDFMessage.EnumType.KnownJDFServices.equals((Object)type) || JDFMessage.EnumType.ModifyNode.equals((Object)type) || JDFMessage.EnumType.NewJDF.equals((Object)type) || JDFMessage.EnumType.NodeInfo.equals((Object)type) || JDFMessage.EnumType.Occupation.equals((Object)type) || JDFMessage.EnumType.OpenQueue.equals((Object)type) || JDFMessage.EnumType.QueueEntryStatus.equals((Object)type) || JDFMessage.EnumType.RepeatMessages.equals((Object)type) || JDFMessage.EnumType.RequestForAuthentication.equals((Object)type) || JDFMessage.EnumType.ResumeQueue.equals((Object)type) || JDFMessage.EnumType.SubmissionMethods.equals((Object)type) || JDFMessage.EnumType.Track.equals((Object)type) || JDFMessage.EnumType.UpdateJDF.equals((Object)type);
    }

    JDFMessage.EnumFamily getNewFamily(JDFMessage m) {
        String type = m.getType();
        if (StringUtil.isEmpty(type)) {
            return null;
        }
        JDFMessage.EnumFamily family = m.getFamily();
        if (this.jdfToXJDF.isAbstractMessage()) {
            if (JDFMessage.EnumFamily.Command.equals((Object)family) || JDFMessage.EnumFamily.Registration.equals((Object)family)) {
                family = JDFMessage.EnumFamily.Query;
            }
            if (JDFMessage.EnumFamily.Acknowledge.equals((Object)family)) {
                family = JDFMessage.EnumFamily.Response;
            }
        }
        return family;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFMessage;
    }
}

