/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Vector;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFSubElement;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFResource;

public class WalkResourceInfo
extends WalkJDFSubElement {
    @Override
    public KElement walk(KElement resInfo, KElement xjdf) {
        JDFResourceInfo ri = (JDFResourceInfo)resInfo;
        KElement eNew = super.walk(ri, xjdf);
        VElement vr = ri.getChildElementVector(null, null);
        int nRes = 0;
        for (KElement e : vr) {
            if (!(e instanceof JDFResource)) continue;
            JDFResource r = (JDFResource)e;
            if (nRes == 0) {
                this.setResource(ri, r, eNew);
            } else {
                this.setResource(null, r, eNew);
            }
            r.deleteNode();
            ++nRes;
        }
        this.moveToResourceSet((JDFResourceInfo)eNew, ri);
        this.updateInfos((JDFResourceInfo)eNew);
        eNew.removeAttribute("ResourceName");
        return null;
    }

    void updateInfos(JDFResourceInfo eNew) {
        KElement parent;
        VElement v = eNew.getChildElementVector("ResourceSet", null);
        int size = v.size();
        if (size > 1 && (parent = eNew.getParentNode_KElement()) != null) {
            int n = 0;
            VElement vRI = new VElement();
            vRI.add(eNew);
            for (int i = 1; i < size; ++i) {
                vRI.add(parent.copyElement(eNew, null));
            }
            for (KElement ri : vRI) {
                for (int ii = size - 1; ii >= 0; --ii) {
                    if (ii == n) continue;
                    ri.removeChild("ResourceSet", null, ii);
                }
                ++n;
            }
        }
    }

    private void moveToResourceSet(JDFResourceInfo ri, JDFResourceInfo jdfRI) {
        KElement set;
        VJDFAttributeMap vPartMap = jdfRI.getPartMapVector();
        this.setAmountPool(jdfRI, jdfRI, null);
        JDFAmountPool ap = jdfRI.getAmountPool();
        String resName = ri.getXPathAttribute("ResourceSet/@Name", null);
        if (resName == null) {
            resName = ri.getResourceName();
        }
        if ((set = ri.getChildWithAttribute("ResourceSet", "Name", null, resName, 0, true)) == null) {
            set = ri.appendElement("ResourceSet");
            set.setAttribute("Name", resName);
        }
        set.moveAttribute("ProcessUsage", ri);
        set.moveAttribute("Orientation", ri);
        set.moveAttribute("Usage", ri);
        SetHelper sh = new SetHelper(set);
        Vector<ResourceHelper> newParts = sh.getCreatePartitions(vPartMap, false);
        for (ResourceHelper ph : newParts) {
            if (ap == null) {
                ph.setAmount(ri.getActualAmount(), null, true);
                if (newParts.size() != 1) continue;
                ph.getRoot().moveAttribute("ExternalID", ri);
                continue;
            }
            if (ph.getRoot().getElement("AmountPool") != null) continue;
            JDFAmountPool ap2 = (JDFAmountPool)ap.getParentNode_KElement().copyElement(ap, null);
            ap2.reducePartAmounts(ph.getPartMapVector());
            this.jdfToXJDF.walkTree(ap2, ph.getRoot());
            ap2.deleteNode();
        }
        if (newParts.size() > 1) {
            set.moveAttribute("ExternalID", ri);
        } else {
            ri.removeAttribute("ExternalID");
        }
        ri.removeChild("AmountPool", null, 0);
    }

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFResourceInfo;
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("ActualAmount");
        map.remove("Amount");
        map.remove("DeviceID");
        map.remove("Level");
        map.remove("LotControlled");
        map.remove("ResourceID");
        map.remove("Status");
        this.updateModule(map);
        super.updateAttributes(map);
    }

    @Override
    void makeRefElements(JDFElement je) {
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("ResourceInfo", null);
    }
}

