/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;

class XJDFCombiner {
    private final XJDFHelper mainHelper;
    int[] typeIndex;

    XJDFCombiner(XJDFHelper helper) {
        this.mainHelper = helper;
        this.typeIndex = null;
    }

    public String toString() {
        return "XJDFCombiner [" + (this.mainHelper != null ? "mainHelper=" + this.mainHelper : "") + "]";
    }

    public void combine(XJDFHelper h) {
        Vector<SetHelper> v;
        this.typeIndex = this.combineTypes(h);
        if (this.typeIndex != null && (v = h.getSets()) != null) {
            for (SetHelper s : v) {
                this.combineSet(s);
            }
        }
    }

    private void combineSet(SetHelper s) {
        SetHelper mainSet = this.mainHelper.getSet(s.getID());
        if (mainSet == null) {
            this.copySet(s);
        } else {
            this.mergeSet(mainSet, s);
        }
    }

    private void mergeSet(SetHelper mainSet, SetHelper s) {
        Vector<ResourceHelper> v = s.getPartitions();
        for (ResourceHelper r : v) {
            ResourceHelper partition = mainSet.getPartition(r.getPartMapVector());
            if (partition != null) {
                partition.getRoot().setAttributes(r.getRoot());
                KElement r2 = r.getResource();
                if (r2 == null) continue;
                partition.getCreateResource().mergeElement(r2, false);
                continue;
            }
            mainSet.copyHelper(r);
        }
    }

    void copySet(SetHelper s) {
        SetHelper copied = new SetHelper(this.mainHelper.copyHelper(s));
        if (this.typeIndex != null) {
            JDFIntegerList cpi = this.getMainCPI(copied);
            copied.setCombinedProcessIndex(cpi);
        }
    }

    protected JDFIntegerList getMainCPI(SetHelper copied) {
        JDFIntegerList cpi = copied.getCombinedProcessIndex();
        if (cpi != null) {
            for (int i = 0; i < cpi.size(); ++i) {
                int index = cpi.getInt(i);
                if (index < 0 || index >= this.typeIndex.length) continue;
                cpi.set(i, this.typeIndex[index]);
            }
        } else {
            cpi = new JDFIntegerList(this.typeIndex);
        }
        return cpi;
    }

    int[] combineTypes(XJDFHelper h) {
        VString types = h.getTypes();
        VString oldTypes = this.mainHelper.getTypes();
        if (types != null && types.size() > 0) {
            int[] typeList = new int[types.size()];
            if (oldTypes == null || oldTypes.size() == 0) {
                for (int i = 0; i < types.size(); ++i) {
                    typeList[i] = i;
                }
            } else {
                int i = 0;
                for (String t : types) {
                    int pos = oldTypes.indexOf(t);
                    if (pos >= 0) {
                        typeList[i++] = pos;
                        continue;
                    }
                    typeList[i++] = oldTypes.size();
                    oldTypes.add(t);
                    this.mainHelper.setTypes(oldTypes);
                }
            }
            return typeList;
        }
        return null;
    }
}

