/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Collection;
import java.util.Vector;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.EnsureNSUri;
import org.cip4.jdflib.elementwalker.RemoveEmpty;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFArtDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.resource.process.JDFDeliveryParams;
import org.cip4.jdflib.resource.process.JDFDependencies;
import org.cip4.jdflib.resource.process.JDFLayoutElement;
import org.cip4.jdflib.resource.process.JDFLayoutElementProductionParams;
import org.cip4.jdflib.resource.process.JDFPageData;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

class PostConverter {
    private final XJDFToJDFImpl xjdfToJDFImpl;
    private final JDFNode theNode;

    PostConverter(XJDFToJDFImpl xjdfToJDFImpl, JDFNode theNode) {
        this.xjdfToJDFImpl = xjdfToJDFImpl;
        this.theNode = theNode;
    }

    void postConvert() {
        JDFNode root = this.theNode.getJDFRoot();
        String type = StringUtil.getNonEmpty(root.getType());
        if (type == null || "Product".equals(type)) {
            this.mergeProductLinks(this.theNode, root);
        }
        this.fixDelivery();
        new GangCleaner().cleanGangLinks();
        new ResourceCleaner().cleanResources();
        new ProcessCleaner().cleanProcesses();
        new DependencyCleaner().fixDependencies(root);
        new UnLinkFinder().eraseUnlinked(root);
        this.xjdfToJDFImpl.firstConvert = false;
        EnsureNSUri fixNS = new EnsureNSUri();
        fixNS.addNS(null, JDFElement.getSchemaURL());
        fixNS.walk(root);
        RemoveEmpty re = new RemoveEmpty();
        re.removEmpty(root);
    }

    private void fixDelivery() {
        JDFDeliveryParams dp = (JDFDeliveryParams)this.theNode.getResource("DeliveryParams", JDFResourceLink.EnumUsage.Input, 0);
        VString allTypes = this.theNode.getAllTypes();
        if (dp != null && allTypes.contains("Product")) {
            boolean keepDI = this.theNode.getResource("DeliveryIntent", JDFResourceLink.EnumUsage.Input, 0) != null;
            JDFDeliveryIntent di = (JDFDeliveryIntent)this.theNode.getCreateResource("DeliveryIntent", JDFResourceLink.EnumUsage.Input, 0);
            boolean bl = keepDI = di.setFromDeliveryParams(dp) || keepDI;
            if (!keepDI) {
                di.deleteNode();
            }
            boolean keepADI = this.theNode.getResource("ArtDeliveryIntent", JDFResourceLink.EnumUsage.Input, 0) != null;
            JDFArtDeliveryIntent adi = (JDFArtDeliveryIntent)this.theNode.getCreateResource("ArtDeliveryIntent", JDFResourceLink.EnumUsage.Input, 0);
            boolean bl2 = keepADI = adi.setFromDeliveryParams(dp) || keepADI;
            if (!keepADI) {
                adi.deleteNode();
            }
            dp.deleteNode();
        }
    }

    public String toString() {
        return "PostConverter [theNode=" + this.theNode + "]";
    }

    private JDFResource mergeProductLink(JDFNode childNode, JDFNode parentProduct, String resName, JDFResourceLink.EnumUsage enumUsage) {
        JDFResourceLink link;
        JDFResource r = parentProduct.getResource(resName, enumUsage, 0);
        int n = 0;
        while (r == null && (link = childNode.getLink(n, resName, new JDFAttributeMap("Usage", enumUsage), null)) != null) {
            if (link.getCombinedProcessIndex() == null) {
                r = link.getLinkRoot();
                parentProduct.ensureLink(r, enumUsage, null);
            }
            ++n;
        }
        return r;
    }

    void mergeProductLinks(JDFNode childNode, JDFNode parentProduct) {
        JDFResource rNode;
        JDFResource r;
        if (childNode == parentProduct) {
            return;
        }
        this.mergeProductLink(childNode, parentProduct, "CustomerInfo", JDFResourceLink.EnumUsage.Input);
        JDFResource ni = this.mergeProductLink(childNode, parentProduct, "NodeInfo", JDFResourceLink.EnumUsage.Input);
        if (ni == null) {
            parentProduct.appendNodeInfo().setDescriptiveName("Generated root NodeInfo");
        }
        if ((r = parentProduct.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null && "dummy outout".equals(r.getDescriptiveName()) && (rNode = childNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null) {
            parentProduct.getLink(r, JDFResourceLink.EnumUsage.Output).deleteNode();
            r.deleteNode();
        }
        this.mergeProductLink(childNode, parentProduct, "Component", JDFResourceLink.EnumUsage.Output);
    }

    private class DependencyCleaner {
        private DependencyCleaner() {
        }

        private void fixDependencies(JDFNode root) {
            Vector<JDFDependencies> vDep = root.getChildrenByClass(JDFDependencies.class, true, 0);
            if (vDep == null) {
                return;
            }
            for (JDFDependencies dep : vDep) {
                this.fixOneDependencies(dep);
            }
        }

        private void fixOneDependencies(JDFDependencies dep) {
            if (dep == null) {
                return;
            }
            VElement v = dep.getChildElementVector_KElement("RunListRef", null, null, true, 0);
            if (v == null) {
                return;
            }
            for (KElement e : v) {
                JDFRefElement rl = (JDFRefElement)e;
                rl.renameElement("LayoutElementRef", null);
                JDFResource root = rl.getTargetRoot();
                if (root == null) continue;
                VElement vR = root.getLeaves(true);
                VElement v2 = root.getLinksAndRefs(true, false);
                if (v2 != null) {
                    for (KElement rl2 : v2) {
                        rl2.renameElement("LayoutElementLink", null);
                    }
                }
                if ((v2 = root.getLinksAndRefs(false, true)) != null) {
                    for (KElement rl2 : v2) {
                        rl2.renameElement("LayoutElementRef", null);
                    }
                }
                for (KElement r : vR) {
                    JDFLayoutElement loe;
                    JDFLayoutElement jDFLayoutElement = loe = r instanceof JDFRunList ? ((JDFRunList)r).getLayoutElement() : null;
                    if (loe != null) {
                        r.moveElements(loe.getChildElementVector_KElement(null, null, null, true, 0), null);
                        r.setAttributes(loe);
                        loe.deleteNode();
                    }
                    r.renameElement("LayoutElement", null);
                }
            }
        }
    }

    class ResourceCleaner {
        ResourceCleaner() {
        }

        void cleanResources() {
            VElement vRes = this.collectResources();
            if (vRes != null) {
                for (KElement rr : vRes) {
                    this.cleanResource(rr);
                }
            }
        }

        private VElement collectResources() {
            VElement vRes = new VElement();
            for (JDFNode n = PostConverter.this.theNode; n != null; n = n.getParentJDF()) {
                JDFResourcePool rp = n.getResourcePool();
                VElement v = rp == null ? null : rp.getPoolChildren(null, null, null);
                vRes.addAll(v);
            }
            return vRes;
        }

        private void cleanResource(KElement eRoot) {
            JDFResource resRoot = (JDFResource)eRoot;
            if (resRoot != null) {
                String localName;
                JDFResource.EnumResStatus s = resRoot.getStatusFromLeaves(false);
                if (s != null) {
                    resRoot.setResStatus(s, false);
                }
                if ("ColorPool".equals(localName = resRoot.getLocalName())) {
                    this.cleanColorPool(resRoot);
                } else if ("PageList".equals(localName)) {
                    this.cleanPageList(resRoot);
                }
                this.cleanLeaf(resRoot, false);
                VElement leaves = resRoot.getLeaves(true);
                for (KElement leaf : leaves) {
                    leaf.removeChildrenByClass(JDFPart.class);
                }
            }
        }

        private void cleanLeaf(KElement elem, boolean cleanMe) {
            if (cleanMe) {
                elem.removeAttribute_KElement("Class", null);
            }
            for (KElement e2 = elem.getFirstChildElement(); e2 != null; e2 = e2.getNextSiblingElement()) {
                this.cleanLeaf(e2, true);
            }
        }

        private void cleanPageList(JDFResource r) {
            VElement v;
            String id = r.getID();
            JDFPageList pl = (JDFPageList)r;
            Collection<JDFPageData> vpd = pl.getAllPageData();
            if (vpd != null) {
                for (JDFPageData pd : vpd) {
                    pd.removeChildrenByClass(JDFPart.class);
                }
            }
            if (StringUtil.getNonEmpty(id) != null && (v = PostConverter.this.theNode.getRoot().getChildrenByTagName_KElement(null, null, new JDFAttributeMap("rRef", id), false, false, 0)) != null) {
                for (KElement e : v) {
                    String name = e.getLocalName();
                    if ("ContentRef".equals(name)) {
                        e.renameElement("PageListRef", null);
                        if (!(e.getParentNode_KElement() instanceof JDFLayoutElementProductionParams)) continue;
                        this.fixLayoutElementProductionParams(e.getParentNode_KElement());
                        continue;
                    }
                    if (!"ContentLink".equals(name)) continue;
                    e.renameElement("PageListLink", null);
                }
            }
        }

        private void fixLayoutElementProductionParams(KElement lopp) {
            JDFPageList pl = (JDFPageList)lopp.getElement("PageList");
            Collection<JDFPageData> vpd = pl.getAllPageData();
            if (vpd != null) {
                for (JDFPageData pd : vpd) {
                    KElement ren = lopp.moveElement(pd, null).renameElement("LayoutElementPart", null);
                    KElement el = lopp.copyElement(ren, ren);
                    KElement fs = el.getElement("FileSpec");
                    if (fs != null) {
                        el.appendElement("LayoutElement").moveElement(fs, null);
                    }
                    ren.deleteNode();
                }
            }
            lopp.getElement("PageListRef").deleteNode();
        }

        private void cleanColorPool(JDFResource r) {
            VElement v;
            String id = r.getID();
            JDFColorPool cp = (JDFColorPool)r;
            Collection<JDFColor> vc = cp.getAllColor();
            if (vc != null) {
                for (JDFColor c : vc) {
                    this.fixColor(c);
                }
            }
            if (StringUtil.getNonEmpty(id) != null && (v = PostConverter.this.theNode.getRoot().getChildrenByTagName_KElement(null, null, new JDFAttributeMap("rRef", id), false, false, 0)) != null) {
                for (KElement e : v) {
                    String name = e.getLocalName();
                    if ("ColorRef".equals(name)) {
                        e.renameElement("ColorPoolRef", null);
                        continue;
                    }
                    if ("ColorLink".equals(name)) {
                        e.renameElement("ColorPoolLink", null);
                        continue;
                    }
                    if ("ContentRef".equals(name)) {
                        e.renameElement("PageListRef", null);
                        continue;
                    }
                    if (!"ContentLink".equals(name)) continue;
                    e.renameElement("PageListLink", null);
                }
            }
        }

        private void fixColor(JDFColor c) {
            c.removeChildrenByClass(JDFPart.class);
            String actual = c.getActualColorName();
            String name = c.getName();
            if (!name.equals(actual)) {
                c.setName(actual);
                VElement v = PostConverter.this.theNode.getChildrenByTagName(null, null, new JDFAttributeMap("Separation", name), false, true, 0);
                for (KElement e : v) {
                    e.setAttribute("Separation", actual);
                }
                VElement w = PostConverter.this.theNode.getChildrenByTagName("SeparationSpec", null, new JDFAttributeMap("Name", name), false, true, 0);
                for (KElement e : w) {
                    e.setAttribute("Name", actual);
                }
            }
        }
    }

    class ProcessCleaner {
        ProcessCleaner() {
        }

        void cleanProcesses() {
            VString types = PostConverter.this.theNode.getAllTypes();
            if (this.getFixType(types) != null) {
                this.cleanProcess(this.getFixType(types));
            }
        }

        private void cleanProcess(String fixType) {
            VElement v;
            String resName = this.getRes(fixType);
            JDFResourceLink.EnumUsage usage = this.getUsage(fixType);
            if (PostConverter.this.theNode.getLink(resName, usage, null) == null && (v = PostConverter.this.theNode.getChildrenByTagName(resName, null, null, false, true, 0)) != null) {
                for (KElement e : v) {
                    JDFResource r = (JDFResource)e;
                    if (!r.isResourceRootRoot()) continue;
                    PostConverter.this.theNode.ensureLink(r, usage, null);
                }
            }
        }

        private String getRes(String fixType) {
            if (JDFNode.EnumType.DieLayoutProduction.getName().equals(fixType)) {
                return "ShapeDef";
            }
            return null;
        }

        private JDFResourceLink.EnumUsage getUsage(String fixType) {
            if (JDFNode.EnumType.DieLayoutProduction.getName().equals(fixType)) {
                return JDFResourceLink.EnumUsage.Input;
            }
            return null;
        }

        private String getFixType(VString types) {
            if (types != null && types.contains(JDFNode.EnumType.DieLayoutProduction.getName())) {
                return JDFNode.EnumType.DieLayoutProduction.getName();
            }
            return null;
        }
    }

    private class GangCleaner {
        private GangCleaner() {
        }

        void cleanGangLinks() {
            for (JDFNode n = PostConverter.this.theNode; n != null; n = n.getParentJDF()) {
                VElement links = PostConverter.this.theNode.getResourceLinks("NodeInfo", null, null);
                if ((links = (VElement)ContainerUtil.addAll(links, PostConverter.this.theNode.getResourceLinks("CustomerInfo", null, null))) == null) continue;
                for (KElement e : links) {
                    this.cleanGangLink(e);
                }
            }
        }

        private void cleanGangLink(KElement e) {
            JDFResourceLink link = (JDFResourceLink)e;
            VJDFAttributeMap linkMaps = link.getPartMapVector();
            if (linkMaps != null) {
                linkMaps.reduceMap(new VString("ProductPart", null));
                if (!linkMaps.isEmpty()) {
                    boolean mustZapp = true;
                    for (JDFAttributeMap map : linkMaps) {
                        String val = map.get("ProductPart");
                        if (!PostConverter.this.theNode.getID().equals(val)) continue;
                        mustZapp = false;
                        break;
                    }
                    if (mustZapp) {
                        link.deleteNode();
                    }
                }
            }
        }
    }
}

