/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFPosition;
import org.cip4.jdflib.resource.process.JDFStripCellParams;
import org.cip4.jdflib.util.StringUtil;

public class WalkPosition
extends WalkXElement {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFPosition;
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        JDFStrippingParams stripParams = trackElem instanceof JDFStrippingParams ? (JDFStrippingParams)trackElem : null;
        this.doCells(e, stripParams);
        KElement walk = super.walk(e, trackElem);
        this.moveBSRef(e, stripParams);
        return walk;
    }

    private void moveBSRef(KElement e, JDFStrippingParams stripParams) {
        if (stripParams != null) {
            KElement bsRef = e.getElement("BinderySignatureRef");
            if (bsRef != null) {
                stripParams.moveElement(bsRef, null);
            } else {
                String bsID = e.getNonEmpty("BinderySignatureID");
                if (bsID != null) {
                    e.removeAttribute("BinderySignatureID");
                    SetHelper bsSet = XJDFHelper.getHelper(this.xjdfToJDFImpl.xjdf).getSet("BinderySignature", 0);
                    if (bsSet != null) {
                        bsSet.getPartition(new JDFAttributeMap("BinderySignatureID", bsID));
                        String id = bsSet.getID();
                        JDFRefElement re = (JDFRefElement)stripParams.appendElement("BinderySignatureRef");
                        re.setrRef(id);
                        re.setPartMap(new JDFAttributeMap("BinderySignatureName", bsID));
                    }
                }
            }
        }
    }

    private void doCells(KElement e, JDFStrippingParams stripParams) {
        if (stripParams != null && stripParams.getStripCellParams() == null) {
            String id = StringUtil.getNonEmpty(e.getAttribute("BinderySignatureRef", null, null));
            XJDFHelper xh = XJDFHelper.getHelper(e);
            if (xh != null) {
                VElement vSigCell;
                ResourceHelper bsh = xh.getPartition(id);
                VElement vElement = vSigCell = bsh == null ? null : bsh.getResource().getChildElementVector("SignatureCell", null);
                if (vSigCell != null) {
                    for (KElement sigCell : vSigCell) {
                        JDFStripCellParams stripCell = stripParams.appendStripCellParams();
                        VString stripCellKnown = stripCell.knownAttributes();
                        JDFAttributeMap sigCelMap = sigCell.getAttributeMap();
                        sigCelMap.reduceMap(stripCellKnown);
                        if (sigCelMap.size() <= 0) continue;
                        stripCell.setAttributes(sigCelMap);
                        sigCell.removeAttributes(sigCelMap.keySet());
                    }
                }
            }
        }
    }

    @Override
    protected void updateAttributes(KElement elem) {
        super.updateAttributes(elem);
        elem.removeAttribute("BinderySignatureID");
    }
}

