/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Vector;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.XJDFToJDFConverter;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkXJDFResource
extends WalkXElement {
    private static final VString keepKeys = new VString("SignatureName SheetName Side PartVersion Separation BlockName Run DocIndex RunIndex SetIndex SheetIndex", null);
    private static final VString indexKeys = new VString("RunIndex DocIndex SetIndex SheetIndex", null);

    @Override
    public KElement walk(KElement xjdfRes, KElement parent) {
        JDFResource res;
        JDFNode theNode = this.getNode(xjdfRes, parent);
        if (theNode != null) {
            res = this.getResourceRoot(theNode, xjdfRes);
        } else if (parent instanceof JDFResourceInfo) {
            res = this.getResInfoRoot((JDFResourceInfo)parent, xjdfRes);
        } else {
            return null;
        }
        ResourceHelper rh = ResourceHelper.getHelper(xjdfRes);
        if (rh == null) {
            return null;
        }
        rh.getCreateResource();
        VJDFAttributeMap vParts = this.getPartMaps(rh);
        KElement newPartitionElement = this.createPartition(res, vParts.get(0), theNode);
        if (newPartitionElement == null) {
            return null;
        }
        JDFAttributeMap map = this.getResMap(xjdfRes);
        if (newPartitionElement instanceof JDFResource) {
            JDFResource newPartition = (JDFResource)newPartitionElement;
            JDFResourceLink rl = null;
            if (theNode != null) {
                rl = this.ensureLink(theNode, newPartition, rl);
            }
            JDFAttributeMap partMap = vParts.get(0);
            this.handleParts(res, vParts, rl);
            this.handleAmountPool(xjdfRes, partMap, map, rl);
        }
        newPartitionElement.setAttributes(map);
        return newPartitionElement;
    }

    protected void handleParts(JDFResource res, VJDFAttributeMap vParts, JDFResourceLink rl) {
        this.handleLinkParts(vParts, rl);
        this.handleIdentical(vParts, res, rl);
    }

    protected void handleLinkParts(VJDFAttributeMap vParts, JDFResourceLink rl) {
        if (rl != null && ContainerUtil.getNonEmpty(vParts) != null) {
            VJDFAttributeMap clone = vParts.clone();
            clone.reduceMap(keepKeys);
            if (clone.containsKey("Run")) {
                for (String index : indexKeys) {
                    if (!clone.containsKey(index)) continue;
                    clone.removeKey("Run");
                    break;
                }
            }
            if (clone.size() > 1) {
                for (String index : indexKeys) {
                    VString values = clone.getPartValues(index, false);
                    if (values == null || values.size() <= 1) continue;
                    clone.removeKey(index);
                    clone.put(index, StringUtil.setvString(values));
                    if (clone.size() != 1) continue;
                    break;
                }
            }
            clone.remove(new JDFAttributeMap());
            VJDFAttributeMap oldParts = rl.getPartMapVector();
            if (oldParts != null) {
                oldParts.appendUnique(clone);
            } else {
                oldParts = clone;
            }
            rl.setPartMapVector(oldParts);
        }
    }

    private void handleIdentical(VJDFAttributeMap vParts, JDFResource res, JDFResourceLink rl) {
        if (vParts.size() > 1) {
            JDFAttributeMap targetMap = vParts.get(0);
            for (int i = 1; i < vParts.size(); ++i) {
                JDFAttributeMap partMap = vParts.get(i);
                JDFResource rPart = res.getCreatePartition(partMap, JDFPart.guessPartIDKeys(partMap));
                rPart.appendIdentical().setPartMap(targetMap);
            }
        }
    }

    VJDFAttributeMap getPartMaps(ResourceHelper rh) {
        Vector<JDFPart> parts = rh.getRoot().getChildrenByClass(JDFPart.class, false, 0);
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        for (JDFPart part : parts) {
            JDFAttributeMap partMap = this.getPartMap(part);
            vMap.add(partMap);
        }
        if (vMap.isEmpty()) {
            vMap.add(new JDFAttributeMap());
        }
        vMap.unify();
        return vMap;
    }

    protected String getJDFResName(SetHelper sh) {
        String name = sh.getName();
        return name;
    }

    private JDFResource getResourceRoot(JDFNode theNode, KElement xjdfRes) {
        JDFNode newRoot = theNode.getJDFRoot();
        ResourceHelper ph = new ResourceHelper(xjdfRes);
        SetHelper sh = ph.getSet();
        String name = this.getJDFResName(sh);
        String processUsage = sh.getProcessUsage();
        JDFResourceLink.EnumUsage inOut = this.getLinkUsage(theNode, sh, name, processUsage);
        String id = this.xjdfToJDFImpl.idMap.get(xjdfRes.getID()).getID();
        JDFResource res = (JDFResource)newRoot.getCreateResourcePool().getChildWithAttribute(null, "ID", null, id, 0, true);
        boolean isNew = false;
        if (res == null) {
            boolean combine = !StringUtil.equals(id, sh.getID());
            JDFResource jDFResource = res = combine ? theNode.getResource(name, inOut, processUsage, null, 0) : null;
            if (res == null) {
                isNew = true;
                res = theNode.addResource(name, null);
                res.setID(id);
            }
            if (theNode != newRoot) {
                newRoot.getCreateResourcePool().moveElement(res, null);
            }
        }
        if (inOut != null) {
            JDFResourceLink rl = theNode.getLink(res, inOut);
            if (rl == null) {
                rl = theNode.ensureLinkPU(res, inOut, processUsage);
                rl.copyAttribute("CombinedProcessIndex", sh.getRoot());
                rl.setrRef(id);
                res.removeAttribute("Usage");
                VString reslinks = XJDFToJDFConverter.getResLinkAttribs();
                for (String key : reslinks) {
                    if (!res.hasAttribute(key)) continue;
                    rl.moveAttribute(key, res);
                }
            }
            JDFResource.EnumResourceClass resClass = res.getResourceClass();
            if (isNew && JDFResourceLink.EnumUsage.Input.equals((Object)inOut) && (JDFResource.EnumResourceClass.Parameter.equals((Object)resClass) || JDFResource.EnumResourceClass.Consumable.equals((Object)resClass) || JDFResource.EnumResourceClass.Intent.equals((Object)resClass))) {
                res.setResStatus(JDFResource.EnumResStatus.Available, false);
            }
        }
        return res;
    }

    JDFResourceLink.EnumUsage getLinkUsage(JDFNode theNode, SetHelper sh, String name, String processUsage) {
        JDFResourceLink.EnumUsage inOut = sh.getUsage();
        if (!(inOut != null || !this.xjdfToJDFImpl.isHeuristicLink() || "Contact".equals(name) || "LayoutElement".equals(name) || "RunList".equals(name) || "Component".equals(name) || "ColorPool".equals(name) || "Media".equals(name) || "ExposedMedia".equals(name) || !theNode.isValidLink(name, JDFResourceLink.EnumUsage.Input, processUsage))) {
            inOut = JDFResourceLink.EnumUsage.Input;
        }
        return inOut;
    }

    private JDFResource getResInfoRoot(JDFResourceInfo parent, KElement xjdfRes) {
        ResourceHelper ph = new ResourceHelper(xjdfRes);
        SetHelper sh = ph.getSet();
        String name = this.getJDFResName(sh);
        String processUsage = sh.getProcessUsage();
        parent.setProcessUsage(processUsage);
        JDFResourceLink.EnumUsage inOut = sh.getUsage();
        parent.setUsage(inOut);
        parent.setResourceName(name);
        JDFResource res = parent.getCreateResource(name);
        VString reslinks = XJDFToJDFConverter.getResLinkAttribs();
        for (String key : reslinks) {
            if (!res.hasAttribute(key)) continue;
            parent.moveAttribute(key, res);
        }
        return res;
    }

    private JDFAttributeMap getResMap(KElement xjdfRes) {
        JDFAttributeMap map = xjdfRes.getAttributeMap();
        map.remove("ID");
        map.remove("PartIDKeys");
        return map;
    }

    private void handleAmountPool(KElement xjdfRes, JDFAttributeMap partmap, JDFAttributeMap map, JDFResourceLink rl) {
        KElement ap = xjdfRes.getElement("AmountPool");
        if (ap != null) {
            JDFAmountPool newAmountPool = rl.getCreateAmountPool();
            Vector<JDFPartAmount> vpa = ap.getChildrenByClass(JDFPartAmount.class, false, 0);
            for (JDFPartAmount pa : vpa) {
                this.xjdfToJDFImpl.walkTree(pa, newAmountPool);
            }
            ap.deleteNode();
        }
        this.xjdfToJDFImpl.moveAmountsToLink(partmap, map, rl);
    }

    private JDFResourceLink ensureLink(JDFNode partialProductNode, JDFResource newPartition, JDFResourceLink rl) {
        if (partialProductNode != null) {
            JDFResourceLink.EnumUsage newUsage;
            JDFResourceLink rlpart = partialProductNode.getLink(newPartition, null);
            JDFResourceLink.EnumUsage enumUsage = newUsage = rl == null ? null : rl.getUsage();
            if (rlpart == null && newUsage != null) {
                rlpart = partialProductNode.ensureLink(newPartition, newUsage, null);
            }
            if (rlpart != null) {
                rl = rlpart;
            }
        }
        return rl;
    }

    protected KElement createPartition(JDFResource jdfRes, JDFAttributeMap partMap, JDFNode theNode) {
        if (partMap == null || partMap.isEmpty()) {
            return jdfRes;
        }
        JDFAttributeMap reduced = this.removeImplicitParts(jdfRes, partMap);
        return jdfRes.getCreatePartition(reduced, JDFPart.guessPartIDKeys(reduced));
    }

    protected JDFAttributeMap removeImplicitParts(JDFResource jdfRes, JDFAttributeMap partMap) {
        Vector<JDFResource.EnumPartIDKey> implicitPartitions = jdfRes.getImplicitPartitions();
        if (implicitPartitions != null) {
            JDFAttributeMap ret = partMap.clone();
            for (JDFResource.EnumPartIDKey key : implicitPartitions) {
                ret.remove(key.getName());
            }
            return ret;
        }
        return partMap;
    }

    JDFAttributeMap getPartMap(JDFPart part) {
        JDFAttributeMap p = part == null ? new JDFAttributeMap() : part.getAttributeMap();
        p.renameKey("BinderySignatureID", "BinderySignatureName");
        String sheetName = p.getNonEmpty("SheetName");
        String signatureName = p.getNonEmpty("SignatureName");
        if (sheetName != null && signatureName == null) {
            signatureName = "Sig_" + sheetName;
            p.put("SignatureName", signatureName);
            part.setSignatureName(signatureName);
        }
        p.renameKey("Metadata", "Metadata0");
        VString keys = p.getKeys();
        for (String key : keys) {
            VString v;
            String val;
            if (JDFResource.EnumPartIDKey.getEnum(key) == null) {
                p.remove(key);
                continue;
            }
            if (!key.endsWith("Index") || (val = p.getNonEmpty(key)) == null || (v = new VString(val, null)).size() % 2 != 0) continue;
            JDFNameRangeList nrl = new JDFNameRangeList();
            for (int i = 0; i < v.size(); i += 2) {
                nrl.append(new JDFNameRange(v.get(i), v.get(i + 1)));
            }
            String newVal = nrl.getString(0);
            p.put(key, newVal);
        }
        p.remove("ProductPart");
        p.remove("DropID");
        p.remove("ContactType");
        return p;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && ResourceHelper.isAsset(toCheck);
    }
}

