/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.pool;

import java.util.Set;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAmountPool;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.IAmountPoolContainer;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.VectorMap;

public class JDFAmountPool
extends JDFAutoAmountPool {
    private static final long serialVersionUID = 1L;

    public void setPartAttribute(String attrib, String value, String nameSpaceURI, VJDFAttributeMap vPart) {
        JDFPartAmount pa0 = this.getCreatePartAmount(vPart);
        pa0.setAttribute(attrib, value, nameSpaceURI);
    }

    public String getPartAttribute(String attrib, String nameSpaceURI, JDFAttributeMap part) {
        JDFPartAmount pa0 = part == null ? this.getPartAmount(part) : this.getMatchingPartAmount(part);
        return pa0 == null ? null : pa0.getAttribute(attrib, nameSpaceURI, null);
    }

    public String getPartAttribute(String attrib, String nameSpaceURI, VJDFAttributeMap vPart) {
        JDFPartAmount pa0 = this.getPartAmount(vPart);
        return pa0 == null ? null : pa0.getAttribute(attrib, nameSpaceURI, null);
    }

    public void setPartAttribute(String attrib, String value, String nameSpaceURI, JDFAttributeMap part) {
        JDFPartAmount pa0 = this.getCreatePartAmount(part);
        pa0.setAttribute(attrib, value, nameSpaceURI);
    }

    public JDFAmountPool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAmountPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAmountPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public void removePartAmount(JDFAttributeMap mPart) {
        JDFPartAmount partAmount = this.getPartAmount(mPart);
        if (partAmount != null) {
            partAmount.deleteNode();
        }
    }

    @Override
    public String toString() {
        return "JDFAmountPool[ -->" + super.toString() + "]";
    }

    public JDFPartAmount getMatchingPartAmount(JDFAttributeMap mPart) {
        if (mPart != null && mPart.size() == 0) {
            mPart = null;
        }
        Vector<JDFPartAmount> vPartAmount = this.getChildrenByClass(JDFPartAmount.class, true, 0);
        for (JDFPartAmount partAmount : vPartAmount) {
            VJDFAttributeMap vMapPart = partAmount.getPartMapVector();
            if ((vMapPart != null || mPart != null) && (mPart == null || !vMapPart.contains(mPart))) continue;
            return partAmount;
        }
        return null;
    }

    public JDFPartAmount getPartAmount(JDFAttributeMap mPart) {
        if (mPart != null && mPart.size() == 0) {
            mPart = null;
        }
        Vector<JDFPartAmount> vPartAmount = this.getChildrenByClass(JDFPartAmount.class, true, 0);
        for (JDFPartAmount partAmount : vPartAmount) {
            VJDFAttributeMap vMapPart;
            VJDFAttributeMap vJDFAttributeMap = vMapPart = partAmount == null ? null : partAmount.getPartMapVector();
            if (vMapPart != null) {
                for (int i = vMapPart.size() - 1; i >= 0; --i) {
                    if (vMapPart.get(i) != null && !vMapPart.get(i).isEmpty()) continue;
                    vMapPart.remove(i);
                }
            }
            if (vMapPart != null && vMapPart.isEmpty()) {
                vMapPart = null;
            }
            if ((vMapPart == null || vMapPart.size() != 1 || !vMapPart.elementAt(0).equals(mPart)) && (vMapPart != null || mPart != null)) continue;
            return partAmount;
        }
        return null;
    }

    public JDFPartAmount getPartAmount(VJDFAttributeMap vPart) {
        if (vPart != null && vPart.size() == 1 && vPart.get(0).isEmpty()) {
            vPart = null;
        } else if (vPart != null && vPart.isEmpty()) {
            vPart = null;
        }
        Vector<JDFPartAmount> vPartAmount = this.getChildrenByClass(JDFPartAmount.class, true, 0);
        for (JDFPartAmount partAmount : vPartAmount) {
            VJDFAttributeMap vMapPart = partAmount.getPartMapVector();
            if (!ContainerUtil.equals(vMapPart, vPart)) continue;
            return partAmount;
        }
        return null;
    }

    public JDFPartAmount getPartAmount(JDFAttributeMap mPart, int iSkip) {
        int n = 0;
        if (mPart != null && mPart.size() == 0) {
            mPart = null;
        }
        Vector<JDFPartAmount> vPartAmount = this.getChildrenByClass(JDFPartAmount.class, true, 0);
        for (JDFPartAmount partAmount : vPartAmount) {
            VJDFAttributeMap vMapPart = partAmount.getPartMapVector();
            if (vMapPart == null || !vMapPart.subMap(mPart) || ++n <= iSkip) continue;
            return partAmount;
        }
        return null;
    }

    @Deprecated
    public JDFPartAmount getPartAmount(JDFAttributeMap mPart, boolean bCreate) {
        JDFPartAmount p = this.getPartAmount(mPart, 0);
        if (bCreate && p == null) {
            p = (JDFPartAmount)this.appendElement("PartAmount", "");
            p.setPartMap(mPart);
        }
        return p;
    }

    @Deprecated
    public VElement getPartAmountVector(VJDFAttributeMap vmPart, boolean bCreate) {
        VElement vPartAmount = new VElement();
        for (int i = 0; i < vmPart.size(); ++i) {
            JDFPartAmount ps = this.getPartAmount(vmPart.elementAt(i), bCreate);
            if (ps == null) continue;
            vPartAmount.addElement(ps);
        }
        return vPartAmount;
    }

    public void reducePartAmounts(VJDFAttributeMap keepList) {
        if (keepList == null) {
            return;
        }
        VElement v = this.getChildElementVector("PartAmount", null, null, true, -1, true);
        for (int i = 0; i < v.size(); ++i) {
            JDFPartAmount pa = (JDFPartAmount)v.elementAt(i);
            JDFAttributeMap map = pa.getPartMap();
            if (map == null) {
                map = new JDFAttributeMap();
            }
            boolean ciao = true;
            for (int j = 0; j < keepList.size(); ++j) {
                if (!map.subMap(keepList.elementAt(j))) continue;
                ciao = false;
                break;
            }
            if (!ciao) continue;
            pa.deleteNode();
        }
    }

    public AmountMap getAmountMap(VString vPartIDKeys) {
        return new AmountMap(vPartIDKeys);
    }

    public JDFPartAmount appendPartAmount(JDFAttributeMap mPart) {
        JDFPartAmount p = super.appendPartAmount();
        p.setPartMap(mPart);
        return p;
    }

    public JDFPartAmount appendPartAmount(VJDFAttributeMap vPart) {
        JDFPartAmount p = super.appendPartAmount();
        p.setPartMapVector(vPart);
        return p;
    }

    public JDFPartAmount getCreatePartAmount(JDFAttributeMap mPart) {
        JDFPartAmount p = this.getPartAmount(mPart);
        if (p == null) {
            p = (JDFPartAmount)this.appendElement("PartAmount", null);
            p.setPartMap(mPart);
        }
        return p;
    }

    public JDFPartAmount getCreatePartAmount(VJDFAttributeMap vPart) {
        JDFPartAmount p = this.getPartAmount(vPart);
        if (p == null) {
            p = (JDFPartAmount)this.appendElement("PartAmount", null);
            p.setPartMapVector(vPart);
        }
        return p;
    }

    public VElement getMatchingPartAmountVector(JDFAttributeMap mPart) {
        Vector<JDFPartAmount> vPartAmount = this.getChildrenByClass(JDFPartAmount.class, true, 0);
        int size = vPartAmount.size();
        if (size == 0) {
            return null;
        }
        VElement vPA = new VElement();
        block0: for (int i = 0; i < size; ++i) {
            JDFPartAmount ps = vPartAmount.elementAt(i);
            VJDFAttributeMap mm = ps.getPartMapVector();
            if (mm == null) continue;
            int mmSize = mm.size();
            for (int j = 0; j < mmSize; ++j) {
                JDFAttributeMap m = mm.elementAt(j);
                if (!m.subMap(mPart)) continue;
                vPA.add(ps);
                continue block0;
            }
        }
        return vPA.size() == 0 ? null : vPA;
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        VElement vPartAmount = this.getChildElementVector("PartAmount", null, null, true, 0, false);
        VJDFAttributeMap ret = new VJDFAttributeMap();
        if (vPartAmount != null) {
            for (KElement e : vPartAmount) {
                JDFPartAmount pa = (JDFPartAmount)e;
                VJDFAttributeMap vamParts = pa.getPartMapVector();
                if (vamParts == null || vamParts.isEmpty()) continue;
                ret.addAll(vamParts);
            }
        }
        ret.unify();
        return ret;
    }

    public static class AmountPoolHelper {
        public static String getAmountPoolAttribute(IAmountPoolContainer poolParent, String attrib, String nameSpaceURI, JDFAttributeMap mPart, int iSkip) {
            if (poolParent instanceof JDFPartAmount) {
                if (mPart != null || iSkip > 1) {
                    throw new JDFException("JDFResourceLink.getAmountPoolAttribute: calling method on PartAmount object");
                }
                return iSkip == 0 ? poolParent.getAttribute(attrib, nameSpaceURI, null) : null;
            }
            JDFAmountPool amountPool = poolParent.getAmountPool();
            if (amountPool == null) {
                return iSkip > 0 ? null : poolParent.getAttribute(attrib, nameSpaceURI, null);
            }
            JDFPartAmount pa = amountPool.getPartAmount(mPart, iSkip);
            String ret = null;
            if (pa != null && (ret = pa.getAttribute(attrib, nameSpaceURI, null)) == null) {
                ret = poolParent.getAttribute(attrib, nameSpaceURI, null);
            }
            return ret;
        }

        public static String getAmountPoolAttribute(IAmountPoolContainer poolParent, String attrib, String nameSpaceURI, VJDFAttributeMap vPart) {
            String ret;
            if (poolParent instanceof JDFPartAmount) {
                if (vPart != null) {
                    throw new JDFException("JDFResourceLink.getAmountPoolAttribute: calling method on PartAmount object");
                }
                return poolParent.getAttribute(attrib, nameSpaceURI, null);
            }
            JDFAmountPool amountPool = poolParent.getAmountPool();
            if (amountPool == null || vPart == null) {
                return poolParent.getAttribute(attrib, nameSpaceURI, null);
            }
            JDFPartAmount pa = amountPool.getPartAmount(vPart);
            if (pa != null && (ret = pa.getAttribute(attrib, nameSpaceURI, null)) != null) {
                return ret;
            }
            return poolParent.getAttribute(attrib, nameSpaceURI, null);
        }

        public static double getAmountPoolMinDouble(IAmountPoolContainer poolParent, String attName, JDFAttributeMap mPart) {
            double d = 0.0;
            int n = 0;
            boolean bFound = false;
            JDFAmountPool ap = poolParent.getAmountPool();
            while (true) {
                String w;
                if (KElement.isWildCard(w = AmountPoolHelper.getAmountPoolAttribute(poolParent, attName, null, mPart, n))) {
                    if (ap == null || ap.getPartAmount(mPart, n) == null) {
                        return bFound ? d : -1.0;
                    }
                    ++n;
                    continue;
                }
                double dd = StringUtil.parseDouble(w, -1.234567);
                if (dd == -1.234567) {
                    throw new JDFException("JDFResourceLink.getAmountPoolDouble: Attribute " + attName + " has an invalid value");
                }
                if (!bFound || dd < d) {
                    d = dd;
                    bFound = true;
                }
                ++n;
            }
        }

        public static double getAmountPoolDouble(IAmountPoolContainer poolParent, String attName, JDFAttributeMap mPart) {
            double d = 0.0;
            int n = 0;
            boolean bFound = false;
            JDFAmountPool ap = poolParent.getAmountPool();
            while (true) {
                String w;
                if (KElement.isWildCard(w = AmountPoolHelper.getAmountPoolAttribute(poolParent, attName, null, mPart, n))) {
                    if (ap == null || ap.getPartAmount(mPart, n) == null) {
                        return bFound ? d : -1.0;
                    }
                    ++n;
                    continue;
                }
                double dd = StringUtil.parseDouble(w, -1.234567);
                if (dd == -1.234567) {
                    throw new JDFException("JDFResourceLink.getAmountPoolDouble: Attribute " + attName + " has an invalid value");
                }
                d += dd;
                bFound = true;
                ++n;
            }
        }

        public static double getAmountPoolDouble(IAmountPoolContainer poolParent, String attName, VJDFAttributeMap vPart) {
            double d = 0.0;
            String w = AmountPoolHelper.getAmountPoolAttribute(poolParent, attName, null, vPart);
            if (w == null) {
                return -1.0;
            }
            d = StringUtil.parseDouble(w, -1.234567);
            if (d == -1.234567) {
                throw new JDFException("JDFResourceLink.getAmountPoolDouble: Attribute " + attName + " has an invalid value");
            }
            return d;
        }

        public static double getAmountPoolSumDouble(IAmountPoolContainer poolParent, String attName, VJDFAttributeMap vPart) {
            boolean isWaste;
            if (vPart == null) {
                vPart = poolParent.getPartMapVector();
            }
            VJDFAttributeMap vm = vPart == null ? null : new VJDFAttributeMap(vPart);
            JDFResource linkRoot = poolParent.getLinkRoot();
            if (linkRoot != null && vm != null) {
                Set<String> set = linkRoot.getPartIDKeys().getSet();
                set.add("Condition");
                vm.reduceMap(set);
            }
            if (vm == null) {
                vm = new VJDFAttributeMap();
                vm.add(null);
            }
            double dd = 0.0;
            JDFAmountPool ap = poolParent.getAmountPool();
            VElement vParts = ap == null ? new VElement() : ap.getChildElementVector("PartAmount", null);
            boolean bl = isWaste = vPart != null && vPart.subMap(new JDFAttributeMap("Condition", "Waste"));
            if (!(isWaste || vPart != null && vPart.subMap(new JDFAttributeMap("Condition", "*")))) {
                vPart = new VJDFAttributeMap(vPart);
                vPart.add(new JDFAttributeMap("Condition", "Good"));
            }
            boolean gotOne = false;
            for (int j = 0; j < vParts.size(); ++j) {
                JDFPartAmount pa = (JDFPartAmount)vParts.elementAt(j);
                VJDFAttributeMap partMapVector = pa.getPartMapVector();
                if (isWaste) {
                    boolean hasCondition;
                    boolean bl2 = hasCondition = partMapVector != null && partMapVector.subMap(new JDFAttributeMap("Condition", "*"));
                    if (!hasCondition) continue;
                }
                if (partMapVector != null && !partMapVector.overlapsMap(vm)) continue;
                String ret = null;
                ret = pa.getAttribute(attName, null, null);
                if (ret == null) {
                    ret = poolParent.getAttribute(attName, null, null);
                }
                dd += StringUtil.parseDouble(ret, 0.0);
                gotOne = true;
            }
            if (!gotOne && !isWaste) {
                dd = poolParent.getRealAttribute(attName, null, 0.0);
            }
            return dd;
        }

        public static AmountMap getAmountMap(IAmountPoolContainer poolParent, VString vPartIDKeys) {
            if (poolParent == null || poolParent.getAmountPool() == null) {
                return null;
            }
            return poolParent.getAmountPool().getAmountMap(vPartIDKeys);
        }

        public static double getAmount(IAmountPoolContainer poolParent, JDFAttributeMap mPart) {
            double d = AmountPoolHelper.getAmountPoolDouble(poolParent, "Amount", mPart);
            if (d == -1.0) {
                JDFResource target = poolParent.getLinkRoot();
                if (target != null && (target = target.getPartition(mPart, null)) != null) {
                    return target.getAmount();
                }
            } else {
                return d;
            }
            return -1.0;
        }

        public static double getMinAmount(IAmountPoolContainer poolParent, JDFAttributeMap mPart) {
            double d = AmountPoolHelper.getAmountPoolDouble(poolParent, "MinAmount", mPart);
            if (d == -1.0) {
                return AmountPoolHelper.getAmount(poolParent, mPart);
            }
            return d;
        }

        public static double getMaxAmount(IAmountPoolContainer poolParent, JDFAttributeMap mPart) {
            double d = AmountPoolHelper.getAmountPoolDouble(poolParent, "MaxAmount", mPart);
            if (d == -1.0) {
                return AmountPoolHelper.getAmount(poolParent, mPart);
            }
            return d;
        }

        public static void setAmountPoolAttribute(IAmountPoolContainer poolParent, String attrib, String value, String nameSpaceURI, VJDFAttributeMap vPart) {
            if (vPart == null || vPart.isEmpty() || vPart.size() == 1 && vPart.elementAt(0).size() == 0) {
                poolParent.setAttribute(attrib, value, nameSpaceURI);
                return;
            }
            poolParent.removeAttribute(attrib, nameSpaceURI);
            JDFAmountPool ap = poolParent.getCreateAmountPool();
            ap.setPartAttribute(attrib, value, nameSpaceURI, vPart);
        }

        public static void setAmountPoolAttribute(IAmountPoolContainer poolParent, String attrib, String value, String nameSpaceURI, JDFAttributeMap mPart) {
            if (mPart == null || mPart.isEmpty()) {
                poolParent.setAttribute(attrib, value, nameSpaceURI);
                return;
            }
            if (poolParent instanceof JDFPartAmount) {
                throw new JDFException("JDFResourceLink.setAmountPoolAttribute: calling method on PartAmount object");
            }
            VJDFAttributeMap v = new VJDFAttributeMap(mPart);
            AmountPoolHelper.setAmountPoolAttribute(poolParent, attrib, value, nameSpaceURI, v);
        }
    }

    public class AmountMap
    extends VectorMap<JDFAttributeMap, JDFPartAmount> {
        private final VString m_vsUsedPartIDKeys = new VString();
        private static final long serialVersionUID = 6548151023982113766L;

        AmountMap(VString vsPartIDKeys) {
            VElement vPartAmount = JDFAmountPool.this.getChildElementVector("PartAmount", null, null, true, 0, false);
            if (vPartAmount != null) {
                for (KElement e : vPartAmount) {
                    JDFPartAmount pa = (JDFPartAmount)e;
                    VJDFAttributeMap vamParts = pa.getPartMapVector();
                    int size2 = vamParts == null ? 1 : vamParts.size();
                    for (int p = 0; p < size2; ++p) {
                        JDFAttributeMap amPart = vamParts == null ? new JDFAttributeMap() : vamParts.elementAt(p);
                        amPart.reduceMap(vsPartIDKeys);
                        this.m_vsUsedPartIDKeys.appendUnique(amPart.getKeys());
                        this.putOne(amPart, pa);
                    }
                }
            }
        }

        public double getAmountDouble(JDFAttributeMap amParts, String strAttributeName) {
            double dValue = -1.0;
            JDFAttributeMap amUsedParts = new JDFAttributeMap(amParts);
            amUsedParts.reduceMap(this.m_vsUsedPartIDKeys);
            Vector lpa = (Vector)this.get(amUsedParts);
            if (lpa != null) {
                double dTmp = 0.0;
                boolean isFound = false;
                for (JDFPartAmount pa : lpa) {
                    double dAdd;
                    String strValue = pa.getAttribute(strAttributeName, null, null);
                    if (strValue == null || !((dAdd = StringUtil.parseDouble(strValue, -1.0)) >= 0.0)) continue;
                    dTmp += dAdd;
                    isFound = true;
                }
                if (isFound) {
                    dValue = dTmp;
                }
            }
            return dValue;
        }
    }
}

