/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.util.HashMap;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class RollingBackupFile
extends File {
    private final int nBackup;
    boolean wantExtension;
    private static final long serialVersionUID = 1521423479897L;

    public void setWantExtension(boolean wantExtension) {
        this.wantExtension = wantExtension;
    }

    public RollingBackupFile(String pathname, int nBackupp) {
        super(pathname);
        this.nBackup = nBackupp;
        this.wantExtension = false;
    }

    public RollingBackupFile(File file, int nBackupp) {
        this(file.getPath(), nBackupp);
    }

    public File getNewFile() {
        String extension = this.getExtension(this);
        return this.getNewFile(extension);
    }

    public File getNewFile(String extension) {
        return this.init(extension);
    }

    public File getOldFile(int i) {
        if (i == 0) {
            return this;
        }
        if (i < 0 || i >= this.nBackup) {
            return null;
        }
        File[] oldFiles = FileUtil.listFilesWithExpression(this.getParentFile(), UrlUtil.newExtension(this.getName(), null) + "." + i + ".*");
        if (oldFiles == null || oldFiles.length == 0) {
            return null;
        }
        return oldFiles[0];
    }

    private String getExtension(File f) {
        VString v = StringUtil.tokenize(f.getName(), ".", false);
        v.remove(0);
        if (v.size() == 0) {
            return null;
        }
        if (StringUtil.isInteger(v.get(0))) {
            v.remove(0);
        }
        return StringUtil.setvString(v, ".", null, null);
    }

    public void clearAll() {
        File[] oldFiles = FileUtil.listFilesWithExpression(this.getParentFile(), UrlUtil.newExtension(this.getName(), null) + "*");
        if (oldFiles != null) {
            for (File lastFile : oldFiles) {
                lastFile.delete();
            }
        }
    }

    private synchronized File init(String extension) {
        String pathname = this.getPath();
        pathname = UrlUtil.newExtension(pathname, extension);
        HashMap<Integer, File> map = this.getNameMap();
        if (!map.isEmpty()) {
            for (int i = this.nBackup; i > 0; --i) {
                File newFile = map.get(i - 1);
                if (newFile == null) continue;
                File oldFile = map.get(i);
                if (oldFile != null && oldFile.exists()) {
                    oldFile.delete();
                }
                File newFileRenamed = new File(this.getPathFor(newFile.getAbsolutePath(), i));
                newFile.renameTo(newFileRenamed);
            }
        }
        return new File(pathname);
    }

    private HashMap<Integer, File> getNameMap() {
        String myExt = FileUtil.getExtension(this);
        String expression = UrlUtil.newExtension(this.getName(), null) + "*";
        if (this.wantExtension && StringUtil.getNonEmpty(myExt) != null) {
            expression = expression + "." + myExt;
        }
        File[] oldFiles = FileUtil.listFilesWithExpression(this.getParentFile(), expression);
        HashMap<Integer, File> map = new HashMap<Integer, File>();
        if (oldFiles != null) {
            for (File file : oldFiles) {
                String name = file.getName();
                String ext = this.getExtension(file);
                int nDot = StringUtil.numSubstrings(ext, ".");
                if (ext == null) continue;
                String delta = StringUtil.token(name, -2 - nDot, ".");
                int i = StringUtil.parseInt(delta, -1);
                if (i >= 0) {
                    map.put(i, file);
                    continue;
                }
                if (delta == null || !delta.equals(UrlUtil.prefix(this.getName()))) continue;
                map.put(0, file);
            }
        }
        return map;
    }

    private String getPathFor(String pathname, int i) {
        String base = i == 0 ? "" : "." + i;
        String oldbase = i <= 1 ? "" : "." + (i - 1);
        String extension = this.getExtension(new File(pathname));
        String oldExtension = oldbase + (extension == null ? "" : "." + extension);
        String newExtension = base + (extension == null ? "" : "." + extension);
        return StringUtil.replaceString(pathname, oldExtension, newExtension);
    }
}

