/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.zip.ZipReader;

public class URLReader {
    private final String urlString;
    private BodyPart bodypart;
    private ZipReader zip;
    private final Vector<File> localRoots;
    private final Log log;
    private File notRelative;

    public URLReader(String urlString) {
        this.urlString = urlString;
        this.localRoots = new Vector();
        this.log = LogFactory.getLog(this.getClass());
        this.notRelative = null;
    }

    public URLReader(String urlString, XMLDoc doc) {
        this(urlString);
        File f;
        File parent;
        this.bodypart = doc.getBodyPart();
        this.zip = doc.getZipReader();
        String orig = doc.getOriginalFileName();
        if (orig != null && (parent = (f = new File(orig)).getParentFile()) != null) {
            this.addLocalRoot(parent);
        }
    }

    public void setBodyPart(BodyPart bodyPart) {
        this.bodypart = bodyPart;
    }

    public void addLocalRoot(File root) {
        if (root == null) {
            this.log.error((Object)"cannot add null root");
        } else {
            this.localRoots.add(root);
            ContainerUtil.unify(this.localRoots);
        }
    }

    public void setZipReader(ZipReader zip) {
        this.zip = zip;
    }

    InputStream getBodyPartInputStream() {
        InputStream retStream = null;
        if (this.bodypart != null) {
            Multipart multipart = this.bodypart.getParent();
            retStream = UrlUtil.getCidURLStream(this.urlString, multipart);
        }
        return retStream;
    }

    InputStream getZipInputStream() {
        InputStream retStream = null;
        if (this.zip != null) {
            ZipEntry e = this.zip.getEntry(this.urlString);
            retStream = e == null ? null : this.zip.getInputStream();
        }
        return retStream;
    }

    public InputStream getURLInputStream() {
        File file;
        InputStream retStream = this.getNetInputStream();
        if (retStream == null && (retStream = this.getBodyPartInputStream()) == null && (retStream = this.getZipInputStream()) == null && (file = this.getFile()) != null) {
            retStream = FileUtil.getBufferedInputStream(file);
        }
        return retStream;
    }

    public File getFile() {
        File file = this.getAbsoluteFile();
        if (file == null) {
            file = this.getRelativeFile();
        }
        return file;
    }

    public XMLDoc getXMLDoc() {
        InputStream retStream = this.getURLInputStream();
        XMLDoc doc = XMLDoc.parseStream(retStream);
        this.applyDoc(doc);
        return doc;
    }

    public JDFDoc getJDFDoc() {
        InputStream retStream = this.getURLInputStream();
        JDFDoc doc = JDFDoc.parseStream(retStream);
        this.applyDoc(doc);
        return doc;
    }

    private void applyDoc(XMLDoc doc) {
        if (doc != null) {
            doc.setBodyPart(this.bodypart);
            doc.setZipReader(this.zip);
            String url = this.notRelative == null ? this.urlString : this.notRelative.getAbsolutePath();
            File f = UrlUtil.urlToFile(url);
            String filename = f == null ? null : f.getAbsolutePath();
            doc.setOriginalFileName(filename);
        }
    }

    InputStream getNetInputStream() {
        if (UrlUtil.isNet(this.urlString)) {
            UrlPart part = UrlUtil.writeToURL(this.urlString, null, "GET", null, null);
            return part == null || part.getResponseCode() != 200 ? null : part.getResponseStream();
        }
        return null;
    }

    File getAbsoluteFile() {
        File f;
        File file = f = !UrlUtil.isNet(this.urlString) && !UrlUtil.isCID(this.urlString) ? UrlUtil.urlToFile(this.urlString) : null;
        if (f != null && f.canRead()) {
            return f;
        }
        return null;
    }

    File getRelativeFile() {
        if (UrlUtil.isRelativeURL(this.urlString)) {
            File fLocal = UrlUtil.urlToFile(this.urlString);
            for (File root : this.localRoots) {
                File f = FileUtil.getFileInDirectory(root, fLocal);
                if (f == null || !f.canRead()) continue;
                this.notRelative = f;
                return this.notRelative;
            }
        }
        return null;
    }

    public String toString() {
        return "URLReader: " + this.urlString + "\n" + this.localRoots + (this.zip != null ? " zip " : "") + (this.bodypart != null ? " mime " : "");
    }
}

