/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class FileSorter {
    private final File[] list;

    public FileSorter(File dir) {
        this(dir == null ? null : dir.listFiles());
    }

    public FileSorter(File[] list) {
        this.list = list;
    }

    public File[] sortLastModified(boolean bNewFirst) {
        if (this.list != null) {
            Arrays.sort(this.list, new LastModifiedComparator(bNewFirst));
        }
        return this.list;
    }

    public int size() {
        return this.list == null ? 0 : this.list.length;
    }

    protected class LastModifiedComparator
    implements Comparator<File> {
        private final int iNewFirst;

        public LastModifiedComparator(boolean newFirst) {
            this.iNewFirst = newFirst ? 1 : -1;
        }

        @Override
        public int compare(File o1, File o2) {
            int n = o1.lastModified() > o2.lastModified() ? -1 : (o1.lastModified() < o2.lastModified() ? 1 : 0);
            return n * this.iNewFirst;
        }
    }
}

