/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFShapeElement;

public abstract class JDFAutoShapeElement
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[10];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoShapeElement(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoShapeElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoShapeElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoShapeElement[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Parameter;
    }

    public void setLockOrigins(boolean value) {
        this.setAttribute("LockOrigins", value, null);
    }

    public boolean getLockOrigins() {
        return this.getBoolAttribute("LockOrigins", null, false);
    }

    public void setCutBox(JDFRectangle value) {
        this.setAttribute("CutBox", value, null);
    }

    public JDFRectangle getCutBox() {
        String strAttrName = this.getAttribute("CutBox", null, null);
        JDFRectangle nPlaceHolder = JDFRectangle.createRectangle(strAttrName);
        return nPlaceHolder;
    }

    public void setCutOut(boolean value) {
        this.setAttribute("CutOut", value, null);
    }

    public boolean getCutOut() {
        return this.getBoolAttribute("CutOut", null, false);
    }

    public void setCutPath(String value) {
        this.setAttribute("CutPath", value, null);
    }

    public String getCutPath() {
        return this.getAttribute("CutPath", null, "");
    }

    public void setCutType(EnumCutType enumVar) {
        this.setAttribute("CutType", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumCutType getCutType() {
        return EnumCutType.getEnum(this.getAttribute("CutType", null, "Cut"));
    }

    public void setDDESCutType(int value) {
        this.setAttribute("DDESCutType", value, (String)null);
    }

    public int getDDESCutType() {
        return this.getIntAttribute("DDESCutType", null, 101);
    }

    public void setMaterial(String value) {
        this.setAttribute("Material", value, null);
    }

    public String getMaterial() {
        return this.getAttribute("Material", null, "");
    }

    public void setShapeDepth(double value) {
        this.setAttribute("ShapeDepth", value, null);
    }

    public double getShapeDepth() {
        return this.getRealAttribute("ShapeDepth", null, 0.0);
    }

    public void setShapeType(EnumShapeType enumVar) {
        this.setAttribute("ShapeType", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumShapeType getShapeType() {
        return EnumShapeType.getEnum(this.getAttribute("ShapeType", null, null));
    }

    public void setTeethPerDimension(double value) {
        this.setAttribute("TeethPerDimension", value, null);
    }

    public double getTeethPerDimension() {
        return this.getRealAttribute("TeethPerDimension", null, 0.0);
    }

    public JDFShapeElement getCreateShape(int iSkip) {
        return (JDFShapeElement)this.getCreateElement_KElement("Shape", null, iSkip);
    }

    public JDFShapeElement getShape(int iSkip) {
        return (JDFShapeElement)this.getElement("Shape", null, iSkip);
    }

    public Collection<JDFShapeElement> getAllShape() {
        VElement vc = this.getChildElementVector("Shape", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFShapeElement> v = new Vector<JDFShapeElement>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFShapeElement)vc.get(i));
        }
        return v;
    }

    public JDFShapeElement appendShape() {
        return (JDFShapeElement)this.appendElement("Shape", null);
    }

    static {
        JDFAutoShapeElement.atrInfoTable[0] = new AtrInfoTable("LockOrigins", 0x33333333L, AttributeInfo.EnumAttributeType.boolean_, null, "false");
        JDFAutoShapeElement.atrInfoTable[1] = new AtrInfoTable("CutBox", 0x33333333L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFAutoShapeElement.atrInfoTable[2] = new AtrInfoTable("CutOut", 0x33333333L, AttributeInfo.EnumAttributeType.boolean_, null, "false");
        JDFAutoShapeElement.atrInfoTable[3] = new AtrInfoTable("CutPath", 0x33333333L, AttributeInfo.EnumAttributeType.PDFPath, null, null);
        JDFAutoShapeElement.atrInfoTable[4] = new AtrInfoTable("CutType", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumCutType.getEnum(0), "Cut");
        JDFAutoShapeElement.atrInfoTable[5] = new AtrInfoTable("DDESCutType", 0x33333333L, AttributeInfo.EnumAttributeType.integer, null, "101");
        JDFAutoShapeElement.atrInfoTable[6] = new AtrInfoTable("Material", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoShapeElement.atrInfoTable[7] = new AtrInfoTable("ShapeDepth", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoShapeElement.atrInfoTable[8] = new AtrInfoTable("ShapeType", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, EnumShapeType.getEnum(0), null);
        JDFAutoShapeElement.atrInfoTable[9] = new AtrInfoTable("TeethPerDimension", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFAutoShapeElement.elemInfoTable[0] = new ElemInfoTable("Shape", 0x33333333L);
    }

    public static class EnumShapeType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumShapeType Rectangular = new EnumShapeType("Rectangular");
        public static final EnumShapeType Round = new EnumShapeType("Round");
        public static final EnumShapeType Path = new EnumShapeType("Path");
        public static final EnumShapeType RoundedRectangle = new EnumShapeType("RoundedRectangle");

        private EnumShapeType(String name) {
            super(name, m_startValue++);
        }

        public static EnumShapeType getEnum(String enumName) {
            return (EnumShapeType)EnumShapeType.getEnum(EnumShapeType.class, (String)enumName);
        }

        public static EnumShapeType getEnum(int enumValue) {
            return (EnumShapeType)EnumShapeType.getEnum(EnumShapeType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumShapeType.getEnumMap(EnumShapeType.class);
        }

        public static List getEnumList() {
            return EnumShapeType.getEnumList(EnumShapeType.class);
        }

        public static Iterator iterator() {
            return EnumShapeType.iterator(EnumShapeType.class);
        }
    }

    public static class EnumCutType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumCutType Cut = new EnumCutType("Cut");
        public static final EnumCutType Perforate = new EnumCutType("Perforate");

        private EnumCutType(String name) {
            super(name, m_startValue++);
        }

        public static EnumCutType getEnum(String enumName) {
            return (EnumCutType)EnumCutType.getEnum(EnumCutType.class, (String)enumName);
        }

        public static EnumCutType getEnum(int enumValue) {
            return (EnumCutType)EnumCutType.getEnum(EnumCutType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumCutType.getEnumMap(EnumCutType.class);
        }

        public static List getEnumList() {
            return EnumCutType.getEnumList(EnumCutType.class);
        }

        public static Iterator iterator() {
            return EnumCutType.iterator(EnumCutType.class);
        }
    }
}

