/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ParentNode;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDocUserData;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.thread.MyMutex;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentJDFImpl
extends DocumentXMLImpl {
    private static final String CORE_KELEMENT = "org.cip4.jdflib.core.KElement";
    private static final String CORE_JDFELEMENT = "org.cip4.jdflib.core.JDFElement";
    private static final String CORE_JDFRESOURCE = "org.cip4.jdflib.resource.JDFResource";
    private static DocumentData data = new DocumentData();
    private static final long serialVersionUID = 1L;
    private static boolean bStaticStrictNSCheck = true;
    private static MyMutex mutex = new MyMutex();
    public boolean bKElementOnly = false;
    public boolean bInitOnCreate = true;
    private XMLDocUserData myXMLUserDat = new XMLDocUserData(this);
    private boolean bInJDFJMF = false;
    private Node m_ParentNode = null;
    private static final String jdfNSURI = JDFElement.getSchemaURL();
    private static final String xjdfNSURI = JDFElement.getSchemaURL(2, 0);
    private static final String jdfNSURIPrefix = StringUtil.leftStr(JDFElement.getSchemaURL(), -3);

    public static boolean isStaticStrictNSCheck() {
        return bStaticStrictNSCheck;
    }

    public static void setStaticStrictNSCheck(boolean staticStrictNSCheck) {
        bStaticStrictNSCheck = staticStrictNSCheck;
    }

    @Override
    public DocumentJDFImpl clone() {
        DocumentJDFImpl clon = (DocumentJDFImpl)super.clone();
        clon.myXMLUserDat = new XMLDocUserData(clon);
        clon.bInitOnCreate = this.bInitOnCreate;
        clon.bKElementOnly = this.bKElementOnly;
        clon.m_Bodypart = this.m_Bodypart;
        clon.m_ZipReader = this.m_ZipReader;
        clon.m_OriginalFileName = this.m_OriginalFileName;
        return clon;
    }

    public static void registerCustomClass(String strElement, String packagepath) {
        data.registerCustomClass(strElement, packagepath);
    }

    @Override
    KElement factoryCreate(ParentNode parent, String qualifiedName) {
        this.setParentNode((Node)parent);
        return (KElement)this.createElement(qualifiedName);
    }

    @Override
    KElement factoryCreate(ParentNode parent, String namespaceURI, String qualifiedName) {
        this.setParentNode((Node)parent);
        return (KElement)this.createElementNS(namespaceURI, qualifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName, String localPart) {
        Constructor<?> constructi;
        Class<?> classOfConstructor = null;
        if (this.bKElementOnly) {
            return new KElement((CoreDocumentImpl)this, namespaceURI, qualifiedName, localPart);
        }
        this.bInJDFJMF = this.bInJDFJMF || jdfNSURI.equals(namespaceURI) || xjdfNSURI.equals(namespaceURI) || "JDF".equals(localPart) || "XJDF".equals(localPart) || "XJMF".equals(localPart) || "JMF".equals(localPart);
        DocumentData theData = data;
        HashMap hashMap = theData.sm_hashCtorElementNS;
        synchronized (hashMap) {
            constructi = (Constructor<?>)theData.sm_hashCtorElementNS.get(qualifiedName);
            String path = null;
            if (constructi == null) {
                path = this.getFactoryClassPath(namespaceURI, qualifiedName, localPart);
                if (path == null) {
                    path = this.getSpecialClassPath(namespaceURI, qualifiedName);
                }
                if (path != null) {
                    constructi = (Constructor)theData.sm_hashCtorElementNS.get(path);
                }
            }
            if (constructi == null) {
                try {
                    classOfConstructor = this.getFactoryClass(namespaceURI, qualifiedName, localPart, path);
                    if (classOfConstructor != null) {
                        Class[] constructorParameters = new Class[]{CoreDocumentImpl.class, String.class, String.class, String.class};
                        constructi = classOfConstructor.getDeclaredConstructor(constructorParameters);
                        this.putConstructorToHashMap(qualifiedName, constructi, path);
                    }
                }
                catch (ClassNotFoundException e) {
                    String message = "(DocumentJDFImpl.createElementNS) getFactoryClass() class " + e.getMessage() + " could not be created (surplus line in sm_PackageNames or non existing class ???)";
                    throw new DOMException(8, message);
                }
                catch (NoSuchMethodException e) {
                    String message = "(DocumentJDFImpl.createElementNS) getDeclaredConstructor() not found: ";
                    if (classOfConstructor != null) {
                        message = message + classOfConstructor.getName() + "(CoreDocumentImpl, String, String, String)";
                    }
                    throw new DOMException(8, message);
                }
            }
        }
        Object[] constructorArguments = new Object[]{this, namespaceURI, qualifiedName, localPart};
        KElement newElement = this.createKElement(constructi, constructorArguments);
        return newElement;
    }

    private void putConstructorToHashMap(String qualifiedName, Constructor<?> constructi, String path) {
        String className = constructi.getDeclaringClass().getName();
        boolean bSpecialClass = this.isSpecialClass(qualifiedName, className);
        if (bSpecialClass) {
            data.sm_hashCtorElementNS.put(qualifiedName, constructi);
        } else if (path != null) {
            data.sm_hashCtorElementNS.put(path, constructi);
        }
    }

    private boolean isSpecialClass(String qualifiedName, String className) {
        qualifiedName = KElement.xmlnsLocalName(qualifiedName);
        return !data.contextSensitive.contains(qualifiedName) && (className == null || !data.contextSensitive.contains(className));
    }

    private KElement createKElement(Constructor<?> constructi, Object[] constructorArguments) {
        KElement newElement = null;
        String message = null;
        try {
            newElement = (KElement)constructi.newInstance(constructorArguments);
        }
        catch (IllegalAccessException e) {
            message = "(DocumentJDFImpl.createKElement) IllegalAccessException caught :" + e.getMessage();
        }
        catch (InstantiationException e) {
            message = "(DocumentJDFImpl.createKElement) InstantiationException caught (abstract class?) : " + constructi.getName() + "(CoreDocumentImpl, String, String, String)";
        }
        catch (InvocationTargetException e) {
            message = "(DocumentJDFImpl.createKElement) InvocationTargetException caught :" + e.getMessage();
        }
        catch (Exception e) {
            message = "(DocumentJDFImpl.createKElement) Exception caught :" + e.getMessage();
        }
        if (newElement == null) {
            if (message == null) {
                message = "(DocumentJDFImpl.createKElement) Could not create an element with " + constructi.getName() + "(CoreDocumentImpl, String, String, String)";
            }
            throw new DOMException(12, message);
        }
        return newElement;
    }

    public Class<?> getFactoryClass(String qualifiedName) {
        Class<?> packageNameClass = null;
        try {
            packageNameClass = this.getFactoryClass(null, qualifiedName, qualifiedName, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return packageNameClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getFactoryClass(String strNameSpaceURI, String qualifiedName, String localPart, String strClassPath) throws ClassNotFoundException {
        Class<?> packageNameClass = (Class<?>)data.sm_ClassAlreadyInstantiated.get(qualifiedName);
        if (packageNameClass == null) {
            HashMap hashMap = data.sm_PackageNames;
            synchronized (hashMap) {
                if (strClassPath == null) {
                    strClassPath = this.getFactoryClassPath(strNameSpaceURI, qualifiedName, localPart);
                }
                boolean normalElement = true;
                if (strClassPath == null) {
                    normalElement = false;
                    strClassPath = this.getSpecialClassPath(strNameSpaceURI, qualifiedName);
                } else {
                    normalElement = this.isSpecialClass(qualifiedName, strClassPath);
                }
                packageNameClass = (Class)data.sm_hashPathToClass.get(strClassPath);
                if (packageNameClass == null) {
                    try {
                        packageNameClass = Class.forName(strClassPath);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException(e.getMessage(), e);
                    }
                    data.sm_hashPathToClass.put(strClassPath, packageNameClass);
                }
                if (normalElement || strClassPath.equals(data.sm_PackageNames.get("ResDefault"))) {
                    data.sm_ClassAlreadyInstantiated.put(qualifiedName, packageNameClass);
                }
            }
        }
        return packageNameClass;
    }

    private String getFactoryClassPath(String strNameSpaceURI, String qualifiedName, String localPart) {
        if (!this.bInJDFJMF) {
            return CORE_KELEMENT;
        }
        String strClassPath = null;
        if (qualifiedName.endsWith("Link") && !"CreateLink".equals(qualifiedName) && !"RemoveLink".equals(qualifiedName)) {
            strClassPath = (String)data.sm_PackageNames.get("ResourceLink");
        } else if (qualifiedName.endsWith("Ref") && !qualifiedName.equals("TestRef")) {
            strClassPath = (String)data.sm_PackageNames.get("RefElement");
        } else {
            strClassPath = (String)data.sm_PackageNames.get(qualifiedName);
            if (strClassPath == null && (null == strNameSpaceURI || strNameSpaceURI != null && strNameSpaceURI.startsWith(jdfNSURIPrefix) || "".equals(strNameSpaceURI))) {
                strClassPath = (String)data.sm_PackageNames.get(localPart);
            }
        }
        return strClassPath;
    }

    private String getSpecialClassPath(String nameSpaceURI, String strName) {
        String strParentNodeClass = this.m_ParentNode == null ? null : this.m_ParentNode.getClass().getName();
        String strClassPath = !this.isSpecialClass(strName = KElement.xmlnsLocalName(strName), null) ? ("HoleType".equals(strName) ? this.getHoleTypeClass(strParentNodeClass) : ("Method".equals(strName) ? this.getMethodClass(strParentNodeClass) : ("Shape".equals(strName) ? this.getShapeClass(strParentNodeClass) : ("Surface".equals(strName) ? this.getSurfaceClass(strParentNodeClass) : ("Position".equals(strName) ? this.getPositionClass(strParentNodeClass) : (nameSpaceURI == null && this.bInJDFJMF || nameSpaceURI != null && nameSpaceURI.startsWith(jdfNSURIPrefix) ? (String)data.sm_PackageNames.get("EleDefault") : (String)data.sm_PackageNames.get("OtherNSDefault"))))))) : (this.isDeepResource(strName, nameSpaceURI) ? (String)data.sm_PackageNames.get("ResDefault") : (nameSpaceURI == null && this.bInJDFJMF || nameSpaceURI != null && nameSpaceURI.startsWith(jdfNSURIPrefix) ? (String)data.sm_PackageNames.get("EleDefault") : (String)data.sm_PackageNames.get("OtherNSDefault")));
        return strClassPath;
    }

    protected String getPositionClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.JDFEmbossingItem".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFXYPairSpan" : "org.cip4.jdflib.resource.process.JDFPosition";
        return strClassPath;
    }

    protected String getSurfaceClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.intent.JDFLaminatingIntent".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFSpanSurface" : "org.cip4.jdflib.resource.process.JDFLayout";
        return strClassPath;
    }

    protected String getShapeClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.intent.JDFBookCase".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFSpanShape" : "org.cip4.jdflib.resource.JDFShapeElement";
        return strClassPath;
    }

    protected String getMethodClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.intent.JDFInsertingIntent".equals(strParentNodeClass) || "org.cip4.jdflib.resource.JDFInsert".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFSpanMethod" : "org.cip4.jdflib.span.JDFNameSpan";
        return strClassPath;
    }

    protected String getHoleTypeClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.process.postpress.JDFRingBinding".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFSpanHoleType" : "org.cip4.jdflib.span.JDFStringSpan";
        return strClassPath;
    }

    @Override
    public String toString() {
        Element rootElement = this.getDocumentElement();
        if (rootElement != null) {
            return super.toString() + rootElement.toString();
        }
        return super.toString();
    }

    public void setParentNode(Node node) {
        this.m_ParentNode = node;
    }

    private boolean isDeepResource(String strName, String nameSpaceURI) {
        if (this.m_ParentNode == null) {
            return false;
        }
        if (this.m_ParentNode instanceof JDFResourcePool) {
            return true;
        }
        if (this.m_ParentNode instanceof JDFResourceInfo) {
            return !jdfNSURI.equals(nameSpaceURI);
        }
        if (this.m_ParentNode instanceof JDFResource) {
            return this.m_ParentNode.getLocalName().equals(strName);
        }
        return false;
    }

    protected XMLDocUserData getXMLDocUserData() {
        return (XMLDocUserData)this.getUserData();
    }

    public Node removeChild(Node arg0) throws DOMException {
        XMLDocUserData ud = this.getXMLDocUserData();
        if (ud != null) {
            ud.clearTargets();
        }
        return super.removeChild(arg0);
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        XMLDocUserData ud = this.getXMLDocUserData();
        if (ud != null) {
            ud.clearTargets();
        }
        return super.replaceChild(arg0, arg1);
    }

    public XMLDocUserData getMyUserData() {
        return this.myXMLUserDat;
    }

    private static class DocumentData {
        private final HashMap<String, String> sm_PackageNames = new HashMap();
        private final HashSet<String> contextSensitive = new HashSet();
        private final HashMap<String, Class<?>> sm_ClassAlreadyInstantiated = new HashMap();
        private final HashMap<String, Constructor<?>> sm_hashCtorElementNS = new HashMap();
        private final HashMap<String, Class<?>> sm_hashPathToClass = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerCustomClass(String strElement, String packagepath) {
            MyMutex myMutex = mutex;
            synchronized (myMutex) {
                this.sm_PackageNames.put(strElement, packagepath);
                this.sm_ClassAlreadyInstantiated.remove(strElement);
                this.sm_hashCtorElementNS.remove(strElement);
            }
        }

        private void fillContextSensitive() {
            this.contextSensitive.add("HoleType");
            this.contextSensitive.add("Method");
            this.contextSensitive.add("Shape");
            this.contextSensitive.add("Position");
            this.contextSensitive.add("Surface");
            this.contextSensitive.add(DocumentJDFImpl.CORE_JDFELEMENT);
            this.contextSensitive.add(DocumentJDFImpl.CORE_KELEMENT);
        }

        private void fillPackages() {
            this.sm_PackageNames.put("ResDefault", DocumentJDFImpl.CORE_JDFRESOURCE);
            this.sm_PackageNames.put("EleDefault", DocumentJDFImpl.CORE_JDFELEMENT);
            this.sm_PackageNames.put("OtherNSDefault", DocumentJDFImpl.CORE_KELEMENT);
            this.sm_PackageNames.put("JDF", "org.cip4.jdflib.node.JDFNode");
            this.sm_PackageNames.put("JMF", "org.cip4.jdflib.jmf.JDFJMF");
            this.sm_PackageNames.put("XJDF", DocumentJDFImpl.CORE_JDFELEMENT);
            this.sm_PackageNames.put("XJMF", DocumentJDFImpl.CORE_JDFELEMENT);
            this.sm_PackageNames.put("PrintTalk", DocumentJDFImpl.CORE_JDFELEMENT);
            this.sm_PackageNames.put("AbortQueueEntryParams", "org.cip4.jdflib.jmf.JDFAbortQueueEntryParams");
            this.sm_PackageNames.put("Acknowledge", "org.cip4.jdflib.jmf.JDFAcknowledge");
            this.sm_PackageNames.put("Action", "org.cip4.jdflib.resource.devicecapability.JDFAction");
            this.sm_PackageNames.put("ActionPool", "org.cip4.jdflib.resource.devicecapability.JDFActionPool");
            this.sm_PackageNames.put("Activity", "org.cip4.jdflib.node.JDFActivity");
            this.sm_PackageNames.put("Added", "org.cip4.jdflib.jmf.JDFAdded");
            this.sm_PackageNames.put("Address", "org.cip4.jdflib.resource.process.JDFAddress");
            this.sm_PackageNames.put("AdhesiveBinding", "org.cip4.jdflib.resource.process.postpress.JDFAdhesiveBinding");
            this.sm_PackageNames.put("AdhesiveBindingParams", "org.cip4.jdflib.resource.JDFAdhesiveBindingParams");
            this.sm_PackageNames.put("AdvancedParams", "org.cip4.jdflib.resource.process.JDFAdvancedParams");
            this.sm_PackageNames.put("Amount", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("AmountPool", "org.cip4.jdflib.pool.JDFAmountPool");
            this.sm_PackageNames.put("Ancestor", "org.cip4.jdflib.node.JDFAncestor");
            this.sm_PackageNames.put("AncestorPool", "org.cip4.jdflib.pool.JDFAncestorPool");
            this.sm_PackageNames.put("and", "org.cip4.jdflib.resource.devicecapability.JDFand");
            this.sm_PackageNames.put("ApprovalDetails", "org.cip4.jdflib.resource.process.JDFApprovalDetails");
            this.sm_PackageNames.put("ApprovalParams", "org.cip4.jdflib.resource.process.JDFApprovalParams");
            this.sm_PackageNames.put("ApprovalPerson", "org.cip4.jdflib.resource.process.JDFApprovalPerson");
            this.sm_PackageNames.put("ApprovalSuccess", "org.cip4.jdflib.resource.process.JDFApprovalSuccess");
            this.sm_PackageNames.put("ArgumentValue", "org.cip4.jdflib.resource.process.JDFArgumentValue");
            this.sm_PackageNames.put("ArtDelivery", "org.cip4.jdflib.resource.intent.JDFArtDelivery");
            this.sm_PackageNames.put("ArtDeliveryDate", "org.cip4.jdflib.span.JDFTimeSpan");
            this.sm_PackageNames.put("ArtDeliveryDuration", "org.cip4.jdflib.span.JDFDurationSpan");
            this.sm_PackageNames.put("ArtDeliveryIntent", "org.cip4.jdflib.resource.intent.JDFArtDeliveryIntent");
            this.sm_PackageNames.put("ArtDeliveryType", "org.cip4.jdflib.resource.intent.JDFArtDeliveryType");
            this.sm_PackageNames.put("ArtHandling", "org.cip4.jdflib.span.JDFSpanArtHandling");
            this.sm_PackageNames.put("Assembly", "org.cip4.jdflib.resource.process.JDFAssembly");
            this.sm_PackageNames.put("AssemblySection", "org.cip4.jdflib.resource.process.JDFAssemblySection");
            this.sm_PackageNames.put("AssetListCreationParams", "org.cip4.jdflib.resource.process.prepress.JDFAssetListCreationParams");
            this.sm_PackageNames.put("Audit", "org.cip4.jdflib.core.JDFAudit");
            this.sm_PackageNames.put("AuditPool", "org.cip4.jdflib.pool.JDFAuditPool");
            this.sm_PackageNames.put("AuthenticationCmdParams", "org.cip4.jdflib.jmf.JDFAuthenticationCmdParams");
            this.sm_PackageNames.put("AuthenticationQuParams", "org.cip4.jdflib.jmf.JDFAuthenticationQuParams");
            this.sm_PackageNames.put("AuthenticationResp", "org.cip4.jdflib.jmf.JDFAuthenticationResp");
            this.sm_PackageNames.put("AutomatedOverPrintParams", "org.cip4.jdflib.resource.process.JDFAutomatedOverPrintParams");
            this.sm_PackageNames.put("BackCoatings", "org.cip4.jdflib.span.JDFSpanCoatings");
            this.sm_PackageNames.put("BackCoverColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("BackCoverColorDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("Band", "org.cip4.jdflib.resource.JDFBand");
            this.sm_PackageNames.put("Barcode", "org.cip4.jdflib.resource.JDFBarcode");
            this.sm_PackageNames.put("BarcodeCompParams", "org.cip4.jdflib.resource.process.JDFBarcodeCompParams");
            this.sm_PackageNames.put("BarcodeDetails", "org.cip4.jdflib.resource.process.JDFBarcodeDetails");
            this.sm_PackageNames.put("BarcodeReproParams", "org.cip4.jdflib.resource.process.JDFBarcodeReproParams");
            this.sm_PackageNames.put("BarcodeProductionParams", "org.cip4.jdflib.resource.process.JDFBarcodeProductionParams");
            this.sm_PackageNames.put("BasicPreflightTest", "org.cip4.jdflib.resource.devicecapability.JDFBasicPreflightTest");
            this.sm_PackageNames.put("BendingParams", "org.cip4.jdflib.resource.process.JDFBendingParams");
            this.sm_PackageNames.put("BinderMaterial", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("BinderBrand", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("BinderySignature", "org.cip4.jdflib.resource.process.JDFBinderySignature");
            this.sm_PackageNames.put("BindingColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("BindingColorDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("BindingIntent", "org.cip4.jdflib.resource.intent.JDFBindingIntent");
            this.sm_PackageNames.put("BindingLength", "org.cip4.jdflib.span.JDFSpanBindingLength");
            this.sm_PackageNames.put("BindingQualityMeasurement", "org.cip4.jdflib.resource.process.JDFBindingQualityMeasurement");
            this.sm_PackageNames.put("BindingQualityParams", "org.cip4.jdflib.resource.process.JDFBindingQualityParams");
            this.sm_PackageNames.put("BindingSide", "org.cip4.jdflib.span.JDFSpanBindingSide");
            this.sm_PackageNames.put("BindingType", "org.cip4.jdflib.span.JDFSpanBindingType");
            this.sm_PackageNames.put("BindItem", "org.cip4.jdflib.resource.JDFBindItem");
            this.sm_PackageNames.put("BindList", "org.cip4.jdflib.resource.JDFBindList");
            this.sm_PackageNames.put("BlockPreparationParams", "org.cip4.jdflib.resource.JDFBlockPreparationParams");
            this.sm_PackageNames.put("BlockThreadSewing", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("BookCase", "org.cip4.jdflib.resource.intent.JDFBookCase");
            this.sm_PackageNames.put("BooleanEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFBooleanEvaluation");
            this.sm_PackageNames.put("BooleanState", "org.cip4.jdflib.resource.devicecapability.JDFBooleanState");
            this.sm_PackageNames.put("BoxApplication", "org.cip4.jdflib.resource.process.JDFBoxApplication");
            this.sm_PackageNames.put("BoxArgument", "org.cip4.jdflib.resource.process.JDFBoxArgument");
            this.sm_PackageNames.put("BoxedQuantity", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("BoxFoldAction", "org.cip4.jdflib.resource.process.JDFBoxFoldAction");
            this.sm_PackageNames.put("BoxFoldingParams", "org.cip4.jdflib.resource.process.JDFBoxFoldingParams");
            this.sm_PackageNames.put("BoxPackingParams", "org.cip4.jdflib.resource.JDFBoxPackingParams");
            this.sm_PackageNames.put("BoxShape", "org.cip4.jdflib.span.JDFShapeSpan");
            this.sm_PackageNames.put("BoxToBoxDifference", "org.cip4.jdflib.resource.process.JDFBoxToBoxDifference");
            this.sm_PackageNames.put("BrandName", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("Brightness", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("BufferParams", "org.cip4.jdflib.resource.JDFBufferParams");
            this.sm_PackageNames.put("Bundle", "org.cip4.jdflib.resource.JDFBundle");
            this.sm_PackageNames.put("BundleItem", "org.cip4.jdflib.resource.JDFBundleItem");
            this.sm_PackageNames.put("BundlingParams", "org.cip4.jdflib.resource.process.postpress.JDFBundlingParams");
            this.sm_PackageNames.put("BusinessInfo", "org.cip4.jdflib.resource.process.JDFBusinessInfo");
            this.sm_PackageNames.put("BuyerSupplied", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("ByteMap", "org.cip4.jdflib.resource.process.JDFByteMap");
            this.sm_PackageNames.put("call", "org.cip4.jdflib.resource.devicecapability.JDFcall");
            this.sm_PackageNames.put("CartonMaxWeight", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("CartonQuantity", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("CartonShape", "org.cip4.jdflib.span.JDFShapeSpan");
            this.sm_PackageNames.put("CartonStrength", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("CaseMakingParams", "org.cip4.jdflib.resource.JDFCaseMakingParams");
            this.sm_PackageNames.put("CasingInParams", "org.cip4.jdflib.resource.JDFCasingInParams");
            this.sm_PackageNames.put("CCITTFaxParams", "org.cip4.jdflib.resource.process.JDFCCITTFaxParams");
            this.sm_PackageNames.put("Certificate", "org.cip4.jdflib.jmf.JDFCertificate");
            this.sm_PackageNames.put("ChangedAttribute", "org.cip4.jdflib.resource.JDFChangedAttribute");
            this.sm_PackageNames.put("ChangedPath", "org.cip4.jdflib.jmf.JDFChangedPath");
            this.sm_PackageNames.put("ChannelBinding", "org.cip4.jdflib.resource.process.postpress.JDFChannelBinding");
            this.sm_PackageNames.put("ChannelBindingParams", "org.cip4.jdflib.resource.process.postpress.JDFChannelBindingParams");
            this.sm_PackageNames.put("ChannelBrand", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("choice", "org.cip4.jdflib.resource.devicecapability.JDFchoice");
            this.sm_PackageNames.put("CIELABMeasuringField", "org.cip4.jdflib.resource.process.JDFCIELABMeasuringField");
            this.sm_PackageNames.put("Circulation", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("Coatings", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("CoilBinding", "org.cip4.jdflib.resource.process.postpress.JDFCoilBinding");
            this.sm_PackageNames.put("CoilBindingParams", "org.cip4.jdflib.resource.JDFCoilBindingParams");
            this.sm_PackageNames.put("CoilBrand", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("CoilMaterial", "org.cip4.jdflib.span.JDFSpanCoilMaterial");
            this.sm_PackageNames.put("CollatingItem", "org.cip4.jdflib.resource.process.JDFCollatingItem");
            this.sm_PackageNames.put("CollectingParams", "org.cip4.jdflib.resource.process.JDFCollectingParams");
            this.sm_PackageNames.put("Color", "org.cip4.jdflib.resource.process.JDFColor");
            this.sm_PackageNames.put("ColorantAlias", "org.cip4.jdflib.resource.process.JDFColorantAlias");
            this.sm_PackageNames.put("ColorantControl", "org.cip4.jdflib.resource.process.JDFColorantControl");
            this.sm_PackageNames.put("ColorantConvertProcess", "org.cip4.jdflib.core.JDFSeparationList");
            this.sm_PackageNames.put("ColorantOrder", "org.cip4.jdflib.core.JDFSeparationList");
            this.sm_PackageNames.put("ColorantParams", "org.cip4.jdflib.core.JDFSeparationList");
            this.sm_PackageNames.put("ColorantZoneDetails", "org.cip4.jdflib.resource.process.JDFColorantZoneDetails");
            this.sm_PackageNames.put("ColorControlStrip", "org.cip4.jdflib.resource.process.JDFColorControlStrip");
            this.sm_PackageNames.put("ColorCorrectionOp", "org.cip4.jdflib.resource.process.prepress.JDFColorCorrectionOp");
            this.sm_PackageNames.put("ColorCorrectionParams", "org.cip4.jdflib.resource.process.prepress.JDFColorCorrectionParams");
            this.sm_PackageNames.put("ColorICCStandard", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("ColorIntent", "org.cip4.jdflib.resource.intent.JDFColorIntent");
            this.sm_PackageNames.put("ColorMeasurementConditions", "org.cip4.jdflib.resource.JDFColorMeasurementConditions");
            this.sm_PackageNames.put("ColorName", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("ColorNameDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("ColorPool", "org.cip4.jdflib.resource.process.JDFColorPool");
            this.sm_PackageNames.put("ColorSpaceConversionOp", "org.cip4.jdflib.resource.process.prepress.JDFColorSpaceConversionOp");
            this.sm_PackageNames.put("ColorSpaceConversionParams", "org.cip4.jdflib.resource.process.prepress.JDFColorSpaceConversionParams");
            this.sm_PackageNames.put("ColorSpaceSubstitute", "org.cip4.jdflib.resource.process.prepress.JDFColorSpaceSubstitute");
            this.sm_PackageNames.put("ColorsResultsPool", "org.cip4.jdflib.resource.process.JDFColorsResultsPool");
            this.sm_PackageNames.put("ColorStandard", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("ColorsUsed", "org.cip4.jdflib.core.JDFSeparationList");
            this.sm_PackageNames.put("ColorType", "org.cip4.jdflib.span.JDFSpanColorType");
            this.sm_PackageNames.put("CombBrand", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("ComChannel", "org.cip4.jdflib.resource.process.JDFComChannel");
            this.sm_PackageNames.put("Command", "org.cip4.jdflib.jmf.JDFCommand");
            this.sm_PackageNames.put("Comment", "org.cip4.jdflib.core.JDFComment");
            this.sm_PackageNames.put("Company", "org.cip4.jdflib.resource.process.JDFCompany");
            this.sm_PackageNames.put("Component", "org.cip4.jdflib.resource.process.JDFComponent");
            this.sm_PackageNames.put("ConstraintValue", "org.cip4.jdflib.resource.process.JDFConstraintValue");
            this.sm_PackageNames.put("Contact", "org.cip4.jdflib.resource.process.JDFContact");
            this.sm_PackageNames.put("ContactCopyParams", "org.cip4.jdflib.resource.JDFContactCopyParams");
            this.sm_PackageNames.put("Container", "org.cip4.jdflib.resource.process.JDFContainer");
            this.sm_PackageNames.put("ContentData", "org.cip4.jdflib.resource.process.JDFContentData");
            this.sm_PackageNames.put("ContentList", "org.cip4.jdflib.resource.process.JDFContentList");
            this.sm_PackageNames.put("ContentMetaData", "org.cip4.jdflib.resource.process.JDFContentMetaData");
            this.sm_PackageNames.put("ContentObject", "org.cip4.jdflib.resource.process.JDFContentObject");
            this.sm_PackageNames.put("ControllerFilter", "org.cip4.jdflib.jmf.JDFControllerFilter");
            this.sm_PackageNames.put("ConventionalPrintingParams", "org.cip4.jdflib.resource.process.JDFConventionalPrintingParams");
            this.sm_PackageNames.put("ConvertingConfig", "org.cip4.jdflib.resource.process.JDFConvertingConfig");
            this.sm_PackageNames.put("CostCenter", "org.cip4.jdflib.resource.process.JDFCostCenter");
            this.sm_PackageNames.put("CounterReset", "org.cip4.jdflib.resource.JDFCounterReset");
            this.sm_PackageNames.put("Cover", "org.cip4.jdflib.resource.process.JDFCover");
            this.sm_PackageNames.put("Coverage", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("CoverApplicationParams", "org.cip4.jdflib.resource.JDFCoverApplicationParams");
            this.sm_PackageNames.put("CoverColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("CoverColorDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("CoverStyle", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("Crease", "org.cip4.jdflib.resource.process.postpress.JDFCrease");
            this.sm_PackageNames.put("CreasingParams", "org.cip4.jdflib.resource.JDFCreasingParams");
            this.sm_PackageNames.put("Created", "org.cip4.jdflib.resource.JDFCreated");
            this.sm_PackageNames.put("CreateLink", "org.cip4.jdflib.jmf.JDFCreateLink");
            this.sm_PackageNames.put("CreateResource", "org.cip4.jdflib.jmf.JDFCreateResource");
            this.sm_PackageNames.put("CreditCard", "org.cip4.jdflib.resource.JDFCreditCard");
            this.sm_PackageNames.put("CustomerInfo", "org.cip4.jdflib.core.JDFCustomerInfo");
            this.sm_PackageNames.put("CustomerMessage", "org.cip4.jdflib.core.JDFCustomerMessage");
            this.sm_PackageNames.put("Cut", "org.cip4.jdflib.resource.process.postpress.JDFCut");
            this.sm_PackageNames.put("CutBlock", "org.cip4.jdflib.resource.process.JDFCutBlock");
            this.sm_PackageNames.put("CutMark", "org.cip4.jdflib.resource.process.postpress.JDFCutMark");
            this.sm_PackageNames.put("CuttingParams", "org.cip4.jdflib.resource.JDFCuttingParams");
            this.sm_PackageNames.put("CutType", "org.cip4.jdflib.span.JDFSpanCutType");
            this.sm_PackageNames.put("CylinderLayout", "org.cip4.jdflib.resource.process.JDFCylinderLayout");
            this.sm_PackageNames.put("CylinderLayoutPreparationParams", "org.cip4.jdflib.resource.process.JDFCylinderLayoutPreparationParams");
            this.sm_PackageNames.put("CylinderPosition", "org.cip4.jdflib.resource.process.JDFCylinderPosition");
            this.sm_PackageNames.put("DateTimeEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFDateTimeEvaluation");
            this.sm_PackageNames.put("DateTimeState", "org.cip4.jdflib.resource.devicecapability.JDFDateTimeState");
            this.sm_PackageNames.put("DCTParams", "org.cip4.jdflib.resource.process.JDFDCTParams");
            this.sm_PackageNames.put("DBMergeParams", "org.cip4.jdflib.resource.process.JDFDBMergeParams");
            this.sm_PackageNames.put("DBRules", "org.cip4.jdflib.resource.process.JDFDBRules");
            this.sm_PackageNames.put("DBSchema", "org.cip4.jdflib.resource.JDFDBSchema");
            this.sm_PackageNames.put("DBSelection", "org.cip4.jdflib.resource.process.JDFDBSelection");
            this.sm_PackageNames.put("Deleted", "org.cip4.jdflib.resource.JDFDeleted");
            this.sm_PackageNames.put("DeliveryCharge", "org.cip4.jdflib.span.JDFSpanDeliveryCharge");
            this.sm_PackageNames.put("DeliveryIntent", "org.cip4.jdflib.resource.intent.JDFDeliveryIntent");
            this.sm_PackageNames.put("DeliveryParams", "org.cip4.jdflib.resource.process.JDFDeliveryParams");
            this.sm_PackageNames.put("DensityMeasuringField", "org.cip4.jdflib.resource.process.JDFDensityMeasuringField");
            this.sm_PackageNames.put("Dependencies", "org.cip4.jdflib.resource.process.JDFDependencies");
            this.sm_PackageNames.put("DevCap", "org.cip4.jdflib.resource.devicecapability.JDFDevCap");
            this.sm_PackageNames.put("DevCapPool", "org.cip4.jdflib.resource.devicecapability.JDFDevCapPool");
            this.sm_PackageNames.put("DevCaps", "org.cip4.jdflib.resource.devicecapability.JDFDevCaps");
            this.sm_PackageNames.put("DevelopingParams", "org.cip4.jdflib.resource.JDFDevelopingParams");
            this.sm_PackageNames.put("Device", "org.cip4.jdflib.resource.JDFDevice");
            this.sm_PackageNames.put("DeviceCap", "org.cip4.jdflib.resource.devicecapability.JDFDeviceCap");
            this.sm_PackageNames.put("DeviceColorantOrder", "org.cip4.jdflib.core.JDFSeparationList");
            this.sm_PackageNames.put("DeviceFilter", "org.cip4.jdflib.jmf.JDFDeviceFilter");
            this.sm_PackageNames.put("DeviceInfo", "org.cip4.jdflib.jmf.JDFDeviceInfo");
            this.sm_PackageNames.put("DeviceList", "org.cip4.jdflib.resource.JDFDeviceList");
            this.sm_PackageNames.put("DeviceMark", "org.cip4.jdflib.resource.JDFDeviceMark");
            this.sm_PackageNames.put("DeviceNColor", "org.cip4.jdflib.resource.process.JDFDeviceNColor");
            this.sm_PackageNames.put("DeviceNSpace", "org.cip4.jdflib.resource.process.JDFDeviceNSpace");
            this.sm_PackageNames.put("DieLayout", "org.cip4.jdflib.resource.process.JDFDieLayout");
            this.sm_PackageNames.put("DieLayoutProductionParams", "org.cip4.jdflib.resource.process.JDFDieLayoutProductionParams");
            this.sm_PackageNames.put("DigitalDeliveryParams", "org.cip4.jdflib.resource.process.prepress.JDFDigitalDeliveryParams");
            this.sm_PackageNames.put("DigitalMedia", "org.cip4.jdflib.resource.process.JDFDigitalMedia");
            this.sm_PackageNames.put("DigitalPrintingParams", "org.cip4.jdflib.resource.process.JDFDigitalPrintingParams");
            this.sm_PackageNames.put("Dimensions", "org.cip4.jdflib.span.JDFXYPairSpan");
            this.sm_PackageNames.put("Direction", "org.cip4.jdflib.span.JDFSpanDirection");
            this.sm_PackageNames.put("Disjointing", "org.cip4.jdflib.resource.process.JDFDisjointing");
            this.sm_PackageNames.put("DisplayGroup", "org.cip4.jdflib.resource.devicecapability.JDFDisplayGroup");
            this.sm_PackageNames.put("DisplayGroupPool", "org.cip4.jdflib.resource.devicecapability.JDFDisplayGroupPool");
            this.sm_PackageNames.put("Disposition", "org.cip4.jdflib.resource.process.JDFDisposition");
            this.sm_PackageNames.put("DividingParams", "org.cip4.jdflib.resource.process.JDFDividingParams");
            this.sm_PackageNames.put("DocumentResultsPool", "org.cip4.jdflib.resource.process.JDFDocumentResultsPool");
            this.sm_PackageNames.put("DotSize", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("Drop", "org.cip4.jdflib.resource.process.JDFDrop");
            this.sm_PackageNames.put("DropIntent", "org.cip4.jdflib.resource.intent.JDFDropIntent");
            this.sm_PackageNames.put("DropItem", "org.cip4.jdflib.resource.process.JDFDropItem");
            this.sm_PackageNames.put("DropItemIntent", "org.cip4.jdflib.resource.intent.JDFDropItemIntent");
            this.sm_PackageNames.put("DurationEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFDurationEvaluation");
            this.sm_PackageNames.put("DurationState", "org.cip4.jdflib.resource.devicecapability.JDFDurationState");
            this.sm_PackageNames.put("DynamicField", "org.cip4.jdflib.resource.process.JDFDynamicField");
            this.sm_PackageNames.put("DynamicInput", "org.cip4.jdflib.resource.process.JDFDynamicInput");
            this.sm_PackageNames.put("Earliest", "org.cip4.jdflib.span.JDFTimeSpan");
            this.sm_PackageNames.put("EarliestDuration", "org.cip4.jdflib.span.JDFDurationSpan");
            this.sm_PackageNames.put("EdgeAngle", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("EdgeGlue", "org.cip4.jdflib.span.JDFSpanGlue");
            this.sm_PackageNames.put("EdgeGluing", "org.cip4.jdflib.resource.JDFEdgeGluing");
            this.sm_PackageNames.put("EdgeShape", "org.cip4.jdflib.span.JDFSpanEdgeShape");
            this.sm_PackageNames.put("ElementColorParams", "org.cip4.jdflib.resource.process.JDFElementColorParams");
            this.sm_PackageNames.put("Emboss", "org.cip4.jdflib.resource.JDFEmboss");
            this.sm_PackageNames.put("EmbossingIntent", "org.cip4.jdflib.resource.intent.JDFEmbossingIntent");
            this.sm_PackageNames.put("EmbossingItem", "org.cip4.jdflib.resource.JDFEmbossingItem");
            this.sm_PackageNames.put("EmbossingParams", "org.cip4.jdflib.resource.JDFEmbossingParams");
            this.sm_PackageNames.put("EmbossingType", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("Employee", "org.cip4.jdflib.resource.process.JDFEmployee");
            this.sm_PackageNames.put("EmployeeDef", "org.cip4.jdflib.jmf.JDFEmployeeDef");
            this.sm_PackageNames.put("EndSheet", "org.cip4.jdflib.resource.process.postpress.JDFEndSheet");
            this.sm_PackageNames.put("EndSheetGluingParams", "org.cip4.jdflib.resource.JDFEndSheetGluingParams");
            this.sm_PackageNames.put("EndSheets", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("EnumerationEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFEnumerationEvaluation");
            this.sm_PackageNames.put("EnumerationState", "org.cip4.jdflib.resource.devicecapability.JDFEnumerationState");
            this.sm_PackageNames.put("Error", "org.cip4.jdflib.resource.JDFError");
            this.sm_PackageNames.put("ErrorData", "org.cip4.jdflib.resource.JDFErrorData");
            this.sm_PackageNames.put("Event", "org.cip4.jdflib.resource.JDFEvent");
            this.sm_PackageNames.put("ExposedMedia", "org.cip4.jdflib.resource.process.JDFExposedMedia");
            this.sm_PackageNames.put("Expr", "org.cip4.jdflib.resource.process.JDFExpr");
            this.sm_PackageNames.put("ExtendedAddress", "org.cip4.jdflib.core.JDFComment");
            this.sm_PackageNames.put("ExternalImpositionTemplate", "org.cip4.jdflib.resource.process.JDFExternalImpositionTemplate");
            this.sm_PackageNames.put("ExtraValues", "org.cip4.jdflib.resource.process.JDFExtraValues");
            this.sm_PackageNames.put("FCNKey", "org.cip4.jdflib.resource.JDFFCNKey");
            this.sm_PackageNames.put("FeatureAttribute", "org.cip4.jdflib.resource.devicecapability.JDFFeatureAttribute");
            this.sm_PackageNames.put("FeaturePool", "org.cip4.jdflib.resource.devicecapability.JDFFeaturePool");
            this.sm_PackageNames.put("Feeder", "org.cip4.jdflib.resource.process.JDFFeeder");
            this.sm_PackageNames.put("FeederQualityParams", "org.cip4.jdflib.resource.process.JDFFeederQualityParams");
            this.sm_PackageNames.put("FeedingParams", "org.cip4.jdflib.resource.process.JDFFeedingParams");
            this.sm_PackageNames.put("FileAlias", "org.cip4.jdflib.resource.process.JDFFileAlias");
            this.sm_PackageNames.put("FileSpec", "org.cip4.jdflib.resource.process.JDFFileSpec");
            this.sm_PackageNames.put("FileTypeResultsPool", "org.cip4.jdflib.resource.process.prepress.JDFFileTypeResultsPool");
            this.sm_PackageNames.put("FillColor", "org.cip4.jdflib.resource.process.JDFFillColor");
            this.sm_PackageNames.put("FillMark", "org.cip4.jdflib.resource.process.JDFFillMark");
            this.sm_PackageNames.put("FinishedDimensions", "org.cip4.jdflib.span.JDFShapeSpan");
            this.sm_PackageNames.put("FinishedGrainDirection", "org.cip4.jdflib.span.JDFSpanFinishedGrainDirection");
            this.sm_PackageNames.put("FitPolicy", "org.cip4.jdflib.resource.JDFFitPolicy");
            this.sm_PackageNames.put("FlateParams", "org.cip4.jdflib.resource.process.JDFFlateParams");
            this.sm_PackageNames.put("FlushedResources", "org.cip4.jdflib.jmf.JDFFlushedResources");
            this.sm_PackageNames.put("FlushQueueInfo", "org.cip4.jdflib.jmf.JDFFlushQueueInfo");
            this.sm_PackageNames.put("FlushQueueParams", "org.cip4.jdflib.jmf.JDFFlushQueueParams");
            this.sm_PackageNames.put("FlushResourceParams", "org.cip4.jdflib.jmf.JDFFlushResourceParams");
            this.sm_PackageNames.put("Flute", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("FluteDirection", "org.cip4.jdflib.span.JDFSpanFluteDirection");
            this.sm_PackageNames.put("FoilColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("FoilColorDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("Fold", "org.cip4.jdflib.resource.process.postpress.JDFFold");
            this.sm_PackageNames.put("FolderProduction", "org.cip4.jdflib.resource.process.JDFFolderProduction");
            this.sm_PackageNames.put("FoldingCatalog", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("FoldingIntent", "org.cip4.jdflib.resource.intent.JDFFoldingIntent");
            this.sm_PackageNames.put("FoldingParams", "org.cip4.jdflib.resource.process.postpress.JDFFoldingParams");
            this.sm_PackageNames.put("FoldingWidth", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("FoldingWidthBack", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("FoldOperation", "org.cip4.jdflib.resource.process.JDFFoldOperation");
            this.sm_PackageNames.put("FontParams", "org.cip4.jdflib.resource.process.JDFFontParams");
            this.sm_PackageNames.put("FontPolicy", "org.cip4.jdflib.resource.process.JDFFontPolicy");
            this.sm_PackageNames.put("FontsResultsPool", "org.cip4.jdflib.resource.process.prepress.JDFFontsResultsPool");
            this.sm_PackageNames.put("FormatConversionParams", "org.cip4.jdflib.resource.JDFFormatConversionParams");
            this.sm_PackageNames.put("Frequency", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("FrequencySelection", "org.cip4.jdflib.span.JDFSpanFrequencySelection");
            this.sm_PackageNames.put("FrontCoatings", "org.cip4.jdflib.span.JDFSpanCoatings");
            this.sm_PackageNames.put("GangCmdFilter", "org.cip4.jdflib.jmf.JDFGangCmdFilter");
            this.sm_PackageNames.put("GangElement", "org.cip4.jdflib.resource.process.JDFGangElement");
            this.sm_PackageNames.put("GangInfo", "org.cip4.jdflib.jmf.JDFGangInfo");
            this.sm_PackageNames.put("GangQuFilter", "org.cip4.jdflib.jmf.JDFGangQuFilter");
            this.sm_PackageNames.put("GatheringParams", "org.cip4.jdflib.resource.JDFGatheringParams");
            this.sm_PackageNames.put("GeneralID", "org.cip4.jdflib.resource.process.JDFGeneralID");
            this.sm_PackageNames.put("Glue", "org.cip4.jdflib.resource.process.postpress.JDFGlue");
            this.sm_PackageNames.put("GlueApplication", "org.cip4.jdflib.resource.process.postpress.JDFGlueApplication");
            this.sm_PackageNames.put("GlueLine", "org.cip4.jdflib.resource.process.postpress.JDFGlueLine");
            this.sm_PackageNames.put("GlueProcedure", "org.cip4.jdflib.span.JDFSpanGlueProcedure");
            this.sm_PackageNames.put("GlueType", "org.cip4.jdflib.span.JDFSpanGlueType");
            this.sm_PackageNames.put("GluingParams", "org.cip4.jdflib.resource.JDFGluingParams");
            this.sm_PackageNames.put("Grade", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("GrainDirection", "org.cip4.jdflib.span.JDFSpanGrainDirection");
            this.sm_PackageNames.put("HalfTone", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("HardCoverBinding", "org.cip4.jdflib.resource.JDFHardCoverBinding");
            this.sm_PackageNames.put("HeadBandApplicationParams", "org.cip4.jdflib.resource.JDFHeadBandApplicationParams");
            this.sm_PackageNames.put("HeadBandColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("HeadBandColorDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("HeadBands", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("Height", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("HoldQueueEntryParams", "org.cip4.jdflib.jmf.JDFHoldQueueEntryParams");
            this.sm_PackageNames.put("Hole", "org.cip4.jdflib.resource.process.postpress.JDFHole");
            this.sm_PackageNames.put("HoleCount", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("HoleLine", "org.cip4.jdflib.resource.JDFHoleLine");
            this.sm_PackageNames.put("HoleList", "org.cip4.jdflib.resource.process.postpress.JDFHoleList");
            this.sm_PackageNames.put("HoleMakingIntent", "org.cip4.jdflib.resource.intent.JDFHoleMakingIntent");
            this.sm_PackageNames.put("HoleMakingParams", "org.cip4.jdflib.resource.process.postpress.JDFHoleMakingParams");
            this.sm_PackageNames.put("Icon", "org.cip4.jdflib.resource.JDFIcon");
            this.sm_PackageNames.put("IconList", "org.cip4.jdflib.resource.JDFIconList");
            this.sm_PackageNames.put("Identical", "org.cip4.jdflib.resource.process.JDFIdentical");
            this.sm_PackageNames.put("IdentificationField", "org.cip4.jdflib.resource.process.JDFIdentificationField");
            this.sm_PackageNames.put("IDInfo", "org.cip4.jdflib.jmf.JDFIDInfo");
            this.sm_PackageNames.put("IDPCover", "org.cip4.jdflib.resource.JDFIDPCover");
            this.sm_PackageNames.put("IDPFinishing", "org.cip4.jdflib.resource.process.JDFIDPFinishing");
            this.sm_PackageNames.put("IDPFolding", "org.cip4.jdflib.resource.process.JDFIDPFolding");
            this.sm_PackageNames.put("IDPHoleMaking", "org.cip4.jdflib.resource.process.JDFIDPHoleMaking");
            this.sm_PackageNames.put("IDPImageShift", "org.cip4.jdflib.resource.JDFIDPImageShift");
            this.sm_PackageNames.put("IDPJobSheet", "org.cip4.jdflib.resource.JDFIDPJobSheet");
            this.sm_PackageNames.put("IDPLayout", "org.cip4.jdflib.resource.process.JDFIDPLayout");
            this.sm_PackageNames.put("IDPrintingParams", "org.cip4.jdflib.resource.process.press.JDFIDPrintingParams");
            this.sm_PackageNames.put("IDPStitching", "org.cip4.jdflib.resource.process.JDFIDPStitching");
            this.sm_PackageNames.put("IDPTrimming", "org.cip4.jdflib.resource.process.JDFIDPTrimming");
            this.sm_PackageNames.put("ImageCompression", "org.cip4.jdflib.resource.JDFImageCompression");
            this.sm_PackageNames.put("ImageCompressionParams", "org.cip4.jdflib.resource.process.JDFImageCompressionParams");
            this.sm_PackageNames.put("ImageReplacementParams", "org.cip4.jdflib.resource.process.JDFImageReplacementParams");
            this.sm_PackageNames.put("ImageEnhancementOp", "org.cip4.jdflib.resource.process.JDFImageEnhancementOp");
            this.sm_PackageNames.put("ImageEnhancementParams", "org.cip4.jdflib.resource.process.JDFImageEnhancementParams");
            this.sm_PackageNames.put("ImageSetterParams", "org.cip4.jdflib.resource.process.JDFImageSetterParams");
            this.sm_PackageNames.put("ImageShift", "org.cip4.jdflib.resource.JDFImageShift");
            this.sm_PackageNames.put("ImageSize", "org.cip4.jdflib.span.JDFXYPairSpan");
            this.sm_PackageNames.put("ImagesResultsPool", "org.cip4.jdflib.resource.process.JDFImagesResultsPool");
            this.sm_PackageNames.put("ImageStrategy", "org.cip4.jdflib.span.JDFSpanImageStrategy");
            this.sm_PackageNames.put("Ink", "org.cip4.jdflib.resource.process.prepress.JDFInk");
            this.sm_PackageNames.put("InkManufacturer", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("InkZoneCalculationParams", "org.cip4.jdflib.resource.process.prepress.JDFInkZoneCalculationParams");
            this.sm_PackageNames.put("InkZoneProfile", "org.cip4.jdflib.resource.process.prepress.JDFInkZoneProfile");
            this.sm_PackageNames.put("Insert", "org.cip4.jdflib.resource.JDFInsert");
            this.sm_PackageNames.put("InsertingIntent", "org.cip4.jdflib.resource.intent.JDFInsertingIntent");
            this.sm_PackageNames.put("InsertingParams", "org.cip4.jdflib.resource.JDFInsertingParams");
            this.sm_PackageNames.put("InsertList", "org.cip4.jdflib.resource.JDFInsertList");
            this.sm_PackageNames.put("InsertSheet", "org.cip4.jdflib.resource.process.JDFInsertSheet");
            this.sm_PackageNames.put("IntegerEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFIntegerEvaluation");
            this.sm_PackageNames.put("IntegerState", "org.cip4.jdflib.resource.devicecapability.JDFIntegerState");
            this.sm_PackageNames.put("IntentResource", "org.cip4.jdflib.resource.intent.JDFIntentResource");
            this.sm_PackageNames.put("InterpretedPDLData", "org.cip4.jdflib.resource.process.JDFInterpretedPDLData");
            this.sm_PackageNames.put("InterpretingDetails", "org.cip4.jdflib.resource.process.prepress.JDFInterpretingDetails");
            this.sm_PackageNames.put("InterpretingParams", "org.cip4.jdflib.resource.JDFInterpretingParams");
            this.sm_PackageNames.put("IsPresentEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFIsPresentEvaluation");
            this.sm_PackageNames.put("IssueDate", "org.cip4.jdflib.span.JDFTimeSpan");
            this.sm_PackageNames.put("IssueName", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("IssueType", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("Jacket", "org.cip4.jdflib.span.JDFSpanJacket");
            this.sm_PackageNames.put("JacketFoldingWidth", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("JacketingParams", "org.cip4.jdflib.resource.JDFJacketingParams");
            this.sm_PackageNames.put("JapanBind", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("JBIG2Params", "org.cip4.jdflib.resource.process.JDFJBIG2Params");
            this.sm_PackageNames.put("JDFController", "org.cip4.jdflib.jmf.JDFJDFController");
            this.sm_PackageNames.put("JDFService", "org.cip4.jdflib.jmf.JDFJDFService");
            this.sm_PackageNames.put("JobField", "org.cip4.jdflib.resource.JDFJobField");
            this.sm_PackageNames.put("JobPhase", "org.cip4.jdflib.jmf.JDFJobPhase");
            this.sm_PackageNames.put("JobSheet", "org.cip4.jdflib.resource.JDFJobSheet");
            this.sm_PackageNames.put("JPEG2000Params", "org.cip4.jdflib.resource.process.JDFJPEG2000Params");
            this.sm_PackageNames.put("KnownMsgQuParams", "org.cip4.jdflib.jmf.JDFKnownMsgQuParams");
            this.sm_PackageNames.put("LabelingParams", "org.cip4.jdflib.resource.JDFLabelingParams");
            this.sm_PackageNames.put("Laminated", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("LaminatingIntent", "org.cip4.jdflib.resource.intent.JDFLaminatingIntent");
            this.sm_PackageNames.put("LaminatingParams", "org.cip4.jdflib.resource.JDFLaminatingParams");
            this.sm_PackageNames.put("LayerDetails", "org.cip4.jdflib.resource.JDFLayerDetails");
            this.sm_PackageNames.put("LayerList", "org.cip4.jdflib.resource.JDFLayerList");
            this.sm_PackageNames.put("Layout", "org.cip4.jdflib.resource.process.JDFLayout");
            this.sm_PackageNames.put("LayoutElement", "org.cip4.jdflib.resource.process.JDFLayoutElement");
            this.sm_PackageNames.put("LayoutElementPart", "org.cip4.jdflib.resource.process.JDFLayoutElementPart");
            this.sm_PackageNames.put("LayoutElementProductionParams", "org.cip4.jdflib.resource.process.JDFLayoutElementProductionParams");
            this.sm_PackageNames.put("LayoutIntent", "org.cip4.jdflib.resource.intent.JDFLayoutIntent");
            this.sm_PackageNames.put("LayoutPreparationParams", "org.cip4.jdflib.resource.JDFLayoutPreparationParams");
            this.sm_PackageNames.put("LayoutShift", "org.cip4.jdflib.resource.process.JDFLayoutShift");
            this.sm_PackageNames.put("Level", "org.cip4.jdflib.span.JDFSpanLevel");
            this.sm_PackageNames.put("Loc", "org.cip4.jdflib.resource.devicecapability.JDFLoc");
            this.sm_PackageNames.put("Location", "org.cip4.jdflib.resource.JDFLocation");
            this.sm_PackageNames.put("LogicalStackParams", "org.cip4.jdflib.resource.process.JDFLogicalStackParams");
            this.sm_PackageNames.put("LongFold", "org.cip4.jdflib.resource.process.JDFLongFold");
            this.sm_PackageNames.put("LongGlue", "org.cip4.jdflib.resource.process.JDFLongGlue");
            this.sm_PackageNames.put("LongitudinalRibbonOperationParams", "org.cip4.jdflib.resource.process.JDFLongitudinalRibbonOperationParams");
            this.sm_PackageNames.put("LongPerforate", "org.cip4.jdflib.resource.process.JDFLongPerforate");
            this.sm_PackageNames.put("LongSlit", "org.cip4.jdflib.resource.process.JDFLongSlit");
            this.sm_PackageNames.put("Lot", "org.cip4.jdflib.resource.process.JDFLot");
            this.sm_PackageNames.put("LZWParams", "org.cip4.jdflib.resource.process.JDFLZWParams");
            this.sm_PackageNames.put("macro", "org.cip4.jdflib.resource.devicecapability.JDFmacro");
            this.sm_PackageNames.put("MacroPool", "org.cip4.jdflib.resource.devicecapability.JDFMacroPool");
            this.sm_PackageNames.put("ManualLaborParams", "org.cip4.jdflib.resource.process.JDFManualLaborParams");
            this.sm_PackageNames.put("MarkObject", "org.cip4.jdflib.resource.JDFMarkObject");
            this.sm_PackageNames.put("MarkActivation", "org.cip4.jdflib.resource.JDFMarkActivation");
            this.sm_PackageNames.put("Material", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("MatrixEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFMatrixEvaluation");
            this.sm_PackageNames.put("MatrixState", "org.cip4.jdflib.resource.devicecapability.JDFMatrixState");
            this.sm_PackageNames.put("Media", "org.cip4.jdflib.resource.process.JDFMedia");
            this.sm_PackageNames.put("MediaColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("MediaColorDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("MediaIntent", "org.cip4.jdflib.resource.intent.JDFMediaIntent");
            this.sm_PackageNames.put("MediaLayers", "org.cip4.jdflib.resource.process.JDFMediaLayers");
            this.sm_PackageNames.put("MediaQuality", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("MediaSource", "org.cip4.jdflib.resource.process.JDFMediaSource");
            this.sm_PackageNames.put("MediaType", "org.cip4.jdflib.span.JDFSpanMediaType");
            this.sm_PackageNames.put("MediaTypeDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("MediaUnit", "org.cip4.jdflib.span.JDFSpanMediaUnit");
            this.sm_PackageNames.put("Merged", "org.cip4.jdflib.resource.JDFMerged");
            this.sm_PackageNames.put("Message", "org.cip4.jdflib.jmf.JDFMessage");
            this.sm_PackageNames.put("MessageService", "org.cip4.jdflib.jmf.JDFMessageService");
            this.sm_PackageNames.put("MetadataMap", "org.cip4.jdflib.resource.process.JDFMetadataMap");
            this.sm_PackageNames.put("Milestone", "org.cip4.jdflib.resource.JDFMilestone");
            this.sm_PackageNames.put("MiscConsumable", "org.cip4.jdflib.resource.process.JDFMiscConsumable");
            this.sm_PackageNames.put("MISDetails", "org.cip4.jdflib.resource.process.JDFMISDetails");
            this.sm_PackageNames.put("Modified", "org.cip4.jdflib.resource.JDFModified");
            this.sm_PackageNames.put("ModifyNodeCmdParams", "org.cip4.jdflib.jmf.JDFModifyNodeCmdParams");
            this.sm_PackageNames.put("Module", "org.cip4.jdflib.resource.devicecapability.JDFModule");
            this.sm_PackageNames.put("ModuleCap", "org.cip4.jdflib.resource.devicecapability.JDFModuleCap");
            this.sm_PackageNames.put("ModulePhase", "org.cip4.jdflib.resource.JDFModulePhase");
            this.sm_PackageNames.put("ModulePool", "org.cip4.jdflib.resource.devicecapability.JDFModulePool");
            this.sm_PackageNames.put("ModuleStatus", "org.cip4.jdflib.resource.JDFModuleStatus");
            this.sm_PackageNames.put("MoveResource", "org.cip4.jdflib.jmf.JDFMoveResource");
            this.sm_PackageNames.put("MsgFilter", "org.cip4.jdflib.jmf.JDFMsgFilter");
            this.sm_PackageNames.put("NameEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFNameEvaluation");
            this.sm_PackageNames.put("NameState", "org.cip4.jdflib.resource.devicecapability.JDFNameState");
            this.sm_PackageNames.put("NewComment", "org.cip4.jdflib.jmf.JDFNewComment");
            this.sm_PackageNames.put("NewJDFCmdParams", "org.cip4.jdflib.jmf.JDFNewJDFCmdParams");
            this.sm_PackageNames.put("NewJDFQuParams", "org.cip4.jdflib.jmf.JDFNewJDFQuParams");
            this.sm_PackageNames.put("NodeInfo", "org.cip4.jdflib.core.JDFNodeInfo");
            this.sm_PackageNames.put("NodeInfoCmdParams", "org.cip4.jdflib.jmf.JDFNodeInfoCmdParams");
            this.sm_PackageNames.put("NodeInfoQuParams", "org.cip4.jdflib.jmf.JDFNodeInfoQuParams");
            this.sm_PackageNames.put("NodeInfoResp", "org.cip4.jdflib.jmf.JDFNodeInfoResp");
            this.sm_PackageNames.put("not", "org.cip4.jdflib.resource.devicecapability.JDFnot");
            this.sm_PackageNames.put("Notification", "org.cip4.jdflib.resource.JDFNotification");
            this.sm_PackageNames.put("NotificationDef", "org.cip4.jdflib.jmf.JDFNotificationDef");
            this.sm_PackageNames.put("NotificationFilter", "org.cip4.jdflib.resource.process.JDFNotificationFilter");
            this.sm_PackageNames.put("NumberEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFNumberEvaluation");
            this.sm_PackageNames.put("NumberingIntent", "org.cip4.jdflib.resource.intent.JDFNumberingIntent");
            this.sm_PackageNames.put("NumberingParam", "org.cip4.jdflib.resource.process.JDFNumberingParam");
            this.sm_PackageNames.put("NumberingParams", "org.cip4.jdflib.resource.JDFNumberingParams");
            this.sm_PackageNames.put("NumberItem", "org.cip4.jdflib.resource.JDFNumberItem");
            this.sm_PackageNames.put("NumberState", "org.cip4.jdflib.resource.devicecapability.JDFNumberState");
            this.sm_PackageNames.put("ObjectModel", "org.cip4.jdflib.resource.process.JDFObjectModel");
            this.sm_PackageNames.put("ObjectResolution", "org.cip4.jdflib.resource.process.JDFObjectResolution");
            this.sm_PackageNames.put("ObservationTarget", "org.cip4.jdflib.resource.JDFObservationTarget");
            this.sm_PackageNames.put("Occupation", "org.cip4.jdflib.jmf.JDFOccupation");
            this.sm_PackageNames.put("OCGControl", "org.cip4.jdflib.resource.process.JDFOCGControl");
            this.sm_PackageNames.put("OfferRange", "org.cip4.jdflib.core.JDFComment");
            this.sm_PackageNames.put("Opacity", "org.cip4.jdflib.span.JDFSpanOpacity");
            this.sm_PackageNames.put("OpacityLevel", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("or", "org.cip4.jdflib.resource.devicecapability.JDFor");
            this.sm_PackageNames.put("OrderingParams", "org.cip4.jdflib.resource.process.JDFOrderingParams");
            this.sm_PackageNames.put("OrganizationalUnit", "org.cip4.jdflib.core.JDFComment");
            this.sm_PackageNames.put("Orientation", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("otherwise", "org.cip4.jdflib.resource.devicecapability.JDFotherwise");
            this.sm_PackageNames.put("Overage", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("PackingIntent", "org.cip4.jdflib.resource.intent.JDFPackingIntent");
            this.sm_PackageNames.put("PackingParams", "org.cip4.jdflib.resource.process.JDFPackingParams");
            this.sm_PackageNames.put("PageAssignedList", "org.cip4.jdflib.resource.process.JDFPageAssignedList");
            this.sm_PackageNames.put("PageAssignParams", "org.cip4.jdflib.resource.process.JDFPageAssignParams");
            this.sm_PackageNames.put("PageCell", "org.cip4.jdflib.resource.JDFPageCell");
            this.sm_PackageNames.put("PageCondition", "org.cip4.jdflib.resource.JDFPageCondition");
            this.sm_PackageNames.put("PageData", "org.cip4.jdflib.resource.process.JDFPageData");
            this.sm_PackageNames.put("PageElement", "org.cip4.jdflib.resource.process.JDFPageElement");
            this.sm_PackageNames.put("PageList", "org.cip4.jdflib.resource.JDFPageList");
            this.sm_PackageNames.put("Pages", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("PagesResultsPool", "org.cip4.jdflib.resource.process.prepress.JDFPagesResultsPool");
            this.sm_PackageNames.put("PageVariance", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("Pallet", "org.cip4.jdflib.resource.JDFPallet");
            this.sm_PackageNames.put("PalletCornerBoards", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("PalletizingParams", "org.cip4.jdflib.resource.JDFPalletizingParams");
            this.sm_PackageNames.put("PalletMaxHeight", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("PalletMaxWeight", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("PalletQuantity", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("PalletSize", "org.cip4.jdflib.span.JDFXYPairSpan");
            this.sm_PackageNames.put("PalletType", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("PalletWrapping", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("Part", "org.cip4.jdflib.resource.JDFPart");
            this.sm_PackageNames.put("PartAmount", "org.cip4.jdflib.core.JDFPartAmount");
            this.sm_PackageNames.put("PartStatus", "org.cip4.jdflib.core.JDFPartStatus");
            this.sm_PackageNames.put("Payment", "org.cip4.jdflib.resource.JDFPayment");
            this.sm_PackageNames.put("PayTerm", "org.cip4.jdflib.core.JDFComment");
            this.sm_PackageNames.put("PDFInterpretingParams", "org.cip4.jdflib.resource.JDFPDFInterpretingParams");
            this.sm_PackageNames.put("PDFPathEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFPDFPathEvaluation");
            this.sm_PackageNames.put("PDFPathState", "org.cip4.jdflib.resource.devicecapability.JDFPDFPathState");
            this.sm_PackageNames.put("PDFToPSConversionParams", "org.cip4.jdflib.resource.process.prepress.JDFPDFToPSConversionParams");
            this.sm_PackageNames.put("PDFXParams", "org.cip4.jdflib.resource.process.JDFPDFXParams");
            this.sm_PackageNames.put("PDLCreationParams", "org.cip4.jdflib.resource.process.JDFPDLCreationParams");
            this.sm_PackageNames.put("PDLResourceAlias", "org.cip4.jdflib.resource.process.prepress.JDFPDLResourceAlias");
            this.sm_PackageNames.put("Perforate", "org.cip4.jdflib.resource.process.JDFPerforate");
            this.sm_PackageNames.put("PerforatingParams", "org.cip4.jdflib.resource.JDFPerforatingParams");
            this.sm_PackageNames.put("Performance", "org.cip4.jdflib.resource.JDFPerformance");
            this.sm_PackageNames.put("Person", "org.cip4.jdflib.resource.process.JDFPerson");
            this.sm_PackageNames.put("PhaseTime", "org.cip4.jdflib.resource.JDFPhaseTime");
            this.sm_PackageNames.put("PipeParams", "org.cip4.jdflib.jmf.JDFPipeParams");
            this.sm_PackageNames.put("PixelColorant", "org.cip4.jdflib.resource.process.JDFPixelColorant");
            this.sm_PackageNames.put("PlaceHolderResource", "org.cip4.jdflib.resource.JDFPlaceHolderResource");
            this.sm_PackageNames.put("PlasticCombBinding", "org.cip4.jdflib.resource.process.postpress.JDFPlasticCombBinding");
            this.sm_PackageNames.put("PlasticCombBindingParams", "org.cip4.jdflib.resource.process.postpress.JDFPlasticCombBindingParams");
            this.sm_PackageNames.put("PlasticCombType", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("PlateCopyParams", "org.cip4.jdflib.resource.process.JDFPlateCopyParams");
            this.sm_PackageNames.put("Position", "org.cip4.jdflib.resource.process.JDFPosition");
            this.sm_PackageNames.put("PositionObj", "org.cip4.jdflib.resource.process.JDFPositionObj");
            this.sm_PackageNames.put("PreflightAction", "org.cip4.jdflib.resource.process.JDFPreflightAction");
            this.sm_PackageNames.put("PreflightAnalysis", "org.cip4.jdflib.resource.JDFPreflightAnalysis");
            this.sm_PackageNames.put("PreflightArgument", "org.cip4.jdflib.resource.process.JDFPreflightArgument");
            this.sm_PackageNames.put("PreflightConstraint", "org.cip4.jdflib.resource.process.prepress.JDFPreflightConstraint");
            this.sm_PackageNames.put("PreflightConstraintsPool", "org.cip4.jdflib.pool.JDFPreflightConstraintsPool");
            this.sm_PackageNames.put("PreflightDetail", "org.cip4.jdflib.resource.process.prepress.JDFPreflightDetail");
            this.sm_PackageNames.put("PreflightInstance", "org.cip4.jdflib.resource.process.prepress.JDFPreflightInstance");
            this.sm_PackageNames.put("PreflightInstanceDetail", "org.cip4.jdflib.resource.process.prepress.JDFPreflightInstanceDetail");
            this.sm_PackageNames.put("PreflightInventory", "org.cip4.jdflib.resource.process.prepress.JDFPreflightInventory");
            this.sm_PackageNames.put("PreflightParams", "org.cip4.jdflib.resource.process.JDFPreflightParams");
            this.sm_PackageNames.put("PreflightProfile", "org.cip4.jdflib.resource.process.prepress.JDFPreflightProfile");
            this.sm_PackageNames.put("PreflightReport", "org.cip4.jdflib.resource.process.JDFPreflightReport");
            this.sm_PackageNames.put("PreflightReportRulePool", "org.cip4.jdflib.resource.process.JDFPreflightReportRulePool");
            this.sm_PackageNames.put("PreflightResultsPool", "org.cip4.jdflib.pool.JDFPreflightResultsPool");
            this.sm_PackageNames.put("PRError", "org.cip4.jdflib.resource.process.JDFPRError");
            this.sm_PackageNames.put("Preview", "org.cip4.jdflib.resource.process.JDFPreview");
            this.sm_PackageNames.put("PreviewGenerationParams", "org.cip4.jdflib.resource.process.prepress.JDFPreviewGenerationParams");
            this.sm_PackageNames.put("PRGroup", "org.cip4.jdflib.resource.process.JDFPRGroup");
            this.sm_PackageNames.put("PRGroupOccurrence", "org.cip4.jdflib.resource.process.JDFPRGroupOccurrence");
            this.sm_PackageNames.put("Pricing", "org.cip4.jdflib.resource.intent.JDFPricing");
            this.sm_PackageNames.put("PrintCondition", "org.cip4.jdflib.resource.process.press.JDFPrintCondition");
            this.sm_PackageNames.put("PrintConditionColor", "org.cip4.jdflib.resource.process.JDFPrintConditionColor");
            this.sm_PackageNames.put("PrintPreference", "org.cip4.jdflib.span.JDFSpanPrintPreference");
            this.sm_PackageNames.put("PrintProcess", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("PrintRollingParams", "org.cip4.jdflib.resource.process.JDFPrintRollingParams");
            this.sm_PackageNames.put("PRItem", "org.cip4.jdflib.resource.process.JDFPRItem");
            this.sm_PackageNames.put("PROccurrence", "org.cip4.jdflib.resource.process.JDFPROccurrence");
            this.sm_PackageNames.put("ProcessRun", "org.cip4.jdflib.resource.JDFProcessRun");
            this.sm_PackageNames.put("ProductionIntent", "org.cip4.jdflib.resource.intent.JDFProductionIntent");
            this.sm_PackageNames.put("ProductionPath", "org.cip4.jdflib.resource.process.JDFProductionPath");
            this.sm_PackageNames.put("ProductionSubPath", "org.cip4.jdflib.resource.process.JDFProductionSubPath");
            this.sm_PackageNames.put("ProofingIntent", "org.cip4.jdflib.resource.intent.JDFProofingIntent");
            this.sm_PackageNames.put("ProofingParams", "org.cip4.jdflib.resource.process.JDFProofingParams");
            this.sm_PackageNames.put("ProofItem", "org.cip4.jdflib.resource.JDFProofItem");
            this.sm_PackageNames.put("ProofType", "org.cip4.jdflib.span.JDFSpanProofType");
            this.sm_PackageNames.put("PRRule", "org.cip4.jdflib.resource.process.JDFPRRule");
            this.sm_PackageNames.put("PRRuleAttr", "org.cip4.jdflib.resource.process.JDFPRRuleAttr");
            this.sm_PackageNames.put("PSToPDFConversionParams", "org.cip4.jdflib.resource.process.prepress.JDFPSToPDFConversionParams");
            this.sm_PackageNames.put("PublishingIntent", "org.cip4.jdflib.resource.intent.JDFPublishingIntent");
            this.sm_PackageNames.put("QualityControlParams", "org.cip4.jdflib.resource.process.JDFQualityControlParams");
            this.sm_PackageNames.put("QualityControlResult", "org.cip4.jdflib.resource.process.JDFQualityControlResult");
            this.sm_PackageNames.put("QualityMeasurement", "org.cip4.jdflib.resource.process.JDFQualityMeasurement");
            this.sm_PackageNames.put("Query", "org.cip4.jdflib.jmf.JDFQuery");
            this.sm_PackageNames.put("Queue", "org.cip4.jdflib.jmf.JDFQueue");
            this.sm_PackageNames.put("QueueEntry", "org.cip4.jdflib.jmf.JDFQueueEntry");
            this.sm_PackageNames.put("QueueEntryDef", "org.cip4.jdflib.jmf.JDFQueueEntryDef");
            this.sm_PackageNames.put("QueueEntryDefList", "org.cip4.jdflib.resource.JDFQueueEntryDefList");
            this.sm_PackageNames.put("QueueEntryPosParams", "org.cip4.jdflib.jmf.JDFQueueEntryPosParams");
            this.sm_PackageNames.put("QueueEntryPriParams", "org.cip4.jdflib.jmf.JDFQueueEntryPriParams");
            this.sm_PackageNames.put("QueueFilter", "org.cip4.jdflib.jmf.JDFQueueFilter");
            this.sm_PackageNames.put("QueueSubmissionParams", "org.cip4.jdflib.jmf.JDFQueueSubmissionParams");
            this.sm_PackageNames.put("Range", "org.cip4.jdflib.core.JDFComment");
            this.sm_PackageNames.put("RasterReadingParams", "org.cip4.jdflib.resource.process.prepress.JDFRasterReadingParams");
            this.sm_PackageNames.put("RectangleEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFRectangleEvaluation");
            this.sm_PackageNames.put("RectangleState", "org.cip4.jdflib.resource.devicecapability.JDFRectangleState");
            this.sm_PackageNames.put("Recycled", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("RecycledPercentage", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("RefAnchor", "org.cip4.jdflib.resource.JDFRefAnchor");
            this.sm_PackageNames.put("RefElement", "org.cip4.jdflib.core.JDFRefElement");
            this.sm_PackageNames.put("ReferenceXObjParams", "org.cip4.jdflib.resource.process.JDFReferenceXObjParams");
            this.sm_PackageNames.put("RegisterMark", "org.cip4.jdflib.resource.process.JDFRegisterMark");
            this.sm_PackageNames.put("RegisterRibbon", "org.cip4.jdflib.resource.JDFRegisterRibbon");
            this.sm_PackageNames.put("Registration", "org.cip4.jdflib.jmf.JDFRegistration");
            this.sm_PackageNames.put("Removed", "org.cip4.jdflib.resource.JDFRemoved");
            this.sm_PackageNames.put("RemoveLink", "org.cip4.jdflib.jmf.JDFRemoveLink");
            this.sm_PackageNames.put("RemoveQueueEntryParams", "org.cip4.jdflib.jmf.JDFRemoveQueueEntryParams");
            this.sm_PackageNames.put("RenderingParams", "org.cip4.jdflib.resource.process.prepress.JDFRenderingParams");
            this.sm_PackageNames.put("RepeatDesc", "org.cip4.jdflib.resource.process.JDFRepeatDesc");
            this.sm_PackageNames.put("RequestQueueEntryParams", "org.cip4.jdflib.jmf.JDFRequestQueueEntryParams");
            this.sm_PackageNames.put("Required", "org.cip4.jdflib.span.JDFTimeSpan");
            this.sm_PackageNames.put("RequiredDuration", "org.cip4.jdflib.span.JDFDurationSpan");
            this.sm_PackageNames.put("Resource", DocumentJDFImpl.CORE_JDFRESOURCE);
            this.sm_PackageNames.put("ResourceAudit", "org.cip4.jdflib.resource.JDFResourceAudit");
            this.sm_PackageNames.put("ResourceCmdParams", "org.cip4.jdflib.jmf.JDFResourceCmdParams");
            this.sm_PackageNames.put("ResourceDefinitionParams", "org.cip4.jdflib.resource.process.JDFResourceDefinitionParams");
            this.sm_PackageNames.put("ResourceInfo", "org.cip4.jdflib.jmf.JDFResourceInfo");
            this.sm_PackageNames.put("ResourceLink", "org.cip4.jdflib.core.JDFResourceLink");
            this.sm_PackageNames.put("ResourceLinkPool", "org.cip4.jdflib.pool.JDFResourceLinkPool");
            this.sm_PackageNames.put("ResourceParam", "org.cip4.jdflib.resource.JDFResourceParam");
            this.sm_PackageNames.put("ResourcePool", "org.cip4.jdflib.pool.JDFResourcePool");
            this.sm_PackageNames.put("ResourcePullParams", "org.cip4.jdflib.jmf.JDFResourcePullParams");
            this.sm_PackageNames.put("ResourceQuParams", "org.cip4.jdflib.jmf.JDFResourceQuParams");
            this.sm_PackageNames.put("Response", "org.cip4.jdflib.jmf.JDFResponse");
            this.sm_PackageNames.put("ResubmissionParams", "org.cip4.jdflib.jmf.JDFResubmissionParams");
            this.sm_PackageNames.put("ResumeQueueEntryParams", "org.cip4.jdflib.jmf.JDFResumeQueueEntryParams");
            this.sm_PackageNames.put("ReturnMethod", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("ReturnQueueEntryParams", "org.cip4.jdflib.jmf.JDFReturnQueueEntryParams");
            this.sm_PackageNames.put("RingBinding", "org.cip4.jdflib.resource.process.postpress.JDFRingBinding");
            this.sm_PackageNames.put("RingBindingParams", "org.cip4.jdflib.resource.process.postpress.JDFRingBindingParams");
            this.sm_PackageNames.put("RingDiameter", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("RingMechanic", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("RingShape", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("RingSystem", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("RivetsExposed", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("RollStand", "org.cip4.jdflib.resource.process.JDFRollStand");
            this.sm_PackageNames.put("RuleLength", "org.cip4.jdflib.resource.process.JDFRuleLength");
            this.sm_PackageNames.put("RunList", "org.cip4.jdflib.resource.process.JDFRunList");
            this.sm_PackageNames.put("SaddleStitching", "org.cip4.jdflib.resource.process.postpress.JDFSaddleStitching");
            this.sm_PackageNames.put("SaddleStitchingParams", "org.cip4.jdflib.resource.process.postpress.JDFSaddleStitchingParams");
            this.sm_PackageNames.put("ScanParams", "org.cip4.jdflib.resource.process.prepress.JDFScanParams");
            this.sm_PackageNames.put("ScavengerArea", "org.cip4.jdflib.resource.JDFScavengerArea");
            this.sm_PackageNames.put("Score", "org.cip4.jdflib.resource.process.postpress.JDFScore");
            this.sm_PackageNames.put("Scoring", "org.cip4.jdflib.span.JDFSpanScoring");
            this.sm_PackageNames.put("ScreeningParams", "org.cip4.jdflib.resource.process.prepress.JDFScreeningParams");
            this.sm_PackageNames.put("ScreeningIntent", "org.cip4.jdflib.resource.intent.JDFScreeningIntent");
            this.sm_PackageNames.put("ScreeningType", "org.cip4.jdflib.span.JDFSpanScreeningType");
            this.sm_PackageNames.put("ScreenSelector", "org.cip4.jdflib.resource.process.JDFScreenSelector");
            this.sm_PackageNames.put("Sealing", "org.cip4.jdflib.resource.process.JDFSealing");
            this.sm_PackageNames.put("SearchPath", "org.cip4.jdflib.core.JDFComment");
            this.sm_PackageNames.put("SeparationControlParams", "org.cip4.jdflib.resource.process.JDFSeparationControlParams");
            this.sm_PackageNames.put("SeparationList", "org.cip4.jdflib.core.JDFSeparationList");
            this.sm_PackageNames.put("SeparationSpec", "org.cip4.jdflib.resource.process.JDFSeparationSpec");
            this.sm_PackageNames.put("ServiceLevel", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("set", "org.cip4.jdflib.resource.devicecapability.JDFset");
            this.sm_PackageNames.put("ShapeCut", "org.cip4.jdflib.resource.intent.JDFShapeCut");
            this.sm_PackageNames.put("ShapeCuttingIntent", "org.cip4.jdflib.resource.intent.JDFShapeCuttingIntent");
            this.sm_PackageNames.put("ShapeCuttingParams", "org.cip4.jdflib.resource.JDFShapeCuttingParams");
            this.sm_PackageNames.put("ShapeDef", "org.cip4.jdflib.resource.process.JDFShapeDef");
            this.sm_PackageNames.put("ShapeDefProductionParams", "org.cip4.jdflib.resource.process.JDFShapeDefProductionParams");
            this.sm_PackageNames.put("ShapeDepth", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("ShapeEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFShapeEvaluation");
            this.sm_PackageNames.put("ShapeState", "org.cip4.jdflib.resource.devicecapability.JDFShapeState");
            this.sm_PackageNames.put("ShapeTemplate", "org.cip4.jdflib.resource.process.JDFShapeTemplate");
            this.sm_PackageNames.put("ShapeType", "org.cip4.jdflib.span.JDFSpanShapeType");
            this.sm_PackageNames.put("Sheet", "org.cip4.jdflib.resource.process.JDFLayout");
            this.sm_PackageNames.put("SheetCondition", "org.cip4.jdflib.resource.JDFSheetCondition");
            this.sm_PackageNames.put("SheetOptimizingParams", "org.cip4.jdflib.resource.process.JDFSheetOptimizingParams");
            this.sm_PackageNames.put("ShiftPoint", "org.cip4.jdflib.resource.process.JDFShiftPoint");
            this.sm_PackageNames.put("ShrinkingParams", "org.cip4.jdflib.resource.JDFShrinkingParams");
            this.sm_PackageNames.put("ShutDownCmdParams", "org.cip4.jdflib.jmf.JDFShutDownCmdParams");
            this.sm_PackageNames.put("SideSewing", "org.cip4.jdflib.resource.process.postpress.JDFSideSewing");
            this.sm_PackageNames.put("SideSewingParams", "org.cip4.jdflib.resource.process.postpress.JDFSideSewingParams");
            this.sm_PackageNames.put("SideStitching", "org.cip4.jdflib.resource.process.postpress.JDFSideStitching");
            this.sm_PackageNames.put("Signal", "org.cip4.jdflib.jmf.JDFSignal");
            this.sm_PackageNames.put("Signature", "org.cip4.jdflib.resource.process.JDFLayout");
            this.sm_PackageNames.put("SignatureCell", "org.cip4.jdflib.resource.process.JDFSignatureCell");
            this.sm_PackageNames.put("SizeIntent", "org.cip4.jdflib.resource.intent.JDFSizeIntent");
            this.sm_PackageNames.put("SizePolicy", "org.cip4.jdflib.span.JDFSpanSizePolicy");
            this.sm_PackageNames.put("SoftCoverBinding", "org.cip4.jdflib.resource.JDFSoftCoverBinding");
            this.sm_PackageNames.put("SourceResource", "org.cip4.jdflib.resource.process.JDFSourceResource");
            this.sm_PackageNames.put("Spawned", "org.cip4.jdflib.node.JDFSpawned");
            this.sm_PackageNames.put("SpineBrushing", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("SpineFiberRoughing", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("SpineGlue", "org.cip4.jdflib.span.JDFSpanGlue");
            this.sm_PackageNames.put("SpineLevelling", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("SpineMilling", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("SpineNotching", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("SpinePreparationParams", "org.cip4.jdflib.resource.JDFSpinePreparationParams");
            this.sm_PackageNames.put("SpineSanding", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("SpineShredding", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("SpineTapingParams", "org.cip4.jdflib.resource.JDFSpineTapingParams");
            this.sm_PackageNames.put("Stack", "org.cip4.jdflib.resource.process.JDFStack");
            this.sm_PackageNames.put("StackingParams", "org.cip4.jdflib.resource.JDFStackingParams");
            this.sm_PackageNames.put("Station", "org.cip4.jdflib.resource.process.JDFStation");
            this.sm_PackageNames.put("StaticBlockingParams", "org.cip4.jdflib.resource.process.postpress.JDFStaticBlockingParams");
            this.sm_PackageNames.put("StatusPool", "org.cip4.jdflib.pool.JDFStatusPool");
            this.sm_PackageNames.put("StatusQuParams", "org.cip4.jdflib.jmf.JDFStatusQuParams");
            this.sm_PackageNames.put("StitchingParams", "org.cip4.jdflib.resource.process.postpress.JDFStitchingParams");
            this.sm_PackageNames.put("StitchNumber", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("StockBrand", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("StockType", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("StopPersChParams", "org.cip4.jdflib.jmf.JDFStopPersChParams");
            this.sm_PackageNames.put("Strap", "org.cip4.jdflib.resource.JDFStrap");
            this.sm_PackageNames.put("StrappingParams", "org.cip4.jdflib.resource.JDFStrappingParams");
            this.sm_PackageNames.put("StringEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFStringEvaluation");
            this.sm_PackageNames.put("StringListValue", "org.cip4.jdflib.resource.process.JDFStringListValue");
            this.sm_PackageNames.put("StringState", "org.cip4.jdflib.resource.devicecapability.JDFStringState");
            this.sm_PackageNames.put("StripBinding", "org.cip4.jdflib.resource.JDFStripBinding");
            this.sm_PackageNames.put("StripBindingParams", "org.cip4.jdflib.resource.process.postpress.JDFStripBindingParams");
            this.sm_PackageNames.put("StripCellParams", "org.cip4.jdflib.resource.process.JDFStripCellParams");
            this.sm_PackageNames.put("StripMark", "org.cip4.jdflib.resource.process.JDFStripMark");
            this.sm_PackageNames.put("StripMaterial", "org.cip4.jdflib.span.JDFSpanStripMaterial");
            this.sm_PackageNames.put("StrippingParams", "org.cip4.jdflib.resource.JDFStrippingParams");
            this.sm_PackageNames.put("SubmissionMethods", "org.cip4.jdflib.jmf.JDFSubmissionMethods");
            this.sm_PackageNames.put("Subscription", "org.cip4.jdflib.jmf.JDFSubscription");
            this.sm_PackageNames.put("SubscriptionFilter", "org.cip4.jdflib.jmf.JDFSubscriptionFilter");
            this.sm_PackageNames.put("SubscriptionInfo", "org.cip4.jdflib.jmf.JDFSubscriptionInfo");
            this.sm_PackageNames.put("SurplusHandling", "org.cip4.jdflib.span.JDFSpanSurplusHandling");
            this.sm_PackageNames.put("SuspendQueueEntryParams", "org.cip4.jdflib.jmf.JDFSuspendQueueEntryParams");
            this.sm_PackageNames.put("SystemTimeSet", "org.cip4.jdflib.resource.JDFSystemTimeSet");
            this.sm_PackageNames.put("TabBindMylar", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("TabBodyCopy", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("TabBrand", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("TabDimensions", "org.cip4.jdflib.resource.process.JDFTabDimensions");
            this.sm_PackageNames.put("TabExtensionDistance", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("TabExtensionMylar", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("TabMylarColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("TabMylarColorDetails", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("Tabs", "org.cip4.jdflib.resource.JDFTabs");
            this.sm_PackageNames.put("Tape", "org.cip4.jdflib.resource.JDFTape");
            this.sm_PackageNames.put("TapeBinding", "org.cip4.jdflib.span.JDFOptionSpan");
            this.sm_PackageNames.put("TapeColor", "org.cip4.jdflib.span.JDFSpanNamedColor");
            this.sm_PackageNames.put("Technology", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("TeethPerDimension", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("Temperature", "org.cip4.jdflib.span.JDFSpanTemperature");
            this.sm_PackageNames.put("Test", "org.cip4.jdflib.resource.devicecapability.JDFTest");
            this.sm_PackageNames.put("TestPool", "org.cip4.jdflib.resource.devicecapability.JDFTestPool");
            this.sm_PackageNames.put("TestRef", "org.cip4.jdflib.resource.devicecapability.JDFTestRef");
            this.sm_PackageNames.put("Texture", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("Thickness", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("ThinPDFParams", "org.cip4.jdflib.resource.process.JDFThinPDFParams");
            this.sm_PackageNames.put("ThreadSealing", "org.cip4.jdflib.resource.process.postpress.JDFThreadSealing");
            this.sm_PackageNames.put("ThreadSealingParams", "org.cip4.jdflib.resource.JDFThreadSealingParams");
            this.sm_PackageNames.put("ThreadSewing", "org.cip4.jdflib.resource.process.postpress.JDFThreadSewing");
            this.sm_PackageNames.put("ThreadSewingParams", "org.cip4.jdflib.resource.process.postpress.JDFThreadSewingParams");
            this.sm_PackageNames.put("TIFFEmbeddedFile", "org.cip4.jdflib.resource.process.JDFTIFFEmbeddedFile");
            this.sm_PackageNames.put("TIFFFormatParams", "org.cip4.jdflib.resource.process.JDFTIFFFormatParams");
            this.sm_PackageNames.put("TIFFtag", "org.cip4.jdflib.resource.process.JDFTIFFtag");
            this.sm_PackageNames.put("TightBacking", "org.cip4.jdflib.span.JDFSpanTightBacking");
            this.sm_PackageNames.put("Tile", "org.cip4.jdflib.resource.process.JDFTile");
            this.sm_PackageNames.put("Tool", "org.cip4.jdflib.resource.JDFTool");
            this.sm_PackageNames.put("TrackFilter", "org.cip4.jdflib.jmf.JDFTrackFilter");
            this.sm_PackageNames.put("TrackResult", "org.cip4.jdflib.jmf.JDFTrackResult");
            this.sm_PackageNames.put("Transfer", "org.cip4.jdflib.span.JDFSpanTransfer");
            this.sm_PackageNames.put("TransferCurve", "org.cip4.jdflib.resource.process.JDFTransferCurve");
            this.sm_PackageNames.put("TransferCurvePool", "org.cip4.jdflib.resource.process.JDFTransferCurvePool");
            this.sm_PackageNames.put("TransferCurveSet", "org.cip4.jdflib.resource.process.JDFTransferCurveSet");
            this.sm_PackageNames.put("TransferFunctionControl", "org.cip4.jdflib.resource.JDFTransferFunctionControl");
            this.sm_PackageNames.put("TrappingDetails", "org.cip4.jdflib.resource.process.prepress.JDFTrappingDetails");
            this.sm_PackageNames.put("TrappingOrder", "org.cip4.jdflib.resource.process.prepress.JDFTrappingOrder");
            this.sm_PackageNames.put("TrappingParams", "org.cip4.jdflib.resource.process.prepress.JDFTrappingParams");
            this.sm_PackageNames.put("TrapRegion", "org.cip4.jdflib.resource.process.JDFTrapRegion");
            this.sm_PackageNames.put("Trigger", "org.cip4.jdflib.jmf.JDFTrigger");
            this.sm_PackageNames.put("TrimmingParams", "org.cip4.jdflib.resource.process.postpress.JDFTrimmingParams");
            this.sm_PackageNames.put("Underage", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("UpdateJDFCmdParams", "org.cip4.jdflib.jmf.JDFUpdateJDFCmdParams");
            this.sm_PackageNames.put("UsageCounter", "org.cip4.jdflib.resource.process.JDFUsageCounter");
            this.sm_PackageNames.put("USWeight", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("Value", "org.cip4.jdflib.resource.JDFValue");
            this.sm_PackageNames.put("ValueLoc", "org.cip4.jdflib.resource.devicecapability.JDFValueLoc");
            this.sm_PackageNames.put("VarnishingParams", "org.cip4.jdflib.resource.JDFVarnishingParams");
            this.sm_PackageNames.put("VeloBinding", "org.cip4.jdflib.resource.process.postpress.JDFVeloBinding");
            this.sm_PackageNames.put("VerificationParams", "org.cip4.jdflib.resource.JDFVerificationParams");
            this.sm_PackageNames.put("ViewBinder", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("WakeUpCmdParams", "org.cip4.jdflib.jmf.JDFWakeUpCmdParams");
            this.sm_PackageNames.put("WebInlineFinishingParams", "org.cip4.jdflib.resource.process.postpress.JDFWebInlineFinishingParams");
            this.sm_PackageNames.put("Weight", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("when", "org.cip4.jdflib.resource.devicecapability.JDFwhen");
            this.sm_PackageNames.put("WindingParams", "org.cip4.jdflib.resource.process.postpress.JDFWindingParams");
            this.sm_PackageNames.put("WireCombBinding", "org.cip4.jdflib.resource.process.postpress.JDFWireCombBinding");
            this.sm_PackageNames.put("WireCombBindingParams", "org.cip4.jdflib.resource.process.postpress.JDFWireCombBindingParams");
            this.sm_PackageNames.put("WireCombBrand", "org.cip4.jdflib.span.JDFStringSpan");
            this.sm_PackageNames.put("WireCombMaterial", "org.cip4.jdflib.span.JDFSpanWireCombMaterial");
            this.sm_PackageNames.put("WireCombShape", "org.cip4.jdflib.span.JDFSpanWireCombShape");
            this.sm_PackageNames.put("WrappedQuantity", "org.cip4.jdflib.span.JDFIntegerSpan");
            this.sm_PackageNames.put("WrappingMaterial", "org.cip4.jdflib.span.JDFNameSpan");
            this.sm_PackageNames.put("WrappingParams", "org.cip4.jdflib.resource.JDFWrappingParams");
            this.sm_PackageNames.put("xor", "org.cip4.jdflib.resource.devicecapability.JDFxor");
            this.sm_PackageNames.put("XPosition", "org.cip4.jdflib.span.JDFNumberSpan");
            this.sm_PackageNames.put("XYPairEvaluation", "org.cip4.jdflib.resource.devicecapability.JDFXYPairEvaluation");
            this.sm_PackageNames.put("XYPairState", "org.cip4.jdflib.resource.devicecapability.JDFXYPairState");
            this.sm_PackageNames.put("YPosition", "org.cip4.jdflib.span.JDFNumberSpan");
        }

        public DocumentData() {
            this.fillPackages();
            this.fillContextSensitive();
        }
    }
}

