/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class VString
extends Vector<String> {
    private static final long serialVersionUID = 1L;
    public static final VString emptyVector = new VString();

    public VString() {
    }

    public VString(Vector<String> m) {
        if (m != null) {
            this.addAll(m);
        }
    }

    @Deprecated
    public VString(String strIn) {
        this(strIn, null);
    }

    public static VString getVString(String strIn, String strSep) {
        return StringUtil.getNonEmpty(strIn) == null ? null : new VString(strIn, strSep);
    }

    public VString(String strIn, String strSep) {
        if (!StringUtil.isEmpty(strIn)) {
            if (strSep == null) {
                strSep = " ";
            }
            if (strSep.length() == 1 && strIn.indexOf(strSep) < 0) {
                this.addElement(strIn);
                return;
            }
            StringTokenizer sToken = new StringTokenizer(strIn, strSep);
            while (sToken.hasMoreTokens()) {
                this.addElement(sToken.nextToken());
            }
        }
    }

    public VString(String[] a) {
        super(a == null ? 0 : a.length);
        int l = a == null ? 0 : a.length;
        for (int i = 0; i < l; ++i) {
            this.add(a[i]);
        }
    }

    public VString(Enumeration<String> a) {
        while (a.hasMoreElements()) {
            this.add(a.nextElement());
        }
    }

    @Deprecated
    public String stringAt(int index) {
        return this.get(index);
    }

    @Override
    public String elementAt(int index) {
        if (index < 0) {
            index += this.size();
        }
        return (String)super.elementAt(index);
    }

    @Override
    public String get(int index) {
        if (index < 0) {
            index += this.size();
        }
        return index >= 0 && index < this.size() ? (String)super.get(index) : null;
    }

    @Override
    public String toString() {
        return "vString[ --> " + super.toString() + " ]";
    }

    @Deprecated
    public String getAllStrings(String strSep) {
        return StringUtil.setvString(this, strSep, null, null);
    }

    @Deprecated
    public String getAllStrings() {
        return StringUtil.setvString(this, " ", null, null);
    }

    public void setAllStrings(String strIn, String strSep) {
        if (strIn != null && strSep != null) {
            this.clear();
            StringTokenizer sToken = new StringTokenizer(strIn, strSep);
            while (sToken.hasMoreTokens()) {
                this.addElement(sToken.nextToken());
            }
        }
    }

    public int index(String s) {
        if (s == null) {
            return -1;
        }
        int siz = this.size();
        for (int i = 0; i < siz; ++i) {
            if (!s.equals(super.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public boolean hasString(String s) {
        return this.index(s) >= 0;
    }

    public void appendUnique(String string) {
        if (string != null && !this.contains(string)) {
            this.addElement(string);
        }
    }

    public void appendUnique(VString v) {
        if (v != null && v.size() > 0) {
            int size = v.size();
            if (size == 1) {
                String theOther = v.elementAt(0);
                if (!this.contains(theOther)) {
                    this.add(theOther);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    this.add(v.elementAt(i));
                }
                this.unify();
            }
        }
    }

    @Deprecated
    public void removeStrings(VString v) {
        this.removeStrings(v, Integer.MAX_VALUE);
    }

    public void removeStrings(VString v, int nMax) {
        if (v == null || v.size() == 0) {
            return;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!v.contains(this.elementAt(i))) continue;
            this.removeElementAt(i);
            if (--nMax == 0) break;
        }
    }

    @Deprecated
    public void removeStrings(String s) {
        this.removeStrings(s, Integer.MAX_VALUE);
    }

    public void removeStrings(String s, int nMax) {
        if (s == null) {
            return;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!s.equals(this.get(i))) continue;
            this.removeElementAt(i);
            if (--nMax == 0) break;
        }
    }

    @Deprecated
    public String getString(String sep, String front, String back) {
        return StringUtil.setvString(this, sep, front, back);
    }

    @Deprecated
    public String setvString(VString v, String sep, String front, String end) {
        String s = front == null ? "" : front;
        int siz = v.size();
        for (int i = 0; i < siz; ++i) {
            if (i != 0) {
                s = s + sep;
            }
            s = s + v.elementAt(i);
        }
        if (end != null) {
            s = s + end;
        }
        return s;
    }

    public void unify() {
        ContainerUtil.unify(this);
    }

    public String get(String s) {
        if (this.contains(s)) {
            int i = this.indexOf(s);
            return this.get(i);
        }
        return null;
    }

    public Set<String> getSet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            set.add((String)it.next());
        }
        return set;
    }

    public void sort() {
        Object[] array = this.elementData;
        Arrays.sort(array, 0, this.size());
    }

    public void addAll(String[] strings) {
        this.ensureCapacity(this.size() + strings.length);
        for (String string : strings) {
            this.add(string);
        }
    }

    public boolean containsAny(VString others) {
        if (others == null) {
            return false;
        }
        for (String other : others) {
            if (!this.contains(other)) continue;
            return true;
        }
        return false;
    }

    public VString getOverlapping(VString others) {
        if (others == null) {
            return null;
        }
        VString ret = new VString();
        for (String s : this) {
            if (!others.contains(s)) continue;
            ret.add(s);
        }
        return ret.size() > 0 ? ret : null;
    }

    @Override
    public boolean add(ValuedEnum enumType) {
        return super.add(enumType.getName());
    }

    @Override
    public synchronized String remove(int index) {
        if (index < 0) {
            index += this.size();
        }
        return (String)super.remove(index);
    }
}

