/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XMLParser;
import org.cip4.jdflib.util.StringUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private KElement root;
    XMLParser parser;
    InputSource src;
    private final Log log;
    private static boolean wantLog = true;

    protected static boolean isWantLog() {
        return wantLog;
    }

    protected static void setWantLog(boolean wantLog) {
        XMLErrorHandler.wantLog = wantLog;
    }

    public XMLErrorHandler() {
        this.reset();
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public void warning(SAXParseException exception) {
        String warn = this.getErrorMsg(exception);
        KElement kEl = this.root.appendElement("Warning");
        kEl.setAttribute("Message", warn);
        this.parser.m_lastExcept = exception;
        if (wantLog) {
            this.log.warn((Object)warn);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        String er = this.getErrorMsg(exception);
        this.parser.m_lastExcept = exception;
        if (er.indexOf("http://www.CIP4.org/JDFSchema") != -1 || er.indexOf("is not declared for") == -1) {
            KElement kEl = this.root.appendElement("Error");
            kEl.setAttribute("Message", er);
            if (wantLog) {
                this.log.error((Object)("Parser error: " + er));
            }
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        String er = this.getErrorMsg(exception);
        KElement kEl = this.root.appendElement("FatalError");
        kEl.setAttribute("Message", er);
        this.parser.m_lastExcept = exception;
        if (wantLog) {
            this.log.fatal((Object)er);
        }
        throw new JDFException("Fatal error in the Parser: " + er);
    }

    private String getErrorMsg(SAXParseException exception) {
        String er = exception.getMessage();
        if (this.src != null) {
            String sysID = StringUtil.getNonEmpty(this.src.getSystemId());
            er = er + " src=" + sysID;
        }
        return er;
    }

    public XMLDoc getXMLOutput() {
        return this.root.getOwnerDocument_KElement();
    }

    public void cleanXML(String schemaLocation) {
        VElement v = this.root.getChildElementVector(null, null, null, true, 0, false);
        int vSize = v.size();
        v.unifyElement();
        int vSizeAfter = v.size();
        if (vSizeAfter < vSize) {
            this.root.removeChildren(null, null, null);
            for (KElement e : v) {
                this.root.appendChild(e);
            }
        }
        if (schemaLocation == null) {
            this.root.setAttribute("ValidationResult", "NotPerformed");
        } else {
            this.root.setAttribute("SchemaLocation", schemaLocation);
            if (this.root.hasChildElement("FatalError", null)) {
                this.root.setAttribute("ValidationResult", "FatalError");
            } else if (this.root.hasChildElement("Error", null)) {
                this.root.setAttribute("ValidationResult", "Error");
            } else if (this.root.hasChildElement("Warning", null)) {
                this.root.setAttribute("ValidationResult", "Warning");
            } else {
                this.root.setAttribute("ValidationResult", "Valid");
            }
        }
    }

    public String toString() {
        return "XMLErrorHandler: " + this.root + " input= " + this.src;
    }

    public void setParser(XMLParser parser) {
        this.parser = parser;
    }

    public void setInputSource(InputSource inSource) {
        this.src = inSource;
    }

    public void reset() {
        this.root = new XMLDoc("SchemaValidationOutput", null).getRoot();
        this.src = null;
    }
}

