/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.util.StringUtil;

public class JDFNumberList
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public JDFNumberList() {
    }

    public JDFNumberList(String s) throws DataFormatException {
        super(s);
    }

    public static JDFNumberList createNumberList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFNumberList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public JDFNumberList(Vector v) throws DataFormatException {
        super(v);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public void add(double x) {
        this.add(Double.valueOf(x));
    }

    public void add(String s) throws DataFormatException {
        StringTokenizer sToken = new StringTokenizer(s, " ");
        while (sToken.hasMoreTokens()) {
            String t = sToken.nextToken();
            if (StringUtil.isNumber(t)) {
                this.add(StringUtil.parseDouble(t, 0.0));
                continue;
            }
            throw new DataFormatException("illegal double: " + t);
        }
    }

    public boolean contains(double d) {
        return this.contains((Object)d);
    }
}

