/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.IWalker;
import org.cip4.jdflib.elementwalker.IWalkerFactory;

public class BaseWalkerFactory
implements IWalkerFactory {
    protected int maxDepth = 0;
    protected final Vector<BaseWalker> vBaseWalker = new Vector();
    private final Map<String, BaseWalker> nameMap = new HashMap<String, BaseWalker>();

    @Override
    public IWalker getWalker(KElement toCheck) {
        String name;
        BaseWalker walkerByName;
        if (toCheck != null && (walkerByName = this.nameMap.get(name = toCheck.getLocalName())) != null && walkerByName.matches(toCheck)) {
            return walkerByName;
        }
        for (BaseWalker w : this.vBaseWalker) {
            if (!w.matches(toCheck)) continue;
            return w;
        }
        return null;
    }

    void addWalker(BaseWalker w) {
        int d = w.getDepth();
        this.maxDepth = d > this.maxDepth ? d : this.maxDepth;
        VString elementNames = w.getElementNames();
        if (elementNames != null) {
            for (String name : elementNames) {
                this.nameMap.put(name, w);
            }
        } else {
            this.vBaseWalker.add(w);
            Collections.sort(this.vBaseWalker);
        }
    }

    public String toString() {
        return "BasewalkerFactory " + this.maxDepth + " name walkers " + this.nameMap.keySet() + " walkers: " + this.vBaseWalker;
    }

    public Vector<BaseWalker> getBaseWalkers() {
        return this.vBaseWalker;
    }
}

