/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFSubscription;
import org.cip4.jdflib.jmf.JMFBuilder;
import org.cip4.jdflib.jmf.JMFBuilderFactory;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class MessageHelper
extends BaseXJDFHelper {
    public MessageHelper(KElement mes) {
        this.theElement = mes;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        MessageHelper.ensureHeader(this.theElement);
        VElement v = this.theElement.getChildrenByTagName("ResourceSet", null, null, false, true, 0);
        if (v != null) {
            for (KElement e : v) {
                new SetHelper(e).cleanUp();
                e.removeAttribute("ID");
                VElement vRes = e.getChildElementVector("Resource", null);
                if (vRes == null) continue;
                for (KElement res : vRes) {
                    res.removeAttribute("ID");
                }
            }
        }
    }

    static KElement ensureHeader(KElement message) {
        KElement header = message.getCreateElement("Header");
        header.appendAnchor(null);
        if (!header.hasAttribute("Time")) {
            header.setAttribute("Time", new JDFDate().getDateTimeISO());
        }
        JMFBuilder jmfBuilder = JMFBuilderFactory.getJMFBuilder("XJMF");
        if (!header.hasAttribute("DeviceID")) {
            String senderID = jmfBuilder.getSenderID();
            if (StringUtil.getNonEmpty(senderID) == null) {
                senderID = JDFJMF.getTheSenderID();
            }
            if (StringUtil.getNonEmpty(senderID) == null) {
                senderID = StringUtil.replaceString(JDFAudit.getStaticAgentName(), " ", "_");
            }
            header.setAttribute("DeviceID", senderID);
        }
        if (!header.hasAttribute("AgentName")) {
            header.setAttribute("AgentName", jmfBuilder.getAgentName());
        }
        if (!header.hasAttribute("AgentVersion")) {
            header.setAttribute("AgentVersion", jmfBuilder.getAgentVersion());
        }
        return header;
    }

    public KElement getHeader() {
        return MessageHelper.ensureHeader(this.theElement);
    }

    public int getReturnCode() {
        if (!this.isResponse()) {
            return -1;
        }
        String rc = this.getAttribute("ReturnCode");
        return StringUtil.parseInt(rc, 0);
    }

    public JDFSubscription subscribe(String url) {
        if (!this.isQuery()) {
            return null;
        }
        JDFSubscription sub = (JDFSubscription)this.getCreateElement("Subscription");
        sub.setURL(url);
        return sub;
    }

    public boolean isQuery() {
        return this.theElement != null && this.theElement.getLocalName().startsWith("Query");
    }

    public static boolean isMessage(KElement element) {
        String localName;
        String string = localName = element == null ? null : element.getLocalName();
        if (localName == null) {
            return false;
        }
        return localName.startsWith("Command") || localName.startsWith("Query") || localName.startsWith("Signal") || localName.startsWith("Response");
    }

    public boolean isCommand() {
        return this.theElement != null && this.theElement.getLocalName().startsWith("Command");
    }

    public boolean isResponse() {
        return this.theElement != null && this.theElement.getLocalName().startsWith("Response");
    }

    public boolean isSignal() {
        return this.theElement != null && this.theElement.getLocalName().startsWith("Signal");
    }

    public void setQuery(MessageHelper hQuery) {
        if (!this.isResponse() && !this.isSignal() || hQuery == null || hQuery.isResponse() || hQuery.isSignal()) {
            return;
        }
        String id = MessageHelper.ensureHeader(hQuery.theElement).appendAnchor(null);
        MessageHelper.ensureHeader(this.theElement).setAttribute("refID", id);
    }
}

