/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.MessageHelper;
import org.cip4.jdflib.extensions.MessageResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class MessagePoolHelper
extends BaseXJDFHelper {
    public MessagePoolHelper(KElement pool) {
        super(pool);
    }

    public MessageResourceHelper getMessageResourceHelper(SetHelper sh) {
        String name;
        String string = name = sh == null ? null : sh.getName();
        if (name == null) {
            return null;
        }
        VElement v = this.theElement.getXPathElementVector("*/ResourceInfo/@ResourceSet[@Name=\"" + name + "\"]", 0);
        if (v != null) {
            for (KElement e : v) {
                SetHelper thisHelper = new SetHelper(e);
                if (!ContainerUtil.equals((Object)sh.getUsage(), (Object)thisHelper.getUsage()) || !ContainerUtil.equals(sh.getProcessUsage(), thisHelper.getProcessUsage())) continue;
                KElement message = e.getParentNode_KElement().getParentNode_KElement();
                return this.newMessageResourceHelper(message);
            }
        }
        return null;
    }

    MessageResourceHelper newMessageResourceHelper(KElement message) {
        return new MessageResourceHelper(message);
    }

    public MessageResourceHelper getCreateMessageResourceHelper(SetHelper sh) {
        String name;
        String string = name = sh == null ? null : sh.getName();
        if (name == null) {
            return null;
        }
        MessageResourceHelper ah = this.getMessageResourceHelper(sh);
        if (ah == null) {
            ah = new MessageResourceHelper(this.theElement.appendElement("AuditResource"));
            KElement set = ah.getRoot().appendElement("ResourceInfo").appendElement("ResourceSet");
            SetHelper shNew = new SetHelper(set);
            shNew.setName(name);
            shNew.setUsage(sh.getUsage());
            shNew.setProcessUsage(sh.getProcessUsage());
        }
        ah.cleanUp();
        return ah;
    }

    @Override
    public void cleanUp() {
        Vector<MessageHelper> vA = this.getAuditHelpers();
        if (vA != null) {
            for (MessageHelper ah : vA) {
                ah.cleanUp();
            }
        }
        super.cleanUp();
    }

    public Vector<MessageHelper> getAuditHelpers() {
        Vector<MessageHelper> vA = new Vector<MessageHelper>();
        VElement v = this.theElement.getChildElementVector(null, null);
        for (KElement e : v) {
            if ("Header".equals(e.getLocalName())) continue;
            vA.add(this.getMessageHelper(e));
        }
        return vA;
    }

    public MessageHelper getMessageHelper(KElement e) {
        if (e == null) {
            return null;
        }
        String name = e.getLocalName();
        if ("AuditResource".equals(name)) {
            return this.newMessageResourceHelper(e);
        }
        if ("SignalResource".equals(name)) {
            return this.newMessageResourceHelper(e);
        }
        if ("AuditStatus".equals(name)) {
            return new MessageHelper(e);
        }
        return new MessageHelper(e);
    }

    public MessageHelper getMessageHelper(int i) {
        Vector<MessageHelper> v = this.getAuditHelpers();
        if (v == null) {
            return null;
        }
        if (i < 0) {
            i += v.size();
        }
        if (i < 0 || i >= v.size()) {
            return null;
        }
        return v.get(i);
    }

    public MessageHelper appendMessage(String elementName) {
        if (StringUtil.isEmpty(elementName)) {
            this.log.error((Object)"Cannot append null element");
            return null;
        }
        KElement e = this.theElement.appendElement(elementName);
        MessageHelper messageHelper = this.getMessageHelper(e);
        messageHelper.cleanUp();
        return messageHelper;
    }
}

