/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;

public class IDRemover
extends BaseElementWalker {
    final Map<String, KElement> theMap = new HashMap<String, KElement>();
    final Set<String> refSet = new HashSet<String>();

    public IDRemover() {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
    }

    public void removeIDs(KElement e) {
        this.walkTree(e, null);
        for (String ref : this.refSet) {
            this.theMap.remove(ref);
        }
        for (KElement eId : this.theMap.values()) {
            eId.removeAttribute("ID");
        }
    }

    public class WalkResource
    extends BaseWalker {
        public WalkResource() {
            super(IDRemover.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            JDFAttributeMap map;
            String id = e.getNonEmpty("ID");
            if (id != null) {
                IDRemover.this.theMap.put(id, e);
            }
            if ((map = e.getAttributeMap()) != null) {
                for (String key : map.keySet()) {
                    if (key.toLowerCase().endsWith("ref")) {
                        IDRemover.this.refSet.add(map.get(key));
                        continue;
                    }
                    if (key.toLowerCase().endsWith("refs")) {
                        VString v = VString.getVString(map.get(key), null);
                        if (v == null || v.isEmpty()) continue;
                        for (String val : v) {
                            IDRemover.this.refSet.add(val);
                        }
                        continue;
                    }
                    if (!"Container".endsWith(key)) continue;
                    IDRemover.this.refSet.add(map.get(key));
                }
            }
            return e;
        }
    }

    public class WalkIgnore
    extends BaseWalker {
        public WalkIgnore() {
            super(IDRemover.this.getFactory());
            ++this.depth;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return this.getElementNames().contains(toCheck.getLocalName());
        }

        @Override
        public VString getElementNames() {
            return new VString(new String[]{"Header"});
        }
    }
}

