/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.extensions.AuditPoolHelper;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.extensions.MessageResourceHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDF20;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDFDataCache;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.MiscConsumableMaker;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFHeadBandApplicationParams;
import org.cip4.jdflib.resource.JDFLaminatingParams;
import org.cip4.jdflib.resource.JDFMarkObject;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.intent.JDFArtDelivery;
import org.cip4.jdflib.resource.intent.JDFArtDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFMediaIntent;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFContentObject;
import org.cip4.jdflib.resource.process.JDFDeliveryParams;
import org.cip4.jdflib.resource.process.JDFDrop;
import org.cip4.jdflib.resource.process.JDFIdentical;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFPosition;
import org.cip4.jdflib.resource.process.JDFSignatureCell;
import org.cip4.jdflib.resource.process.JDFStripCellParams;
import org.cip4.jdflib.resource.process.postpress.JDFStitchingParams;
import org.cip4.jdflib.resource.process.postpress.JDFThreadSewingParams;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

class PostXJDFWalker
extends BaseElementWalker {
    private boolean mergeLayout;
    protected XJDFHelper newRootHelper;
    private boolean bIntentPartition;
    private boolean bDeliveryIntent;
    private boolean retainAll;
    private boolean removeSignatureName;

    boolean isMergeLayout() {
        return this.mergeLayout;
    }

    void setMergeLayout(boolean mergeLayout) {
        this.mergeLayout = mergeLayout;
    }

    boolean isIntentPartition() {
        return this.bIntentPartition;
    }

    void setIntentPartition(boolean bIntentPartition) {
        this.bIntentPartition = bIntentPartition;
    }

    boolean isDeliveryIntent() {
        return this.bDeliveryIntent;
    }

    void setDeliveryIntent(boolean bDeliveryIntent) {
        this.bDeliveryIntent = bDeliveryIntent;
    }

    boolean isRemoveSignatureName() {
        return this.removeSignatureName;
    }

    void setRemoveSignatureName(boolean removeSignatureName) {
        this.removeSignatureName = removeSignatureName;
    }

    PostXJDFWalker(JDFElement newRoot) {
        super(new BaseWalkerFactory());
        this.newRootHelper = new XJDFHelper(newRoot);
        this.bDeliveryIntent = false;
        this.bIntentPartition = false;
        this.mergeLayout = true;
        this.removeSignatureName = true;
        this.retainAll = false;
    }

    protected boolean isRetainAll() {
        return this.retainAll;
    }

    protected void setRetainAll(boolean retainAll) {
        this.retainAll = retainAll;
        if (retainAll) {
            this.removeSignatureName = !retainAll;
            this.mergeLayout = !retainAll;
            this.bDeliveryIntent = retainAll;
        }
    }

    void moveToSender(KElement xjdf) {
        if (xjdf != null) {
            VElement v;
            JDFElement sender = (JDFElement)xjdf.getCreateElement("Header");
            sender.moveAttribute("AgentName", xjdf);
            sender.moveAttribute("AgentVersion", xjdf);
            sender.moveAttribute("Author", xjdf);
            sender.moveAttribute("DeviceID", xjdf);
            sender.moveAttribute("Time", xjdf);
            sender.moveAttribute("ICSVersions", xjdf);
            sender.moveAttribute("PersonalID", xjdf);
            sender.moveAttribute("ID", xjdf);
            sender.moveAttribute("refID", xjdf);
            if (!sender.hasAttribute("DeviceID")) {
                sender.setAttribute("DeviceID", "dummy");
            }
            if ((v = xjdf.getChildrenByTagName(null, null, new JDFAttributeMap("ID", "*"), false, true, 0)) != null) {
                for (KElement e : v) {
                    if ("Header".equals(e.getLocalName())) continue;
                    e.removeAttribute("ID");
                }
            }
            this.getFactory().getWalker(sender).walk(sender, null);
        }
    }

    @Override
    public String toString() {
        return "PostXJDFWalker [mergeLayout=" + this.mergeLayout + ", bIntentPartition=" + this.bIntentPartition + ", bDeliveryIntent=" + this.bDeliveryIntent + ", retainAll=" + this.retainAll + ", removeSignatureName=" + this.removeSignatureName + ", newRoot=" + this.newRootHelper.getRoot() + "]";
    }

    protected class WalkAudit
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            PostXJDFWalker.this.moveToSender(xjdf);
            return super.walk(xjdf, dummy);
        }

        @Override
        public boolean matches(KElement e) {
            String localName = e.getLocalName();
            return localName.startsWith("Audit") && !"AuditPool".equals(localName);
        }
    }

    protected class WalkMessage
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            PostXJDFWalker.this.moveToSender(xjdf);
            return super.walk(xjdf, dummy);
        }

        @Override
        public boolean matches(KElement e) {
            String localName = e.getLocalName();
            return localName.startsWith("Query") || localName.startsWith("Signal") || localName.startsWith("Response") || localName.startsWith("Command");
        }
    }

    protected class WalkXJMF
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return VString.getVString("XJMF", null);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            PostXJDFWalker.this.moveToSender(xjdf);
            return super.walk(xjdf, dummy);
        }
    }

    public class WalkProcessList
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "ProcessList".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (xjdf.numChildElements("Process", null) < 2) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }
    }

    public class WalkLooseBindindingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("LooseBindingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
            String typ = xjdf.getAttribute("BindingType");
            if ("CoilBinding".equals(typ)) {
                this.moveFromCoil(xjdf, mm);
            } else if ("ChannelBinding".equals(typ)) {
                this.moveFromChannel(xjdf, mm);
            }
        }

        private void moveFromCoil(KElement xjdf, MiscConsumableMaker mm) {
            mm.create("Coil", "Spine");
            mm.setTypeDetails(xjdf.getNonEmpty("Material"));
            mm.setColor(xjdf.getNonEmpty("Color"));
            mm.setColorDetails(xjdf.getNonEmpty("ColorDetails"));
            mm.setBrand(xjdf.getNonEmpty("Brand"));
            xjdf.removeAttribute("Material");
            xjdf.removeAttribute("Color");
            xjdf.removeAttribute("ColorDetails");
            xjdf.removeAttribute("Brand");
        }

        private void moveFromChannel(KElement xjdf, MiscConsumableMaker mm) {
            mm.create("ChannelBinder", "Spine");
            mm.setColor(xjdf.getNonEmpty("ClampColor"));
            mm.setColorDetails(xjdf.getNonEmpty("ClampColorDetails"));
            mm.setBrand(xjdf.getNonEmpty("Brand"));
            xjdf.removeAttribute("ClampColor");
            xjdf.removeAttribute("ClampColorDetails");
            xjdf.removeAttribute("Brand");
        }
    }

    public class WalkCustomerInfo
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("CustomerInfo", null);
        }

        @Override
        void updateAttributes(KElement xjdf) {
            super.updateAttributes(xjdf);
            xjdf.removeAttribute("ContactRefs");
        }
    }

    public class WalkStitchingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("StitchingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            JDFStitchingParams sp = (JDFStitchingParams)xjdf;
            String brand = sp.getNonEmpty("WireBrand");
            if (brand != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Wire", null);
                mm.setBrand(brand);
                String gauge = sp.getNonEmpty("WireGauge");
                mm.setTypeDetails(gauge);
                sp.removeAttribute("WireBrand");
                sp.removeAttribute("WireGauge");
            }
        }
    }

    public class WalkLaminatingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("LaminatingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            String hard;
            JDFLaminatingParams lp = (JDFLaminatingParams)xjdf;
            String adhesive = lp.getNonEmpty("AdhesiveType");
            if (adhesive != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Glue", null);
                mm.setTypeDetails(adhesive);
                lp.removeAttribute("AdhesiveType");
            }
            if ((hard = lp.getNonEmpty("HardenerType")) != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Hardener", null);
                mm.setTypeDetails(hard);
                lp.removeAttribute("HardenerType");
            }
        }
    }

    public class WalkThreadSewingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll() && toCheck instanceof JDFThreadSewingParams;
        }

        @Override
        public VString getElementNames() {
            return new VString("ThreadSewingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            String cast;
            JDFThreadSewingParams tsp = (JDFThreadSewingParams)xjdf;
            String core = tsp.getNonEmpty("CoreMaterial");
            String string = cast = core == null ? tsp.getNonEmpty("CastingMaterial") : core;
            if (cast != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Thread", null);
                mm.setTypeDetails(cast);
                tsp.removeAttribute("CoreMaterial");
                tsp.removeAttribute("CastingMaterial");
            }
        }
    }

    public class WalkHeadBandApplicationParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll() && toCheck instanceof JDFHeadBandApplicationParams;
        }

        @Override
        public VString getElementNames() {
            return new VString("HeadBandApplicationParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            this.moveHeadBand(xjdf);
            this.moveBackStrip(xjdf);
        }

        private void moveHeadBand(KElement xjdf) {
            JDFHeadBandApplicationParams hap = (JDFHeadBandApplicationParams)xjdf;
            String col = hap.getNonEmpty("TopColor");
            String brand = hap.getNonEmpty("TopBrand");
            if (col != null || brand != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("HeadBand", null);
                mm.setColor(col);
                mm.setColorDetails(hap.getNonEmpty("TopColorDetails"));
                mm.setBrand(brand);
                hap.removeAttribute("TopColor");
                hap.removeAttribute("TopColorDetails");
                hap.removeAttribute("TopBrand");
                hap.removeAttribute("BottomColor");
                hap.removeAttribute("BottomColorDetails");
                hap.removeAttribute("BottomBrand");
            }
        }

        private void moveBackStrip(KElement xjdf) {
            JDFHeadBandApplicationParams hap = (JDFHeadBandApplicationParams)xjdf;
            String mat = hap.getNonEmpty("StripMaterial");
            if (mat != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("BackStrip", null);
                mm.setTypeDetails(mat);
                hap.removeAttribute("StripMaterial");
            }
        }
    }

    public class WalkIdentical
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (xjdf instanceof JDFIdentical) {
                KElement set;
                JDFIdentical id = (JDFIdentical)xjdf;
                KElement xjdfRes = xjdf.getDeepParent("Resource", 0);
                KElement kElement = set = xjdfRes == null ? null : xjdfRes.getDeepParent("ResourceSet", 0);
                if (set != null) {
                    SetHelper sh = new SetHelper(set);
                    JDFAttributeMap trgMap = id.getPartMap();
                    ResourceHelper targetHelper = sh.getPartition(trgMap);
                    if (targetHelper != null) {
                        targetHelper.appendPartMap(new ResourceHelper(xjdfRes).getPartMap());
                    }
                    xjdfRes.deleteNode();
                }
            }
            return null;
        }

        @Override
        public VString getElementNames() {
            return new VString("Identical", null);
        }
    }

    public class WalkProduct
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Product".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.fixChildRefs(xjdf);
            return super.walk(xjdf, dummy);
        }

        private void fixChildRefs(KElement xjdf) {
            ProductHelper ph = new ProductHelper(xjdf);
            IntentHelper bind = ph.getIntent("BindingIntent");
            if (bind != null) {
                bind.getCreateResource().moveAttribute("ChildRefs", ph.getRoot());
            } else {
                IntentHelper insert = ph.getIntent("InsertingIntent");
                if (insert != null) {
                    insert.getCreateResource().moveAttribute("ChildRefs", ph.getRoot());
                }
            }
        }

        @Override
        public VString getElementNames() {
            return new VString("Product", null);
        }
    }

    public class WalkProductList
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "ProductList".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement firstProduct = xjdf.getElement("Product");
            if (firstProduct == null) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }

        @Override
        public VString getElementNames() {
            return new VString("ProductList", null);
        }
    }

    protected class WalkXJDF
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return new VString("XJDF", null);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (!PostXJDFWalker.this.retainAll) {
                this.reorderSets((JDFElement)xjdf);
                this.reorderProductList(xjdf);
            }
            super.walk(xjdf, dummy);
            return xjdf;
        }

        protected void reorderProductList(KElement xjdf) {
            KElement productList = xjdf.getElement("ProductList");
            KElement auditPool = xjdf.getElement("AuditPool");
            if (productList != null && auditPool != null) {
                xjdf.moveElement(productList, auditPool);
            }
        }

        private void reorderSets(JDFElement xjdf) {
            Vector<SetHelper> v = new XJDFHelper(xjdf).getSets();
            if (v == null) {
                return;
            }
            int n = v.size();
            int j = 0;
            while (n > 0) {
                for (int i = 0; i < v.size(); ++i) {
                    KElement e;
                    SetHelper setHelper = v.get(i);
                    KElement kElement = e = setHelper == null ? null : setHelper.getSet();
                    if (e == null) continue;
                    JDFIntegerList lcpi = null;
                    String cpi = e.getAttribute("CombinedProcessIndex", null, null);
                    try {
                        lcpi = cpi == null ? null : new JDFIntegerList(cpi);
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                    if (lcpi == null || lcpi.contains(j)) {
                        v.set(i, null);
                        --n;
                        continue;
                    }
                    xjdf.moveElement(e, null);
                }
                ++j;
            }
            this.combineSameSets(xjdf);
        }

        private void combineSameSets(JDFElement xjdf) {
            Vector<SetHelper> v = new XJDFHelper(xjdf).getSets();
            while (v.size() > 0) {
                Vector<SetHelper> sameSets = new Vector<SetHelper>();
                SetHelper firstSet = v.remove(0);
                sameSets.add(firstSet);
                for (int j = 0; j < v.size(); ++j) {
                    SetHelper next = v.get(j);
                    if (!this.sameSetType(firstSet, next)) continue;
                    sameSets.add(next);
                    v.remove(j);
                    --j;
                }
                KElement root = firstSet.getRoot();
                for (int j = 1; j < sameSets.size(); ++j) {
                    Vector<ResourceHelper> parts = ((SetHelper)sameSets.get(j)).getPartitions();
                    for (ResourceHelper ph : parts) {
                        root.copyElement(ph.getRoot(), null);
                    }
                    ((SetHelper)sameSets.get(j)).getRoot().deleteNode();
                }
            }
        }

        private boolean sameSetType(SetHelper firstSet, SetHelper next) {
            boolean same = firstSet.getName().equals(next.getName());
            if (same) {
                same = StringUtil.equals(firstSet.getProcessUsage(), next.getProcessUsage());
            }
            if (same) {
                same = ContainerUtil.equals((Object)firstSet.getUsage(), (Object)next.getUsage());
            }
            if (same) {
                same = ContainerUtil.equals(firstSet.getXPathValue("@CombinedProcessIndex"), next.getXPathValue("@CombinedProcessIndex"));
            }
            if (same) {
                same = ContainerUtil.equals(firstSet.getXPathValue("Resource/Media/@MediaType"), next.getXPathValue("Resource/Media/@MediaType"));
            }
            return same;
        }
    }

    protected class WalkIntent
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Intent".equals(toCheck.getLocalName());
        }

        @Override
        void updateAttributes(KElement xjdf) {
            xjdf.removeAttribute("DescriptiveName");
            xjdf.removeAttribute("Status");
            xjdf.removeAttribute("StatusDetails");
            xjdf.removeAttribute("ID");
            super.updateAttributes(xjdf);
        }
    }

    protected class WalkResourceSet
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return SetHelper.isSet(toCheck);
        }

        @Override
        public KElement walk(KElement set, KElement dummy) {
            KElement ret = super.walk(set, dummy);
            set.eraseEmptyNodes(true);
            KElement res = set.getElement(StringUtil.leftStr(set.getLocalName(), -3));
            if (res != null) {
                return ret;
            }
            KElement comment = set.getElement("Comment");
            if (comment != null) {
                return ret;
            }
            JDFAttributeMap map = set.getAttributeMap();
            map.remove("ID");
            map.remove("Name");
            map.remove("ProcessUsage");
            map.remove("Usage");
            map.remove("CombinedProcessIndex");
            if (map.size() == 0) {
                set.deleteNode();
                return null;
            }
            return ret;
        }
    }

    protected class WalkResource
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Resource".equals(toCheck.getLocalName()) || "Parameter".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            String name;
            this.moveToSet(xjdf);
            KElement ret = super.walk(xjdf, dummy);
            xjdf.eraseEmptyNodes(true);
            KElement set = xjdf.getParentNode_KElement();
            String string = name = set == null ? null : StringUtil.getNonEmpty(set.getAttribute("Name"));
            if (name == null) {
                return null;
            }
            return ret;
        }

        void moveToSet(KElement xjdf) {
            KElement set = xjdf.getParentNode_KElement();
            if (set != null && xjdf.hasNonEmpty("Unit")) {
                set.moveAttribute("Unit", xjdf);
            }
        }
    }

    protected class WalkResourceElement
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return ResourceHelper.isResourceElement(toCheck);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement ret = super.walk(xjdf, dummy);
            this.moveToMisconsumable(xjdf);
            xjdf.eraseEmptyNodes(true);
            if (xjdf.getFirstChild() == null && xjdf.getAttributeMap().size() == 0) {
                xjdf.deleteNode();
                return null;
            }
            return ret;
        }

        void moveToMisconsumable(KElement xjdf) {
        }
    }

    protected class WalkIntentSet
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "IntentSet".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = xjdf.getElement("Intent");
            if (!PostXJDFWalker.this.bIntentPartition && intent != null) {
                intent.copyAttribute("Name", xjdf);
                xjdf.getParentNode_KElement().moveElement(intent, xjdf);
                xjdf.deleteNode();
            } else {
                super.walk(xjdf, dummy);
            }
            return intent;
        }
    }

    public class WalkDeliveryParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && toCheck instanceof JDFDeliveryParams;
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement delParams = super.walk(xjdf, dummy);
            if (delParams != null) {
                KElement set;
                Vector<JDFDrop> vDrop = delParams.getChildrenByClass(JDFDrop.class, false, 0);
                int size = vDrop == null ? 0 : vDrop.size();
                KElement param = delParams.getParentNode_KElement();
                KElement kElement = set = param == null ? null : param.getParentNode_KElement();
                if (set != null) {
                    ResourceHelper ph = new ResourceHelper(param);
                    SetHelper sh = new SetHelper(set);
                    JDFAttributeMap partMap = ph.getPartMap();
                    partMap.put("DropID", "DROP_0");
                    ph.setPartMap(partMap);
                    delParams.removeChildren("Drop", null, null);
                    for (int j = 0; j < size; ++j) {
                        KElement newDrop;
                        ResourceHelper newParam;
                        int i = (j + 1) % size;
                        partMap.put("DropID", "DROP_" + i);
                        if (i != 0) {
                            newParam = sh.getCreatePartition(partMap, true);
                            newDrop = newParam.getResource();
                            newDrop.copyInto(delParams, false);
                        } else {
                            newDrop = delParams;
                            newParam = ph;
                        }
                        newDrop.copyInto(vDrop.get(i), false);
                    }
                }
            }
            return delParams;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("DeliveryParams", null);
        }
    }

    public class WalkDeliveryIntentSet
    extends WalkIntentSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.bDeliveryIntent && super.matches(toCheck) && "DeliveryIntent".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = super.walk(xjdf, dummy);
            if (intent != null) {
                XJDFHelper h = new XJDFHelper(xjdf.getDeepParent("XJDF", 0));
                SetHelper delResHelper = h.getCreateSet("Resource", "DeliveryParams", JDFResourceLink.EnumUsage.Input);
                ResourceHelper ph = delResHelper.appendPartition(null, true);
                JDFDeliveryParams dp = (JDFDeliveryParams)ph.getResource();
                dp.setFromDeliveryIntent((JDFDeliveryIntent)intent.getElement("DeliveryIntent"));
            }
            return intent;
        }
    }

    public class WalkArtDeliveryIntentSet
    extends WalkIntentSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && super.matches(toCheck) && "ArtDeliveryIntent".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = super.walk(xjdf, dummy);
            if (intent != null) {
                XJDFHelper h = new XJDFHelper(intent.getDeepParent("XJDF", 0));
                SetHelper artDelResHelper = h.getCreateSet("Resource", "DeliveryParams", JDFResourceLink.EnumUsage.Input);
                ResourceHelper ph = artDelResHelper.appendPartition(null, true);
                JDFDeliveryParams dp = (JDFDeliveryParams)ph.getResource();
                this.setFromArtDelivery(dp, (JDFArtDeliveryIntent)intent.getElement("ArtDeliveryIntent"));
                intent.deleteNode();
                return null;
            }
            return intent;
        }

        private void setFromArtDelivery(JDFDeliveryParams dp, JDFArtDeliveryIntent adi) {
            Vector<JDFArtDelivery> vAD;
            Vector<JDFArtDelivery> vector = vAD = adi == null ? null : adi.getChildrenByClass(JDFArtDelivery.class, false, 0);
            if (vAD != null) {
                for (JDFArtDelivery ad : vAD) {
                    dp.setMethod(StringUtil.getNonEmpty(ad.getArtDeliveryType()));
                    KElement dropItem = dp.appendElement("DropItem");
                    dropItem.copyAttribute("ItemRef", ad, "RunListRef", null, null);
                    dropItem.setAttribute("Amount", 1, (String)null);
                }
            }
        }
    }

    protected class WalkStrippingSet
    extends WalkResourceSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && toCheck.getLocalName().equals("ResourceSet") && "StrippingParams".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (PostXJDFWalker.this.mergeLayout) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }
    }

    protected class WalkStrippingParams
    extends WalkResourceElement {
        @Override
        public VString getElementNames() {
            return new VString("StrippingParams", null);
        }

        @Override
        public KElement walk(KElement strippingParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(strippingParams, dummy);
                return strippingParams;
            }
            SetHelper layoutseth = PostXJDFWalker.this.newRootHelper.getCreateSet("Resource", "Layout", JDFResourceLink.EnumUsage.Input);
            VJDFAttributeMap vmap = new ResourceHelper(strippingParams.getParentNode_KElement()).getPartMapVector();
            JDFAttributeMap map = vmap.size() == 0 ? null : vmap.get(0);
            map = this.mergeStrippingParamsLayout((JDFStrippingParams)strippingParams, layoutseth, map);
            this.mergeSurfaces(map);
            super.walk(strippingParams, dummy);
            return null;
        }

        private JDFAttributeMap mergeStrippingParamsLayout(JDFStrippingParams strippingParams, SetHelper layoutseth, JDFAttributeMap map) {
            if (PostXJDFWalker.this.isRemoveSignatureName() && map != null) {
                map.remove("SignatureName");
            }
            String bsName = this.getBSID(strippingParams, map);
            String cellIndex = map == null ? null : map.remove("CellIndex");
            ResourceHelper layoutPartitionH = layoutseth.getCreatePartition(map, true);
            JDFLayout layoutPartition = (JDFLayout)layoutPartitionH.getResource();
            this.ensureLayoutPositions(strippingParams, layoutPartition, bsName);
            JDFBinderySignature bsOld = (JDFBinderySignature)layoutPartition.getChildWithAttribute("BinderySignature", "BinderySignatureName", null, bsName, 0, true);
            VElement childElementVector = strippingParams.getChildElementVector("SignatureCell", null);
            if (childElementVector != null) {
                for (KElement kid : childElementVector) {
                    JDFStripCellParams scp = (JDFStripCellParams)kid;
                    scp.setAttribute("CellIndex", cellIndex);
                }
            }
            if (bsOld != null) {
                this.moveStripCells(bsOld, childElementVector);
            } else {
                String bsRef = strippingParams.getNonEmpty("BinderySignatureRef");
                ResourceHelper bsHelper = XJDFHelper.getHelper(layoutPartition).getPartition(bsRef);
                if (bsHelper != null) {
                    String bsID;
                    JDFAttributeMap partMap = bsHelper.getPartMap();
                    if (partMap == null) {
                        partMap = new JDFAttributeMap();
                    }
                    if ((bsID = partMap.get("BinderySignatureID")) == null) {
                        SetHelper sh = bsHelper.getSet();
                        if (bsName == null) {
                            bsName = "BS_" + sh.indexOf(bsHelper);
                        }
                        partMap.put("BinderySignatureID", bsName);
                        bsHelper.setPartMap(partMap);
                    } else if (!bsID.equals(bsName) && bsName != null) {
                        VJDFAttributeMap partMaps = bsHelper.getPartMapVector();
                        JDFAttributeMap map2 = partMap.clone();
                        map2.put("BinderySignatureID", bsName);
                        partMaps.appendUnique(map2);
                        bsHelper.setPartMapVector(partMaps);
                    }
                    JDFBinderySignature bs = (JDFBinderySignature)bsHelper.getResource();
                    if (bs != null) {
                        this.moveStripCells(bs, childElementVector);
                        this.moveBSFromStripping(bs, strippingParams);
                        VElement positions = layoutPartition.getChildElementVector("Position", null);
                        if (positions != null) {
                            for (KElement position : positions) {
                                if (position.hasAttribute("BinderySignatureID")) continue;
                                position.setAttribute("BinderySignatureID", bsID);
                            }
                        }
                        strippingParams.removeAttribute("BinderySignatureRef");
                    }
                }
                layoutPartition.copyInto(strippingParams, false);
            }
            return map;
        }

        String getBSID(JDFStrippingParams strippingParams, JDFAttributeMap map) {
            String bsName = map == null ? null : map.remove("BinderySignatureName");
            String bsn2 = strippingParams.getNonEmpty("BinderySignatureIDs");
            if (bsn2 != null) {
                bsName = bsn2;
            }
            return bsName;
        }

        private void ensureLayoutPositions(JDFStrippingParams strippingParams, JDFLayout layoutPartition, String bsName) {
            VElement positions = strippingParams.getChildElementVector("Position", null);
            if (positions != null && positions.size() > 0) {
                layoutPartition.moveElements(positions, null);
            } else {
                JDFPosition newPos = (JDFPosition)layoutPartition.appendElement("Position");
                newPos.setRelativeBox(new JDFRectangle(0.0, 0.0, 1.0, 1.0));
                positions = new VElement();
                positions.add(newPos);
            }
            String attribute = "StackDepth";
            for (KElement position : positions) {
                position.setAttribute("BinderySignatureID", bsName);
                position.copyAttribute("StackDepth", strippingParams);
            }
            strippingParams.removeAttribute("StackDepth");
        }

        private void moveBSFromStripping(JDFBinderySignature bs, JDFStrippingParams strippingParams) {
            if (strippingParams == null || bs == null) {
                return;
            }
            bs.moveAttribute("BinderySignatureID", bs, "AssemblyIDs", null, null);
            bs.moveAttribute("JobID", bs);
            bs.moveAttribute("InnermostShingling", bs);
            bs.moveAttribute("OutermostShingling", bs);
        }

        private void moveStripCells(JDFBinderySignature bindSig, VElement childElementVector) {
            if (childElementVector == null) {
                return;
            }
            for (KElement sigCell : childElementVector) {
                String cellindex = sigCell.getAttribute("CellIndex", null, null);
                JDFIntegerList il = JDFIntegerList.createIntegerList(cellindex);
                Vector<JDFSignatureCell> vbsCell = this.getSigCellForIndex(bindSig, il);
                sigCell.removeAttribute("CellIndex");
                if (vbsCell != null) {
                    for (JDFSignatureCell bsCell : vbsCell) {
                        bsCell.mergeElement(sigCell, false);
                    }
                }
                sigCell.deleteNode();
            }
        }

        private Vector<JDFSignatureCell> getSigCellForIndex(JDFBinderySignature bindSig, JDFIntegerList il) {
            Vector<JDFSignatureCell> v = bindSig.getChildrenByClass(JDFSignatureCell.class, true, 0);
            Vector<JDFSignatureCell> vRet = new Vector<JDFSignatureCell>();
            if (v == null || v.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            } else {
                for (JDFSignatureCell sc : v) {
                    if (!this.matchesIndex(sc, il)) continue;
                    vRet.add(sc);
                }
            }
            if (vRet.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            }
            return vRet;
        }

        private boolean matchesIndex(JDFSignatureCell sc, JDFIntegerList il) {
            if (il == null) {
                return true;
            }
            try {
                il = new JDFIntegerList(il);
            }
            catch (DataFormatException e) {
                return false;
            }
            il.scale(2.0);
            JDFIntegerList fp = sc.getFrontPages();
            return il.contains(fp);
        }

        private void mergeSurfaces(JDFAttributeMap map) {
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStrippingParams;
        }
    }

    protected class WalkStripCellParams
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStripCellParams;
        }

        @Override
        public KElement walk(KElement stripCellParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(stripCellParams, dummy);
                return stripCellParams;
            }
            stripCellParams.renameElement("SignatureCell", null);
            super.walk(stripCellParams, dummy);
            return stripCellParams;
        }

        @Override
        void updateAttributes(KElement xjdf) {
            xjdf.renameAttribute("Spine", "TrimSpine");
            super.updateAttributes(xjdf);
        }

        @Override
        public VString getElementNames() {
            return new VString("StripCellParams", null);
        }
    }

    protected class WalkMediaIntent
    extends WalkIntent {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && toCheck instanceof JDFMediaIntent;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("MediaIntent", null);
        }

        @Override
        void updateAttributes(KElement xjdf) {
            String coating = xjdf.getNonEmpty("FrontCoatings");
            if (xjdf != null) {
                xjdf.removeAttribute("FrontCoatings");
                xjdf.setAttribute("Coating", this.getCoating(coating));
            }
            super.updateAttributes(xjdf);
        }
    }

    public class WalkPlacedObject
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFContentObject || toCheck instanceof JDFMarkObject;
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.copyToPlaceObject(xjdf);
            return super.walk(xjdf, dummy);
        }

        private KElement copyToPlaceObject(KElement xjdf) {
            KElement po = xjdf.getParentNode_KElement().insertBefore("PlacedObject", xjdf, null);
            VString poAttribs = JDFToXJDFDataCache.getPlacedObjectAttribs();
            for (String att : poAttribs) {
                po.moveAttribute(att, xjdf);
            }
            po.moveElement(xjdf, null);
            return po;
        }

        @Override
        public VString getElementNames() {
            return new VString(new String[]{"ContentObject", "MarkObject"});
        }
    }

    protected class WalkAmountPool
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return VString.getVString("AmountPool", null);
        }

        @Override
        public KElement walk(KElement ap, KElement dummy) {
            JDFAmountPool pool = (JDFAmountPool)ap;
            if (!PostXJDFWalker.this.retainAll) {
                this.moveActualToAudit(pool);
            }
            return super.walk(pool, dummy);
        }

        void moveActualToAudit(JDFAmountPool partAmount) {
            if (partAmount.getDeepParent("AuditPool", 0) == null && partAmount.getDeepParent("XJMF", 0) == null) {
                SetHelper sh;
                AuditPoolHelper ah = PostXJDFWalker.this.newRootHelper.getCreateAuditPool();
                KElement resource = partAmount.getDeepParent("Resource", 0);
                ResourceHelper ph = resource == null ? null : new ResourceHelper(resource);
                SetHelper setHelper = sh = ph == null ? null : ph.getSet();
                if (sh != null) {
                    MessageResourceHelper arh = ah.getCreateMessageResourceHelper(sh);
                    SetHelper shNew = arh.getSet();
                    ResourceHelper phNew = shNew.getCreateVPartition(sh.getPartMapVector(), false);
                    phNew.getRoot().copyElement(partAmount, null);
                    PostXJDFWalker.this.walkTree(shNew.getRoot(), null);
                }
                VElement vpa = partAmount.getChildElementVector("PartAmount", null);
                for (KElement pa : vpa) {
                    pa.removeAttribute("ActualAmount");
                    pa.removeAttribute("ActualWaste");
                }
            } else {
                VElement vpa = partAmount.getChildElementVector("PartAmount", null);
                for (KElement pa : vpa) {
                    this.fixPartAmount(pa);
                }
            }
        }

        public void fixPartAmount(KElement pa) {
            pa.removeAttribute("Amount");
            pa.renameAttribute("ActualAmount", "Amount");
            pa.removeAttribute("Waste");
            pa.renameAttribute("ActualWaste", "Waste");
        }

        @Override
        public boolean matches(KElement e) {
            return e instanceof JDFAmountPool;
        }
    }

    protected class WalkPartAmount
    extends WalkElement {
        @Override
        public KElement walk(KElement pa, KElement dummy) {
            JDFPartAmount partAmount = (JDFPartAmount)pa;
            if (!PostXJDFWalker.this.retainAll) {
                this.removeRedundantPartKeys(partAmount);
            }
            return super.walk(partAmount, dummy);
        }

        private void removeRedundantPartKeys(JDFPartAmount partAmount) {
            VElement parentParts = this.getParentParts(partAmount);
            if (parentParts != null) {
                VString keys = new VString();
                for (KElement e : parentParts) {
                    JDFPart p = (JDFPart)e;
                    JDFAttributeMap partMap = p.getPartMap();
                    VString nextKeys = partMap.getKeys();
                    keys.appendUnique(nextKeys);
                }
                VJDFAttributeMap vPA = partAmount.getPartMapVector();
                if (vPA == null) {
                    vPA = new VJDFAttributeMap();
                }
                if (vPA != null && keys != null && keys.size() > 0) {
                    vPA.removeKeys(keys);
                }
                if (vPA.isEmpty()) {
                    vPA = null;
                }
                partAmount.setPartMapVector(vPA);
                VElement v = partAmount.getParts();
                for (KElement e : v) {
                    this.updateNamespaces(e);
                }
            }
        }

        private VElement getParentParts(KElement part) {
            return part.getXPathElementVector("../../Part", 0);
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("PartAmount", null);
        }

        @Override
        public boolean matches(KElement e) {
            return e instanceof JDFPartAmount;
        }
    }

    protected class WalkPart
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return VString.getVString("Part", null);
        }

        @Override
        void updateAttributes(KElement part) {
            if (PostXJDFWalker.this.retainAll) {
                return;
            }
            if (PostXJDFWalker.this.isRemoveSignatureName()) {
                part.removeAttribute("SignatureName");
            }
            part.removeAttribute("BinderySignaturePaginationIndex");
            part.removeAttribute("BundleItemIndex");
            part.removeAttribute("CellIndex");
            part.removeAttribute("DocCopies");
            part.renameAttribute("DocRunIndex", "RunIndex");
            part.renameAttribute("DocSheetIndex", "SheetIndex");
            part.removeAttribute("DeliveryUnit0");
            part.removeAttribute("DeliveryUnit1");
            part.removeAttribute("DeliveryUnit2");
            part.removeAttribute("DeliveryUnit3");
            part.removeAttribute("DeliveryUnit4");
            part.removeAttribute("DeliveryUnit5");
            part.removeAttribute("DeliveryUnit6");
            part.removeAttribute("DeliveryUnit7");
            part.removeAttribute("DeliveryUnit8");
            part.removeAttribute("DeliveryUnit9");
            part.removeAttribute("DocTags");
            part.removeAttribute("Edition");
            part.removeAttribute("EditionVersion");
            part.removeAttribute("FountainNumber");
            part.removeAttribute("ItemNames");
            part.removeAttribute("LayerIDs");
            part.renameAttribute("Metadata0", "Metadata");
            part.removeAttribute("Metadata1");
            part.removeAttribute("Metadata2");
            part.removeAttribute("Metadata3");
            part.removeAttribute("Metadata4");
            part.removeAttribute("Metadata5");
            part.removeAttribute("Metadata6");
            part.removeAttribute("Metadata7");
            part.removeAttribute("Metadata8");
            part.removeAttribute("Metadata9");
            part.removeAttribute("PageTags");
            part.removeAttribute("PlateLayout");
            part.removeAttribute("PreflightRule");
            part.removeAttribute("RunPage");
            part.removeAttribute("RunPageRange");
            part.removeAttribute("RunSet");
            part.removeAttribute("RunTags");
            part.removeAttribute("SectionIndex");
            part.removeAttribute("SetCopies");
            part.renameAttribute("SetDocIndex", "DocIndex");
            part.renameAttribute("SetRunIndex", "RunIndex");
            part.renameAttribute("SetSheetIndex", "SheetIndex");
            part.removeAttribute("SubRun");
            part.renameAttribute("WebProduct", "ProductPart");
            part.removeAttribute("WebSetup");
            super.updateAttributes(part);
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(PostXJDFWalker.this.getFactory());
        }

        public String getCoating(String coating) {
            if (coating == null) {
                return null;
            }
            if ("glossy".equalsIgnoreCase(coating)) {
                return "Gloss";
            }
            return coating;
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.updateNamespaces(xjdf);
            this.updateAttributes(xjdf);
            return xjdf;
        }

        void updateAttributes(KElement xjdf) {
        }

        void updateNamespaces(KElement xjdf) {
            if (xjdf.hasAttribute("xmlns")) {
                xjdf.removeAttribute("xmlns");
            }
            if (xjdf.getNamespaceURI().equals(JDFElement.getSchemaURL())) {
                xjdf.setNamespaceURI(XJDF20.getSchemaURL());
            }
        }
    }
}

