/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoMISDetails;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFSubElement;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFDeviceList;
import org.cip4.jdflib.util.StringUtil;

public class WalkDeviceInfo
extends WalkJDFSubElement {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll();
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        this.updateDeviceStatus(map);
        super.updateAttributes(map);
    }

    private void updateDeviceStatus(JDFAttributeMap map) {
        map.renameKey("DeviceStatus", "Status");
        String status = map.get("Status");
        String opMode = map.remove("DeviceOperationMode");
        JDFAutoMISDetails.EnumDeviceOperationMode eOpMode = JDFAutoMISDetails.EnumDeviceOperationMode.getEnum(opMode);
        if (JDFAutoMISDetails.EnumDeviceOperationMode.NonProductive.equals((Object)eOpMode) || JDFAutoMISDetails.EnumDeviceOperationMode.Maintenance.equals((Object)eOpMode)) {
            status = "NonProductive";
        } else if (StringUtil.getNonEmpty(status) != null) {
            if ("Unknown".equals(status) || "Down".equals(status)) {
                status = "Offline";
            } else if ("Setup".equals(status) || "Running".equals(status) || "Cleanup".equals(status)) {
                status = "Production";
            }
        }
        map.put("Status", status);
    }

    @Override
    public VString getElementNames() {
        return new VString("DeviceInfo", null);
    }

    @Override
    protected void setAttributes(KElement jdf, KElement eNew) {
        super.setAttributes(jdf, eNew);
        KElement parent = eNew.getParentNode_KElement();
        if (parent != null) {
            parent.moveAttribute("DeviceID", eNew);
        }
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement e = jdf.getParentNode_KElement();
        if (e instanceof JDFDeviceList) {
            String devID = jdf.getNonEmpty("DeviceID");
            if (devID != null) {
                jdf.getCreateElement("Device").setAttribute("DeviceID", devID);
            }
            return xjdf;
        }
        return super.walk(jdf, xjdf);
    }

    @Override
    protected void removeUnusedElements(KElement jdf) {
        JDFDevice dev = (JDFDevice)jdf.getElement("Device");
        if (dev != null) {
            String devID = dev.getDeviceID();
            if (devID != null && jdf.getNonEmpty("DeviceID") == null) {
                jdf.setAttribute("DeviceID", devID);
            }
            dev.deleteNode();
        }
        super.removeUnusedElements(jdf);
    }
}

