/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResLink;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFMedia;

public class WalkMediaLink
extends WalkResLink {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFResourceLink && "MediaLink".equals(toCheck.getLocalName());
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFResourceLink rl = (JDFResourceLink)jdf;
        JDFResource r = rl.getLinkRoot();
        if (this.mustConvert(r)) {
            rl = this.createComponent(xjdf, rl);
        }
        return super.walk(rl, xjdf);
    }

    private boolean mustConvert(JDFResource r) {
        JDFMedia media = (JDFMedia)r;
        if (media == null) {
            return false;
        }
        media = (JDFMedia)media.getLeaves(false).get(0);
        return media.isComponentMedia();
    }

    private JDFResourceLink createComponent(KElement xjdf, JDFResourceLink rl) {
        String compID = "Comp." + rl.getrRef();
        if (this.getSet(compID, xjdf, "Resource") == null) {
            JDFNode rlParent = rl.getParentJDF();
            JDFComponent comp = (JDFComponent)rlParent.addResource("Component", null);
            comp.setID(compID);
            JDFResourceLink rlComp = rlParent.linkResource((JDFResource)comp, rl.getUsage(), rl.getEnumProcessUsage());
            JDFMedia media = (JDFMedia)rl.getLinkRoot();
            comp.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
            comp.clonePartitions(media, null);
            VElement leaves = media.getLeaves(false);
            for (KElement leaf : leaves) {
                JDFMedia rLeaf = (JDFMedia)leaf;
                JDFComponent twin = (JDFComponent)comp.getPartition(rLeaf.getPartMap(), null);
                twin.refMedia(rLeaf);
            }
            rlComp.setPartMapVector(rl.getPartMapVector());
            rlComp.moveElement(rl.getAmountPool(), null);
            rl.removeAttribute("rRef");
            rlComp.setAttributes(rl);
            rl.deleteNode();
            return rlComp;
        }
        return rl;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("MediaLink", null);
    }
}

