/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFProductionIntent;

public class WalkRefElement
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFRefElement refElem = (JDFRefElement)jdf;
        if (this.mustInline(refElem.getRefLocalName())) {
            try {
                JDFElement e = refElem.inlineRef();
                this.jdfToXJDF.walkTree(e, xjdf);
            }
            catch (JDFException x) {
                this.log.error((Object)("Problems converting refElement: " + refElem.getNodeName()), (Throwable)x);
            }
        } else if (this.isProduct(refElem)) {
            this.refProduct(refElem, xjdf);
        } else if (this.wantRef(refElem)) {
            this.makeRefAttribute(refElem, xjdf);
        }
        return null;
    }

    private boolean wantRef(JDFRefElement refElem) {
        return !(refElem.getParentNode_KElement() instanceof JDFProductionIntent);
    }

    private void refProduct(JDFRefElement refElem, KElement xjdf) {
        String attName = "ItemRef";
        String id = this.jdfToXJDF.getProduct(refElem.getrRef());
        xjdf.appendAttribute("ItemRef", id, null, " ", true);
    }

    private boolean isProduct(JDFRefElement refElem) {
        return this.jdfToXJDF.getProduct(refElem.getrRef()) != null;
    }

    protected void makeRefAttribute(JDFRefElement re, KElement xjdf) {
        JDFResource target = re.getTarget();
        JDFResourceLink rl = this.getLinkForRef(re, target);
        VElement v = this.setResource(rl == null ? re : rl, target, this.getRefRoot(xjdf));
        if (v != null) {
            String attName = this.getRefName(re);
            for (KElement ref : v) {
                xjdf.appendAttribute(attName, ref.getID(), null, " ", true);
            }
        }
        re.deleteNode();
    }

    protected void makeSetRefAttribute(JDFRefElement re, KElement xjdf) {
        String attName = this.getRefName(re);
        VElement v = this.setResource(re, re.getTarget(), this.jdfToXJDF.newRoot);
        if (v != null && v.size() > 0) {
            KElement ref = v.get(0).getParentNode_KElement();
            xjdf.setAttribute(attName, ref.getID());
        }
        re.deleteNode();
    }

    private JDFResourceLink getLinkForRef(JDFRefElement re, JDFResource target) {
        JDFResourceLink rl = null;
        if (this.jdfToXJDF.oldRoot != null) {
            JDFResourceLinkPool resourceLinkPool = this.jdfToXJDF.oldRoot.getResourceLinkPool();
            rl = resourceLinkPool != null ? resourceLinkPool.getLink(target, null, null) : null;
        }
        return rl;
    }

    private KElement getRefRoot(KElement xjdf) {
        KElement ret = null;
        if (xjdf != null) {
            ret = xjdf.getDeepParent("ResourceInfo", 0);
        }
        return ret == null ? this.jdfToXJDF.newRoot : ret;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFRefElement;
    }
}

