/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoQueueEntry;
import org.cip4.jdflib.auto.JDFAutoQueueFilter;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueue;
import org.cip4.jdflib.jmf.JDFQueueEntry;
import org.cip4.jdflib.jmf.JDFQueueEntryDef;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.VectorMap;

public class JDFQueueFilter
extends JDFAutoQueueFilter
implements INodeIdentifiable {
    private static final long serialVersionUID = 1L;
    Set<String> queueEntrieDefs = null;

    public void setQueueEntrieDefs(Set<String> queueEntrieDefs) {
        this.queueEntrieDefs = queueEntrieDefs;
    }

    public JDFQueueFilter(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFQueueFilter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFQueueFilter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFQueueFilter[  --> " + super.toString() + " ]";
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vPart) {
        super.setPartMapVector(vPart);
    }

    @Deprecated
    public JDFQueue match(JDFQueue theQueue) {
        return this.apply(theQueue, null);
    }

    @Deprecated
    public JDFQueue apply(JDFQueue theQueue, JDFQueue lastQueue) {
        if (theQueue == null) {
            return null;
        }
        return new QueueMatcher(theQueue, lastQueue).apply();
    }

    @Override
    public JDFAutoQueueFilter.EnumQueueEntryDetails getQueueEntryDetails() {
        String det = this.getAttribute("QueueEntryDetails", null, "Brief");
        if ("None".equals(det)) {
            return JDFAutoQueueFilter.EnumQueueEntryDetails.None;
        }
        if ("Brief".equals(det)) {
            return JDFAutoQueueFilter.EnumQueueEntryDetails.Brief;
        }
        if ("JobPhase".equals(det)) {
            return JDFAutoQueueFilter.EnumQueueEntryDetails.JobPhase;
        }
        if ("JDF".equals(det)) {
            return JDFAutoQueueFilter.EnumQueueEntryDetails.JDF;
        }
        return null;
    }

    public boolean matches(JDFQueueEntry qe) {
        return new QueueEntryMatcher().matches(qe);
    }

    @Override
    public void setActivation(JDFNode.EnumActivation enumVar) {
        this.setAttribute("Activation", enumVar == null ? null : enumVar.getName(), null);
    }

    @Override
    public JDFNode.EnumActivation getActivation() {
        return JDFNode.EnumActivation.getEnum(this.getAttribute("Activation", null, null));
    }

    public Vector<JDFAutoQueueEntry.EnumQueueEntryStatus> getStatusList() {
        return this.getEnumerationsAttribute("StatusList", null, JDFAutoQueueEntry.EnumQueueEntryStatus.getEnum(0), false);
    }

    public Set<String> getQueueEntryDefSet() {
        if (this.queueEntrieDefs != null) {
            return this.queueEntrieDefs;
        }
        HashSet<String> set = null;
        Vector<JDFQueueEntryDef> v = this.getChildrenByClass(JDFQueueEntryDef.class, false, 0);
        if (v != null && v.size() > 0) {
            set = new HashSet<String>();
            for (JDFQueueEntryDef qed : v) {
                String qeid = qed.getQueueEntryID();
                if (JDFQueueFilter.isWildCard(qeid)) continue;
                set.add(qeid);
            }
        }
        return set != null && set.size() > 0 ? set : null;
    }

    public Set<String> getDeviceIDSet() {
        int siz = 0;
        HashSet set = null;
        VElement v = this.getChildElementVector("Device", null);
        if (v != null) {
            siz = v.size();
            set = siz == 0 ? null : new HashSet();
            for (int i = 0; i < siz; ++i) {
                String qeid = ((JDFDevice)v.elementAt(i)).getDeviceID();
                if (JDFQueueFilter.isWildCard(qeid)) continue;
                set.add(qeid);
            }
        }
        return set != null && set.size() > 0 ? set : null;
    }

    public JDFDevice appendDevice(String deviceID) throws JDFException {
        JDFDevice device = super.appendDevice();
        device.setDeviceID(deviceID);
        return device;
    }

    public JDFQueueEntryDef appendQueueEntryDef(String queueEntryID) throws JDFException {
        JDFQueueEntryDef queueEntryDef = super.appendQueueEntryDef();
        queueEntryDef.setQueueEntryID(queueEntryID);
        return queueEntryDef;
    }

    public JDFQueue copy(JDFQueue theQueue, JDFQueue lastQueue, KElement resp) {
        QueueMatcher queueMatcher = new QueueMatcher(theQueue, lastQueue);
        return queueMatcher.copyTo(resp);
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return new NodeIdentifier(this.getJobID(), this.getJobPartID(), this.getPartMapVector());
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        if (ni == null) {
            ni = new NodeIdentifier();
        }
        this.setJobID(ni.getJobID());
        this.setJobPartID(ni.getJobPartID());
        this.setPartMapVector(ni.getPartMapVector());
    }

    @Override
    public int getMaxEntries() {
        JDFMessage.EnumType t;
        KElement parent = this.getParentNode_KElement();
        int def = 0;
        if (parent instanceof JDFMessage && JDFMessage.EnumType.QueueStatus.equals((Object)(t = ((JDFMessage)parent).getEnumType()))) {
            def = Integer.MAX_VALUE;
        }
        return this.getIntAttribute("MaxEntries", null, def);
    }

    protected class QueueEntryMatcher {
        private final Set<String> qeDefs;
        private final Set<String> devIDs;
        private VString gangNames;
        private VString statusList;
        private final String jobID;
        private final String jobPartID;
        private final JDFDate olderThan;
        private final JDFDate newerThan;
        private final JDFNode.EnumActivation activation;
        private VectorMap<String, JDFGeneralID> generalIDS;

        protected QueueEntryMatcher() {
            this.qeDefs = JDFQueueFilter.this.getQueueEntryDefSet();
            this.devIDs = JDFQueueFilter.this.getDeviceIDSet();
            this.gangNames = JDFQueueFilter.this.getGangNames();
            this.olderThan = JDFQueueFilter.this.getOlderThan();
            this.newerThan = JDFQueueFilter.this.getNewerThan();
            this.activation = JDFQueueFilter.this.getActivation();
            if (this.gangNames.size() == 0) {
                this.gangNames = null;
            }
            this.jobID = StringUtil.getNonEmpty(JDFQueueFilter.this.getJobID());
            this.jobPartID = StringUtil.getNonEmpty(JDFQueueFilter.this.getJobPartID());
            Vector<JDFAutoQueueEntry.EnumQueueEntryStatus> vs = JDFQueueFilter.this.getStatusList();
            if (vs == null) {
                this.statusList = null;
            } else {
                this.statusList = new VString();
                for (JDFAutoQueueEntry.EnumQueueEntryStatus e : vs) {
                    this.statusList.add(e.getName());
                }
            }
            VElement v = JDFQueueFilter.this.getChildElementVector("GeneralID", null);
            this.generalIDS = v.size() == 0 ? null : JDFQueueFilter.this.getGeneralIDVectorMap();
        }

        protected boolean matches(JDFQueueEntry qe) {
            boolean b;
            JDFNode.EnumActivation qeActivation;
            if (qe == null) {
                return false;
            }
            if (JDFAutoQueueFilter.EnumQueueEntryDetails.None.equals((Object)JDFQueueFilter.this.getQueueEntryDetails())) {
                return false;
            }
            if (this.qeDefs != null && !this.qeDefs.contains(qe.getQueueEntryID())) {
                return false;
            }
            if (this.activation != null && (!this.activation.equals((Object)(qeActivation = qe.getActivation())) || qeActivation == null && this.activation.equals((Object)JDFNode.EnumActivation.Active))) {
                return false;
            }
            if (this.devIDs != null && !this.devIDs.contains(qe.getDeviceID())) {
                return false;
            }
            if (this.gangNames != null && !this.gangNames.contains(qe.getGangName())) {
                return false;
            }
            if (this.statusList != null && !this.statusList.contains(qe.getAttribute("Status"))) {
                return false;
            }
            if (this.jobID != null && !StringUtil.matchesSimple(qe.getJobID(), this.jobID)) {
                return false;
            }
            if (this.jobPartID != null && !StringUtil.matches(qe.getJobPartID(), this.jobPartID)) {
                return false;
            }
            if (this.newerThan != null && this.newerThan.isLater(qe.getSubmissionTime())) {
                return false;
            }
            if (this.olderThan != null && this.olderThan.isEarlier(qe.getSubmissionTime())) {
                return false;
            }
            return this.generalIDS == null || (b = this.matchesGeneralIDs(qe));
        }

        private boolean matchesGeneralIDs(JDFQueueEntry qe) {
            VectorMap<String, JDFGeneralID> qeGeneralIDS = qe.getGeneralIDVectorMap();
            if (qeGeneralIDS.size() < this.generalIDS.size()) {
                return false;
            }
            Set keys = this.generalIDS.keySet();
            for (String key : keys) {
                Vector qeGIDs = (Vector)qeGeneralIDS.get(key);
                if (qeGIDs == null) {
                    return false;
                }
                Vector filterGIDs = (Vector)this.generalIDS.get(key);
                boolean gotIt = false;
                for (JDFGeneralID filterValue : filterGIDs) {
                    for (JDFGeneralID qeValue : qeGIDs) {
                        if (!qeValue.matches(filterValue)) continue;
                        gotIt = true;
                        break;
                    }
                    if (!gotIt) continue;
                    break;
                }
                if (gotIt) continue;
                return false;
            }
            return true;
        }
    }

    private class QueueMatcher {
        private final JDFQueue lastQueue;
        private JDFQueue theQueue;
        private Map<String, JDFQueueEntry> lastMap;
        private JDFAutoQueueFilter.EnumQueueEntryDetails qed;
        private final QueueEntryMatcher qeMatch;

        public QueueMatcher(JDFQueue theQueue, JDFQueue lastQueue) {
            this.qed = JDFQueueFilter.this.getQueueEntryDetails();
            this.theQueue = theQueue;
            this.lastQueue = lastQueue;
            this.qeMatch = new QueueEntryMatcher();
            if (lastQueue != null && JDFAutoQueueFilter.EnumUpdateGranularity.ChangesOnly.equals((Object)JDFQueueFilter.this.getUpdateGranularity())) {
                this.lastMap = lastQueue.getQueueEntryIDMap();
                if (!lastQueue.hasAttribute("QueueSize")) {
                    lastQueue.setQueueSize(lastQueue.getQueueSize());
                }
            } else {
                this.lastMap = null;
            }
        }

        @Deprecated
        protected JDFQueue apply() {
            int i;
            int maxEntries = JDFQueueFilter.this.hasAttribute("MaxEntries") ? JDFQueueFilter.this.getMaxEntries() : 999999;
            VElement v = this.theQueue.getQueueEntryVector();
            if (v != null) {
                int size = v.size();
                this.theQueue.setQueueSize(size);
                for (i = 0; i < size; ++i) {
                    JDFQueueEntry qe = (JDFQueueEntry)v.elementAt(i);
                    this.apply(qe);
                }
            }
            this.addRemoved(this.theQueue);
            int numEntries = this.theQueue.numEntries(null);
            if (numEntries > maxEntries) {
                v = this.theQueue.getQueueEntryVector();
                for (i = maxEntries; i < numEntries; ++i) {
                    v.get(i).deleteNode();
                }
            }
            if (numEntries == 0 && this.lastMap != null) {
                JDFAttributeMap mapQueue = this.theQueue.getAttributeMap();
                JDFAttributeMap mapLast = this.lastQueue.getAttributeMap();
                if (ContainerUtil.equals(mapLast, mapQueue)) {
                    this.theQueue.deleteNode();
                    this.theQueue = null;
                }
            }
            return this.theQueue;
        }

        private void addRemoved(JDFQueue copyQueue) {
            if (this.lastMap != null && this.lastMap.size() > 0) {
                JDFQueueEntry qeFirst = copyQueue.getQueueEntry(0);
                for (String qeID : this.lastMap.keySet()) {
                    JDFQueueEntry removedQE = this.lastMap.get(qeID);
                    if (!this.qeMatch.matches(removedQE)) continue;
                    JDFQueueEntry qe = (JDFQueueEntry)copyQueue.copyElement(removedQE, qeFirst);
                    qe.setQueueEntryStatus(JDFAutoQueueEntry.EnumQueueEntryStatus.Removed);
                    qe.removeAttribute("StatusDetails");
                    qe.removeChildren("JobPhase", null, null);
                }
            }
        }

        @Deprecated
        protected void apply(JDFQueueEntry qe) {
            if (qe == null) {
                return;
            }
            if (!JDFQueueFilter.this.matches(qe)) {
                qe.deleteNode();
            }
            if (this.noDifference(qe, true)) {
                qe.deleteNode();
            }
            this.cleanQE(qe);
        }

        private JDFQueueEntry copyTo(JDFQueue newQueue, JDFQueueEntry qe) {
            if (qe == null) {
                return null;
            }
            if (this.qeMatch.matches(qe)) {
                if (this.noDifference(qe, false)) {
                    return null;
                }
                qe = (JDFQueueEntry)newQueue.copyElement(qe, null);
                this.cleanQE(qe);
                if (this.noDifference(qe, true)) {
                    qe.deleteNode();
                    qe = null;
                }
            } else {
                if (this.lastMap != null) {
                    this.lastMap.remove(qe.getQueueEntryID());
                }
                qe = null;
            }
            return qe;
        }

        private void cleanQE(JDFQueueEntry qe) {
            Vector<JDFJobPhase> v;
            if (this.qed == null) {
                this.qed = JDFAutoQueueFilter.EnumQueueEntryDetails.Brief;
            }
            if (EnumUtil.aLessEqualsThanB(this.qed, JDFAutoQueueFilter.EnumQueueEntryDetails.Brief)) {
                qe.removeChildren("JobPhase", null, null);
            }
            if (EnumUtil.aLessEqualsThanB(this.qed, JDFAutoQueueFilter.EnumQueueEntryDetails.JobPhase) && (v = qe.getChildrenByClass(JDFJobPhase.class, false, -1)) != null) {
                for (JDFJobPhase jp : v) {
                    jp.removeChildren("JDF", null, null);
                }
            }
        }

        private boolean noDifference(JDFQueueEntry qe, boolean clean) {
            if (this.lastMap == null) {
                return false;
            }
            String qeID = qe.getQueueEntryID();
            JDFQueueEntry lastQueueEntry = this.lastMap.get(qeID);
            if (lastQueueEntry == null) {
                return false;
            }
            if (clean) {
                this.cleanQE(lastQueueEntry);
            }
            boolean equal = qe.isEqual(lastQueueEntry);
            if (clean || equal) {
                this.lastMap.remove(qeID);
            }
            return equal;
        }

        protected JDFQueue copyTo(KElement parent) {
            Set<String> s;
            JDFQueue newQueue = (JDFQueue)(parent == null ? new JDFDoc("Queue").getRoot() : parent.appendElement("Queue"));
            newQueue.setAttributes(this.theQueue);
            if (!newQueue.hasAttribute("QueueSize") && this.theQueue != null) {
                newQueue.setAttribute("QueueSize", this.theQueue.getQueueSize(), (String)null);
            }
            if ((s = JDFQueueFilter.this.getQueueEntryDefSet()) == null) {
                this.copyAll(newQueue);
            } else {
                this.copySet(newQueue, s);
            }
            this.addRemoved(newQueue);
            int numEntries = newQueue.numEntries(null);
            if (numEntries == 0 && this.lastMap != null) {
                JDFAttributeMap mapQueue = newQueue.getAttributeMap();
                JDFAttributeMap mapLast = this.lastQueue.getAttributeMap();
                if (ContainerUtil.equals(mapLast, mapQueue)) {
                    newQueue = null;
                }
            }
            return newQueue;
        }

        private void copySet(JDFQueue newQueue, Set<String> s) {
            int n = 0;
            int maxEntries = JDFQueueFilter.this.getMaxEntries();
            for (String qeid : s) {
                if (n == maxEntries) break;
                JDFQueueEntry qe = this.theQueue.getQueueEntry(qeid);
                JDFQueueEntry qeNew = this.copyTo(newQueue, qe);
                if (qeNew == null) continue;
                ++n;
            }
        }

        private void copyAll(JDFQueue newQueue) {
            int n = 0;
            int maxEntries = JDFQueueFilter.this.getMaxEntries();
            for (JDFQueueEntry qe = (JDFQueueEntry)this.theQueue.getFirstChildElement("QueueEntry", null); n < maxEntries && qe != null; qe = qe.getNextQueueEntry()) {
                JDFQueueEntry qeNew = this.copyTo(newQueue, qe);
                if (qeNew == null) continue;
                ++n;
            }
        }
    }
}

