/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFCustomerInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFPool;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFLocation;
import org.cip4.jdflib.resource.PartitionGetter;
import org.cip4.jdflib.resource.PartitionMap;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFIdentical;
import org.cip4.jdflib.resource.process.JDFIdentificationField;
import org.cip4.jdflib.resource.process.JDFQualityControlResult;
import org.cip4.jdflib.resource.process.JDFSourceResource;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFMerge;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class JDFResource
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static boolean autoAgent = false;
    private static boolean autoSubElementClass = false;
    private static boolean bUnpartitiondImplicit = false;
    private static HashSet<String> validParentNodeNameSet = null;
    private static HashSet<String> validRootParentNodeNameSet = null;
    PartitionMap partitionMap;
    private static AtrInfoTable[] atrInfoTable_Abstract = new AtrInfoTable[17];
    private static AtrInfoTable[] atrInfoTable_Physical;
    private static AtrInfoTable[] atrInfoTable_Param;
    private static AtrInfoTable[] atrInfoTable_ID_Class_Required;
    private static AtrInfoTable[] atrInfoTable_ID_Class_Optional;
    private static AtrInfoTable[] atrInfoTable_ID_Class_Root;
    private static AtrInfoTable[] atrInfoTable_Status_Required;
    private static AtrInfoTable[] atrInfoTable_Status_Optional;
    private static AtrInfoTable[] atrInfoTable_UpdateID_Optional;
    private static AtrInfoTable[] atrInfoTable_UpdateID_Required;
    private static AtrInfoTable[] atrInfoTable_PartIDKeys;
    private static ElemInfoTable[] elemInfoTable_Abstract;
    private static ElemInfoTable[] elemInfoTable_Physical;

    synchronized PartitionMap getPartitionMapper() {
        if (this.isResourceRoot()) {
            if (this.partitionMap == null) {
                this.partitionMap = new PartitionMap(this);
            }
            return this.partitionMap;
        }
        JDFResource resourceRoot = this.getResourceRoot();
        if (resourceRoot == this) {
            if (this.partitionMap == null) {
                this.partitionMap = new PartitionMap(this);
            }
            return this.partitionMap;
        }
        return resourceRoot.getPartitionMapper();
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = super.getTheAttributeInfo().updateReplace(atrInfoTable_Abstract);
        if (this.isPhysical()) {
            ai.updateAdd(atrInfoTable_Physical);
        } else if (this.isParameter()) {
            ai.updateAdd(atrInfoTable_Param);
        }
        if (this.isResourceUpdate()) {
            ai.updateAdd(atrInfoTable_UpdateID_Required);
        } else {
            ai.updateAdd(atrInfoTable_UpdateID_Optional);
        }
        if (this.isResourceRootRoot()) {
            ai.updateAdd(atrInfoTable_ID_Class_Required);
            ai.updateAdd(atrInfoTable_Status_Required);
        } else if (this.isResourceElement()) {
            ai.updateAdd(atrInfoTable_ID_Class_Optional);
        } else if (this.isResourceRoot()) {
            ai.updateAdd(atrInfoTable_ID_Class_Root);
            ai.updateAdd(atrInfoTable_Status_Optional);
        } else {
            ai.updateAdd(atrInfoTable_Status_Optional);
        }
        VString partIDKeys = this.getPartIDKeys();
        if (partIDKeys != null) {
            int siz = partIDKeys.size();
            block0: for (int i = 0; i < siz; ++i) {
                String partIDKey = partIDKeys.get(i);
                for (AtrInfoTable keyTable : atrInfoTable_PartIDKeys) {
                    String key = keyTable.getAttributeName();
                    if (!key.equals(partIDKey)) continue;
                    ai.updateAdd(keyTable);
                    continue block0;
                }
            }
        }
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        JDFResource resRoot;
        ElementInfo ei = super.getTheElementInfo().updateAdd(elemInfoTable_Abstract);
        if (this.isPhysical()) {
            ei.updateAdd(elemInfoTable_Physical);
        }
        if ((resRoot = this.getResourceRoot()) != null && resRoot.hasAttribute("PartIDKeys", null, false)) {
            ei.updateAdd(new ElemInfoTable(this.getNodeName(), 0x33333333L));
        }
        return ei;
    }

    public JDFResource(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResource(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResource(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFResource[ --> " + super.toString() + " ]";
    }

    @Deprecated
    public void setAvailable(boolean bAvailable) {
        this.setStatus(bAvailable ? EnumResStatus.Available : EnumResStatus.Unavailable);
    }

    @Deprecated
    public boolean isAvailable(boolean bRecurseRefs) {
        return EnumResStatus.Available.equals((Object)this.getResStatus(bRecurseRefs));
    }

    public boolean isRootElement() {
        KElement parent = this.getParentNode_KElement();
        if (parent == null) {
            throw new JDFException("JDFResource.IsRootElement: resource without parent");
        }
        return !this.getNodeName().equals(parent.getNodeName());
    }

    public boolean isQuantity() {
        EnumResourceClass c = this.getValidClass();
        if (c == null) {
            c = this.getResourceClass();
        }
        return c.equals((Object)EnumResourceClass.Quantity) || c.equals((Object)EnumResourceClass.Consumable);
    }

    public boolean isParameter() {
        EnumResourceClass c = this.getValidClass();
        if (c == null) {
            c = this.getResourceClass();
        }
        return EnumResourceClass.Parameter.equals((Object)c);
    }

    @Deprecated
    public boolean getLock() {
        return this.getBoolAttribute("Locked", null, false);
    }

    @Deprecated
    public void lock(boolean bLock) {
        if (bLock) {
            this.setAttribute("Locked", true, null);
        } else {
            this.removeAttribute("Locked", null);
        }
    }

    public boolean isPhysical() {
        EnumResourceClass c = this.getValidClass();
        if (c == null) {
            c = this.getResourceClass();
        }
        return EnumResourceClass.Consumable.equals((Object)c) || EnumResourceClass.Quantity.equals((Object)c) || EnumResourceClass.Handling.equals((Object)c);
    }

    public JDFResource getResourceRoot() {
        return JDFResource.getResourceRoot(this);
    }

    public static JDFResource getResourceRoot(KElement elem) {
        if (elem == null) {
            return null;
        }
        KElement parentNode = (elem = elem.getDeepParent(elem.getLocalName(), Integer.MAX_VALUE)).getParentNode_KElement();
        if (parentNode != null) {
            String parentName = parentNode.getLocalName();
            if (JDFResource.isValidParentNodeName(parentName)) {
                KElement par;
                if ((parentNode instanceof JDFNodeInfo || parentNode instanceof JDFCustomerInfo) && (par = parentNode.getParentNode_KElement()) != null && !(par instanceof JDFNode)) {
                    return JDFResource.getResourceRoot(parentNode);
                }
                return (JDFResource)(elem instanceof JDFResource ? elem : null);
            }
            if (parentNode instanceof JDFNode || parentNode instanceof JDFJMF) {
                return elem instanceof JDFResource ? (JDFResource)elem : null;
            }
            if (elem instanceof JDFResource && !(parentNode instanceof JDFResource)) {
                return (JDFResource)elem;
            }
            return JDFResource.getResourceRoot(parentNode);
        }
        if (elem instanceof JDFResource) {
            return (JDFResource)elem;
        }
        return null;
    }

    @Deprecated
    public JDFResourcePool getPool() {
        return (JDFResourcePool)this.getDeepParent("ResourcePool", 0);
    }

    @Override
    public boolean init() {
        if (this.isResourceRootRoot()) {
            JDFElement.EnumVersion v;
            this.appendAnchor(null);
            if (!this.hasAttribute("Status")) {
                this.setResStatus(EnumResStatus.Unavailable, false);
            }
            if ((v = this.getVersion(true)) == null || v.getValue() >= JDFElement.EnumVersion.Version_1_2.getValue() && autoAgent) {
                if (!this.hasAttribute("AgentName")) {
                    this.setAgentName(JDFAudit.getStaticAgentName());
                }
                if (!this.hasAttribute("AgentVersion")) {
                    this.setAgentVersion(JDFAudit.getStaticAgentVersion());
                }
            }
        }
        return true;
    }

    public JDFResource makeRootResource(String alias, JDFElement parentPool, boolean bLinkHere) {
        JDFResource retRes = this;
        if (this.isResourceElement()) {
            JDFElement link = null;
            if (bLinkHere) {
                link = (JDFElement)this.getParentNode_KElement().insertBefore(this.getNodeName() + "Ref", this, null);
                if (JDFResource.isWildCard(alias)) {
                    alias = this.getIDPrefix() + JDFResource.uniqueID(0);
                }
                link.appendHRef(this, null, alias);
            }
            JDFElement rp = null;
            if (parentPool instanceof JDFResourcePool) {
                rp = parentPool;
            } else if (parentPool instanceof JDFNode) {
                rp = ((JDFNode)parentPool).getCreateResourcePool();
            } else if (parentPool instanceof JDFResourceInfo) {
                rp = parentPool;
            }
            if (rp == null) {
                rp = this.getResourcePool();
            }
            if (rp == null) {
                JDFNode root = this.getJDFRoot();
                JDFElement jDFElement = rp = root == null ? null : root.getCreateResourcePool();
                if (rp == null) {
                    return this;
                }
            }
            JDFResource oldRoot = this.getResourceRoot();
            JDFResource newRes = (JDFResource)rp.moveElement(this, null);
            if (oldRoot.hasAttribute("Status")) {
                newRes.setResStatus(oldRoot.getResStatus(false), false);
            }
            if (oldRoot.hasAttribute("SpawnStatus")) {
                newRes.setSpawnStatus(oldRoot.getSpawnStatus());
            }
            newRes.init();
            retRes = newRes;
        }
        return retRes;
    }

    public VElement getCreator(boolean bCreate) {
        VElement v = this.getLinksAndRefs(true, false);
        VElement vv = new VElement();
        if (v == null) {
            return null;
        }
        for (KElement kElem : v) {
            JDFPool pool;
            JDFResourceLink l;
            if (!(kElem instanceof JDFResourceLink) || JDFResourceLink.EnumUsage.Input.equals((Object)(l = (JDFResourceLink)kElem).getUsage()) == bCreate || (pool = l.getPool()) == null) continue;
            vv.add(pool.getParentNode_KElement());
        }
        vv.unify();
        return vv.size() > 0 ? vv : null;
    }

    @Deprecated
    public void mergePartition(JDFResource resToMerge, String spawnID, EnumAmountMerge amountPolicy, boolean bLocalResource) {
        JDFMerge.mergePartition(this, resToMerge, spawnID, amountPolicy, bLocalResource);
    }

    public void setPartIDKeys(VString partIDKeys) {
        this.getResourceRoot().setAttribute("PartIDKeys", StringUtil.setvString(partIDKeys, " ", null, null));
    }

    public JDFResource mergeCloneResource(JDFResource oldRes) {
        JDFAttributeMap m = this.getAttributeMap();
        this.mergeElement(oldRes, false);
        this.setAttributes(m);
        return this;
    }

    @Deprecated
    public VElement getLinks(String linkName) {
        return this.getLinks(linkName, null);
    }

    public VElement getLinks(String linkName, String nameSpaceURI) {
        JDFAttributeMap m = new JDFAttributeMap("rRef", this.getID());
        return this.getParentJDF().getChildrenByTagName(linkName, nameSpaceURI, m, false, false, 0);
    }

    @Deprecated
    public VElement getLinksAndRefs() {
        return this.getLinksAndRefs(true, true);
    }

    public VElement getLinksAndRefs(boolean bLink, boolean bRef) {
        return new RefFinder(bLink, bRef).getLinksAndRefs();
    }

    private static synchronized boolean isValidParentNodeName(String nodeName) {
        if (validParentNodeNameSet == null) {
            String[] nodeNames;
            validParentNodeNameSet = new HashSet();
            for (String nodeName2 : nodeNames = new String[]{"ResourcePool", "PipeParams", "ResourceInfo", "ResourceCmdParams", "DeviceInfo", "DropItemIntent", "DropItem", "ProductionIntent", "CustomerInfo", "NodeInfo", "Ancestor", "Occupation", "PhaseTime"}) {
                validParentNodeNameSet.add(nodeName2);
            }
        }
        return validParentNodeNameSet.contains(nodeName);
    }

    private static synchronized boolean isValidRootParentNodeName(String nodeName) {
        if (validRootParentNodeNameSet == null) {
            String[] nodeNames;
            validRootParentNodeNameSet = new HashSet();
            for (String nodeName2 : nodeNames = new String[]{"ResourcePool", "PipeParams", "ResourceInfo", "ResourceCmdParams"}) {
                validRootParentNodeNameSet.add(nodeName2);
            }
        }
        return validRootParentNodeNameSet.contains(nodeName);
    }

    public boolean isResourceElement() {
        KElement e = this.getDeepParentNotName(this.getLocalName());
        if (e == null) {
            return false;
        }
        String par = e.getLocalName();
        return !JDFResource.isValidRootParentNodeName(par);
    }

    @Deprecated
    public JDFResource getPartition(JDFAttributeMap m, boolean bIncomplete) {
        return this.getPartition(m, bIncomplete ? EnumPartUsage.Implicit : EnumPartUsage.Explicit);
    }

    public JDFResource getPartition(JDFAttributeMap m, EnumPartUsage partUsage) {
        if (this.isResourceElement()) {
            return this;
        }
        return new PartitionGetter(this).getPartition(m, partUsage);
    }

    public HashMap<JDFAttributeMap, JDFResource> getPartitionMap() {
        PartitionMap partitionMap = this.getPartitionMapper();
        return partitionMap.getLeafMap();
    }

    @Deprecated
    public JDFResource getPartition(EnumPartIDKey key, String value, boolean bIncomplete) {
        JDFAttributeMap mp = new JDFAttributeMap();
        mp.put(key.getName(), value);
        return this.getPartition(mp, bIncomplete);
    }

    public void clonePartitions(JDFResource r, VString partIDKeys) {
        int size;
        if (r == null) {
            return;
        }
        if (partIDKeys == null) {
            partIDKeys = r.getPartIDKeys();
        }
        int n = size = partIDKeys == null ? 0 : partIDKeys.size();
        if (size == 0) {
            return;
        }
        this.setPartIDKeys(partIDKeys);
        VElement vLeaves = r.getLeaves(false);
        int leafSize = vLeaves.size();
        for (int i = 0; i < leafSize; ++i) {
            JDFResource leaf = (JDFResource)vLeaves.get(i);
            JDFAttributeMap partMap = leaf.getPartMap();
            partMap.reduceMap(partIDKeys);
            this.getCreatePartition(partMap, partIDKeys);
        }
    }

    public JDFResource getCreatePartition(JDFAttributeMap partMap, VString vPartKeys) {
        return new PartitionGetter(this).getCreatePartition(partMap, vPartKeys);
    }

    public JDFResource getCreatePartition(EnumPartIDKey key, String value, VString vPartIDKeys) {
        JDFAttributeMap mp = new JDFAttributeMap(key.getName(), value);
        return this.getCreatePartition(mp, vPartIDKeys);
    }

    protected boolean consistentPartIDKeys(EnumPartIDKey key, JDFResource root, VString partIDKeys) {
        if (key == null) {
            return false;
        }
        Vector<EnumPartIDKey> vImplicitKeys = this.getImplicitPartitions();
        if (vImplicitKeys != null && vImplicitKeys.contains((Object)key)) {
            return false;
        }
        String keyName = key.getName();
        int nDepth = 0;
        JDFResource r = this;
        int index = partIDKeys.indexOf(keyName);
        if (index < 0) {
            return !this.hasAttribute(keyName, null, false);
        }
        while (!r.equals(root)) {
            ++nDepth;
            if ((r = (JDFResource)r.getParentNode()) != null) continue;
        }
        if (partIDKeys.size() < nDepth) {
            return false;
        }
        KElement e = this;
        for (int i = nDepth - 1; i >= -1; --i) {
            if (i == index && !e.hasAttribute_KElement(keyName, null, false)) {
                return false;
            }
            if (i != index && e.hasAttribute_KElement(keyName, null, false)) {
                return false;
            }
            if (i <= -1) continue;
            e = e.getParentNode_KElement();
        }
        return true;
    }

    public boolean consistentPartIDKeys(EnumPartIDKey key) {
        JDFResource root = this.getResourceRoot();
        return this.consistentPartIDKeys(key, root, root.getPartIDKeys());
    }

    @Deprecated
    public JDFResource getDeepPart(JDFAttributeMap m, boolean bIncomplete) {
        return this.getDeepPart(m, bIncomplete ? EnumPartUsage.Implicit : EnumPartUsage.Explicit);
    }

    public JDFResource getDeepPart(JDFAttributeMap m, EnumPartUsage partUsage) {
        return new PartitionGetter(this).getDeepPart(m, partUsage);
    }

    public VElement getLeaves(boolean bAll) {
        Vector<? extends KElement> vAllChildren = this.getDirectPartitionVector();
        VElement vLeaves = new VElement();
        if (vAllChildren == null || vAllChildren.isEmpty()) {
            vLeaves.add(this);
        } else {
            if (bAll) {
                vLeaves.add(this);
            }
            int size = vAllChildren.size();
            for (int i = 0; i < size; ++i) {
                JDFResource pi = (JDFResource)vAllChildren.elementAt(i);
                VElement v = pi.getLeaves(bAll);
                vLeaves.addAll(v);
            }
        }
        return vLeaves;
    }

    public Vector<? extends KElement> getDirectPartitionVector() {
        Class<?> clazz = this.getClass();
        if (clazz.equals(JDFResource.class)) {
            return this.getChildElementVector_KElement(this.getNodeName(), null, null, true, 0);
        }
        return this.getChildrenByClass(clazz, false, 0);
    }

    public JDFResource getDirectPartition(int i) {
        return (JDFResource)this.getElement_KElement(this.getNodeName(), this.getNamespaceURI(), i);
    }

    public boolean isLeaf() {
        Class<?> class1 = this.getClass();
        if (class1.equals(JDFResource.class)) {
            return this.getElement_KElement(this.getNodeName(), null, 0) == null;
        }
        return this.getElementByClass(class1, 0, false) == null;
    }

    public VString getPartValues(EnumPartIDKey partType) {
        VElement v = this.getLeaves(false);
        VString vs = new VString();
        for (int i = 0; i < v.size(); ++i) {
            JDFResource p = (JDFResource)v.elementAt(i);
            String s = p.getAttribute(partType.getName(), null, "");
            if (s == null || s.equals("")) continue;
            boolean bOK = true;
            for (int j = 0; j < vs.size() && bOK; ++j) {
                if (!s.equals(vs.elementAt(j))) continue;
                bOK = false;
            }
            if (!bOK) continue;
            vs.addElement(s);
        }
        return vs;
    }

    @Override
    public String getAttribute(String attrib, String nameSpaceURI, String def) {
        String resultAttrib = super.getAttribute(attrib, nameSpaceURI, null);
        String nodeName = resultAttrib == null ? this.getNodeName() : null;
        KElement ke = this;
        while (resultAttrib == null) {
            if ((ke = ke.getParentNode_KElement()) == null || !ke.getNodeName().equals(nodeName)) {
                return def;
            }
            resultAttrib = ke.getAttribute_KElement(attrib, nameSpaceURI, null);
        }
        return resultAttrib;
    }

    @Override
    public <a extends KElement> Vector<a> getChildrenByClass(Class<a> clazz, boolean bRecurse, int nMax) {
        Vector<a> v = super.getChildrenByClass(clazz, bRecurse, nMax);
        KElement ke = this;
        if (v.size() == 0 && clazz != this.getClass()) {
            String nodeName = this.getNodeName();
            if ((ke = ke.getParentNode_KElement()) != null && ke.getNodeName().equals(nodeName)) {
                v = ke.getChildrenByClass(clazz, false, nMax);
            }
        }
        return v;
    }

    @Override
    public JDFAttributeMap getAttributeMap() {
        JDFResource parent = this.getParentPartition();
        if (parent != null) {
            JDFAttributeMap map = parent.getAttributeMap();
            map.putAll(super.getAttributeMap());
            return map;
        }
        return super.getAttributeMap();
    }

    @Override
    public boolean hasAttribute(String attrib, String nameSpaceURI, boolean bInherit) {
        return this.hasAttribute_JDFResource(attrib, nameSpaceURI, bInherit);
    }

    private boolean hasAttribute_JDFResource(String attrib, String nameSpaceURI, boolean bInherit) {
        if (bInherit) {
            return this.getInheritedAttribute(attrib, nameSpaceURI, null) != null;
        }
        return this.getAttribute(attrib, nameSpaceURI, null) != null;
    }

    @Override
    public int numChildElements(String nodeName, String nameSpaceURI) {
        int iNumChildElements = super.numChildElements(nodeName, nameSpaceURI);
        if (iNumChildElements == 0) {
            KElement jdfRes = this.getParentNode_KElement();
            if (jdfRes == null || !jdfRes.getNodeName().equals(this.getNodeName())) {
                iNumChildElements = 0;
            } else if (jdfRes instanceof JDFResource) {
                iNumChildElements = ((JDFResource)jdfRes).numChildElements(nodeName, nameSpaceURI);
            }
        }
        return iNumChildElements;
    }

    public KElement getCreateElement_JDFResource(String nodeName, String nameSpaceURI, int iSkip) {
        KElement resultKElement = this.getElement_JDFElement(nodeName, nameSpaceURI, iSkip);
        if (resultKElement == null) {
            resultKElement = this.appendElement(nodeName, nameSpaceURI);
        }
        return resultKElement;
    }

    @Override
    public KElement getElement(String nodeName, String nameSpaceURI, int iSkip) {
        return this.getElement_JDFResource(nodeName, nameSpaceURI, iSkip);
    }

    private KElement getElement_JDFResource(String nodeName, String nameSpaceURI, int iSkip) {
        KElement retEle = super.getElement(nodeName, nameSpaceURI, 0);
        if (retEle == null) {
            KElement parent = this.getParentNode_KElement();
            if (parent != null && parent.getNodeName().equals(this.getNodeName())) {
                if (!(parent instanceof JDFResource)) {
                    throw new JDFException("getElement_JDFResource tried to return a JDFElement as a JDFResource");
                }
                retEle = ((JDFResource)parent).getElement_JDFResource(nodeName, nameSpaceURI, iSkip);
            }
        } else if (iSkip != 0) {
            retEle = super.getElement(nodeName, nameSpaceURI, iSkip);
        }
        return retEle;
    }

    public VElement addPartitions(EnumPartIDKey partType, VString values) {
        if (this.isResourceElement()) {
            throw new JDFException("Attempting to add partition to resource element: " + this.buildXPath(null, 1));
        }
        VElement v = new VElement();
        if (!this.hasAttribute(partType.getName(), null, false)) {
            VElement vLeaves = this.getLeaves(false);
            int size = values.size();
            for (int i = 0; i < vLeaves.size(); ++i) {
                for (int j = 0; j < size; ++j) {
                    JDFResource p = (JDFResource)vLeaves.elementAt(i);
                    v.add(p.addPartition(partType, values.get(j)));
                }
            }
        }
        return v;
    }

    public JDFResource addPartition(EnumPartIDKey partType, ValuedEnum enumPart) {
        return this.addPartition(partType, enumPart.getName());
    }

    public JDFResource addPartition(EnumPartIDKey partType, String value) {
        return new PartitionGetter(this).addPartition(partType, value);
    }

    @Override
    public VString getAttributeVector() {
        return this.getAttributeVector_JDFResource();
    }

    public VString getAttributeVector_JDFResource() {
        VString v = new VString();
        KElement parent = this.getParentNode_KElement();
        v = super.getAttributeVector();
        if (parent != null && parent.getNodeName().equals(this.getNodeName())) {
            VString par = ((JDFResource)parent).getAttributeVector_JDFResource();
            for (int i = 0; i < par.size(); ++i) {
                String att = par.elementAt(i);
                if (v.contains(att)) continue;
                v.addElement(att);
            }
        }
        return v;
    }

    public JDFResource getAttributePart(String key) {
        JDFResource result = null;
        if (super.hasAttribute(key, null, false)) {
            result = this;
        } else {
            JDFElement jdfRes = (JDFElement)this.getParentNode_KElement();
            if (jdfRes != null && jdfRes.getNodeName().equals(this.getNodeName())) {
                if (!(jdfRes instanceof JDFResource)) {
                    throw new JDFException("getAttributePart tried to return a JDFElement as a JDFResource");
                }
                result = ((JDFResource)jdfRes).getAttributePart(key);
            }
        }
        return result;
    }

    public VElement getAttributePartVector(String key) {
        VElement leaves = this.getLeaves(false);
        VElement v = new VElement();
        for (int i = 0; i < leaves.size(); ++i) {
            JDFResource p = ((JDFResource)leaves.elementAt(i)).getAttributePart(key);
            if (p == null) continue;
            boolean bFound = false;
            for (int j = 0; j < v.size() && !bFound; ++j) {
                if (!p.equals(v.elementAt(j))) continue;
                bFound = true;
            }
            if (bFound) continue;
            v.addElement(p);
        }
        return v;
    }

    @Override
    public String buildXPath(String relativeTo, int methCountSiblings) {
        if (methCountSiblings != 2 && methCountSiblings != 3 || this.isResourceElement() || this.isResourceRoot()) {
            return super.buildXPath(relativeTo, methCountSiblings);
        }
        String path = "/" + this.getLocalName();
        String sKey = this.getLocalPartitionKey();
        if (sKey != null) {
            path = path + "[@" + sKey + "=\"" + this.getAttribute(sKey) + "\"]";
        }
        KElement parent = this.getParentNode_KElement();
        return parent.buildXPath(relativeTo, methCountSiblings) + path;
    }

    public String getLocalPartitionKey() {
        JDFResource partRoot = this.getResourceRoot();
        if (partRoot == null) {
            return null;
        }
        if (partRoot == this) {
            return null;
        }
        VString keys = partRoot.getPartIDKeys();
        if (keys == null) {
            return null;
        }
        int n = 0;
        for (KElement par = this.getParentNode_KElement(); par != partRoot; par = par.getParentNode_KElement()) {
            ++n;
        }
        if (n >= keys.size()) {
            return null;
        }
        String s = keys.get(n);
        return this.hasAttribute_KElement(s, null, false) ? s : null;
    }

    public void cleanResourceAttributes() {
        this.removeAttribute("ID");
        this.removeAttribute("Class");
        this.removeAttribute("Status");
        this.removeAttribute("PartUsage");
        this.removeAttribute("NoOp");
        VString v = this.getPartIDKeys();
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                this.removeAttribute(v.get(i));
            }
        }
        this.removeAttribute("Locked");
        this.removeAttribute("PartIDKeys");
        this.removeAttribute("rRefs", null);
        this.removeAttribute("SpawnIDs", null);
        this.removeAttribute("SpawnStatus", null);
    }

    public void removeInheritedAttributes(String attrib, String nameSpaceURI) {
        String nodeName = this.getNodeName();
        KElement ke = this;
        while (ke.getNodeName().equals(nodeName)) {
            ((KElement)ke).removeAttribute(attrib, nameSpaceURI);
            ke = ke.getParentNode_KElement();
        }
    }

    @Override
    public void removeAttribute(String attrib, String nameSpaceURI) {
        if (super.hasAttribute(attrib, nameSpaceURI, false)) {
            if (nameSpaceURI == null || nameSpaceURI.equals("")) {
                this.removeAttribute(attrib);
            } else {
                this.removeAttributeNS(nameSpaceURI, attrib);
            }
        }
    }

    public void removeAttributeFromLeaves(String attrib, String nameSpaceURI) {
        VElement v = this.getLeaves(true);
        v.removeAttribute(attrib, nameSpaceURI);
    }

    public void reducePartitions(VJDFAttributeMap vValidParts) {
        if (vValidParts == null || vValidParts.size() == 0 || !this.getResourceRoot().hasAttribute("PartIDKeys")) {
            return;
        }
        VString partIDKeys = this.getPartIDKeys();
        VElement v = this.getPartitionVector(vValidParts, EnumPartUsage.Implicit);
        vValidParts = new VJDFAttributeMap();
        if (v != null) {
            int vSize = v.size();
            for (int j = 0; j < vSize; ++j) {
                JDFResource r = (JDFResource)v.elementAt(j);
                vValidParts.add(r.getPartMap(partIDKeys));
            }
        }
        vValidParts.unify();
        int size = vValidParts.size();
        if (size != 0 && this.getPartIDKeys().size() > 0) {
            VElement leaves = this.getLeaves(true);
            for (int i = 0; i < leaves.size(); ++i) {
                boolean bOK = false;
                JDFResource leaf = (JDFResource)leaves.elementAt(i);
                JDFAttributeMap leafMap = leaf.getPartMap();
                for (int j = 0; j < size && !bOK; ++j) {
                    if (!leafMap.overlapMap(vValidParts.elementAt(j))) continue;
                    bOK = true;
                }
                if (bOK) continue;
                leaf.deleteNode();
            }
            this.clearPartitions();
        }
    }

    public void clearPartitions() {
        this.partitionMap = null;
    }

    @Deprecated
    public void reduceParts(Vector vParts) {
        if (!vParts.isEmpty() && this.getPartIDKeys().size() > 0) {
            VElement leaves = this.getLeaves(false);
            String nodeName = this.getNodeName();
            for (int i = 0; i < leaves.size(); ++i) {
                KElement parent;
                boolean bOK = false;
                JDFResource leaf = (JDFResource)leaves.elementAt(i);
                JDFAttributeMap leafMap = leaf.getPartMap();
                for (int j = 0; j < vParts.size() && !bOK; ++j) {
                    if (!leafMap.subMap((JDFAttributeMap)vParts.elementAt(j))) continue;
                    bOK = true;
                }
                if (bOK || (parent = leaf.getParentNode_KElement()) == null) continue;
                boolean bBreakWhile = false;
                JDFResource parentNode = (JDFResource)parent;
                while (!bBreakWhile && nodeName.equals(parentNode.getNodeName())) {
                    if (parentNode.numChildElements(nodeName, null) == 1) {
                        leaf = parentNode;
                        parent = parentNode.getParentNode_KElement();
                        if (parent == null) {
                            bBreakWhile = true;
                        }
                        parentNode = (JDFResource)parent;
                        continue;
                    }
                    bBreakWhile = true;
                }
                leaf.deleteNode();
            }
        }
    }

    public JDFAttributeMap getPartMap(VString ids) {
        JDFAttributeMap m = new JDFAttributeMap();
        KElement rLocal = this;
        for (int i = ids.size() - 1; i >= 0; --i) {
            String attName = ids.get(i);
            String s = rLocal.getAttribute_KElement(attName, null, null);
            if (s == null) continue;
            m.put(attName, s);
            rLocal = rLocal.getParentNode_KElement();
        }
        return m;
    }

    @Override
    public JDFAttributeMap getPartMap() {
        return this.getPartMap(this.getPartIDKeys());
    }

    public String getLinkString() {
        return this.getNodeName() + "Link";
    }

    @Deprecated
    public void mergeSpawnIDs(JDFResource resToMerge, VString previousMergeIDs) {
        if (!this.getID().equals(resToMerge.getID())) {
            throw new JDFException("JDFResource.mergeSpawnIDs  merging incompatible resources ID = " + this.getID() + " IDMerge = " + resToMerge.getID());
        }
        VElement allLeaves = this.getLeaves(true);
        VString partIDKeys = this.getPartIDKeys();
        for (int i = 0; i < allLeaves.size(); ++i) {
            int siz;
            JDFResource thisResNode = (JDFResource)allLeaves.elementAt(i);
            JDFResource mergeResNode = resToMerge.getPartition(thisResNode.getPartMap(partIDKeys), EnumPartUsage.Explicit);
            if (mergeResNode == null) continue;
            VString vSpawnIDs = thisResNode.getSpawnIDs(false);
            if (vSpawnIDs == null) {
                siz = 0;
                vSpawnIDs = mergeResNode.getSpawnIDs(false);
            } else {
                siz = vSpawnIDs.size();
                vSpawnIDs.appendUnique(mergeResNode.getSpawnIDs(false));
            }
            if (vSpawnIDs != null) {
                vSpawnIDs.removeStrings(previousMergeIDs, 999999);
            }
            if (vSpawnIDs == null || vSpawnIDs.isEmpty()) {
                thisResNode.removeAttribute("SpawnIDs");
                thisResNode.removeAttribute("SpawnStatus");
                continue;
            }
            if (siz == vSpawnIDs.size()) continue;
            thisResNode.setSpawnIDs(vSpawnIDs);
            if (mergeResNode.getSpawnStatus() != EnumSpawnStatus.SpawnedRW) continue;
            thisResNode.setSpawnStatus(EnumSpawnStatus.SpawnedRW);
        }
    }

    public void expand(boolean bDeleteFromNode) {
        new Collapser().expand(bDeleteFromNode);
    }

    public void expandLeaf() {
        this.getResourceRoot().new Collapser().expandLeaf(this, null);
    }

    public VString getRootPartAtts() {
        VString parts = this.getPartIDKeys();
        parts.addElement("ID");
        parts.addElement("Class");
        parts.addElement("PartIDKeys");
        parts.addElement("AgentName");
        parts.addElement("AgentVersion");
        parts.addElement("Author");
        parts.addElement("PartUsage");
        return parts;
    }

    @Deprecated
    public void collapse(boolean bCollapseToNode) {
        new Collapser().collapse(bCollapseToNode, true);
    }

    public void collapse(boolean bCollapseToNode, boolean bCollapseElements) {
        new Collapser().collapse(bCollapseToNode, bCollapseElements);
    }

    public boolean unpartition(boolean bForce) {
        return new Collapser().unpartition(bForce);
    }

    @Deprecated
    public void spawnPart(String spawnID, EnumSpawnStatus spawnStatus, VJDFAttributeMap vParts, boolean bStayInMain) {
        if (vParts != null && vParts.size() > 0) {
            int size = vParts.size();
            for (int j = 0; j < size; ++j) {
                JDFResource pLeaf = this.getPartition(vParts.elementAt(j), null);
                if (pLeaf == null) continue;
                if (bStayInMain) {
                    if (spawnStatus == EnumSpawnStatus.SpawnedRW || pLeaf.getSpawnStatus() != EnumSpawnStatus.SpawnedRW) {
                        pLeaf.setSpawnStatus(spawnStatus);
                        pLeaf.setLocked(spawnStatus == EnumSpawnStatus.SpawnedRW);
                    }
                } else {
                    pLeaf.setLocked(spawnStatus != EnumSpawnStatus.SpawnedRW);
                }
                pLeaf.appendSpawnIDs(spawnID);
            }
        } else {
            if (bStayInMain) {
                if (spawnStatus == EnumSpawnStatus.SpawnedRW || this.getSpawnStatus() != EnumSpawnStatus.SpawnedRW) {
                    this.setSpawnStatus(spawnStatus);
                    this.setLocked(spawnStatus == EnumSpawnStatus.SpawnedRW);
                }
            } else {
                this.setLocked(spawnStatus != EnumSpawnStatus.SpawnedRW);
            }
            this.appendSpawnIDs(spawnID);
        }
    }

    public void unSpawnPart(String spawnID, EnumSpawnStatus spawnStatus) {
        VElement vLeaves = this.getNodesWithSpawnID(spawnID);
        for (int i = 0; i < vLeaves.size(); ++i) {
            JDFResource leaf = (JDFResource)vLeaves.elementAt(i);
            leaf.removeFromSpawnIDs(spawnID);
            if (spawnStatus == EnumSpawnStatus.SpawnedRW) {
                leaf.removeAttribute("Locked", null);
            }
            if (!leaf.hasAttribute("SpawnIDs", null, false)) {
                leaf.removeAttribute("SpawnStatus", null);
                continue;
            }
            if (spawnStatus != EnumSpawnStatus.SpawnedRW) continue;
            leaf.setSpawnStatus(EnumSpawnStatus.SpawnedRO);
        }
    }

    public VElement getNodesWithSpawnID(String spawnID) {
        VElement v2 = this.getLeaves(true);
        for (int i = v2.size() - 1; i >= 0; --i) {
            JDFElement e = (JDFElement)v2.elementAt(i);
            if (e.hasAttribute_KElement("SpawnIDs", null, false) && e.includesMatchingAttribute("SpawnIDs", spawnID, AttributeInfo.EnumAttributeType.NMTOKENS)) continue;
            v2.remove(i);
        }
        return v2;
    }

    @Deprecated
    public VElement getPartitionVector(JDFAttributeMap m, boolean bIncomplete) {
        return this.getPartitionVector(m, bIncomplete ? EnumPartUsage.Implicit : EnumPartUsage.Explicit);
    }

    public VElement getPartitionVector(VJDFAttributeMap vm, EnumPartUsage partUsage) {
        return new PartitionGetter(this).getPartitionVector(vm, partUsage);
    }

    public VElement getPartitionLeafVector(JDFAttributeMap m, EnumPartUsage partUsage) {
        return new PartitionGetter(this).getPartitionLeafVector(m, partUsage);
    }

    public VElement getPartitionVector(JDFAttributeMap m, EnumPartUsage partUsage) {
        return new PartitionGetter(this).getPartitionVector(m, partUsage);
    }

    @Deprecated
    public VElement getPartitionVector(EnumPartIDKey key, String value, boolean bIncomplete) {
        JDFAttributeMap mp = new JDFAttributeMap(key.getName(), value);
        return this.getPartitionVector(mp, bIncomplete);
    }

    @Override
    protected String getIDPrefix() {
        return "r";
    }

    public VJDFAttributeMap getPartMapVector(boolean bIntermediate) {
        VElement allNodes = this.getLeaves(bIntermediate);
        VJDFAttributeMap vReturn = new VJDFAttributeMap();
        VString ids = this.getPartIDKeys();
        for (int j = 0; j < allNodes.size(); ++j) {
            JDFAttributeMap m = new JDFAttributeMap();
            JDFResource r = (JDFResource)allNodes.elementAt(j);
            for (int i = 0; i < ids.size(); ++i) {
                String strIds = ids.elementAt(i);
                if (!r.hasAttribute(strIds, null, false)) continue;
                m.put(strIds, r.getAttribute(strIds, null, ""));
            }
            if (m.size() <= 0) continue;
            vReturn.add(m);
        }
        vReturn.unify();
        return vReturn;
    }

    public VJDFAttributeMap reducePartVector(VJDFAttributeMap vParts) {
        boolean bChanged;
        VJDFAttributeMap vTest = new VJDFAttributeMap();
        vTest.setVector(vParts);
        VString partIDKeys = this.getPartIDKeys();
        block0: for (int i = 0; i < vTest.size(); ++i) {
            JDFAttributeMap partMapi = vTest.elementAt(i);
            for (int j = vTest.size() - 1; j > i; --j) {
                JDFAttributeMap partMapj = vTest.elementAt(j);
                if (partMapj.subMap(partMapi)) {
                    vTest.removeElementAt(j);
                    continue;
                }
                if (!partMapi.subMap(partMapj)) continue;
                vTest.removeElementAt(i);
                --i;
                continue block0;
            }
        }
        do {
            bChanged = false;
            for (int i = 0; i < vTest.size(); ++i) {
                JDFAttributeMap partMapi = vTest.elementAt(i);
                JDFResource r = this.getPartition(partMapi, false);
                if (r == null) {
                    vTest.removeElementAt(i);
                    --i;
                    continue;
                }
                if (r.isResourceRoot()) {
                    vTest.clear();
                    vTest.appendUnique(new JDFAttributeMap());
                    return vTest;
                }
                JDFElement parentElm = (JDFElement)r.getParentNode_KElement();
                if (parentElm == null) continue;
                VElement vKids = new VElement(parentElm.getChildElementVector(this.getNodeName(), null, null, true, 0, false));
                Vector<Integer> vTmp = new Vector<Integer>();
                for (int j = 0; j < vKids.size(); ++j) {
                    JDFAttributeMap kidMap = ((JDFResource)vKids.elementAt(j)).getPartMap(partIDKeys);
                    int index = vTest.indexOf(kidMap);
                    if (index < 0) {
                        vTmp.clear();
                        break;
                    }
                    vTmp.add(index);
                }
                if (vTmp.isEmpty()) continue;
                for (int l = vTmp.size() - 1; l >= 0; --l) {
                    int mymax = -1;
                    int posMax = -1;
                    for (int kk = 0; kk < vTmp.size(); ++kk) {
                        if ((Integer)vTmp.elementAt(kk) <= mymax) continue;
                        mymax = (Integer)vTmp.elementAt(kk);
                        posMax = kk;
                    }
                    vTest.removeElementAt(mymax);
                    vTmp.removeElementAt(posMax);
                }
                JDFResource parent = (JDFResource)parentElm;
                vTest.appendUnique(parent.getPartMap(partIDKeys));
                bChanged = true;
            }
        } while (bChanged);
        return vTest;
    }

    public String newModifiedID() {
        String id = this.getID();
        if (id.length() < 9) {
            return id + "_old_001";
        }
        String postFix = id.substring(0, 8);
        String preFix = id;
        VString siblingIDs = this.getResourcePool().getResIds();
        if (postFix.substring(0, "_old_".length()).equals("_old_")) {
            preFix = id.substring(0, id.length() - 8);
        }
        int siz = siblingIDs.size();
        String buf = "";
        boolean bTooManyIDs = true;
        String newModifiedID = "";
        for (int i = 1; i < 1000 && bTooManyIDs; ++i) {
            buf = this.makeID("_old_", 3, i);
            newModifiedID = preFix + buf;
            boolean bFound = false;
            for (int j = 0; j < siz && !bFound; ++j) {
                if (!newModifiedID.equals(siblingIDs.elementAt(j))) continue;
                bFound = true;
            }
            if (bFound) continue;
            bTooManyIDs = false;
        }
        if (bTooManyIDs) {
            throw new JDFException(" JDFResource.newModifiedID too many equivalent modified resources! Resource ID = " + id);
        }
        return newModifiedID;
    }

    private String makeID(String s, int numberOfDigits, int value) {
        String result = s;
        Integer myValue = value;
        int numberOfValueDigits = myValue.toString().length();
        if (numberOfValueDigits > numberOfDigits) {
            throw new JDFException("Value is bigger then maxDiggits: Cant make String");
        }
        for (int i = 0; i < numberOfDigits - numberOfValueDigits; ++i) {
            result = result + "0";
        }
        result = result + myValue.toString();
        return result;
    }

    public JDFResourcePool getResourcePool() {
        return (JDFResourcePool)this.getDeepParent("ResourcePool", 0);
    }

    public boolean isResourceRoot() {
        KElement parentNode = this.getParentNode_KElement();
        if (parentNode == null) {
            return true;
        }
        if (parentNode.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        String locName = parentNode.getLocalName();
        if ((locName.equals("NodeInfo") || locName.equals("CustomerInfo")) && this.getResourcePool() != null) {
            return false;
        }
        return JDFResource.isValidParentNodeName(locName);
    }

    public boolean isResourceRootRoot() {
        KElement parentNode = this.getParentNode_KElement();
        if (parentNode == null) {
            return true;
        }
        if (parentNode.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        String locName = parentNode.getLocalName();
        return JDFResource.isValidRootParentNodeName(locName);
    }

    public String updateAttributeFromLeaves(String attName, String nsURI, boolean bDirect) {
        int size;
        VElement v = JDFIdentical.removeIdenticals(this.getLeaves(false));
        int n = size = v == null ? 0 : v.size();
        if (size == 0 || size == 1 && this == v.get(0)) {
            if (!this.hasAttribute_KElement(attName, nsURI, false)) {
                String val = StringUtil.getNonEmpty(this.getAttribute(attName, nsURI, null));
                this.setAttribute(attName, val, nsURI);
                return val;
            }
            return null;
        }
        if (!bDirect) {
            for (KElement e : v) {
                ((JDFResource)e).updateAttributeFromLeaves(attName, nsURI, bDirect);
            }
        }
        Object val = v.get(0).getAttribute(attName, nsURI, null);
        for (int i = 1; i < size && val != null; ++i) {
            String vali = v.get(i).getAttribute(attName, nsURI, null);
            if (((String)val).equals(vali)) continue;
            val = null;
        }
        if (val != null) {
            this.setAttribute(attName, (String)val, nsURI);
        }
        return val;
    }

    public void updateAmounts(boolean keepPrevious) {
        double amount = keepPrevious ? StringUtil.parseDouble(this.getAttribute_KElement("Amount"), 0.0) : 0.0;
        double amountProduced = keepPrevious ? StringUtil.parseDouble(this.getAttribute_KElement("AmountProduced"), 0.0) : 0.0;
        double amountRequired = 0.0;
        JDFAttributeMap partMap = this.getPartMap();
        JDFAttributeMap partMapGood = null;
        JDFAttributeMap partMapCond = null;
        if (partMap.get("Condition") == null) {
            partMapGood = new JDFAttributeMap(partMap);
            partMapGood.put("Condition", "Good");
            partMapCond = new JDFAttributeMap(partMap);
            partMapCond.put("Condition", (String)null);
        }
        boolean mustWrite = this.hasAttribute("Amount");
        VElement resLinks = this.getLinks(this.getLinkString(), null);
        if (resLinks != null) {
            int linkSize = resLinks.size();
            for (int i = 0; i < linkSize; ++i) {
                JDFResourceLink rl = (JDFResourceLink)resLinks.elementAt(i);
                KElement linkParent = rl.getParentNode_KElement();
                if (!(linkParent instanceof JDFResourceLinkPool)) continue;
                JDFNode n = rl.getParentJDF();
                if (n != null) {
                    boolean bIsLeaf;
                    JDFNode.EnumType typ = JDFNode.EnumType.getEnum(n.getType());
                    boolean bl = bIsLeaf = !JDFNode.EnumType.ProcessGroup.equals((Object)typ) && !JDFNode.EnumType.Product.equals((Object)typ);
                    if (bIsLeaf) {
                        double rlActualAmount = 0.0;
                        double rlAmount = 0.0;
                        boolean hasConditionAmount = false;
                        boolean hasConditionActualAmount = false;
                        if (partMapGood != null) {
                            rlActualAmount = rl.getActualAmount(partMapCond);
                            rlAmount = rl.getAmount(partMapCond);
                            if (rlActualAmount > 0.0) {
                                hasConditionActualAmount = true;
                                rlActualAmount = rl.getActualAmount(partMapGood);
                            }
                            if (rlAmount > 0.0) {
                                hasConditionAmount = true;
                                rlAmount = rl.getAmount(partMapGood);
                            }
                        }
                        if (!hasConditionActualAmount) {
                            rlActualAmount = rl.getActualAmount(partMap);
                        }
                        if (!hasConditionAmount) {
                            rlAmount = rl.getAmount(partMap);
                        }
                        if (JDFResourceLink.EnumUsage.Input.equals((Object)rl.getUsage())) {
                            if (rlActualAmount > 0.0) {
                                amount -= rlActualAmount;
                                mustWrite = true;
                            }
                            if (rlAmount > 0.0) {
                                amountRequired += rlAmount;
                                mustWrite = true;
                            }
                        } else if (rlActualAmount >= 0.0) {
                            mustWrite = true;
                            amount += rlActualAmount;
                            amountProduced += rlActualAmount;
                        }
                    }
                }
                if (!mustWrite) continue;
                if (amount > 0.0) {
                    this.setAmount(amount);
                }
                if (amountProduced > 0.0) {
                    this.setAmountProduced(amountProduced);
                }
                if (!(amountRequired > 0.0)) continue;
                this.setAmountRequired(amountRequired);
            }
        }
    }

    @Override
    public VElement getChildElementVector(String element, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bAnd, int maxSize, boolean bResolveTarget) {
        KElement n;
        boolean bAlwaysFit;
        VElement v = null;
        String nodeName = this.getNodeName();
        boolean bl = bAlwaysFit = element == null && nameSpaceURI == null;
        if (bAlwaysFit) {
            v = new VElement();
            boolean bMapEmpty = mAttrib == null;
            int iSize = 0;
            for (KElement kElem = this.getFirstChildElement(); kElem != null; kElem = kElem.getNextSiblingElement()) {
                if (bResolveTarget && kElem instanceof JDFRefElement) {
                    try {
                        JDFRefElement ref = (JDFRefElement)kElem;
                        JDFResource target = ref.getTarget();
                        if (target == null || !bMapEmpty && !target.includesAttributes(mAttrib, bAnd)) continue;
                        v.addElement(target);
                        ++iSize;
                    }
                    catch (JDFException ref) {}
                    continue;
                }
                if (!bMapEmpty && !kElem.includesAttributes(mAttrib, bAnd) || nodeName.equals(kElem.getNodeName())) continue;
                v.addElement(kElem);
                if (++iSize != maxSize) {
                    continue;
                }
                break;
            }
        } else {
            v = super.getChildElementVector(element, nameSpaceURI, mAttrib, bAnd, 0, bResolveTarget);
            for (int i = v.size() - 1; i >= 0; --i) {
                if (!nodeName.equals(v.elementAt(i).getNodeName())) continue;
                v.remove(i);
            }
        }
        if ((v.size() == 0 || JDFResource.isWildCard(element)) && (n = this.getParentNode_KElement()) != null && n.getNodeName().equals(this.getNodeName()) && n instanceof JDFResource) {
            JDFResource r = (JDFResource)n;
            VElement v2 = r.getChildElementVector(element, nameSpaceURI, mAttrib, bAnd, maxSize, bResolveTarget);
            VString nodeNames = v.getElementNameVector(false);
            for (int i = v2.size() - 1; i >= 0; --i) {
                if (!nodeNames.contains(v2.item(i).getLocalName())) continue;
                v2.remove(i);
            }
            v.addAll(v2);
        }
        return v;
    }

    public Vector<EnumPartIDKey> getImplicitPartitions() {
        return null;
    }

    public boolean isPartitioningCompatible(JDFResource other) {
        boolean isCompatible = false;
        if (this.getNodeName().equals(other.getNodeName())) {
            isCompatible = this.isPartitioningCompatible(other.getPartIDKeys());
        }
        return isCompatible;
    }

    public boolean isPartitioningCompatible(VString vsPartitions) {
        if (vsPartitions == null || vsPartitions.isEmpty()) {
            return true;
        }
        VString vsPartIDKeysThis = this.getPartIDKeys();
        if (vsPartIDKeysThis == null || vsPartIDKeysThis.isEmpty()) {
            return false;
        }
        return vsPartIDKeysThis.containsAll(vsPartitions);
    }

    public boolean isSpawnAllowed() {
        JDFAttributeMap amPartMap = this.getPartMap();
        boolean isSpawnAllowed = true;
        if (amPartMap.size() > 0) {
            String strPartIDKey = null;
            VString vsPartKeys = this.getPartIDKeys();
            int nPartKeys = vsPartKeys.size();
            for (int i = nPartKeys - 1; i >= 0 && strPartIDKey == null; --i) {
                String str = vsPartKeys.get(i);
                if (!amPartMap.containsKey(str)) continue;
                strPartIDKey = str;
            }
            if (strPartIDKey != null && (strPartIDKey.equals("DocIndex") || strPartIDKey.equals("DocCopies") || strPartIDKey.equals("DocRunIndex") || strPartIDKey.equals("DocSheetIndex") || strPartIDKey.equals("RunIndex") || strPartIDKey.equals("SheetIndex"))) {
                isSpawnAllowed = false;
            }
        }
        return isSpawnAllowed;
    }

    public JDFContact getCreateContact() {
        return (JDFContact)this.getCreateElement("Contact", null, 0);
    }

    public JDFContact getContact() {
        return (JDFContact)this.getElement("Contact", null, 0);
    }

    public JDFContact appendContact() {
        return (JDFContact)this.appendElementN("Contact", 1, null);
    }

    public JDFLocation getCreateLocationElement() {
        return (JDFLocation)this.getCreateElement("Location", null, 0);
    }

    public JDFLocation getLocationElement() {
        return (JDFLocation)this.getElement("Location", null, 0);
    }

    public JDFLocation appendLocationElement() {
        return (JDFLocation)this.appendElementN("Location", 1, null);
    }

    public JDFSourceResource createSourceResource(JDFResource source) {
        JDFSourceResource sr = this.appendSourceResource();
        sr.refElement(source);
        return sr;
    }

    public JDFSourceResource appendSourceResource() {
        return (JDFSourceResource)this.appendElement("SourceResource", null);
    }

    public JDFSourceResource getSourceResource(int i) {
        return (JDFSourceResource)this.getElement("SourceResource", null, i);
    }

    public JDFIdentificationField getCreateIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getCreateElement("IdentificationField", null, iSkip);
    }

    public JDFIdentificationField getIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getElement("IdentificationField", null, iSkip);
    }

    public JDFIdentificationField appendIdentificationField() {
        return (JDFIdentificationField)this.appendElement("IdentificationField", null);
    }

    public JDFAttributeMap getIdenticalMap() {
        JDFIdentical ident = this.getIdentical();
        if (ident == null) {
            return null;
        }
        return ident.getPartMap();
    }

    public JDFIdentical getIdentical() {
        return (JDFIdentical)this.getElement_KElement("Identical", null, 0);
    }

    public JDFResource getIdenticalTarget() {
        JDFIdentical id = this.getIdentical();
        return id == null ? this : id.getTarget();
    }

    public JDFIdentical getCreateIdentical() {
        return (JDFIdentical)this.getCreateElement_KElement("Identical", null, 0);
    }

    public JDFIdentical appendIdentical() {
        return (JDFIdentical)this.appendElementN("Identical", 1, null);
    }

    public void setIdentical(VJDFAttributeMap vPartMap) {
        if (vPartMap == null || vPartMap.size() < 2) {
            return;
        }
        JDFResource target = this.getPartition(vPartMap.elementAt(0), null);
        for (int i = 1; i < vPartMap.size(); ++i) {
            JDFResource leaf = this.getPartition(vPartMap.elementAt(i), null);
            if (leaf == null) continue;
            leaf.setIdentical(target);
        }
    }

    public void setIdentical(JDFResource target) {
        if (target == null) {
            throw new JDFException("setIdentical: cannot create Identical in null element");
        }
        if (target == this || target.getIdentical() != null) {
            throw new JDFException("setIdentical: cannot create Identical to identical");
        }
        if (this.isResourceRoot()) {
            throw new JDFException("setIdentical: cannot create Identical in root");
        }
        if (target.isAncestor(this) || this.isAncestor(target)) {
            throw new JDFException("setIdentical: cannot create Identical in Ancestor or Child");
        }
        if (target.getResourceRoot() != this.getResourceRoot()) {
            throw new JDFException("setIdentical: Identical must be in the same resource");
        }
        JDFAttributeMap targetMap = target.getPartMap();
        JDFAttributeMap thisPart = this.getPartMap();
        if (thisPart.equals(targetMap)) {
            return;
        }
        JDFAttributeMap thisAllMap = this.getAttributeMap();
        if (thisAllMap != null) {
            thisAllMap.removeKeys(thisPart.keySet());
            this.removeAttributes(thisAllMap.getKeys());
        }
        this.removeChildren(null, null, null);
        JDFIdentical ident = (JDFIdentical)this.appendElement("Identical");
        ident.setPartMap(targetMap);
    }

    public JDFQualityControlResult getCreateQualityControlResult(int iSkip) {
        return (JDFQualityControlResult)this.getCreateElement("QualityControlResult", null, iSkip);
    }

    public JDFQualityControlResult getQualityControlResult(int iSkip) {
        return (JDFQualityControlResult)this.getElement("QualityControlResult", null, iSkip);
    }

    public JDFQualityControlResult appendQualityControlResult() {
        return (JDFQualityControlResult)this.appendElement("QualityControlResult", null);
    }

    @Deprecated
    public JDFResource getUpdate(int iSkip) {
        JDFResource updateResource = null;
        KElement updateElement = null;
        updateElement = this.getElement(this.getUpdateName(), null, iSkip);
        if (updateElement != null) {
            updateResource = (JDFResource)updateElement;
        }
        return updateResource;
    }

    @Deprecated
    public JDFResource getUpdate(String updateID) {
        JDFResource updateResource = null;
        KElement updateElement = null;
        updateElement = this.getChildWithAttribute(this.getUpdateName(), "UpdateID", null, updateID, 0, true);
        if (updateElement != null) {
            updateResource = (JDFResource)updateElement;
        }
        return updateResource;
    }

    @Deprecated
    public VElement getUpdateVector() {
        return this.getChildElementVector(this.getUpdateName(), null, null, true, 0, false);
    }

    @Deprecated
    public void removeUpdate(String updateID) {
        this.getUpdate(updateID).deleteNode();
    }

    @Deprecated
    public void removeUpdate(int iSkip) {
        this.getUpdate(iSkip).deleteNode();
    }

    @Deprecated
    public JDFResource appendUpdate(String updateID) {
        String uid = updateID;
        JDFResource r = null;
        if (JDFResource.isWildCard(updateID)) {
            uid = "Up" + JDFResource.uniqueID(0);
        } else {
            r = this.getUpdate(updateID);
            if (r != null) {
                throw new JDFException("JDFResource.appendUpdate: update with id = " + updateID + " exists!");
            }
        }
        KElement k = null;
        k = this.appendElement(this.getUpdateName(), null);
        if (k != null) {
            r = (JDFResource)k;
            r.setUpdateID(uid);
        }
        return r;
    }

    @Deprecated
    public int numUpdates() {
        return this.numChildElements(this.getUpdateName(), null);
    }

    @Deprecated
    public boolean hasUpdate() {
        return this.numUpdates() > 0;
    }

    @Deprecated
    public String getUpdateName() {
        return this.getNodeName() + "Update";
    }

    public void setAgentName(String value) {
        this.setAttribute("AgentName", value);
    }

    public String getAgentName() {
        return this.getAttribute("AgentName");
    }

    public void setAgentVersion(String value) {
        this.setAttribute("AgentVersion", value);
    }

    public String getAgentVersion() {
        return this.getAttribute("AgentVersion");
    }

    public void setAlternateBrand(String value) {
        this.setAttribute("AlternateBrand", value);
    }

    public String getAlternateBrand() {
        return this.getAttribute("AlternateBrand");
    }

    public void setAmount(double amount) {
        this.setAttribute("Amount", amount, null);
    }

    public double getAmount() {
        return this.getRealAttribute("Amount", null, 0.0);
    }

    public void setAmountProduced(double value) {
        this.setAttribute("AmountProduced", value, null);
    }

    public double getAmountProduced() {
        return this.getRealAttribute("AmountProduced", null, 0.0);
    }

    public void setAmountRequired(double value) {
        this.setAttribute("AmountRequired", value, null);
    }

    public double getAmountRequired() {
        return this.getRealAttribute("AmountRequired", null, 0.0);
    }

    public void setAuthor(String value) {
        this.setAttribute("Author", value);
    }

    public String getAuthor() {
        return this.getAttribute("Author");
    }

    public void setBatchID(String value) {
        this.setAttribute("BatchID", value);
    }

    public String getBatchID() {
        return this.getAttribute("BatchID");
    }

    public void setBinderySignatureName(String value) {
        this.setAttribute("BinderySignatureName", value);
    }

    public String getBinderySignatureName() {
        return this.getAttribute("BinderySignatureName", null, "");
    }

    public void setBlockName(String value) {
        this.setAttribute("BlockName", value);
    }

    public String getBlockName() {
        return this.getAttribute("BlockName", null, "");
    }

    public void setBrand(String value) {
        this.setAttribute("Brand", value);
    }

    public String getBrand() {
        return this.getAttribute("Brand");
    }

    public void setBundleItemIndex(JDFIntegerRangeList value) {
        this.setAttribute("BundleItemIndex", value.toString());
    }

    public JDFIntegerRangeList getBundleItemIndex() {
        String strAttrName = this.getAttribute("BundleItemIndex", null, null);
        try {
            return new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            return null;
        }
    }

    public void setCatalogDetails(String value) {
        this.setAttribute("CatalogDetails", value);
    }

    public String getCatalogDetails() {
        return this.getAttribute("CatalogDetails");
    }

    public void setCatalogID(String value) {
        this.setAttribute("CatalogID", value);
    }

    public String getCatalogID() {
        return this.getAttribute("CatalogID");
    }

    public void setCellIndex(JDFIntegerRangeList value) {
        this.setAttribute("CellIndex", value.toString());
    }

    public JDFIntegerRangeList getCellIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("CellIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setCondition(String value) {
        this.setAttribute("Condition", value);
    }

    public String getCondition() {
        return this.getAttribute("Condition");
    }

    public void setDocCopies(JDFIntegerRangeList value) {
        this.setAttribute("DocCopies", value.toString());
    }

    public JDFIntegerRangeList getDocCopies() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("DocCopies", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setDocIndex(JDFIntegerRangeList value) {
        this.setAttribute("DocIndex", value.toString());
    }

    public JDFIntegerRangeList getDocIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("DocIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setDeliveryUnit(int iUnit, String value) {
        if (iUnit < 0 || iUnit > 9) {
            throw new JDFException("setDeliveryUnit: invalid iUnit: " + String.valueOf(iUnit));
        }
        this.setAttribute("DeliveryUnit" + String.valueOf(iUnit), value);
    }

    public String getDeliveryUnit(int iUnit) {
        if (iUnit < 0 || iUnit > 9) {
            throw new JDFException("getDeliveryUnit: invalid iUnit: " + String.valueOf(iUnit));
        }
        return this.getAttribute("DeliveryUnit" + String.valueOf(iUnit), null, "");
    }

    public void setDocRunIndex(JDFIntegerRangeList value) {
        this.setAttribute("DocRunIndex", value.toString());
    }

    public JDFIntegerRangeList getDocRunIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("DocRunIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setDocSheetIndex(JDFIntegerRangeList value) {
        this.setAttribute("DocSheetIndex", value.toString());
    }

    public JDFIntegerRangeList getDocSheetIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("DocSheetIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setFountainNumber(int value) {
        Integer i = value;
        this.setAttribute("FountainNumber", i.toString());
    }

    public int getFountainNumber() {
        return this.getIntAttribute("FountainNumber", null, 0);
    }

    public void setItemNames(String value) {
        this.setAttribute("ItemNames", value);
    }

    public String getItemNames() {
        return this.getAttribute("ItemNames", null, "");
    }

    public void setLayerIDs(JDFIntegerRangeList value) {
        this.setAttribute("LayerIDs", value.toString());
    }

    public JDFIntegerRangeList getLayerIDs() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("LayerIDs", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setLocation(String value) {
        this.setAttribute("Location", value);
    }

    public String getLocation() {
        return this.getAttribute("Location", null, "");
    }

    public void setLocked(boolean value) {
        String localLock = this.getAttribute_KElement("Locked", null, null);
        if (localLock != null) {
            boolean b = localLock.equalsIgnoreCase("true");
            if (b == value) {
                return;
            }
            this.removeAttribute("Locked");
        }
        if (value || this.getLocked()) {
            this.setAttribute("Locked", value, null);
        }
    }

    public boolean getLocked() {
        return this.getBoolAttribute("Locked", null, false);
    }

    public void setNoOp(boolean value) {
        this.setAttribute("NoOp", value, null);
    }

    public boolean getNoOp() {
        return this.getBoolAttribute("NoOp", null, false);
    }

    public void setOption(String value) {
        this.setAttribute("Option", value);
    }

    public String getOption() {
        return this.getAttribute("Option", null, "");
    }

    public void setPageNumber(JDFIntegerRangeList value) {
        this.setAttribute("PageNumber", value.toString());
    }

    public JDFIntegerRangeList getPageNumber() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("PageNumber", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    protected void addPartIDKey(EnumPartIDKey partType) {
        String s = partType.getName();
        JDFResource r = this.getResourceRoot();
        Vector<EnumPartIDKey> implicitPartitions = this.getImplicitPartitions();
        if (implicitPartitions != null && implicitPartitions.contains((Object)partType)) {
            throw new JDFException("AddPartIDKey: attempting to add implicit partition: " + s);
        }
        r.appendAttribute("PartIDKeys", s, null, " ", true);
    }

    public void setPartIDKey(EnumPartIDKey key, String value) {
        String keyName = key.getName();
        String old = this.getNonEmpty_KElement(keyName);
        if (old == null || !old.equals(value)) {
            this.setAttribute(keyName, value, null);
            this.addPartIDKey(key);
            if (old != null) {
                this.getResourceRoot().partitionMap = null;
            }
        }
    }

    public JDFResource getParentPartition() {
        KElement parent = this.getParentNode_KElement();
        return this.getMyPartitionResource(parent);
    }

    public VString getPartIDKeys() {
        JDFResource partRoot = this.getResourceRoot();
        if (partRoot != null) {
            String idKeys = partRoot.getAttribute("PartIDKeys", null, null);
            return StringUtil.tokenize(idKeys, " ", false);
        }
        return null;
    }

    public void setPartUsage(EnumPartUsage value) {
        this.setAttribute("PartUsage", value == null ? null : value.getName(), null);
    }

    public static void setUnpartitiondImplicit(boolean bUnpartitiondImplicit) {
        JDFResource.bUnpartitiondImplicit = bUnpartitiondImplicit;
    }

    public EnumPartUsage getPartUsage() {
        String partUsage = this.getAttribute("PartUsage", null, null);
        if (partUsage == null) {
            if (!bUnpartitiondImplicit || this.getResourceRoot().hasAttribute("PartIDKeys")) {
                return EnumPartUsage.Explicit;
            }
            return EnumPartUsage.Implicit;
        }
        return EnumPartUsage.getEnum(partUsage);
    }

    public void setLotControl(EnumLotControl value) {
        this.setAttribute("LotControl", value.getName(), null);
    }

    public EnumLotControl getLotControl() {
        return EnumLotControl.getEnum(this.getAttribute("LotControl", null, null));
    }

    public void setPartVersion(String value) {
        this.setPartIDKey(EnumPartIDKey.PartVersion, value);
    }

    public String getPartVersion() {
        return this.getAttribute("PartVersion", null, "");
    }

    public void setPipeID(String value) {
        this.setAttribute("PipeID", value);
    }

    public String getPipeID() {
        return this.getAttribute("PipeID");
    }

    public boolean hasPipePartIDKey(EnumPartIDKey key) {
        return this.hasAttribute(key.getName());
    }

    public boolean consistentPipePartIDKeys(EnumPartIDKey key) {
        String s = key.getName();
        if (!this.hasAttribute(s)) {
            return true;
        }
        String strPipe = this.getResourceRoot().getAttribute("PipePartIDKeys");
        return StringUtil.hasToken(strPipe, s, " ", 0);
    }

    public boolean containsData() {
        return new Collapser().containsData(this);
    }

    public void addPipePartIDKey(EnumPartIDKey partType) {
        this.getResourceRoot().appendAttribute("PipePartIDKeys", partType.getName(), null, " ", true);
    }

    public void setPipePartIDKey(EnumPartIDKey key, String value) {
        this.setAttribute(key.getName(), value);
        this.addPipePartIDKey(key);
    }

    public Vector<EnumPartIDKey> getPipePartIDKeysEnum() {
        VString vPartIDKeys = this.getPartIDKeys();
        Vector<? extends ValuedEnum> v = this.getEnumerationsAttribute("PipePartIDKeys", null, EnumPartIDKey.getEnum(0), false);
        for (int i = 0; i < v.size(); ++i) {
            if (vPartIDKeys.contains(((EnumPartIDKey)v.elementAt(i)).getName())) continue;
            throw new JDFException("JDFResource.getPipePartIDKeys: key " + v.elementAt(i) + " is not subset of PartIDKey");
        }
        return v;
    }

    @Deprecated
    public VString getPipePartIDKeys() {
        VString vPipePartIDKeys = new VString();
        Vector<EnumPartIDKey> v = this.getPipePartIDKeysEnum();
        for (int i = 0; i < v.size(); ++i) {
            vPipePartIDKeys.add(v.elementAt(i).getName());
        }
        return vPipePartIDKeys;
    }

    public void setPipeProtocol(String value) {
        this.setAttribute("PipeProtocol", value);
    }

    public String getPipeProtocol() {
        return this.getAttribute("PipeProtocol");
    }

    public void setPipeURL(String value) {
        this.setAttribute("PipeURL", value);
    }

    public String getPipeURL() {
        return this.getAttribute("PipeURL");
    }

    public void setPreflightRule(String value) {
        this.setAttribute("PreflightRule", value);
    }

    public String getPreflightRule() {
        return this.getAttribute("PreflightRule", null, "");
    }

    public void setPreviewType(JDFAutoPart.EnumPreviewType value) {
        this.setAttribute("PreviewType", value.getName(), null);
    }

    public JDFAutoPart.EnumPreviewType getPreviewType() {
        return JDFAutoPart.EnumPreviewType.getEnum(this.getAttribute("PreviewType", null, null));
    }

    public void setProductID(String value) {
        this.setAttribute("ProductID", value);
    }

    public String getProductID() {
        return this.getAttribute("ProductID");
    }

    public void setResourceClass(EnumResourceClass value) {
        if (value == null) {
            this.removeAttribute("Class", null);
        }
        if (this.isResourceRootRoot() || autoSubElementClass && this.isResourceElement()) {
            this.setAttribute("Class", value.getName(), null);
        } else {
            this.removeAttribute("Class", null);
        }
    }

    public EnumResourceClass getResourceClass() {
        return EnumResourceClass.getEnum(this.getAttribute("Class", null, null));
    }

    public boolean validResourceClass(JDFElement.EnumValidationLevel level) {
        boolean b = this.validAttribute("Class", null, level);
        if (!b) {
            return false;
        }
        if (this.isResourceRootRoot()) {
            return this.validClass();
        }
        return true;
    }

    public final boolean validClass() {
        EnumResourceClass c = this.getValidClass();
        if (c == null) {
            return true;
        }
        if (!this.hasAttribute_KElement("Class", null, false)) {
            return true;
        }
        return c == this.getResourceClass();
    }

    public EnumResourceClass getValidClass() {
        return null;
    }

    public void setGrossWeight(double value) {
        this.setAttribute("GrossWeight", Double.toString(value));
    }

    public double getGrossWeight() {
        return this.getRealAttribute("GrossWeight", null, 0.0);
    }

    public void setResourceWeight(double value) {
        this.setAttribute("GrossWeight", Double.toString(value));
    }

    public double getResourceWeight() {
        return this.getRealAttribute("GrossWeight", null, 0.0);
    }

    public void setRibbonName(String value) {
        this.setAttribute("RibbonName", value);
    }

    public String getManufacturer() {
        return this.getAttribute("Manufacturer", null, "");
    }

    public void setManufacturer(String value) {
        this.setAttribute("Manufacturer", value);
    }

    public String getRibbonName() {
        return this.getAttribute("RibbonName", null, "");
    }

    public void setRun(String value) {
        this.setPartIDKey(EnumPartIDKey.Run, value);
    }

    public String getRunSet() {
        return this.getAttribute("RunSet", null, "");
    }

    public void setRunSet(String value) {
        this.setAttribute("RunSet", value, null);
    }

    public String getRun() {
        return this.getAttribute("Run", null, "");
    }

    public void setRunIndex(JDFIntegerRangeList value) {
        this.setAttribute("RunIndex", value.toString());
    }

    public JDFIntegerRangeList getRunIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("RunIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setRunPage(int value) {
        this.setAttribute("RunPage", value, (String)null);
    }

    public int getRunPage() {
        return this.getIntAttribute("RunPage", null, 0);
    }

    public void setRunTags(VString value) {
        StringBuffer strBuff = new StringBuffer(100);
        for (int i = 0; i < value.size(); ++i) {
            strBuff.append(value.elementAt(i));
        }
        this.setAttribute("RunTags", strBuff.toString(), null);
    }

    public VString getRunTags() {
        String s = this.getAttribute("RunTags", null, "");
        VString v = StringUtil.tokenize(s, " ", false);
        VString vstr = new VString();
        vstr.addAll(v);
        return vstr;
    }

    public void setSectionIndex(JDFIntegerRangeList value) {
        this.setAttribute("SectionIndex", value.toString());
    }

    public JDFIntegerRangeList getSectionIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("SectionIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setSeparation(String value) {
        this.setAttribute("Separation", value, null);
    }

    public String getSeparation() {
        return this.getAttribute("Separation", null, "");
    }

    public void setSetDocIndex(JDFIntegerRangeList value) {
        this.setAttribute("SetDocIndex", value.toString());
    }

    public JDFIntegerRangeList getSetDocIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("SetDocIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setSetIndex(JDFIntegerRangeList value) {
        this.setAttribute("SetIndex", value.toString());
    }

    public JDFIntegerRangeList getSetIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("SetIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setSetRunIndex(JDFIntegerRangeList value) {
        this.setAttribute("SetRunIndex", value.toString());
    }

    public JDFIntegerRangeList getSetRunIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("SetRunIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setSetSheetIndex(JDFIntegerRangeList value) {
        this.setAttribute("SetSheetIndex", value.toString());
    }

    public JDFIntegerRangeList getSetSheetIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("SetSheetIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setSheetIndex(JDFIntegerRangeList value) {
        this.setAttribute("SheetIndex", value.toString());
    }

    public JDFIntegerRangeList getSheetIndex() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("SheetIndex", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setSheetName(String value) {
        this.setAttribute("SheetName", value);
    }

    public String getSheetName() {
        return this.getAttribute("SheetName", null, "");
    }

    public void setSide(JDFAutoPart.EnumSide value) {
        this.setAttribute("Side", value.getName(), null);
    }

    public JDFAutoPart.EnumSide getSide() {
        return JDFAutoPart.EnumSide.getEnum(this.getAttribute("Side", null, null));
    }

    public void setSignatureName(String value) {
        this.setAttribute("SignatureName", value);
    }

    public String getSignatureName() {
        return this.getAttribute("SignatureName", null, "");
    }

    public String getStationName() {
        return this.getAttribute("StationName", null, "");
    }

    public void setStationName(String value) {
        this.setAttribute("StationName", value);
    }

    public void setSortAmount(boolean value) {
        this.setAttribute("SortAmount", value, null);
    }

    public boolean getSortAmount() {
        return this.getBoolAttribute("SortAmount", null, false);
    }

    public void setSorting(JDFIntegerRangeList value) {
        this.setAttribute("Sorting", value.toString(), null);
    }

    public JDFIntegerRangeList getSorting() {
        String strAttrName = "";
        JDFIntegerRangeList nPlaceHolder = null;
        strAttrName = this.getAttribute("Sorting", null, "");
        try {
            nPlaceHolder = new JDFIntegerRangeList(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void appendSpawnIDs(String value) {
        this.appendAttribute("SpawnIDs", value, null, " ", true);
    }

    public int removeFromSpawnIDs(String value) {
        return this.removeFromAttribute("SpawnIDs", value, null, " ", -1);
    }

    public VString getSpawnIDs(boolean bInherit) {
        String attribute;
        String string = attribute = bInherit ? this.getAttribute("SpawnIDs", null, null) : this.getAttribute_KElement("SpawnIDs", null, null);
        if (attribute == null) {
            return null;
        }
        return StringUtil.tokenize(attribute, " ", false);
    }

    public void setSpawnIDs(VString vStr) {
        this.setAttribute("SpawnIDs", StringUtil.setvString(vStr, " ", null, null), null);
    }

    public void setSpawnIDs(String spawndID) {
        this.setAttribute("SpawnIDs", spawndID);
    }

    public void setSpawnStatus(EnumSpawnStatus s) {
        this.setAttribute("SpawnStatus", s.getName(), null);
    }

    public EnumSpawnStatus getSpawnStatus() {
        return EnumSpawnStatus.getEnum(this.getAttribute("SpawnStatus", null, EnumSpawnStatus.NotSpawned.getName()));
    }

    @Deprecated
    public void setStatus(EnumResStatus value) {
        this.setAttribute("Status", value.getName(), null);
    }

    @Deprecated
    public void setStatus(EnumResStatus value, boolean bCleanLeaves) {
        this.setResStatus(value, bCleanLeaves);
    }

    @Deprecated
    public EnumResStatus getStatus(boolean bRecurseRefs) {
        return this.getResStatus(bRecurseRefs);
    }

    public void setResStatus(EnumResStatus value, boolean bCleanLeaves) {
        if (bCleanLeaves) {
            this.removeAttributeFromLeaves("Status", null);
        }
        this.setAttribute("Status", value == null ? null : value.getName(), null);
    }

    public EnumResStatus getResStatus(boolean bRecurseRefs) {
        if (bRecurseRefs) {
            EnumResStatus ret = this.getResStatus(false);
            VElement v = this.getvHRefRes(true, true);
            for (int i = 0; i < v.size(); ++i) {
                JDFResource rs = (JDFResource)v.elementAt(i);
                EnumResStatus rss = rs.getResStatus(false);
                if (rss == null || ret != null && rss.getValue() >= ret.getValue()) continue;
                ret = rss;
            }
            return ret;
        }
        return EnumResStatus.getEnum(this.getAttribute("Status", null, null));
    }

    public EnumResStatus getStatusFromLeaves(boolean bAll) {
        EnumResStatus minStatus = null;
        VElement v = this.getLeaves(bAll);
        if (v != null) {
            for (KElement e : v) {
                JDFResource r = (JDFResource)e;
                if (minStatus == null) {
                    minStatus = r.getResStatus(false);
                    continue;
                }
                minStatus = (EnumResStatus)EnumUtil.min(minStatus, r.getResStatus(false));
            }
        }
        return minStatus;
    }

    public void setTileID(JDFXYPair value) {
        this.setAttribute("TileID", value.toString());
    }

    public JDFXYPair getTileID() {
        String strAttrName = "";
        JDFXYPair nPlaceHolder = null;
        strAttrName = this.getAttribute("TileID", null, "");
        try {
            nPlaceHolder = new JDFXYPair(strAttrName);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return nPlaceHolder;
    }

    public void setUnit(String value) {
        this.setAttribute("Unit", value);
    }

    public String getUnit() {
        return this.getAttribute("Unit");
    }

    public void setUpdateID(String value) {
        this.setAttribute("UpdateID", value, null);
    }

    public String getUpdateID() {
        return this.getAttribute("UpdateID", null, "");
    }

    public void setWebName(String value) {
        this.setAttribute("WebName", value);
    }

    public String getWebName() {
        return this.getAttribute("WebName", null, "");
    }

    public void setWebProduct(String value) {
        this.setAttribute("WebProduct", value);
    }

    public String getWebProduct() {
        return this.getAttribute("WebProduct", null, "");
    }

    public void setWebSetup(String value) {
        this.setAttribute("WebSetup", value);
    }

    public String getWebSetup() {
        return this.getAttribute("WebSetup", null, "");
    }

    public VElement createPartitions(VJDFAttributeMap vPartMap, VString vPartIDKeys) {
        return new PartitionGetter(this).createPartitions(vPartMap, vPartIDKeys);
    }

    private JDFElement.EnumValidationLevel incompleteLevel(JDFElement.EnumValidationLevel level, boolean bForce) {
        JDFElement.EnumValidationLevel levelLocal = level;
        EnumResStatus es = this.getResStatus(false);
        if (es == EnumResStatus.Incomplete || this.isResourceUpdate() || bForce) {
            levelLocal = JDFElement.EnumValidationLevel.incompleteLevel(levelLocal);
        }
        return levelLocal;
    }

    @Override
    public boolean isValid(JDFElement.EnumValidationLevel level) {
        boolean bForceIncomplete;
        boolean bRet = true;
        level = this.incompleteLevel(level, false);
        boolean bLeaf = this.isLeaf();
        EnumPartUsage partUsage = this.getResourceRoot().getPartUsage();
        boolean bl = bForceIncomplete = partUsage != EnumPartUsage.Implicit || partUsage == EnumPartUsage.Sparse;
        if (bLeaf) {
            if (!super.isValid(level)) {
                return false;
            }
        } else if (this.isResourceUpdate()) {
            JDFResource r = this.getResourceRoot();
            if (r == null) {
                return true;
            }
        } else {
            if (this.getInvalidAttributes(this.incompleteLevel(level, bForceIncomplete), true, 1).size() > 0) {
                return false;
            }
            VElement v = this.getChildElementVector_KElement(this.getNodeName(), null, null, true, 0);
            for (KElement e : v) {
                if (((JDFResource)e).isValid(level)) continue;
                return false;
            }
        }
        if (!this.isResourceRootRoot()) {
            if (this.hasAttribute_KElement("PartIDKeys", null, false)) {
                return false;
            }
            if (!this.isResourceElement() && this.hasAttribute_KElement("Class", null, false)) {
                return false;
            }
        } else if (!(bLeaf || bForceIncomplete || super.isValid(level))) {
            return false;
        }
        return true;
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        EnumPartUsage pu;
        VString vAtts = super.getInvalidAttributes(level, bIgnorePrivate, nMax);
        int n = vAtts.size();
        if (n >= nMax) {
            return vAtts;
        }
        if (!this.validResourceClass(level)) {
            vAtts.appendUnique("Class");
            if (++n >= nMax) {
                return vAtts;
            }
        }
        if (!this.isResourceElement()) {
            KElement parent;
            VElement vThis;
            JDFResource root = this.getResourceRoot();
            VString partIDKeys = root.getPartIDKeys();
            int size = partIDKeys.size();
            String currentPartition = null;
            for (int i = 0; i < size; ++i) {
                String keyName = partIDKeys.get(i);
                EnumPartIDKey nxt = EnumPartIDKey.getEnum(keyName);
                if (!this.consistentPartIDKeys(nxt, root, partIDKeys)) {
                    vAtts.appendUnique(keyName);
                    if (++n >= nMax) {
                        return vAtts;
                    }
                }
                if (!this.hasAttribute_KElement(keyName, null, false)) continue;
                currentPartition = keyName;
            }
            if (currentPartition != null && (vThis = (parent = this.getParentNode_KElement()).getChildElementVector_KElement(this.getNodeName(), this.getNamespaceURI(), new JDFAttributeMap(currentPartition, this.getAttribute_KElement(currentPartition)), true, 999)).size() > 1) {
                vAtts.appendUnique(currentPartition);
                if (++n >= nMax) {
                    return vAtts;
                }
            }
        }
        if (!JDFElement.EnumValidationLevel.isNoWarn(level) && this.isResourceRoot() && EnumPartUsage.Sparse.equals((Object)(pu = this.getPartUsage())) && JDFElement.EnumVersion.Version_1_3.isGreater(this.getVersion(true))) {
            vAtts.add("PartUsage");
        }
        return vAtts;
    }

    public boolean deleteUnLinked() {
        boolean bRet = false;
        VElement vLinks = this.getLinksAndRefs(true, true);
        if (vLinks == null) {
            VElement vRefs = this.getRefElements();
            if (vRefs != null) {
                VElement v2 = new VElement();
                for (int j = 0; j < vRefs.size(); ++j) {
                    v2.add(((JDFRefElement)vRefs.get(j)).getTarget());
                }
                vRefs = v2;
            }
            this.deleteNode();
            if (vRefs != null) {
                for (int j = 0; j < vRefs.size(); ++j) {
                    ((JDFResource)vRefs.get(j)).deleteUnLinked();
                }
            }
            bRet = true;
        }
        return bRet;
    }

    public static boolean getAutoAgent() {
        return autoAgent;
    }

    public static void setAutoAgent(boolean _autoAgent) {
        autoAgent = _autoAgent;
    }

    public boolean matchesString(String namedResLink) {
        if (namedResLink == null) {
            return true;
        }
        return this.getLocalName().equals(namedResLink);
    }

    public static boolean getAutoSubElementClass() {
        return autoSubElementClass;
    }

    public static void setAutoSubElementClass(boolean autoSubElementClass) {
        JDFResource.autoSubElementClass = autoSubElementClass;
    }

    private JDFResource getMyPartitionResource(Node e) {
        if (!(e instanceof JDFResource)) {
            return null;
        }
        if (JDFResource.class != e.getClass()) {
            return (JDFResource)(this.getClass() == e.getClass() ? e : null);
        }
        return (JDFResource)(e.getNodeName().equals(this.getNodeName()) ? e : null);
    }

    public JDFResource getLeaf(int i) {
        VElement v = this.getLeaves(false);
        return (JDFResource)v.get(i);
    }

    @Override
    public KElement moveElement(KElement src, KElement beforeChild) {
        if (src != null && src.getNodeName().equals(this.getNodeName()) && !((JDFResource)src).isResourceElement()) {
            ((JDFResource)src).getResourceRoot().partitionMap = null;
        }
        KElement moveElement = super.moveElement(src, beforeChild);
        this.updatePartitionMap(moveElement);
        return moveElement;
    }

    @Override
    public KElement copyElement(KElement src, KElement beforeChild) {
        KElement copy = super.copyElement(src, beforeChild);
        this.updatePartitionMap(copy);
        return copy;
    }

    @Override
    public KElement replaceElement(KElement src) {
        if (src != null && src.getNodeName().equals(this.getNodeName()) && !this.isResourceElement()) {
            this.getResourceRoot().partitionMap = null;
        }
        return super.replaceElement(src);
    }

    @Override
    public KElement deleteNode() {
        if (!this.isResourceElement()) {
            if (this.isLeaf()) {
                PartitionMap m = this.getResourceRoot().partitionMap;
                if (m != null) {
                    m.remove(this.getPartMap());
                }
            } else {
                this.getResourceRoot().partitionMap = null;
            }
        }
        return super.deleteNode();
    }

    @Override
    public KElement mergeElement(KElement kElem, boolean bDelete) {
        if (kElem != null && !((JDFResource)kElem).isLeaf() && !this.isResourceElement()) {
            this.getResourceRoot().partitionMap = null;
        }
        return super.mergeElement(kElem, bDelete);
    }

    @Override
    public synchronized Node insertBefore(Node src, Node arg1) throws DOMException {
        Node insertBefore = super.insertBefore(src, arg1);
        this.updatePartitionMap(insertBefore);
        return insertBefore;
    }

    void updatePartitionMap(Node src) {
        JDFAttributeMap newPartMap;
        if (src != null && src.getNodeName().equals(this.getNodeName()) && !this.isResourceElement() && this.getResourceRoot().partitionMap != null && !(newPartMap = ((JDFResource)src).getPartMap()).isEmpty()) {
            this.getResourceRoot().partitionMap.addPartitionMap(newPartMap, (JDFResource)src);
        }
    }

    static {
        JDFResource.atrInfoTable_Abstract[0] = new AtrInfoTable("AgentName", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Abstract[1] = new AtrInfoTable("AgentVersion", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Abstract[2] = new AtrInfoTable("Author", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Abstract[3] = new AtrInfoTable("CatalogID", 0x44443333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Abstract[4] = new AtrInfoTable("CatalogDetails", 0x4444333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Abstract[5] = new AtrInfoTable("Locked", 0x33333333L, AttributeInfo.EnumAttributeType.boolean_, null, "false");
        JDFResource.atrInfoTable_Abstract[6] = new AtrInfoTable("PipeID", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Abstract[7] = new AtrInfoTable("PipeProtocol", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_Abstract[8] = new AtrInfoTable("PipeURL", 0x33333311L, AttributeInfo.EnumAttributeType.URL, null, null);
        JDFResource.atrInfoTable_Abstract[9] = new AtrInfoTable("ProductID", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Abstract[10] = new AtrInfoTable("rRefs", 0x44444433L, AttributeInfo.EnumAttributeType.IDREFS, null, null);
        JDFResource.atrInfoTable_Abstract[11] = new AtrInfoTable("SpawnStatus", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumSpawnStatus.getEnum(0), EnumSpawnStatus.NotSpawned.getName());
        JDFResource.atrInfoTable_Abstract[12] = new AtrInfoTable("SpawnIDs", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFResource.atrInfoTable_Abstract[13] = new AtrInfoTable("Sorting", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_Abstract[14] = new AtrInfoTable("SortAmount", 0x33333333L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFResource.atrInfoTable_Abstract[15] = new AtrInfoTable("PartIDKeys", 0x33333333L, AttributeInfo.EnumAttributeType.enumerations, EnumPartIDKey.getEnum(0), null);
        JDFResource.atrInfoTable_Abstract[16] = new AtrInfoTable("PipePartIDKeys", 0x33333311L, AttributeInfo.EnumAttributeType.enumerations, EnumPartIDKey.getEnum(0), null);
        atrInfoTable_Physical = new AtrInfoTable[11];
        JDFResource.atrInfoTable_Physical[0] = new AtrInfoTable("AlternateBrand", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Physical[1] = new AtrInfoTable("Amount", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFResource.atrInfoTable_Physical[2] = new AtrInfoTable("AmountProduced", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFResource.atrInfoTable_Physical[3] = new AtrInfoTable("AmountRequired", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFResource.atrInfoTable_Physical[4] = new AtrInfoTable("BatchID", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Physical[5] = new AtrInfoTable("Brand", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Physical[6] = new AtrInfoTable("Unit", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_Physical[7] = new AtrInfoTable("ResourceWeight", 0x33333331L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFResource.atrInfoTable_Physical[8] = new AtrInfoTable("GrossWeight", 0x33333111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFResource.atrInfoTable_Physical[9] = new AtrInfoTable("Manufacturer", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_Physical[10] = new AtrInfoTable("LotControl", 0x33333111L, AttributeInfo.EnumAttributeType.enumeration, EnumLotControl.getEnum(0), null);
        atrInfoTable_Param = new AtrInfoTable[1];
        JDFResource.atrInfoTable_Param[0] = new AtrInfoTable("NoOp", 0x33333331L, AttributeInfo.EnumAttributeType.boolean_, null, "false");
        atrInfoTable_ID_Class_Required = new AtrInfoTable[3];
        JDFResource.atrInfoTable_ID_Class_Required[0] = new AtrInfoTable("ID", 0x22222222L, AttributeInfo.EnumAttributeType.ID, null, null);
        JDFResource.atrInfoTable_ID_Class_Required[1] = new AtrInfoTable("Class", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, EnumResourceClass.getEnum(0), null);
        JDFResource.atrInfoTable_ID_Class_Required[2] = new AtrInfoTable("PartUsage", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, EnumPartUsage.getEnum(0), EnumPartUsage.Explicit.getName());
        atrInfoTable_ID_Class_Optional = new AtrInfoTable[2];
        JDFResource.atrInfoTable_ID_Class_Optional[0] = new AtrInfoTable("ID", 0x44444433L, AttributeInfo.EnumAttributeType.ID, null, null);
        JDFResource.atrInfoTable_ID_Class_Optional[1] = new AtrInfoTable("Class", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumResourceClass.getEnum(0), null);
        atrInfoTable_ID_Class_Root = new AtrInfoTable[3];
        JDFResource.atrInfoTable_ID_Class_Root[0] = new AtrInfoTable("ID", 0x33333333L, AttributeInfo.EnumAttributeType.ID, null, null);
        JDFResource.atrInfoTable_ID_Class_Root[1] = new AtrInfoTable("Class", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumResourceClass.getEnum(0), null);
        JDFResource.atrInfoTable_ID_Class_Root[2] = new AtrInfoTable("PartUsage", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, EnumPartUsage.getEnum(0), null);
        atrInfoTable_Status_Required = new AtrInfoTable[1];
        JDFResource.atrInfoTable_Status_Required[0] = new AtrInfoTable("Status", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, EnumResStatus.getEnum(0), null);
        atrInfoTable_Status_Optional = new AtrInfoTable[1];
        JDFResource.atrInfoTable_Status_Optional[0] = new AtrInfoTable("Status", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumResStatus.getEnum(0), null);
        atrInfoTable_UpdateID_Optional = new AtrInfoTable[1];
        JDFResource.atrInfoTable_UpdateID_Optional[0] = new AtrInfoTable("UpdateID", 0x44444331L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        atrInfoTable_UpdateID_Required = new AtrInfoTable[1];
        JDFResource.atrInfoTable_UpdateID_Required[0] = new AtrInfoTable("UpdateID", 0x44444221L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        atrInfoTable_PartIDKeys = new AtrInfoTable[56];
        JDFResource.atrInfoTable_PartIDKeys[0] = new AtrInfoTable("BinderySignatureName", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[1] = new AtrInfoTable("BlockName", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[2] = new AtrInfoTable("BundleItemIndex", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[3] = new AtrInfoTable("CellIndex", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[4] = new AtrInfoTable("Condition", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[5] = new AtrInfoTable("DocCopies", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[6] = new AtrInfoTable("DocIndex", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[7] = new AtrInfoTable("DocRunIndex", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[8] = new AtrInfoTable("DocSheetIndex", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[9] = new AtrInfoTable("FountainNumber", 0x33333333L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFResource.atrInfoTable_PartIDKeys[10] = new AtrInfoTable("ItemNames", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFResource.atrInfoTable_PartIDKeys[11] = new AtrInfoTable("LayerIDs", 0x33333331L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[12] = new AtrInfoTable("Location", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[13] = new AtrInfoTable("Option", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[14] = new AtrInfoTable("PageNumber", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[15] = new AtrInfoTable("PartVersion", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFResource.atrInfoTable_PartIDKeys[16] = new AtrInfoTable("PreflightRule", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[17] = new AtrInfoTable("PreviewType", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, JDFAutoPart.EnumPreviewType.getEnum(0), null);
        JDFResource.atrInfoTable_PartIDKeys[18] = new AtrInfoTable("RibbonName", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[19] = new AtrInfoTable("Run", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[20] = new AtrInfoTable("RunIndex", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[21] = new AtrInfoTable("RunTags", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFResource.atrInfoTable_PartIDKeys[22] = new AtrInfoTable("RunPage", 0x33333331L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFResource.atrInfoTable_PartIDKeys[23] = new AtrInfoTable("SectionIndex", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[24] = new AtrInfoTable("Separation", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_PartIDKeys[25] = new AtrInfoTable("SetDocIndex", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[26] = new AtrInfoTable("SetIndex", 0x33333331L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[27] = new AtrInfoTable("SetRunIndex", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[28] = new AtrInfoTable("SetSheetIndex", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[29] = new AtrInfoTable("SheetIndex", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFResource.atrInfoTable_PartIDKeys[30] = new AtrInfoTable("SheetName", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_PartIDKeys[31] = new AtrInfoTable("Side", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, JDFAutoPart.EnumSide.getEnum(0), null);
        JDFResource.atrInfoTable_PartIDKeys[32] = new AtrInfoTable("SignatureName", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFResource.atrInfoTable_PartIDKeys[33] = new AtrInfoTable("TileID", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFResource.atrInfoTable_PartIDKeys[34] = new AtrInfoTable("WebName", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[35] = new AtrInfoTable("DeliveryUnit0", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[36] = new AtrInfoTable("DeliveryUnit1", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[37] = new AtrInfoTable("DeliveryUnit2", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[38] = new AtrInfoTable("DeliveryUnit3", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[39] = new AtrInfoTable("DeliveryUnit4", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[40] = new AtrInfoTable("DeliveryUnit5", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[41] = new AtrInfoTable("DeliveryUnit6", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[42] = new AtrInfoTable("DeliveryUnit7", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[43] = new AtrInfoTable("DeliveryUnit8", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[44] = new AtrInfoTable("DeliveryUnit9", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[45] = new AtrInfoTable("Edition", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[46] = new AtrInfoTable("EditionVersion", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[47] = new AtrInfoTable("PageTags", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFResource.atrInfoTable_PartIDKeys[48] = new AtrInfoTable("PlateLayout", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[49] = new AtrInfoTable("WebSetup", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[50] = new AtrInfoTable("RunSet", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[51] = new AtrInfoTable("DocTags", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFResource.atrInfoTable_PartIDKeys[52] = new AtrInfoTable("SetTags", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFResource.atrInfoTable_PartIDKeys[53] = new AtrInfoTable("SubRun", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[54] = new AtrInfoTable("WebProduct", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFResource.atrInfoTable_PartIDKeys[55] = new AtrInfoTable("ProductPart", 0x33331111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        elemInfoTable_Abstract = new ElemInfoTable[3];
        JDFResource.elemInfoTable_Abstract[0] = new ElemInfoTable("QualityControlResult", 0x33333311L);
        JDFResource.elemInfoTable_Abstract[1] = new ElemInfoTable("SourceResource", 0x33333111L);
        JDFResource.elemInfoTable_Abstract[2] = new ElemInfoTable("Identical", 0x33333111L);
        elemInfoTable_Physical = new ElemInfoTable[3];
        JDFResource.elemInfoTable_Physical[0] = new ElemInfoTable("Location", 0x33333333L);
        JDFResource.elemInfoTable_Physical[1] = new ElemInfoTable("Contact", 0x33333333L);
        JDFResource.elemInfoTable_Physical[2] = new ElemInfoTable("IdentificationField", 0x33333331L);
    }

    private class Collapser {
        protected Collapser() {
        }

        boolean unpartition(boolean force) {
            if (!JDFResource.this.isResourceRoot()) {
                throw new JDFException("Unpartition currently only implemented for root nodes");
            }
            JDFResource.this.collapse(false, true);
            VElement v = JDFResource.this.getLeaves(true);
            v.remove(JDFResource.this);
            boolean clean = true;
            if (!force) {
                for (KElement e : v) {
                    JDFResource r = (JDFResource)e;
                    if (!this.containsData(r)) continue;
                    clean = false;
                    break;
                }
            }
            if (clean) {
                for (KElement e : v) {
                    e.deleteNode();
                }
                JDFResource.this.removeAttribute("PartIDKeys");
            }
            return clean;
        }

        protected boolean containsData(JDFResource r) {
            VElement ve = r.getChildElementVector_KElement(null, null, null, true, 0);
            String locName = r.getLocalName();
            for (KElement e : ve) {
                if (locName.equals(e.getLocalName())) continue;
                return true;
            }
            VString v = r.getAttributeVector_KElement();
            if (v != null) {
                VString ignoreAtts = r.getPartIDKeys();
                ignoreAtts.add("Class");
                ignoreAtts.add("ID");
                ignoreAtts.add("AgentName");
                ignoreAtts.add("AgentVersion");
                ignoreAtts.add("PartUsage");
                if (r.isResourceRoot()) {
                    ignoreAtts.add("Status");
                }
                v.removeStrings(ignoreAtts, 0);
                return v.size() != 0;
            }
            return false;
        }

        void expand(boolean bDeleteFromNode) {
            VElement leaves = JDFIdentical.removeIdenticals(JDFResource.this.getLeaves(false));
            if (leaves.size() == 1 && leaves.elementAt(0) == JDFResource.this && JDFResource.this.isResourceRoot()) {
                return;
            }
            VString parts = JDFResource.this.getRootPartAtts();
            for (KElement e : leaves) {
                JDFResource leaf = (JDFResource)e;
                this.expandLeaf(leaf, parts);
            }
            if (bDeleteFromNode) {
                this.deleteFromNode(leaves, parts);
            }
        }

        void expandLeaf(JDFResource leaf, VString parts) {
            if (parts == null) {
                parts = JDFResource.this.getRootPartAtts();
            }
            VString atts = new VString(leaf.getAttributeVector_JDFResource());
            for (String aj : atts) {
                if (parts.contains(aj)) continue;
                leaf.setAttribute(aj, leaf.getAttribute(aj, null, null), null);
            }
            VElement vElm = leaf.getChildElementVector(null, null, null, true, 0, false);
            for (KElement elm : vElm) {
                String nodeName = elm.getNodeName();
                if (leaf.getElement_JDFElement(nodeName, null, 0) != null) continue;
                VElement vCopy = leaf.getChildElementVector(nodeName, null, null, true, 0, false);
                for (KElement copy : vCopy) {
                    leaf.copyElement(copy, null);
                }
            }
        }

        private void deleteFromNode(VElement leaves, VString parts) {
            String nodeName = JDFResource.this.getNodeName();
            block0: for (KElement e : leaves) {
                JDFResource res = (JDFResource)e;
                for (JDFElement r = (JDFElement)res.getParentNode_KElement(); r != null && r.getNodeName().equals(nodeName); r = (JDFElement)r.getParentNode_KElement()) {
                    VString atts = new VString(r.getAttributeVector());
                    for (String aj : atts) {
                        if (parts.contains(aj)) continue;
                        r.removeAttribute(aj, null);
                    }
                    VElement vElm = r.getChildElementVector_JDFElement(null, null, null, true, 0, false);
                    for (KElement elm : vElm) {
                        if (elm.getNodeName().equals(nodeName)) continue;
                        elm.deleteNode();
                    }
                    if (r == JDFResource.this) continue block0;
                }
            }
        }

        void collapse(boolean bCollapseToNode, boolean bCollapseElements) {
            VElement leaves = JDFIdentical.removeIdenticals(JDFResource.this.getLeaves(false));
            if (leaves.size() == 1 && leaves.elementAt(0) == JDFResource.this) {
                return;
            }
            VString parts = JDFResource.this.getRootPartAtts();
            block0: for (KElement l : leaves) {
                JDFResource leaf = (JDFResource)l;
                VString atts = leaf.getAttributeVector_JDFResource();
                atts.removeStrings(parts, Integer.MAX_VALUE);
                JDFResource parent = (JDFResource)leaf.getParentNode_KElement();
                while (true) {
                    VElement localLeaves = JDFIdentical.removeIdenticals(parent.getChildElementVector_JDFElement(JDFResource.this.getNodeName(), null, null, true, 0, false));
                    this.collapseAttributes(bCollapseToNode, leaf, atts, parent, localLeaves, true);
                    if (bCollapseElements) {
                        this.collapseElements(bCollapseToNode, leaf, parent, localLeaves);
                    }
                    if (parent.isResourceRoot() || parent == JDFResource.this) continue block0;
                    leaf = parent;
                    parent = (JDFResource)parent.getParentNode_KElement();
                }
            }
        }

        private void collapseAttributes(boolean bCollapseToNode, JDFResource leaf, VString atts, JDFResource parent, VElement localLeaves, boolean removeEqual) {
            int localSize = localLeaves.size();
            for (String att : atts) {
                String parentAttribute;
                if (!bCollapseToNode && !parent.hasAttribute(att, null, false)) {
                    String attVal = leaf.getAttribute_KElement(att, null, "");
                    if (!parent.getAttribute(att).equals(attVal)) {
                        int l;
                        boolean bAllSame = true;
                        for (l = 0; l < localSize; ++l) {
                            if (localLeaves.elementAt(l).getAttribute(att, null, "").equals(attVal)) continue;
                            bAllSame = false;
                            break;
                        }
                        if (bAllSame) {
                            parent.setAttribute(att, attVal, null);
                            if (removeEqual) {
                                for (l = 0; l < localSize; ++l) {
                                    localLeaves.elementAt(l).removeAttribute(att);
                                }
                            }
                        }
                    }
                }
                if ((parentAttribute = parent.getAttribute(att, null, null)) == null || !parentAttribute.equals(leaf.getAttribute_KElement(att, null, null))) continue;
                leaf.removeAttribute(att, null);
            }
        }

        private void collapseElements(boolean bCollapseToNode, JDFResource leaf, JDFResource parent, VElement localLeaves) {
            int localSize = localLeaves.size();
            VElement vElm = leaf.getChildElementVector_JDFElement(null, null, null, true, 0, false);
            String resName = parent.getNodeName();
            for (int j = 0; j < vElm.size(); ++j) {
                int k;
                int kk;
                boolean bElmEqual;
                String nodeName = vElm.elementAt(j).getNodeName();
                if (resName.equals(nodeName)) continue;
                VElement vParentElm = parent.getChildElementVector(nodeName, null, null, true, 0, false);
                VElement vLocalElm = leaf.getChildElementVector_JDFElement(nodeName, null, null, true, 0, false);
                VElement localNamedElements0 = localLeaves.elementAt(0).getChildElementVector(nodeName, null, null, true, 0, false);
                int elm0Size = localNamedElements0.size();
                boolean bl = bElmEqual = elm0Size > 0;
                if ((bCollapseToNode || vParentElm.size() > 0) && vParentElm.size() != elm0Size) {
                    bElmEqual = false;
                }
                if (bElmEqual && elm0Size == vParentElm.size()) {
                    for (kk = 0; kk < elm0Size; ++kk) {
                        KElement kelem2;
                        KElement kelem1 = localNamedElements0.elementAt(kk);
                        if (kelem1.isEqual(kelem2 = vParentElm.elementAt(kk))) continue;
                        bElmEqual = false;
                        break;
                    }
                }
                if (bElmEqual) {
                    for (k = 1; k < localSize; ++k) {
                        VElement localNamedElements = localLeaves.elementAt(k).getChildElementVector(nodeName, null, null, true, 0, false);
                        if (localNamedElements.size() != elm0Size) {
                            bElmEqual = false;
                            break;
                        }
                        for (int kk2 = 0; kk2 < elm0Size; ++kk2) {
                            if (localNamedElements0.elementAt(kk2).isEqual(localNamedElements.elementAt(kk2))) continue;
                            bElmEqual = false;
                            break;
                        }
                        if (!bElmEqual) break;
                    }
                }
                if (bElmEqual) {
                    if (!bCollapseToNode) {
                        parent.removeChildren(nodeName, null, null);
                        for (k = 0; k < elm0Size; ++k) {
                            parent.copyElement(localNamedElements0.elementAt(k), null);
                        }
                    }
                    for (kk = 0; kk < localSize; ++kk) {
                        localLeaves.elementAt(kk).removeChildren(nodeName, null, null);
                    }
                    continue;
                }
                if (vParentElm.size() != vLocalElm.size()) continue;
                boolean bZappEm = vParentElm.size() > 0;
                for (int k2 = 0; k2 < vParentElm.size(); ++k2) {
                    if (vParentElm.elementAt(k2).isEqual(vLocalElm.elementAt(k2))) continue;
                    bZappEm = false;
                    break;
                }
                if (!bZappEm) continue;
                leaf.removeChildren(nodeName, null, null);
            }
        }
    }

    class RefFinder {
        final boolean bLink;
        final boolean bRef;

        RefFinder(boolean bLink, boolean bRef) {
            this.bLink = bLink;
            this.bRef = bRef;
        }

        VElement getLinksAndRefs() {
            if (!this.bLink && !this.bRef) {
                return null;
            }
            JDFNode n = JDFResource.this.getParentJDF();
            String resID = JDFResource.this.getID();
            if (n == null || StringUtil.getNonEmpty(resID) == null) {
                return null;
            }
            VElement vRet = this.getRootLinksAndRefs(n, resID);
            this.reduceParts(vRet);
            return vRet.size() > 0 ? vRet : null;
        }

        private void reduceParts(VElement vRet) {
            JDFAttributeMap mPart = JDFResource.this.getPartMap();
            if (mPart != null && mPart.size() > 0) {
                for (int i = vRet.size() - 1; i >= 0; --i) {
                    JDFAttributeMap partMap;
                    KElement e = vRet.elementAt(i);
                    VJDFAttributeMap linkMapVector = null;
                    if (e instanceof JDFResourceLink) {
                        linkMapVector = ((JDFResourceLink)e).getPartMapVector();
                    } else if (e instanceof JDFRefElement && (partMap = ((JDFRefElement)e).getPartMap()) != null) {
                        linkMapVector = new VJDFAttributeMap();
                        linkMapVector.add(partMap);
                    }
                    if (linkMapVector == null) continue;
                    int nZapp = 0;
                    int size = linkMapVector.size();
                    for (int j = 0; j < size; ++j) {
                        JDFAttributeMap m2 = linkMapVector.elementAt(j);
                        if (m2.overlapMap(mPart)) continue;
                        ++nZapp;
                    }
                    if (nZapp != size) continue;
                    vRet.remove(i);
                }
            }
        }

        private VElement getRootLinksAndRefs(JDFNode n, String resID) {
            VElement vRet;
            JDFAttributeMap mID = new JDFAttributeMap("rRef", resID);
            VString refList = this.getRefList();
            if (this.bRef) {
                vRet = n.getChildrenFromList(refList, mID, false, null);
            } else {
                VElement vNodes = n.getvJDFNode(null, null, false);
                vRet = new VElement();
                for (KElement nE : vNodes) {
                    VElement vTmp = ((JDFNode)nE).getResourceLinks(null);
                    if (vTmp == null) continue;
                    for (KElement lE : vTmp) {
                        JDFResourceLink link = (JDFResourceLink)lE;
                        if (!resID.equals(link.getrRef())) continue;
                        vRet.add(link);
                    }
                }
            }
            return vRet;
        }

        private VString getRefList() {
            VString refList = new VString();
            if (this.bLink) {
                refList.add(JDFResource.this.getLinkString());
            }
            if (this.bRef) {
                refList.add(JDFResource.this.getRefString());
            }
            return refList;
        }
    }

    public static final class EnumSpawnStatus
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumSpawnStatus NotSpawned = new EnumSpawnStatus("NotSpawned");
        public static final EnumSpawnStatus SpawnedRO = new EnumSpawnStatus("SpawnedRO");
        public static final EnumSpawnStatus SpawnedRW = new EnumSpawnStatus("SpawnedRW");

        @Deprecated
        public String toString() {
            return this.getName();
        }

        private EnumSpawnStatus(String name) {
            super(name, m_startValue++);
        }

        public static EnumSpawnStatus getEnum(String enumName) {
            return (EnumSpawnStatus)EnumSpawnStatus.getEnum(EnumSpawnStatus.class, (String)enumName);
        }

        public static EnumSpawnStatus getEnum(int enumValue) {
            return (EnumSpawnStatus)EnumSpawnStatus.getEnum(EnumSpawnStatus.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumSpawnStatus.getEnumMap(EnumSpawnStatus.class);
        }

        public static List getEnumList() {
            return EnumSpawnStatus.getEnumList(EnumSpawnStatus.class);
        }

        public static Iterator iterator() {
            return EnumSpawnStatus.iterator(EnumSpawnStatus.class);
        }
    }

    public static final class EnumPartIDKey
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPartIDKey BinderySignatureName = new EnumPartIDKey("BinderySignatureName");
        public static final EnumPartIDKey BinderySignaturePaginationIndex = new EnumPartIDKey("BinderySignaturePaginationIndex");
        public static final EnumPartIDKey BlockName = new EnumPartIDKey("BlockName");
        public static final EnumPartIDKey BundleItemIndex = new EnumPartIDKey("BundleItemIndex");
        public static final EnumPartIDKey CellIndex = new EnumPartIDKey("CellIndex");
        public static final EnumPartIDKey Condition = new EnumPartIDKey("Condition");
        public static final EnumPartIDKey DocCopies = new EnumPartIDKey("DocCopies");
        public static final EnumPartIDKey DocIndex = new EnumPartIDKey("DocIndex");
        public static final EnumPartIDKey DocRunIndex = new EnumPartIDKey("DocRunIndex");
        public static final EnumPartIDKey DocSheetIndex = new EnumPartIDKey("DocSheetIndex");
        public static final EnumPartIDKey FountainNumber = new EnumPartIDKey("FountainNumber");
        public static final EnumPartIDKey ItemNames = new EnumPartIDKey("ItemNames");
        public static final EnumPartIDKey LayerIDs = new EnumPartIDKey("LayerIDs");
        public static final EnumPartIDKey Location = new EnumPartIDKey("Location");
        public static final EnumPartIDKey LotID = new EnumPartIDKey("LotID");
        public static final EnumPartIDKey Option = new EnumPartIDKey("Option");
        public static final EnumPartIDKey PageNumber = new EnumPartIDKey("PageNumber");
        public static final EnumPartIDKey PartVersion = new EnumPartIDKey("PartVersion");
        public static final EnumPartIDKey PreflightRule = new EnumPartIDKey("PreflightRule");
        public static final EnumPartIDKey PreviewType = new EnumPartIDKey("PreviewType");
        public static final EnumPartIDKey PrintCondition = new EnumPartIDKey("PrintCondition");
        public static final EnumPartIDKey ProductPart = new EnumPartIDKey("ProductPart");
        public static final EnumPartIDKey QualityMeasurement = new EnumPartIDKey("QualityMeasurement");
        public static final EnumPartIDKey RibbonName = new EnumPartIDKey("RibbonName");
        public static final EnumPartIDKey Run = new EnumPartIDKey("Run");
        public static final EnumPartIDKey RunIndex = new EnumPartIDKey("RunIndex");
        public static final EnumPartIDKey RunTags = new EnumPartIDKey("RunTags");
        public static final EnumPartIDKey RunPage = new EnumPartIDKey("RunPage");
        public static final EnumPartIDKey RunPageRange = new EnumPartIDKey("RunPageRange");
        public static final EnumPartIDKey Separation = new EnumPartIDKey("Separation");
        public static final EnumPartIDKey SectionIndex = new EnumPartIDKey("SectionIndex");
        public static final EnumPartIDKey SetCopies = new EnumPartIDKey("SetCopies");
        public static final EnumPartIDKey SetDocIndex = new EnumPartIDKey("SetDocIndex");
        public static final EnumPartIDKey SetSheetIndex = new EnumPartIDKey("SetSheetIndex");
        public static final EnumPartIDKey SetIndex = new EnumPartIDKey("SetIndex");
        public static final EnumPartIDKey SetRunIndex = new EnumPartIDKey("SetRunIndex");
        public static final EnumPartIDKey SheetIndex = new EnumPartIDKey("SheetIndex");
        public static final EnumPartIDKey SheetName = new EnumPartIDKey("SheetName");
        public static final EnumPartIDKey Side = new EnumPartIDKey("Side");
        public static final EnumPartIDKey SignatureName = new EnumPartIDKey("SignatureName");
        public static final EnumPartIDKey TileID = new EnumPartIDKey("TileID");
        public static final EnumPartIDKey TransferCurveName = new EnumPartIDKey("TransferCurveName");
        public static final EnumPartIDKey WebName = new EnumPartIDKey("WebName");
        public static final EnumPartIDKey DeliveryUnit0 = new EnumPartIDKey("DeliveryUnit0");
        public static final EnumPartIDKey DeliveryUnit1 = new EnumPartIDKey("DeliveryUnit1");
        public static final EnumPartIDKey DeliveryUnit2 = new EnumPartIDKey("DeliveryUnit2");
        public static final EnumPartIDKey DeliveryUnit3 = new EnumPartIDKey("DeliveryUnit3");
        public static final EnumPartIDKey DeliveryUnit4 = new EnumPartIDKey("DeliveryUnit4");
        public static final EnumPartIDKey DeliveryUnit5 = new EnumPartIDKey("DeliveryUnit5");
        public static final EnumPartIDKey DeliveryUnit6 = new EnumPartIDKey("DeliveryUnit6");
        public static final EnumPartIDKey DeliveryUnit7 = new EnumPartIDKey("DeliveryUnit7");
        public static final EnumPartIDKey DeliveryUnit8 = new EnumPartIDKey("DeliveryUnit8");
        public static final EnumPartIDKey DeliveryUnit9 = new EnumPartIDKey("DeliveryUnit9");
        public static final EnumPartIDKey Edition = new EnumPartIDKey("Edition");
        public static final EnumPartIDKey EditionVersion = new EnumPartIDKey("EditionVersion");
        public static final EnumPartIDKey PageTags = new EnumPartIDKey("PageTags");
        public static final EnumPartIDKey PlateLayout = new EnumPartIDKey("PlateLayout");
        public static final EnumPartIDKey RunSet = new EnumPartIDKey("RunSet");
        public static final EnumPartIDKey DocTags = new EnumPartIDKey("DocTags");
        public static final EnumPartIDKey SetTags = new EnumPartIDKey("SetTags");
        public static final EnumPartIDKey SubRun = new EnumPartIDKey("SubRun");
        public static final EnumPartIDKey WebProduct = new EnumPartIDKey("WebProduct");
        public static final EnumPartIDKey StationName = new EnumPartIDKey("StationName");
        public static final EnumPartIDKey WebSetup = new EnumPartIDKey("WebSetup");
        public static final EnumPartIDKey Metadata0 = new EnumPartIDKey("Metadata0");
        public static final EnumPartIDKey Metadata1 = new EnumPartIDKey("Metadata1");
        public static final EnumPartIDKey Metadata2 = new EnumPartIDKey("Metadata2");
        public static final EnumPartIDKey Metadata3 = new EnumPartIDKey("Metadata3");
        public static final EnumPartIDKey Metadata4 = new EnumPartIDKey("Metadata4");
        public static final EnumPartIDKey Metadata5 = new EnumPartIDKey("Metadata5");
        public static final EnumPartIDKey Metadata6 = new EnumPartIDKey("Metadata6");
        public static final EnumPartIDKey Metadata7 = new EnumPartIDKey("Metadata7");
        public static final EnumPartIDKey Metadata8 = new EnumPartIDKey("Metadata8");
        public static final EnumPartIDKey Metadata9 = new EnumPartIDKey("Metadata9");

        @Deprecated
        public String toString() {
            return this.getName();
        }

        private EnumPartIDKey(String name) {
            super(name, m_startValue++);
        }

        public static EnumPartIDKey getEnum(String enumName) {
            return (EnumPartIDKey)EnumPartIDKey.getEnum(EnumPartIDKey.class, (String)enumName);
        }

        public static EnumPartIDKey getEnum(int enumValue) {
            return (EnumPartIDKey)EnumPartIDKey.getEnum(EnumPartIDKey.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPartIDKey.getEnumMap(EnumPartIDKey.class);
        }

        public static List<EnumPartIDKey> getEnumList() {
            return EnumPartIDKey.getEnumList(EnumPartIDKey.class);
        }

        public static Iterator<EnumPartIDKey> iterator() {
            return EnumPartIDKey.iterator(EnumPartIDKey.class);
        }
    }

    public static final class EnumPartUsage
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPartUsage Explicit = new EnumPartUsage("Explicit");
        public static final EnumPartUsage Sparse = new EnumPartUsage("Sparse");
        public static final EnumPartUsage Implicit = new EnumPartUsage("Implicit");

        private EnumPartUsage(String name) {
            super(name, m_startValue++);
        }

        public static EnumPartUsage getEnum(String enumName) {
            if ("Implicit".equals(enumName)) {
                return Implicit;
            }
            if ("Explicit".equals(enumName)) {
                return Explicit;
            }
            if ("Sparse".equals(enumName)) {
                return Sparse;
            }
            return null;
        }

        public static EnumPartUsage getEnum(int enumValue) {
            return (EnumPartUsage)EnumPartUsage.getEnum(EnumPartUsage.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPartUsage.getEnumMap(EnumPartUsage.class);
        }

        public static List getEnumList() {
            return EnumPartUsage.getEnumList(EnumPartUsage.class);
        }

        public static Iterator iterator() {
            return EnumPartUsage.iterator(EnumPartUsage.class);
        }
    }

    public static final class EnumLotControl
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumLotControl Controlled = new EnumLotControl("Controlled");
        public static final EnumLotControl NotControlled = new EnumLotControl("NotControlled");

        private EnumLotControl(String name) {
            super(name, m_startValue++);
        }

        public static EnumLotControl getEnum(String enumName) {
            return (EnumLotControl)EnumLotControl.getEnum(EnumLotControl.class, (String)enumName);
        }

        public static EnumLotControl getEnum(int enumValue) {
            return (EnumLotControl)EnumLotControl.getEnum(EnumLotControl.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumLotControl.getEnumMap(EnumLotControl.class);
        }

        public static List getEnumList() {
            return EnumLotControl.getEnumList(EnumLotControl.class);
        }

        public static Iterator iterator() {
            return EnumLotControl.iterator(EnumLotControl.class);
        }
    }

    public static final class EnumResStatus
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumResStatus Incomplete = new EnumResStatus("Incomplete");
        public static final EnumResStatus Rejected = new EnumResStatus("Rejected");
        public static final EnumResStatus Unavailable = new EnumResStatus("Unavailable");
        public static final EnumResStatus InUse = new EnumResStatus("InUse");
        public static final EnumResStatus Draft = new EnumResStatus("Draft");
        public static final EnumResStatus Complete = new EnumResStatus("Complete");
        public static final EnumResStatus Available = new EnumResStatus("Available");

        private EnumResStatus(String name) {
            super(name, m_startValue++);
        }

        public static EnumResStatus getEnum(String enumName) {
            return (EnumResStatus)EnumResStatus.getEnum(EnumResStatus.class, (String)enumName);
        }

        public static EnumResStatus getEnum(int enumValue) {
            return (EnumResStatus)EnumResStatus.getEnum(EnumResStatus.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumResStatus.getEnumMap(EnumResStatus.class);
        }

        public static List getEnumList() {
            return EnumResStatus.getEnumList(EnumResStatus.class);
        }

        public static Iterator iterator() {
            return EnumResStatus.iterator(EnumResStatus.class);
        }
    }

    public static final class EnumResourceClass
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumResourceClass Parameter = new EnumResourceClass("Parameter");
        public static final EnumResourceClass Handling = new EnumResourceClass("Handling");
        public static final EnumResourceClass Consumable = new EnumResourceClass("Consumable");
        public static final EnumResourceClass Quantity = new EnumResourceClass("Quantity");
        public static final EnumResourceClass Implementation = new EnumResourceClass("Implementation");
        public static final EnumResourceClass PlaceHolder = new EnumResourceClass("PlaceHolder");
        public static final EnumResourceClass Intent = new EnumResourceClass("Intent");

        private EnumResourceClass(String name) {
            super(name, m_startValue++);
        }

        public static EnumResourceClass getEnum(String enumName) {
            if ("Consumable".equals(enumName)) {
                return Consumable;
            }
            if ("Parameter".equals(enumName)) {
                return Parameter;
            }
            if ("Intent".equals(enumName)) {
                return Intent;
            }
            if ("Implementation".equals(enumName)) {
                return Implementation;
            }
            if ("Quantity".equals(enumName)) {
                return Quantity;
            }
            if ("Handling".equals(enumName)) {
                return Handling;
            }
            if ("PlaceHolder".equals(enumName)) {
                return PlaceHolder;
            }
            return null;
        }

        public static EnumResourceClass getEnum(int enumValue) {
            return (EnumResourceClass)EnumResourceClass.getEnum(EnumResourceClass.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumResourceClass.getEnumMap(EnumResourceClass.class);
        }

        public static List getEnumList() {
            return EnumResourceClass.getEnumList(EnumResourceClass.class);
        }

        public static Iterator iterator() {
            return EnumResourceClass.iterator(EnumResourceClass.class);
        }
    }

    public static final class EnumAmountMerge
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumAmountMerge None = new EnumAmountMerge("None");
        public static final EnumAmountMerge LinkOnly = new EnumAmountMerge("LinkOnly");
        public static final EnumAmountMerge UpdateLink = new EnumAmountMerge("UpdateLink");

        private EnumAmountMerge(String name) {
            super(name, m_startValue++);
        }

        public static EnumAmountMerge getEnum(String enumName) {
            return (EnumAmountMerge)EnumAmountMerge.getEnum(EnumAmountMerge.class, (String)enumName);
        }

        public static EnumAmountMerge getEnum(int enumValue) {
            return (EnumAmountMerge)EnumAmountMerge.getEnum(EnumAmountMerge.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumAmountMerge.getEnumMap(EnumAmountMerge.class);
        }

        public static List getEnumList() {
            return EnumAmountMerge.getEnumList(EnumAmountMerge.class);
        }

        public static Iterator iterator() {
            return EnumAmountMerge.iterator(EnumAmountMerge.class);
        }
    }

    @Deprecated
    public class PartionGetter
    extends PartitionGetter {
        public PartionGetter() {
            super(JDFResource.this);
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public boolean isFollowIdentical() {
            return super.isFollowIdentical();
        }

        @Override
        public void setFollowIdentical(boolean followIdentical) {
            super.setFollowIdentical(followIdentical);
        }

        @Override
        public VElement getPartitionVector(VJDFAttributeMap vm, EnumPartUsage partUsage) {
            return super.getPartitionVector(vm, partUsage);
        }

        @Override
        public VJDFAttributeMap getPartitionMaps(VJDFAttributeMap vm, EnumPartUsage partUsage) {
            return super.getPartitionMaps(vm, partUsage);
        }

        @Override
        public VElement getPartitionVector(JDFAttributeMap m, EnumPartUsage partUsage) {
            return super.getPartitionVector(m, partUsage);
        }

        @Override
        public JDFResource getPartition(JDFAttributeMap m, EnumPartUsage partUsage) {
            return super.getPartition(m, partUsage);
        }

        @Override
        protected JDFResource getDeepPart(JDFAttributeMap m, EnumPartUsage partUsage) {
            return super.getDeepPart(m, partUsage);
        }

        @Override
        public JDFResource getCreatePartition(JDFAttributeMap partMap, VString vPartKeys) {
            return super.getCreatePartition(partMap, vPartKeys);
        }

        @Override
        public JDFResource addPartition(EnumPartIDKey partType, String value) {
            return super.addPartition(partType, value);
        }

        @Override
        public void setStrictPartVersion(boolean strictPartVersion) {
            super.setStrictPartVersion(strictPartVersion);
        }
    }
}

