/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;

class PartitionMap {
    private final HashMap<JDFAttributeMap, JDFResource> leafMap;
    private final VString partIDKeys;

    PartitionMap(JDFResource r) {
        this.partIDKeys = r.getPartIDKeys();
        this.leafMap = new LinkedHashMap<JDFAttributeMap, JDFResource>();
        this.addPartitionMap(new JDFAttributeMap(), r.getResourceRoot());
    }

    void addPartitionMap(JDFAttributeMap parentMap, JDFResource parent) {
        Vector<? extends KElement> v;
        this.leafMap.put(parentMap, parent);
        String key = this.partIDKeys.get(parentMap.size());
        Vector<? extends KElement> vector = v = key == null ? null : parent.getDirectPartitionVector();
        if (v != null && !v.isEmpty()) {
            for (KElement kElement : v) {
                JDFResource r = (JDFResource)kElement;
                JDFAttributeMap newMap = parentMap.clone();
                String val = r.getAttribute_KElement(key);
                newMap.put(key, val);
                this.addPartitionMap(newMap, r);
            }
        }
    }

    JDFResource get(JDFAttributeMap arg0) {
        return this.leafMap.get(arg0);
    }

    Set<JDFAttributeMap> keySet() {
        return this.leafMap.keySet();
    }

    VString getPartIDKeys() {
        return this.partIDKeys;
    }

    boolean hasMissingKeys(JDFAttributeMap m) {
        int s = m.size();
        if (s == 0) {
            return false;
        }
        for (String k : this.partIDKeys) {
            if (!m.containsKey(k)) {
                return true;
            }
            if (--s != 0) continue;
            return false;
        }
        return false;
    }

    JDFResource put(JDFAttributeMap arg0, JDFResource arg1) {
        return this.leafMap.put(arg0, arg1);
    }

    void updatePartIDKeys(VString vPartIDKeys) {
        this.partIDKeys.appendUnique(vPartIDKeys);
    }

    HashMap<JDFAttributeMap, JDFResource> getLeafMap() {
        return this.leafMap;
    }

    public String toString() {
        return "PartitionMap [leafMap=" + this.leafMap + ", partIDKeys=" + this.partIDKeys + "]";
    }

    int size() {
        return this.leafMap.size();
    }

    public JDFResource remove(Object key) {
        return this.leafMap.remove(key);
    }
}

