/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoColorantControl;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.resource.process.JDFDeviceNSpace;
import org.w3c.dom.DOMException;

public class JDFColorantControl
extends JDFAutoColorantControl {
    private static final long serialVersionUID = 1L;

    public JDFColorantControl(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFColorantControl(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFColorantControl(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFColorantControl[  --> " + super.toString() + " ]";
    }

    @Override
    public Vector<JDFResource.EnumPartIDKey> getImplicitPartitions() {
        Vector<JDFResource.EnumPartIDKey> v = super.getImplicitPartitions();
        if (v == null) {
            v = new Vector();
        }
        v.add(JDFResource.EnumPartIDKey.Separation);
        return v;
    }

    public VString getDeviceColorantOrderSeparations() {
        if (this.hasChildElement("DeviceColorantOrder", null)) {
            return super.getDeviceColorantOrder().getSeparations();
        }
        return this.getColorantOrderSeparations();
    }

    public VString getColorantOrderSeparations() {
        if (this.hasChildElement("ColorantOrder", null)) {
            return super.getColorantOrder().getSeparations();
        }
        return this.getSeparations();
    }

    public VString getAllSeparations() {
        VElement e = this.getLeaves(false);
        if (e == null) {
            return null;
        }
        VString allCols = new VString();
        for (int i = 0; i < e.size(); ++i) {
            allCols.addAll(((JDFColorantControl)e.get(i)).getSeparations());
        }
        allCols.unify();
        return allCols;
    }

    public VString getSeparations() {
        VString vName = this.getProcessSeparations();
        JDFSeparationList colpar = this.getColorantParams();
        if (colpar != null) {
            vName.addAll(colpar.getSeparations());
        }
        vName.unify();
        return vName;
    }

    public VString getProcessSeparations() {
        JDFDeviceNSpace deviceNSpace;
        VString vName = new VString();
        String model = this.getProcessColorModel();
        if ("DeviceCMY".equals(model)) {
            vName.add("Cyan");
            vName.add("Magenta");
            vName.add("Yellow");
        } else if ("DeviceCMYK".equals(model)) {
            vName.add("Cyan");
            vName.add("Magenta");
            vName.add("Yellow");
            vName.add("Black");
        } else if ("DeviceGray".equals(model)) {
            vName.add("Black");
        } else if ("DeviceRGB".equals(model)) {
            vName.add("Red");
            vName.add("Green");
            vName.add("Blue");
        } else if ("DeviceN".equals(model) && (deviceNSpace = this.getDeviceNSpace(0)) != null) {
            vName = deviceNSpace.getSeparations();
        }
        return vName;
    }

    @Override
    public JDFColorPool getCreateColorPool() {
        JDFColorPool cp = this.getColorPool();
        return cp == null ? super.getCreateColorPool() : cp;
    }

    public void removeProcessColors() {
        JDFSeparationList params;
        VString processSeps = this.getProcessSeparations();
        if (!processSeps.isEmpty() && (params = this.getColorantParams()) != null) {
            VString oldList = params.getSeparations();
            oldList.removeAll(processSeps);
            if (oldList.isEmpty()) {
                params.deleteNode();
            } else {
                params.setSeparations(oldList);
            }
        }
    }
}

