/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Vector;
import org.cip4.jdflib.cformat.ScanfFormat;
import org.cip4.jdflib.cformat.ScanfMatchException;
import org.cip4.jdflib.cformat.ScanfReader;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.StringUtil;

public class SScanf
extends ScanfReader
implements Iterator<Object> {
    private final VString vFmt;
    private int pos = 0;

    public SScanf(String theString, String format) {
        super(new StringReader(theString));
        String newFMT = StringUtil.replaceString(format, "%%", "__comma__\ufffd\ufffd-eher selten");
        this.vFmt = StringUtil.tokenize(newFMT, "%", false);
        int siz = this.vFmt.size();
        String firstChar = "%";
        if (siz > 1 && !format.startsWith("%")) {
            this.vFmt.set(1, this.vFmt.get(0) + "%" + this.vFmt.get(1));
            this.vFmt.remove(0);
            --siz;
            firstChar = "";
        }
        for (int i = 0; i < siz; ++i) {
            String fmtString = this.vFmt.get(i);
            fmtString = StringUtil.replaceString(fmtString, "__comma__\ufffd\ufffd-eher selten", "%%");
            this.vFmt.set(i, firstChar + fmtString);
            firstChar = "%";
        }
    }

    public Vector<Object> sscanf() {
        Vector<Object> v = new Vector<Object>();
        while (this.hasNext()) {
            v.add(this.next());
        }
        return v;
    }

    @Override
    public double scanDouble(ScanfFormat fmt) throws IOException, ScanfMatchException, IllegalArgumentException {
        if ("dxoi".indexOf(fmt.type) >= 0) {
            return this.scanLong(fmt);
        }
        return super.scanDouble(fmt);
    }

    @Override
    public String scanString(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        if ("di".indexOf(fmt.type) >= 0) {
            return Long.toString(this.scanLong(fmt), 10);
        }
        if ("o".indexOf(fmt.type) >= 0) {
            return Long.toString(this.scanLong(fmt), 8);
        }
        if ("x".indexOf(fmt.type) >= 0) {
            return Long.toString(this.scanLong(fmt), 16);
        }
        if ("f".indexOf(fmt.type) >= 0) {
            return Double.toString(this.scanDouble(fmt));
        }
        if ("c".indexOf(fmt.type) >= 0) {
            return new String(this.scanChars(fmt));
        }
        return super.scanString(fmt);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.vFmt.size();
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            return null;
        }
        String fmtString = this.vFmt.get(this.pos++);
        ScanfFormat fmt = new ScanfFormat(fmtString);
        try {
            if ("dxoi".indexOf(fmt.type) >= 0) {
                return this.scanInt(fmt);
            }
            if ("f".indexOf(fmt.type) >= 0) {
                return this.scanDouble(fmt);
            }
            return this.scanString(fmt);
        }
        catch (IllegalArgumentException x) {
            this.pos = 999999;
            return null;
        }
        catch (IOException x) {
            this.pos = 999999;
            return null;
        }
    }

    @Override
    public void remove() {
        throw new IllegalArgumentException("remove not implemented!");
    }

    public static Vector<Object> sscanf(String theString, String format) {
        return new SScanf(theString, format).sscanf();
    }
}

