/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.StringUtil;

public class StreamUtil {
    public static InputStream getBufferedInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        if (is instanceof ByteArrayInputStream) {
            return is;
        }
        if (is instanceof BufferedInputStream) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    public static OutputStream getBufferedOutputStream(OutputStream os) {
        if (os == null) {
            return null;
        }
        if (os instanceof ByteArrayOutputStream) {
            return os;
        }
        if (os instanceof BufferedOutputStream) {
            return os;
        }
        return new BufferedOutputStream(os);
    }

    public static VString getLines(InputStream in) {
        ByteArrayIOStream.ByteArrayIOInputStream ios = ByteArrayIOStream.getBufferedInputStream(in);
        if (ios == null) {
            return null;
        }
        byte[] bytes = ios.getBuf();
        String s = bytes == null ? null : new String(bytes, 0, bytes.length);
        return StringUtil.tokenize(s, "\n\r", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getMD5(InputStream is) {
        MessageDigest md5;
        if (is == null) {
            return null;
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            byte[] b = new byte[100000];
            try {
                int n = is.read(b);
                while (n > 0) {
                    md5.update(b, 0, n);
                    n = is.read(b);
                }
                return md5.digest();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static void close(OutputStream ios) {
        if (ios != null) {
            try {
                ios.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void reset(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream ios) {
        if (ios != null) {
            try {
                ios.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

