/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.file.FileSorter;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.thread.MultiTaskQueue;

public class HotFolder {
    private static int defaultStabilizeTime = 2222;
    public int stabilizeTime = defaultStabilizeTime;
    private static int nThread = 0;
    private int maxConcurrent = 1;
    private final File dir;
    private String allExtensions;
    private long lastModified = -1L;
    private final Vector<FileTime> lastFileTime;
    protected final Vector<ExtensionListener> hfl;
    private HotFolderRunner runThread;
    final Set<File> hfRunning;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setMaxConcurrent(int maxConcurrent) {
        if (maxConcurrent > 42) {
            maxConcurrent = 42;
        } else if (maxConcurrent < 1) {
            maxConcurrent = 1;
        }
        this.maxConcurrent = maxConcurrent;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public File getDir() {
        return this.dir;
    }

    private String getAllExtensions() {
        if (this.allExtensions != null) {
            return this.allExtensions;
        }
        if (this.hfl == null) {
            return null;
        }
        VString allextensions = new VString();
        for (int i = 0; i < this.hfl.size(); ++i) {
            Set<String> ext = this.hfl.get((int)i).extension;
            if (ext == null) {
                return null;
            }
            allextensions.addAll(ext);
        }
        allextensions.unify();
        this.allExtensions = allextensions.size() == 0 ? null : StringUtil.setvString(allextensions, ",", null, null);
        return this.allExtensions;
    }

    @Deprecated
    public HotFolder(File _dir) {
        this(_dir, null, null);
    }

    public synchronized void addListener(HotFolderListener _hfl, String ext) {
        if (this.hfl != null) {
            this.hfl.add(new ExtensionListener(_hfl, ext));
        }
        this.allExtensions = null;
        this.lastModified = 0L;
    }

    public HotFolder(File _dir, String ext, HotFolderListener _hfl) {
        this.dir = _dir;
        this.dir.mkdirs();
        this.dir.setWritable(true);
        this.lastFileTime = new Vector();
        this.hfl = new Vector();
        this.hfRunning = new HashSet<File>();
        this.runThread = null;
        this.allExtensions = null;
        if (_hfl != null) {
            this.addListener(_hfl, ext);
            this.restart();
        }
    }

    public synchronized void restart() {
        if (this.runThread != null) {
            this.stop();
        }
        if (!this.dir.canWrite()) {
            this.log.error((Object)"Cannot use read only hot folder at");
        }
        this.runThread = new HotFolderRunner();
        this.lastModified = -1L;
        this.hfRunning.clear();
    }

    String getThreadName(boolean increment) {
        String threadName = "HotFolder_" + nThread + "_" + this.dir.getAbsolutePath();
        if (increment) {
            ++nThread;
        }
        return threadName;
    }

    public synchronized void stop() {
        if (this.runThread != null) {
            this.runThread.quit();
            ThreadUtil.join(this.runThread, 10);
            this.runThread = null;
            this.log.info((Object)("stopped hot folder at: " + this.dir.getAbsolutePath()));
        } else {
            this.log.info((Object)"Stopping stopped hot folder: ");
        }
    }

    private boolean processSingleFile(File[] files, FileTime lftAt, int j, File fileJ) {
        boolean found = true;
        if (fileJ.lastModified() == lftAt.modified && lftAt.modified + (long)this.stabilizeTime < System.currentTimeMillis()) {
            if (fileJ.exists()) {
                HotFileRunner runner = new HotFileRunner(fileJ);
                if (this.maxConcurrent == 1) {
                    runner.run();
                } else {
                    MultiTaskQueue taskQueue = MultiTaskQueue.getCreateQueue(this.getThreadName(false), this.maxConcurrent);
                    found = taskQueue.queue(runner);
                }
            } else {
                found = false;
            }
        } else {
            lftAt.modified = files[j].lastModified();
        }
        files[j] = null;
        return found;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.dir + " " + this.lastModified + " maxConcurrent=" + this.getMaxConcurrent();
    }

    public static int getDefaultStabilizeTime() {
        return defaultStabilizeTime;
    }

    public static void setDefaultStabilizeTime(int defaultStabilizeTime) {
        if (defaultStabilizeTime > 0) {
            HotFolder.defaultStabilizeTime = defaultStabilizeTime;
        }
    }

    public int getStabilizeTime() {
        return this.stabilizeTime;
    }

    public void setStabilizeTime(int stabilizeTime) {
        if (stabilizeTime > 0) {
            this.stabilizeTime = stabilizeTime;
        }
    }

    protected class ExtensionListener {
        protected final HotFolderListener fl;
        protected final Set<String> extension;

        protected ExtensionListener(HotFolderListener _hfl, String ext) {
            this.fl = _hfl;
            ext = StringUtil.getNonEmpty(ext);
            if (ext != null) {
                this.extension = new HashSet<String>();
                VString vs = StringUtil.tokenize(ext, ",", false);
                for (String s : vs) {
                    if (s.startsWith(".")) {
                        s = s.substring(1);
                    }
                    s = s.toLowerCase();
                    this.extension.add(s);
                }
            } else {
                this.extension = null;
            }
        }

        public void hotFile(File file) {
            String fileExt;
            if (file == null) {
                return;
            }
            if (this.extension != null && (fileExt = FileUtil.getExtension(file)) != null && !this.extension.contains(fileExt = fileExt.toLowerCase())) {
                return;
            }
            this.fl.hotFile(file);
        }
    }

    protected class FileTime {
        protected File f;
        protected long modified;

        protected FileTime(File _f) {
            this.f = _f;
            this.modified = -1L;
        }

        public String toString() {
            return this.f + " " + this.modified;
        }
    }

    class HotFileRunner
    implements Runnable {
        File fileJ;

        HotFileRunner(File fileJ) {
            if (HotFolder.this.hfRunning != null) {
                HotFolder.this.hfRunning.add(fileJ);
            }
            this.fileJ = fileJ;
        }

        @Override
        public void run() {
            for (ExtensionListener xl : HotFolder.this.hfl) {
                try {
                    xl.hotFile(this.fileJ);
                }
                catch (Throwable x) {
                    HotFolder.this.log.error((Object)"exception processing hot files", x);
                }
            }
            if (this.fileJ != null) {
                HotFolder.this.hfRunning.remove(this.fileJ);
            }
        }

        public String toString() {
            return "HotFileRunner [fileJ=" + this.fileJ + "]";
        }
    }

    class HotFolderRunner
    extends Thread {
        boolean interrupt;

        void quit() {
            String name = this.getName();
            HotFolder.this.log.info((Object)("Stopping hot folder: " + name));
            this.interrupt = true;
            if (HotFolder.this.maxConcurrent > 1) {
                MultiTaskQueue.shutDown(name);
            }
            ThreadUtil.notifyAll(this);
            HotFolder.this.log.info((Object)("Finished stopping hot folder: " + name));
        }

        public HotFolderRunner() {
            super(HotFolder.this.getThreadName(true));
            this.setDaemon(true);
            HotFolder.this.log.info((Object)("Starting hotfolder: " + HotFolder.this.getThreadName(false)));
            this.interrupt = false;
            this.start();
        }

        @Override
        public void run() {
            HotFolder.this.log.info((Object)("starting hot folder at: " + HotFolder.this.dir.getAbsolutePath()));
            while (!this.interrupt) {
                long t0 = System.currentTimeMillis();
                long lastMod = HotFolder.this.dir.lastModified();
                if (lastMod > HotFolder.this.lastModified || HotFolder.this.lastFileTime.size() > 0 || t0 - HotFolder.this.lastModified < 42000L) {
                    int i;
                    HotFolder.this.lastModified = lastMod;
                    File[] files = this.getHotFiles();
                    if (HotFolder.this.lastFileTime.size() > 0) {
                        int fileListLength = files == null ? 0 : files.length;
                        for (i = 0; i < HotFolder.this.lastFileTime.size(); ++i) {
                            boolean found = false;
                            FileTime lftAt = (FileTime)HotFolder.this.lastFileTime.elementAt(i);
                            for (int j = 0; !this.interrupt && j < fileListLength; ++j) {
                                File fileJ = files[j];
                                if (fileJ == null || !fileJ.equals(lftAt.f)) continue;
                                found = found || HotFolder.this.processSingleFile(files, lftAt, j, fileJ);
                            }
                            if (found) continue;
                            HotFolder.this.lastFileTime.remove(i--);
                        }
                    }
                    if (files != null) {
                        Vector<File> vf = ContainerUtil.toVector(files);
                        for (i = vf.size() - 1; i >= 0; --i) {
                            if (vf.get(i) != null) continue;
                            vf.remove(i);
                        }
                        files = vf.toArray(new File[0]);
                        for (File f : files = new FileSorter(files).sortLastModified(false)) {
                            HotFolder.this.lastFileTime.add(new FileTime(f));
                        }
                    }
                }
                if (ThreadUtil.wait(this, HotFolder.this.stabilizeTime)) continue;
                break;
            }
            HotFolder.this.log.info((Object)("completed hot folder at: " + HotFolder.this.dir.getAbsolutePath()));
        }

        private File[] getHotFiles() {
            if (this.interrupt) {
                return null;
            }
            File[] files = FileUtil.listFilesWithExtension(HotFolder.this.dir, HotFolder.this.getAllExtensions());
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].canWrite()) {
                        HotFolder.this.log.warn((Object)("ignoring read only file in hot folder: " + files[i]));
                        files[i] = null;
                        continue;
                    }
                    if (files[i].isDirectory()) {
                        files[i] = null;
                        continue;
                    }
                    if (!HotFolder.this.hfRunning.contains(files[i])) continue;
                    files[i] = null;
                }
            }
            return files;
        }
    }
}

