/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.RollingBackupFile;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.file.FileSorter;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.StorageHotFolder;

class StorageHotFolderListener
implements HotFolderListener {
    private final File storage;
    private File errorStorage;
    private File okStorage;
    final StorageHotFolder parent;
    protected final Log log;
    private int nHotOK = 0;
    private int nHotError = 0;
    private int nQueued = 0;
    private int maxStore;
    HotFolderListener theListener;

    StorageHotFolderListener(File storageDir, HotFolderListener hfListener, StorageHotFolder parent) {
        this.setMaxStore(42);
        this.errorStorage = null;
        this.okStorage = null;
        this.log = LogFactory.getLog(this.getClass());
        if (hfListener == null) {
            this.log.error((Object)"hfListner MUST NOT be null");
            throw new IllegalArgumentException("hfListner MUST NOT be null");
        }
        this.theListener = hfListener;
        this.storage = storageDir;
        this.parent = parent;
    }

    void setOKStorage(File ok) {
        this.okStorage = ok;
        if (ok != null) {
            this.okStorage.mkdirs();
            this.okStorage.setWritable(true);
            if (!this.okStorage.isDirectory()) {
                this.log.error((Object)("OK Directory is not a directory: " + this.okStorage.getAbsolutePath()));
            }
        }
    }

    void setErrorStorage(File error) {
        this.errorStorage = error;
        if (error != null) {
            this.errorStorage.mkdirs();
            this.errorStorage.setWritable(true);
            if (!this.errorStorage.isDirectory()) {
                this.log.error((Object)("Error Directory is not a directory: " + this.errorStorage.getAbsolutePath()));
            }
        }
    }

    @Override
    public boolean hotFile(File hotFile) {
        this.log.info((Object)("processing hot file: " + hotFile));
        File storedFile = this.getStoredFile(hotFile);
        if (storedFile == null) {
            this.log.warn((Object)("snafu retrieving file " + hotFile.getAbsolutePath()));
            this.copyCompleted(hotFile, false);
            return false;
        }
        boolean b = this.theListener.hotFile(storedFile);
        this.copyCompleted(storedFile, b);
        return b;
    }

    void copyCompleted(File storedFile, boolean bOK) {
        File auxFile = FileUtil.getAuxDir(storedFile);
        if (bOK) {
            if (this.okStorage != null) {
                File okFile = FileUtil.getFileInDirectory(this.okStorage, new File(storedFile.getName()));
                RollingBackupFile roller = new RollingBackupFile(okFile, 10);
                roller.setWantExtension(true);
                roller.getNewFile();
                File copied = FileUtil.moveFileToDir(storedFile, this.okStorage);
                if (copied == null) {
                    this.handleBad(storedFile, true);
                } else {
                    this.log.info((Object)("Copied good file: " + storedFile.getName() + " to " + this.okStorage));
                    copied.setLastModified(System.currentTimeMillis());
                    if (auxFile != null) {
                        File auxbackup = FileUtil.getFileInDirectory(this.okStorage, new File(auxFile.getName()));
                        RollingBackupFile rollingBackupFile = new RollingBackupFile(auxbackup, 10);
                        rollingBackupFile.setWantExtension(true);
                        rollingBackupFile.getNewFile();
                        File movedAux = FileUtil.moveFileToDir(auxFile, this.okStorage);
                        if (movedAux != null) {
                            this.log.info((Object)("Copied good aux dir: " + auxFile.getName() + " to " + movedAux));
                        } else {
                            this.log.warn((Object)("Could not copy good aux dir: " + auxFile.getName() + " to " + this.okStorage));
                        }
                    }
                }
                this.cleanup(bOK);
            } else {
                boolean ok = FileUtil.forceDelete(storedFile);
                if (!ok) {
                    this.log.warn((Object)("failed to delete temporary file " + storedFile.getAbsolutePath()));
                }
                FileUtil.deleteAll(auxFile);
            }
        } else if (this.errorStorage != null) {
            File backup = FileUtil.getFileInDirectory(this.errorStorage, new File(storedFile.getName()));
            RollingBackupFile roller = new RollingBackupFile(backup, 10);
            roller.setWantExtension(true);
            roller.getNewFile();
            File copied = FileUtil.moveFileToDir(storedFile, this.errorStorage);
            if (copied == null) {
                this.handleBad(storedFile, false);
            } else {
                this.log.warn((Object)("Copied error file: " + storedFile.getName() + " to " + this.errorStorage));
                copied.setLastModified(System.currentTimeMillis());
                if (auxFile != null) {
                    File auxbackup = FileUtil.getFileInDirectory(this.errorStorage, new File(auxFile.getName()));
                    RollingBackupFile rollingBackupFile = new RollingBackupFile(auxbackup, 10);
                    rollingBackupFile.setWantExtension(true);
                    rollingBackupFile.getNewFile();
                    File movedAux = FileUtil.moveFileToDir(auxFile, this.errorStorage);
                    if (movedAux != null) {
                        this.log.info((Object)("Copied error aux dir: " + auxFile.getName() + " to " + movedAux));
                    } else {
                        this.log.warn((Object)("Could not copy error aux dir: " + auxFile.getName() + " to " + this.okStorage));
                    }
                }
            }
            this.cleanup(bOK);
        } else {
            boolean ok = FileUtil.forceDelete(storedFile);
            if (!ok) {
                this.log.warn((Object)("failed to delete temporary file " + storedFile.getAbsolutePath()));
            }
            FileUtil.deleteAll(auxFile);
        }
        File tmp = storedFile.getParentFile();
        FileUtil.deleteAll(tmp);
    }

    protected boolean handleBad(File storedFile, boolean bOK) {
        if (bOK) {
            this.log.warn((Object)("could not move ok " + storedFile + " to " + this.okStorage.getAbsolutePath()));
        } else {
            this.log.warn((Object)("could not move error " + storedFile + " to " + this.errorStorage.getAbsolutePath()));
        }
        File auxFile = FileUtil.getAuxDir(storedFile);
        FileUtil.deleteAll(auxFile);
        boolean bZapp = storedFile.delete();
        if (bZapp) {
            this.log.warn((Object)("utterly removed hot file: " + storedFile));
        } else {
            this.log.error((Object)("cannot delete hot file: " + storedFile));
        }
        return bZapp;
    }

    private void cleanup(boolean bOK) {
        int n;
        if (bOK) {
            int n2 = this.nHotOK;
            n = n2;
            this.nHotOK = n2 + 1;
        } else {
            int n3 = this.nHotError;
            n = n3;
            this.nHotError = n3 + 1;
        }
        int nHot = n;
        if (nHot % 13 == 0) {
            FileSorter fs = new FileSorter(bOK ? this.okStorage : this.errorStorage);
            File[] list = fs.sortLastModified(true);
            Vector<File> vList = new Vector<File>();
            for (File f : list) {
                if (f.isDirectory()) continue;
                vList.add(f);
            }
            for (int i = this.maxStore; i < vList.size(); ++i) {
                File hotFile = (File)vList.get(i);
                File aux = FileUtil.getAuxDir(hotFile);
                boolean ok = FileUtil.forceDelete(hotFile);
                if (!ok) {
                    this.log.warn((Object)("failed to delete temporary file " + hotFile.getAbsolutePath()));
                }
                if (aux == null || (ok = FileUtil.deleteAll(aux))) continue;
                this.log.warn((Object)("failed to delete temporary directory " + aux.getAbsolutePath()));
            }
        }
    }

    File getStoredFile(File hotFile) {
        File aux;
        String name = hotFile.getName();
        File tmpDir = this.getTmpDir();
        File newAbsoluteFile = FileUtil.getFileInDirectory(tmpDir, new File(name));
        boolean ok = false;
        int i = 0;
        while (!ok) {
            ok = FileUtil.moveFile(hotFile, newAbsoluteFile);
            if (!ok && i < this.parent.getRetry()) {
                this.log.warn((Object)("retry " + i + " moving file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
                if (!ThreadUtil.sleep(this.parent.getStabilizeTime())) {
                    this.log.error((Object)("Interrupted while waiting to move file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
                    return null;
                }
            }
            ++i;
        }
        if (ok) {
            this.log.info((Object)("moving file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
        } else {
            this.log.error((Object)("cannot move file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
        }
        if (ok && (aux = FileUtil.getAuxDir(hotFile)) != null) {
            File newaux = FileUtil.getFileInDirectory(tmpDir, new File(aux.getName()));
            FileUtil.moveFile(aux, newaux);
            this.log.info((Object)("moving aux file " + aux + " to " + tmpDir));
            int i2 = 1;
            while (true) {
                File moved;
                if ((moved = FileUtil.moveFileToDir(newaux, tmpDir)) != null) {
                    this.log.info((Object)("moved aux dir " + aux + " to " + moved));
                    break;
                }
                this.log.warn((Object)("could not move aux dir " + aux + " to " + tmpDir + " #" + i2));
                if (i2 == 3 || !ThreadUtil.sleep(4242 * i2)) break;
                ++i2;
            }
        }
        return ok ? newAbsoluteFile : null;
    }

    private synchronized File getTmpDir() {
        return FileUtil.getFileInDirectory(this.storage, new File("tmp." + this.nQueued++));
    }

    void setMaxStore(int maxStore) {
        this.maxStore = maxStore;
    }

    public String toString() {
        return "StorageHotFolderListener: ok=" + this.okStorage + " error=" + this.errorStorage + " " + this.parent;
    }
}

