/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.util.StringUtil;

public abstract class JDFNumList
extends Vector<Object>
implements JDFBaseDataTypes,
Cloneable {
    private static final int INT_NAN = -2147483606;
    private static final long serialVersionUID = 1L;

    public JDFNumList() {
    }

    public JDFNumList(int size) {
        super(size);
        for (int i = 0; i < size; ++i) {
            this.addElement(0.0);
        }
    }

    public JDFNumList(int[] array) {
        super(array.length);
        for (int element : array) {
            this.addElement(element);
        }
    }

    public JDFNumList(double[] array) {
        super(array.length);
        for (double element : array) {
            this.addElement(element);
        }
    }

    @Deprecated
    public JDFNumList(Vector v) throws DataFormatException {
        this.addAll(v);
        this.isValid();
    }

    public JDFNumList(String sl) throws DataFormatException {
        this.setString(sl);
    }

    @Override
    public void set(int pos, double d) {
        super.set(pos, d);
    }

    public JDFNumList setX(int pos, double d) {
        this.set(pos, d);
        return this;
    }

    public JDFNumList setString(String string) throws DataFormatException {
        this.clear();
        VString v = StringUtil.tokenize(string, null, false);
        if (v != null) {
            boolean bInteger = this instanceof JDFIntegerList;
            for (String s : v) {
                this.setSingle(bInteger, s);
            }
        } else {
            throw new DataFormatException("JDFNumList: bad string value: " + string);
        }
        this.isValid();
        return this;
    }

    void setSingle(boolean bInteger, String s) throws DataFormatException {
        if (bInteger) {
            int theInt = StringUtil.parseInt(s, -2147483606);
            if (theInt == -2147483606) {
                throw new DataFormatException("JDFNumList: bad numeric value: " + s);
            }
            this.addElement(theInt);
        } else {
            double theDouble = StringUtil.parseDouble(s, Double.NaN);
            if (Double.isNaN(theDouble)) {
                throw new DataFormatException("JDFNumList: bad numeric value: " + s);
            }
            this.addElement(theDouble);
        }
    }

    public JDFNumList(JDFNumList nl) throws DataFormatException {
        this.addAll(nl);
        this.isValid();
    }

    @Deprecated
    public String getString() {
        return this.toString();
    }

    public double[] getDoubleList() {
        double[] list = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            list[i] = this.doubleAt(i);
        }
        return list;
    }

    public Vector<Double> getDoubleVector() {
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < this.size(); ++i) {
            v.add(this.doubleAt(i));
        }
        return v;
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object o;
            if (i > 0) {
                sb.append(" ");
            }
            if ((o = this.elementAt(i)) instanceof Double) {
                sb.append(StringUtil.formatDouble((Double)o));
                continue;
            }
            if (o instanceof Integer) {
                sb.append(StringUtil.formatInteger((Integer)o));
                continue;
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public String getString(int precision) {
        StringBuilder sb = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object o;
            if (i > 0) {
                sb.append(" ");
            }
            if ((o = this.elementAt(i)) instanceof Double) {
                sb.append(StringUtil.formatDouble((Double)o, precision));
                continue;
            }
            if (o instanceof Integer) {
                sb.append(StringUtil.formatInteger((Integer)o));
                continue;
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    @Override
    public synchronized boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        boolean retVal = false;
        JDFNumList jdfNumList = (JDFNumList)other;
        int size = this.size();
        if (size == jdfNumList.size()) {
            retVal = true;
            for (int i = 0; i < size && retVal; ++i) {
                double d1 = this.doubleAt(i);
                double d2 = jdfNumList.doubleAt(i);
                retVal = StringUtil.isEqual(d1, d2);
            }
        }
        return retVal;
    }

    @Override
    public synchronized int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public synchronized Object elementAt(int i) {
        if (i < 0) {
            i = this.size() + i;
        }
        if (i < 0 || i >= this.size()) {
            return null;
        }
        return super.elementAt(i);
    }

    public double doubleAt(int i) {
        Object o = this.elementAt(i);
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return 0.0;
    }

    public int intAt(int i) {
        Object o = this.elementAt(i);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return ((Double)o).intValue();
        }
        return 0;
    }

    @Deprecated
    public Vector<Object> copyNumList() {
        return this.clone();
    }

    @Override
    public synchronized void removeElementAt(int i) {
        if (i < 0) {
            i += this.size();
        }
        if (i < this.size() && i >= 0) {
            super.removeElementAt(i);
        }
    }

    public boolean replaceElementAt(Object obj, int i) {
        if (i < 0) {
            i += this.size();
        }
        if (i < this.size() && i >= 0) {
            this.set(i, obj);
            return true;
        }
        return false;
    }

    public abstract boolean isValid() throws DataFormatException;

    public boolean isValidString(String st) {
        VString v = StringUtil.tokenize(st, null, false);
        if (v != null) {
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                String s = v.get(i);
                if (StringUtil.isNumber(s)) continue;
                return false;
            }
        }
        return true;
    }

    public JDFNumList scaleFromMM() {
        return this.scale(2.834645669291339);
    }

    public JDFNumList scaleFromMM(int precision) {
        return this.scale(2.834645669291339, precision);
    }

    public JDFNumList scaleFromCM() {
        return this.scale(28.346456692913385);
    }

    public JDFNumList scaleFromCM(int precision) {
        return this.scale(28.346456692913385, precision);
    }

    public JDFNumList scaleToMM() {
        return this.scale(0.35277777777777775);
    }

    public JDFNumList scaleToMM(int precision) {
        return this.scale(0.35277777777777775, precision);
    }

    public JDFNumList scaleToCM() {
        return this.scale(0.035277777777777776);
    }

    public JDFNumList scaleToCM(int precision) {
        return this.scale(0.035277777777777776, precision);
    }

    public JDFNumList scale(double factor) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double number = this.doubleAt(i) * factor;
            this.setElementAt(number, i);
        }
        return this;
    }

    public JDFNumList scale(double factor, int precision) {
        this.scale(factor);
        for (int i = 0; i < this.size(); ++i) {
            double scale = Math.pow(10.0, precision);
            int num = (int)(0.5 + this.doubleAt(i) * scale);
            this.setElementAt((double)num / scale, i);
        }
        return this;
    }

    public JDFNumList abs() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double number = Math.abs(this.doubleAt(i));
            this.setElementAt(number, i);
        }
        return this;
    }

    @Override
    public synchronized JDFNumList clone() {
        return (JDFNumList)super.clone();
    }

    public boolean matches(JDFNumList other, double delta) {
        if (other == null) {
            return false;
        }
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (StringUtil.isEqual(this.doubleAt(i), other.doubleAt(i), delta)) continue;
            return false;
        }
        return true;
    }

    public JDFNumList subtract(JDFNumList l) {
        if (l != null && this.size() == l.size()) {
            double[] me = this.getDoubleList();
            double[] them = l.getDoubleList();
            for (int i = 0; i < me.length; ++i) {
                int n = i;
                me[n] = me[n] - them[i];
                this.setElementAt(me[i], i);
            }
        }
        return this;
    }

    public void unify() {
        HashSet<Object> set = new HashSet<Object>();
        int j = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (set.contains(this.elementAt(j))) {
                this.remove(j);
                continue;
            }
            set.add(this.elementAt(j));
            ++j;
        }
    }

    public int[] getIntArray() {
        int size = this.size();
        int[] intArray = new int[size];
        for (int i = 0; i < size; ++i) {
            intArray[i] = this.intAt(i);
        }
        return intArray;
    }

    public Double getDouble(int i) {
        return (Double)this.elementAt(i);
    }

    public void sort() {
        double[] a = this.getDoubleList();
        Arrays.sort(a);
        int pos = 0;
        for (double d : a) {
            this.set(pos++, d);
        }
    }

    public boolean contains(JDFNumList l) {
        if (l == null) {
            return false;
        }
        for (int i = 0; i < l.size(); ++i) {
            if (!this.contains(l.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public double norm() {
        double sum = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double di = this.doubleAt(i);
            sum += di * di;
        }
        return Math.sqrt(sum);
    }

    public double min() {
        double min = Double.MAX_VALUE;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double di = this.doubleAt(i);
            if (!(di < min)) continue;
            min = di;
        }
        return min;
    }

    public JDFNumList shift(double x) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double di = this.doubleAt(i);
            this.set(i, di + x);
        }
        return this;
    }

    public double max() {
        double max = Double.MIN_VALUE;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double di = this.doubleAt(i);
            if (!(di > max)) continue;
            max = di;
        }
        return max;
    }

    public double volume() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        double product = 1.0;
        for (int i = 0; i < size; ++i) {
            double di = this.doubleAt(i);
            product *= di;
        }
        return product;
    }

    public boolean containsAll(JDFNumList l) {
        if (l == null) {
            return true;
        }
        for (int i = 0; i < l.size(); ++i) {
            if (this.contains(l.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class NormComparator
    implements Comparator<JDFNumList> {
        @Override
        public int compare(JDFNumList o1, JDFNumList o2) {
            double d2;
            double d1 = o1 == null ? -1.0 : o1.norm();
            double d = d2 = o2 == null ? -1.0 : o2.norm();
            return d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
        }
    }

    public static class VolumeComparator
    implements Comparator<JDFNumList> {
        @Override
        public int compare(JDFNumList o1, JDFNumList o2) {
            double d2;
            double d1 = o1 == null ? Double.MIN_VALUE : o1.volume();
            double d = d2 = o2 == null ? Double.MIN_VALUE : o2.volume();
            return d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
        }
    }
}

