/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.auto.JDFAutoGeneralID;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.fixversion.WalkElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.EnumUtil;

public class WalkJDF
extends WalkElement {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFNode;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("JDF", null);
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        JDFNode.EnumType enumType;
        JDFNode n = (JDFNode)e1;
        if (this.fixVersion.version != null) {
            n.setVersion(this.fixVersion.version);
            n.setMaxVersion(this.fixVersion.version);
            n.fixNiCi(this.fixVersion.version);
            this.fixNamedFeatures(n, trackElem);
        }
        if (n.isJDFRoot() && !n.hasAncestorAttribute("JobID", null)) {
            n.setJobID(n.generateDotID("JobID", null));
        }
        if (!n.hasNonEmpty("JobPartID")) {
            if (n.isJDFRoot()) {
                n.setJobPartID("P_" + n.getJobID(true));
            } else {
                n.setJobPartID(n.generateDotID("JobPartID", null));
            }
        }
        if ((enumType = n.getEnumType()) != null) {
            n.setType(enumType);
        }
        return super.walk(e1, trackElem);
    }

    private void fixNamedFeatures(JDFNode n, KElement trackElem) {
        if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_1_4, this.fixVersion.version)) {
            VString v = n.getNamedFeatures();
            int size = v == null ? 0 : v.size();
            for (int i = 0; i < size / 2; ++i) {
                String key = v.get(i * 2);
                String val = v.get(i * 2 + 1);
                n.appendGeneralID(key, val).setDataType(JDFAutoGeneralID.EnumDataType.NamedFeature);
            }
            n.removeAttribute("NamedFeatures");
        }
    }
}

