/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class ProductHelper
extends BaseXJDFHelper {
    public static final String PRODUCT = "Product";
    public static final String PRODUCTLIST = "ProductList";
    public static boolean partitionProducts = false;
    public static final String rootProduct = "IsRoot";

    public ProductHelper(KElement product) {
        this.theElement = product;
        this.theElement.appendAnchor(null);
    }

    public void setRoot() {
        this.setRoot(true);
    }

    public void setRoot(boolean isRoot) {
        this.theElement.setAttribute(rootProduct, isRoot, null);
    }

    public IntentHelper getCreateIntent(String name) {
        IntentHelper ih = this.getIntent(name);
        if (ih == null) {
            ih = this.appendIntent(name);
        }
        return ih;
    }

    public IntentHelper appendIntent(String name) {
        KElement intent = this.theElement.appendElement("Intent");
        intent.appendElement(name);
        intent.setAttribute("Name", name);
        return new IntentHelper(intent);
    }

    public IntentHelper getIntent(String name) {
        KElement intent = this.theElement.getChildWithAttribute("Intent", "Name", null, name, 0, true);
        return intent == null ? null : new IntentHelper(intent);
    }

    public Vector<IntentHelper> getIntents() {
        VElement v = this.theElement.getChildElementVector("Intent", null);
        Vector<IntentHelper> v2 = new Vector<IntentHelper>();
        if (v != null) {
            for (KElement e : v) {
                v2.add(new IntentHelper(e));
            }
        }
        return v2;
    }

    public String getIntentAttribute(String intentName, String attName) {
        KElement intent = this.theElement.getChildWithAttribute("Intent", "Name", null, intentName, 0, true);
        intent = intent == null ? null : intent.getElement(intentName);
        return intent == null ? null : intent.getNonEmpty(attName);
    }

    public int getAmount() {
        return this.theElement.getIntAttribute("Amount", null, -1);
    }

    public void setAmount(int amount) {
        this.theElement.setAttribute("Amount", amount, (String)null);
    }

    public int getMaxAmount() {
        int a = this.theElement.getIntAttribute("MaxAmount", null, -4242);
        return a == -4242 ? this.getAmount() : a;
    }

    @Deprecated
    public String getProductID() {
        return this.theElement.getNonEmpty("ProductID");
    }

    @Override
    public String getExternalID() {
        return this.getAttribute("ExternalID");
    }

    @Override
    public void setExternalID(String id) {
        this.setAttribute("ExternalID", id);
    }

    @Override
    public String getDescriptiveName() {
        return this.getAttribute("DescriptiveName");
    }

    @Override
    public void setDescriptiveName(String id) {
        this.setAttribute("DescriptiveName", id);
    }

    public String getProductType() {
        return this.theElement.getNonEmpty("ProductType");
    }

    public void setProductType(String productType) {
        this.theElement.setNonEmpty("ProductType", productType);
    }

    public double getOverproduction() {
        int a1 = this.getAmount();
        int max = this.getMaxAmount();
        return a1 > 0 ? 100.0 * (double)(max - a1) / (double)a1 : 0.0;
    }

    public void setMaxAmount(int amount) {
        this.theElement.setAttribute("MaxAmount", amount, (String)null);
    }

    public int getMinAmount() {
        int a = this.theElement.getIntAttribute("MinAmount", null, -4242);
        return a == -4242 ? this.getAmount() : a;
    }

    public void setMinAmount(int amount) {
        this.theElement.setAttribute("MinAmount", amount, (String)null);
    }

    @Deprecated
    public void setChild(ProductHelper phCover, int amount) {
        if (phCover != null) {
            IntentHelper childIntent = this.getCreateChildIntent();
            KElement e = this.theElement.getChildWithAttribute("ChildProduct", "Childref", null, phCover.theElement.getID(), 0, true);
            if (e == null) {
                e = this.theElement.appendElement("ChildProduct");
                e.copyAttribute("ChildRef", phCover.theElement, "ID", null, null);
                phCover.theElement.removeAttribute(rootProduct);
            }
            if (amount > 0) {
                e.setAttribute("Amount", amount, (String)null);
            }
        }
    }

    public void setChild(ProductHelper phKid) {
        if (phKid != null) {
            IntentHelper childIntent = this.getCreateChildIntent();
            String id = phKid.ensureID();
            phKid.setRoot(false);
            childIntent.getCreateResource().appendAttribute("ChildRefs", id, null, null, true);
        }
    }

    IntentHelper getCreateChildIntent() {
        IntentHelper ret = this.getChildIntent();
        if (ret == null) {
            ret = this.getCreateIntent("BindingIntent");
        }
        return ret;
    }

    List<String> getChildRefs(boolean bRecurse) {
        IntentHelper kids = this.getChildIntent();
        if (kids == null) {
            return null;
        }
        String refs = kids.getSpan("ChildRefs");
        StringArray a = StringArray.getVString(refs, null);
        if (a == null || !bRecurse) {
            return a;
        }
        List<KElement> v = this.theElement.getParentNode_KElement().getChildList(PRODUCT, null);
        for (int i = 0; i < a.size(); ++i) {
            String ida = a.get(i);
            for (KElement e : v) {
                List<String> grandkids;
                if (!ida.equals(e.getID()) || (grandkids = new ProductHelper(e).getChildRefs(false)) == null) continue;
                a.appendUnique(grandkids);
            }
        }
        return a;
    }

    IntentHelper getChildIntent() {
        IntentHelper ret = this.getIntent("BindingIntent");
        if (ret == null) {
            ret = this.getIntent("InsertingIntent");
        }
        if (ret == null) {
            ret = this.getIntent("AssemblingIntent");
        }
        return ret;
    }

    public ProductHelper getChild(int nChild) {
        String kidRef;
        List<String> childRefs = this.getChildRefs(false);
        String string = kidRef = childRefs == null ? null : childRefs.get(nChild);
        if (kidRef != null) {
            KElement list = this.theElement.getParentNode_KElement();
            KElement kid = list.getChildWithAttribute(PRODUCT, "ID", null, kidRef, 0, true);
            return kid == null ? null : new ProductHelper(kid);
        }
        return null;
    }

    public ProductHelper getParent() {
        if (this.isRootProduct()) {
            return null;
        }
        String id = this.getID();
        if (StringUtil.isEmpty(id)) {
            return null;
        }
        List<KElement> list = this.theElement.getParentNode_KElement().getChildArray_KElement(PRODUCT, null, null, false, 0);
        if (ContainerUtil.isEmpty(list)) {
            return null;
        }
        for (KElement e : list) {
            ProductHelper ph = new ProductHelper(e);
            List<String> childRefs = ph.getChildRefs(false);
            if (childRefs == null || !childRefs.contains(id)) continue;
            return ph;
        }
        return null;
    }

    public ProductHelper getChild(String productType, int n) {
        List<ProductHelper> v = this.getChildren(false);
        if (ContainerUtil.isEmpty(v)) {
            return null;
        }
        for (ProductHelper p : v) {
            if (productType != null && !productType.equals(p.getProduct().getAttribute("ProductType")) || n-- != 0) continue;
            return p;
        }
        return null;
    }

    public List<ProductHelper> getChildren(boolean recurse) {
        List<String> childRefs = this.getChildRefs(recurse);
        if (childRefs != null) {
            KElement list = this.theElement.getParentNode_KElement();
            ArrayList<ProductHelper> ret = new ArrayList<ProductHelper>();
            for (String id : childRefs) {
                KElement kid = list.getChildWithAttribute(PRODUCT, "ID", null, id, 0, true);
                ret.add(new ProductHelper(kid));
            }
            return ret;
        }
        return null;
    }

    @Deprecated
    public Vector<ProductHelper> getChildren() {
        List<ProductHelper> kids = this.getChildren(false);
        Vector<ProductHelper> vph = new Vector<ProductHelper>();
        if (kids != null) {
            vph.addAll(kids);
        }
        return vph;
    }

    public KElement getProduct() {
        return this.theElement;
    }

    public boolean isRootProduct() {
        boolean b = this.theElement.getBoolAttribute(rootProduct, null, false);
        if (!b && this.theElement.getBoolAttribute(rootProduct, null, true)) {
            KElement list = this.theElement.getParentNode_KElement();
            b = list != null && list.getElement(PRODUCT, null, 0) == this.theElement && list.getChildWithAttribute(PRODUCT, rootProduct, null, "true", 0, true) == null;
        }
        return b;
    }

    public void setCustomerInfo(ResourceHelper cuph) {
        if (cuph != null) {
            this.getRoot().setAttribute("CustomerInfoRef", cuph.getID());
        }
    }

    @Override
    public void cleanUp() {
    }
}

