/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.zip.DataFormatException;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFDuration
implements Comparable<JDFDuration> {
    private double m_lDuration;
    private static final String REGEX_DURATION = "(-)?[P](((\\d)+)[Y])?((\\d)+[M])?((\\d)+[D])?([T]((\\d)+[H])?((\\d)+[M])?((\\d)+([.](\\d)+)?[S])?)?";

    public static JDFDuration createDuration(String duration) {
        if ((duration = StringUtil.normalize(duration, false, null)) == null) {
            return null;
        }
        if (StringUtil.matches(duration = duration.toUpperCase(), REGEX_DURATION)) {
            try {
                return new JDFDuration(duration);
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        if (!duration.startsWith("P")) {
            if (StringUtil.isNumber(duration)) {
                double d = StringUtil.parseDouble(duration, 0.0);
                return d == Double.MAX_VALUE ? new JDFDuration(Long.MAX_VALUE) : new JDFDuration(d * 24.0 * 60.0 * 60.0);
            }
            return JDFDuration.createDuration("P" + duration);
        }
        if (duration.length() < 3) {
            return null;
        }
        int posD = duration.indexOf("D");
        int posT = duration.indexOf("T");
        if (posD > 0 && posD < duration.length() - 1 && posT < 0) {
            return JDFDuration.createDuration(StringUtil.replaceString(duration, "D", "DT"));
        }
        if (posD < 0 && posT < 0) {
            return JDFDuration.createDuration(StringUtil.replaceString(duration, "P", "PT"));
        }
        return null;
    }

    public JDFDuration() {
        this.m_lDuration = 0.0;
    }

    public JDFDuration(JDFDuration d) {
        this.m_lDuration = d.m_lDuration;
    }

    public JDFDuration(JDFDate start, JDFDate end) {
        if (start == null || end == null) {
            this.m_lDuration = 0.0;
            return;
        }
        this.m_lDuration = (double)(end.getTimeInMillis() - start.getTimeInMillis()) / 1000.0;
    }

    public JDFDuration(double s) {
        this.m_lDuration = s;
    }

    public JDFDuration(long s) {
        this.m_lDuration = s;
    }

    public JDFDuration(String strDuration) throws DataFormatException {
        this.m_lDuration = 0.0;
        this.init(strDuration);
    }

    public double addSeconds(double seconds) {
        this.m_lDuration += seconds;
        return this.m_lDuration;
    }

    public String toString() {
        return "JDFDuration[ m_lDuration=(" + this.m_lDuration + ")  --> " + this.getDurationISO() + " ]";
    }

    private void init(String strDuration) throws DataFormatException {
        boolean bComplete = (strDuration = StringUtil.normalize(strDuration, false)) == null ? false : strDuration.matches(REGEX_DURATION);
        this.m_lDuration = 0.0;
        if (bComplete) {
            bComplete = this.setDurationISO(strDuration);
        }
        if (!bComplete) {
            throw new DataFormatException("JDFDuration.init: invalid duration String " + strDuration);
        }
    }

    public String getDurationISO() {
        int lastIndex;
        double deltaS;
        if (this.m_lDuration == 0.0) {
            return "PT00M";
        }
        if (this.m_lDuration >= 9.223372036854776E18) {
            return "INF";
        }
        int temp = Math.abs((int)this.m_lDuration);
        double abs = Math.abs(this.m_lDuration);
        StringBuilder iso = new StringBuilder(32);
        if (this.m_lDuration < 0.0) {
            iso.append("-");
        }
        iso.append("P");
        int i = (int)abs / 31536000;
        if (i != 0) {
            iso.append(i).append("Y");
            temp = (int)abs - i * 60 * 60 * 24 * 365;
        }
        i = temp;
        if ((i /= 2592000) != 0) {
            iso.append(i).append("M");
            temp -= i * 60 * 60 * 24 * 30;
        }
        i = temp % 2592000;
        if ((i /= 86400) != 0) {
            iso.append(i).append("D");
        }
        iso.append("T");
        i = (int)abs % 86400;
        if ((i /= 3600) != 0) {
            iso.append(i).append("H");
        }
        i = (int)abs % 3600;
        if ((i /= 60) != 0) {
            iso.append(i).append("M");
        }
        i = (int)abs % 60;
        boolean bSec = false;
        if (i != 0) {
            iso.append(i);
            bSec = true;
        }
        if ((deltaS = abs - (double)((int)abs)) > 0.0) {
            String s = StringUtil.formatDouble(deltaS);
            if (!bSec) {
                iso.append("0");
            }
            iso.append(s.substring(1));
            bSec = true;
        }
        if (bSec) {
            iso.append("S");
        }
        if (iso.charAt(lastIndex = iso.length() - 1) == 'T') {
            iso.deleteCharAt(lastIndex);
        }
        return iso.toString();
    }

    public boolean setDurationISO(String a_aDuration) {
        String strDate;
        String strTime;
        String strPeriod;
        int iTPos;
        int iPPos = a_aDuration.indexOf("P");
        int factor = this.parseFactor(a_aDuration, iPPos);
        if ((iTPos = (strPeriod = a_aDuration.substring(++iPPos, a_aDuration.length())).indexOf("T")) == 0) {
            strTime = strPeriod.substring(1);
            strDate = null;
        } else {
            strDate = StringUtil.token(strPeriod, 0, "T");
            strTime = StringUtil.token(strPeriod, 1, "T");
        }
        this.m_lDuration = 0.0;
        try {
            this.parseDate(strDate);
            this.parseTime(strTime);
            this.m_lDuration *= (double)factor;
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private int parseFactor(String a_aDuration, int iPPos) {
        char c;
        int factor = 1;
        if (iPPos > 0 && (c = a_aDuration.charAt(iPPos - 1)) == '-') {
            factor = -1;
        }
        return factor;
    }

    private void parseTime(String strTime) {
        if (strTime != null) {
            int iSPos;
            int iMPos;
            int iHPos = strTime.indexOf("H");
            int iTimeLastPos = 0;
            if (iHPos > 0) {
                int iHours = Integer.parseInt(strTime.substring(0, iHPos));
                this.m_lDuration += (double)(iHours * 60 * 60);
                iTimeLastPos = ++iHPos;
            }
            if ((iMPos = strTime.indexOf("M")) > 0) {
                int iMinutes = Integer.parseInt(strTime.substring(iTimeLastPos, iMPos));
                this.m_lDuration += (double)(iMinutes * 60);
                iTimeLastPos = ++iMPos;
            }
            if ((iSPos = strTime.indexOf("S")) > 0) {
                int iDotPos = strTime.indexOf(".");
                if (iDotPos > 0) {
                    int mLen;
                    int iSeconds = Integer.parseInt(strTime.substring(iTimeLastPos, iDotPos));
                    if ((mLen = iSPos - ++iDotPos) > 0) {
                        String sMilli = "0." + strTime.substring(iDotPos, iSPos);
                        this.m_lDuration += Double.parseDouble(sMilli);
                    }
                    this.m_lDuration += (double)iSeconds;
                } else {
                    int iSeconds = Integer.parseInt(strTime.substring(iTimeLastPos, iSPos));
                    this.m_lDuration += (double)iSeconds;
                }
            }
        }
    }

    private void parseDate(String strDate) {
        if (strDate != null) {
            int iDPos;
            int iMPos;
            int iYPos = strDate.indexOf("Y");
            int iDateLastPos = 0;
            if (iYPos > 0) {
                int iYears = Integer.parseInt(strDate.substring(0, iYPos));
                this.m_lDuration += (double)(iYears * 365 * 24 * 60 * 60);
                iDateLastPos = ++iYPos;
            }
            if ((iMPos = strDate.indexOf("M")) > 0) {
                int iMonths = Integer.parseInt(strDate.substring(iDateLastPos, iMPos));
                int nYears = iMonths / 12;
                this.m_lDuration += (double)((iMonths * 30 + nYears * 5) * 24 * 60 * 60);
                iDateLastPos = ++iMPos;
            }
            if ((iDPos = strDate.indexOf("D")) > 0) {
                int iDays = Integer.parseInt(strDate.substring(iDateLastPos, iDPos));
                this.m_lDuration += (double)(iDays * 24 * 60 * 60);
            }
        }
    }

    public void setDuration(long seconds) {
        this.m_lDuration = seconds == Integer.MAX_VALUE ? 9.223372036854776E18 : (double)seconds;
    }

    public void setDuration(double seconds) {
        this.m_lDuration = seconds;
    }

    public long getDuration() {
        return (long)this.m_lDuration;
    }

    public long getDurationMillis() {
        return (long)(this.m_lDuration * 1000.0);
    }

    public boolean isLonger(JDFDuration x) {
        return this.getDuration() > x.getDuration();
    }

    public boolean isShorter(JDFDuration x) {
        return this.getDuration() < x.getDuration();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof JDFDuration)) {
            return false;
        }
        return Math.abs(this.m_lDuration - ((JDFDuration)other).m_lDuration) <= 0.001;
    }

    public int hashCode() {
        return (int)(this.m_lDuration * 1000.0);
    }

    @Override
    public int compareTo(JDFDuration arg0) {
        double l = arg0 == null ? 0.0 : arg0.m_lDuration;
        return (int)Math.signum(-(l -= this.m_lDuration));
    }
}

